/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.thrift.TestThriftHttpServer;
import org.apache.hadoop.hbase.thrift.TestThriftServerCmdLine;
import org.apache.hadoop.hbase.thrift.ThriftServer;
import org.apache.hadoop.hbase.thrift.ThriftServerRunner;
import org.apache.hadoop.hbase.thrift.generated.Hbase;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.apache.hadoop.hbase.util.IncrementingEnvironmentEdge;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TMemoryBuffer;
import org.apache.thrift.transport.TTransport;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClientTests.class, LargeTests.class})
public class TestThriftHttpServerSSL {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestThriftHttpServerSSL.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestThriftHttpServerSSL.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final String KEY_STORE_PASSWORD = "myKSPassword";
    private static final String TRUST_STORE_PASSWORD = "myTSPassword";
    private File keyDir;
    private HttpClientBuilder httpClientBuilder;
    private ThriftServerRunner tsr;
    private HttpPost httpPost = null;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.regionserver.thrift.http", true);
        TEST_UTIL.getConfiguration().setBoolean("hbase.table.sanity.checks", false);
        TEST_UTIL.startMiniCluster();
        EnvironmentEdgeManagerTestHelper.injectEdge((EnvironmentEdge)new IncrementingEnvironmentEdge());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
        EnvironmentEdgeManager.reset();
    }

    @Before
    public void setUp() throws Exception {
        TestThriftHttpServerSSL.initializeAlgorithmId();
        this.keyDir = this.initKeystoreDir();
        this.keyDir.deleteOnExit();
        KeyPair keyPair = KeyStoreTestUtil.generateKeyPair((String)"RSA");
        X509Certificate serverCertificate = KeyStoreTestUtil.generateCertificate((String)"CN=localhost, O=server", (KeyPair)keyPair, (int)30, (String)"SHA1withRSA");
        this.generateTrustStore(serverCertificate);
        this.generateKeyStore(keyPair, serverCertificate);
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.setBoolean("hbase.thrift.ssl.enabled", true);
        conf.set("hbase.thrift.ssl.keystore.store", this.getKeystoreFilePath());
        conf.set("hbase.thrift.ssl.keystore.password", KEY_STORE_PASSWORD);
        conf.set("hbase.thrift.ssl.keystore.keypassword", KEY_STORE_PASSWORD);
        this.tsr = TestThriftServerCmdLine.createBoundServer(() -> new ThriftServer(conf));
        String url = "https://localhost:" + this.tsr.getThriftServer().listenPort;
        KeyStore trustStore = KeyStore.getInstance("JKS");
        try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(new File(this.getTruststoreFilePath()).toPath(), new OpenOption[0]));){
            trustStore.load(inputStream, TRUST_STORE_PASSWORD.toCharArray());
        }
        this.httpClientBuilder = HttpClients.custom();
        SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(trustStore, null).build();
        this.httpClientBuilder.setSSLContext(sslcontext);
        this.httpPost = new HttpPost(url);
        this.httpPost.setHeader("Content-Type", "application/x-thrift");
        this.httpPost.setHeader("Accept", "application/x-thrift");
        this.httpPost.setHeader("User-Agent", "Java/THttpClient/HC");
    }

    @After
    public void tearDown() throws IOException {
        if (this.httpPost != null) {
            this.httpPost.releaseConnection();
        }
        if (this.tsr != null) {
            this.tsr.close();
        }
    }

    @Test
    public void testSecurityHeaders() throws Exception {
        try (CloseableHttpClient httpClient = this.httpClientBuilder.build();){
            TMemoryBuffer memoryBuffer = new TMemoryBuffer(100);
            TBinaryProtocol prot = new TBinaryProtocol((TTransport)memoryBuffer);
            Hbase.Client client = new Hbase.Client((TProtocol)prot);
            client.send_getClusterId();
            this.httpPost.setEntity((HttpEntity)new ByteArrayEntity(memoryBuffer.getArray()));
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)this.httpPost);
            Assert.assertEquals((long)200L, (long)httpResponse.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"DENY", (Object)httpResponse.getFirstHeader("X-Frame-Options").getValue());
            Assert.assertEquals((Object)"nosniff", (Object)httpResponse.getFirstHeader("X-Content-Type-Options").getValue());
            Assert.assertEquals((Object)"1; mode=block", (Object)httpResponse.getFirstHeader("X-XSS-Protection").getValue());
            Assert.assertEquals((Object)"default-src https: data: 'unsafe-inline' 'unsafe-eval'", (Object)httpResponse.getFirstHeader("Content-Security-Policy").getValue());
            Assert.assertEquals((Object)"max-age=63072000;includeSubDomains;preload", (Object)httpResponse.getFirstHeader("Strict-Transport-Security").getValue());
        }
    }

    private static void initializeAlgorithmId() {
        try {
            Class<?> algoId = Class.forName("sun.security.x509.AlgorithmId");
            Method method = algoId.getMethod("get", String.class);
            method.setAccessible(true);
            method.invoke(null, "PBEWithSHA1AndDESede");
        }
        catch (Exception e) {
            LOG.warn("failed to initialize AlgorithmId", (Throwable)e);
        }
    }

    private File initKeystoreDir() {
        String dataTestDir = TEST_UTIL.getDataTestDir().toString();
        File keystoreDir = new File(dataTestDir, TestThriftHttpServer.class.getSimpleName() + "_keys");
        keystoreDir.mkdirs();
        return keystoreDir;
    }

    private void generateKeyStore(KeyPair keyPair, X509Certificate serverCertificate) throws Exception {
        String keyStorePath = this.getKeystoreFilePath();
        KeyStoreTestUtil.createKeyStore((String)keyStorePath, (String)KEY_STORE_PASSWORD, (String)KEY_STORE_PASSWORD, (String)"serverKS", (Key)keyPair.getPrivate(), (Certificate)serverCertificate);
    }

    private void generateTrustStore(X509Certificate serverCertificate) throws Exception {
        String trustStorePath = this.getTruststoreFilePath();
        KeyStoreTestUtil.createTrustStore((String)trustStorePath, (String)TRUST_STORE_PASSWORD, (String)"serverTS", (Certificate)serverCertificate);
    }

    private String getKeystoreFilePath() {
        return String.format("%s/serverKS.%s", this.keyDir.getAbsolutePath(), "jks");
    }

    private String getTruststoreFilePath() {
        return String.format("%s/serverTS.%s", this.keyDir.getAbsolutePath(), "jks");
    }
}

