/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.thrift.TestThriftServer;
import org.apache.hadoop.hbase.thrift.TestThriftServerCmdLine;
import org.apache.hadoop.hbase.thrift.ThriftServer;
import org.apache.hadoop.hbase.thrift.ThriftServerRunner;
import org.apache.hadoop.hbase.thrift.generated.Hbase;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.apache.hadoop.hbase.util.IncrementingEnvironmentEdge;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClientTests.class, LargeTests.class})
public class TestThriftHttpServer {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestThriftHttpServer.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestThriftHttpServer.class);
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @Rule
    public ExpectedException exception = ExpectedException.none();
    protected static volatile boolean tableCreated = false;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.regionserver.thrift.http", true);
        TEST_UTIL.getConfiguration().setBoolean("hbase.table.sanity.checks", false);
        TEST_UTIL.startMiniCluster();
        EnvironmentEdgeManagerTestHelper.injectEdge((EnvironmentEdge)new IncrementingEnvironmentEdge());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
        EnvironmentEdgeManager.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExceptionThrownWhenMisConfigured() throws IOException {
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.set("hbase.thrift.security.qop", "privacy");
        conf.setBoolean("hbase.thrift.ssl.enabled", false);
        ExpectedException thrown = ExpectedException.none();
        try (ThriftServerRunner tsr = null;){
            thrown.expect(IllegalArgumentException.class);
            thrown.expectMessage("Thrift HTTP Server's QoP is privacy, but hbase.thrift.ssl.enabled is false");
            tsr = TestThriftServerCmdLine.createBoundServer(() -> new ThriftServer(conf));
            Assert.fail((String)"Thrift HTTP Server starts up even with wrong security configurations.");
        }
    }

    @Test
    public void testRunThriftServerWithHeaderBufferLength() throws Exception {
        try {
            this.runThriftServer(64512);
        }
        catch (TTransportException tex) {
            Assert.assertFalse((boolean)tex.getMessage().equals("HTTP Response code: 431"));
        }
        this.exception.expect(TTransportException.class);
        this.exception.expectMessage("HTTP Response code: 431");
        this.runThriftServer(65536);
    }

    protected Supplier<ThriftServer> getThriftServerSupplier() {
        return () -> new ThriftServer(TEST_UTIL.getConfiguration());
    }

    @Test
    public void testRunThriftServer() throws Exception {
        this.runThriftServer(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runThriftServer(int customHeaderSize) throws Exception {
        Exception clientSideException = null;
        for (int i = 0; i < 10; ++i) {
            clientSideException = null;
            ThriftServerRunner tsr = TestThriftServerCmdLine.createBoundServer(this.getThriftServerSupplier());
            String url = "http://localhost:" + tsr.getThriftServer().listenPort;
            try {
                this.checkHttpMethods(url);
                this.talkToThriftServer(url, customHeaderSize);
                break;
            }
            catch (Exception ex) {
                clientSideException = ex;
                LOG.info("Client-side Exception", (Throwable)ex);
            }
            finally {
                tsr.close();
                tsr.join();
                if (tsr.getRunException() == null) continue;
                LOG.error("Invocation of HBase Thrift server threw exception", (Throwable)tsr.getRunException());
                throw tsr.getRunException();
            }
        }
        if (clientSideException != null) {
            LOG.error("Thrift Client", clientSideException);
            throw clientSideException;
        }
    }

    private void checkHttpMethods(String url) throws Exception {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setRequestMethod("TRACE");
        conn.connect();
        Assert.assertEquals((String)conn.getResponseMessage(), (long)403L, (long)conn.getResponseCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void talkToThriftServer(String url, int customHeaderSize) throws Exception {
        THttpClient httpClient = new THttpClient(url);
        httpClient.open();
        if (customHeaderSize > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < customHeaderSize; ++i) {
                sb.append("a");
            }
            httpClient.setCustomHeader("User-Agent", sb.toString());
        }
        try {
            TBinaryProtocol prot = new TBinaryProtocol((TTransport)httpClient);
            Hbase.Client client = new Hbase.Client((TProtocol)prot);
            if (!tableCreated) {
                TestThriftServer.createTestTables((Hbase.Iface)client);
                tableCreated = true;
            }
            TestThriftServer.checkTableList((Hbase.Iface)client);
        }
        finally {
            httpClient.close();
        }
    }
}

