/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.thrift.ThriftMetrics;
import org.apache.hadoop.hbase.thrift.ThriftServer;
import org.apache.hbase.thirdparty.com.google.common.base.Joiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseThriftTestingUtility {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseThriftTestingUtility.class);
    private Thread thriftServerThread;
    private volatile Exception thriftServerException;
    private ThriftServer thriftServer;
    private int port;

    public int getServerPort() {
        return this.port;
    }

    public void startThriftServer(Configuration conf, ThriftMetrics.ThriftServerType type) throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        this.port = HBaseTestingUtility.randomFreePort();
        args.add("-port");
        args.add(String.valueOf(this.port));
        args.add("-infoport");
        int infoPort = HBaseTestingUtility.randomFreePort();
        args.add(String.valueOf(infoPort));
        LOG.info("Starting Thrift Server {} on port: {} ", (Object)type, (Object)this.port);
        this.thriftServer = this.createThriftServer(conf, type);
        this.startThriftServerThread(args.toArray(new String[args.size()]));
        this.waitForThriftServer();
        LOG.info("Started Thrift Server {} on port {}", (Object)type, (Object)this.port);
    }

    private void startThriftServerThread(String[] args) {
        LOG.info("Starting HBase Thrift server with command line: " + Joiner.on((String)" ").join((Object[])args));
        this.thriftServerException = null;
        this.thriftServerThread = new Thread(() -> {
            try {
                this.thriftServer.run(args);
            }
            catch (Exception e) {
                this.thriftServerException = e;
            }
        });
        this.thriftServerThread.setName(ThriftServer.class.getSimpleName());
        this.thriftServerThread.start();
    }

    private ThriftServer createThriftServer(Configuration conf, ThriftMetrics.ThriftServerType type) {
        switch (type) {
            case ONE: {
                return new ThriftServer(conf);
            }
            case TWO: {
                return new org.apache.hadoop.hbase.thrift2.ThriftServer(conf);
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    private void waitForThriftServer() throws Exception {
        boolean isServing = false;
        int i = 0;
        while (i++ < 100) {
            if (this.thriftServer.tserver == null) {
                Thread.sleep(100L);
                continue;
            }
            isServing = true;
            break;
        }
        if (!isServing) {
            if (this.thriftServer != null) {
                this.thriftServer.stop();
            }
            throw new IOException("Failed to start thrift server ");
        }
    }

    public void stopThriftServer() throws Exception {
        LOG.debug("Stopping Thrift Server");
        this.thriftServer.stop();
        this.thriftServerThread.join();
        if (this.thriftServerException != null) {
            LOG.error("HBase Thrift server threw an exception ", (Throwable)this.thriftServerException);
            throw new Exception(this.thriftServerException);
        }
    }
}

