/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.hbase.CallDroppedException;
import org.apache.hadoop.hbase.CallQueueTooBigException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.MultiActionResultTooLarge;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RegionTooBusyException;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.coprocessor.CoreCoprocessor;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.exceptions.FailedSanityCheckException;
import org.apache.hadoop.hbase.exceptions.OutOfOrderScannerNextException;
import org.apache.hadoop.hbase.exceptions.RegionMovedException;
import org.apache.hadoop.hbase.exceptions.ScannerResetException;
import org.apache.hadoop.hbase.quotas.QuotaExceededException;
import org.apache.hadoop.hbase.quotas.RpcThrottlingException;
import org.apache.hadoop.hbase.util.Bytes;

@CoreCoprocessor
public class ErrorThrowingGetObserver
implements RegionCoprocessor,
RegionObserver {
    public static final String SHOULD_ERROR_ATTRIBUTE = "error";

    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this);
    }

    public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
        byte[] errorType = get.getAttribute(SHOULD_ERROR_ATTRIBUTE);
        if (errorType != null) {
            ErrorType type = ErrorType.valueOf(Bytes.toString((byte[])errorType));
            switch (type) {
                case CALL_QUEUE_TOO_BIG: {
                    throw new CallQueueTooBigException("Failing for test");
                }
                case MULTI_ACTION_RESULT_TOO_LARGE: {
                    throw new MultiActionResultTooLarge("Failing for test");
                }
                case FAILED_SANITY_CHECK: {
                    throw new FailedSanityCheckException("Failing for test");
                }
                case NOT_SERVING_REGION: {
                    throw new NotServingRegionException("Failing for test");
                }
                case REGION_MOVED: {
                    throw new RegionMovedException(((RegionCoprocessorEnvironment)e.getEnvironment()).getServerName(), 1L);
                }
                case SCANNER_RESET: {
                    throw new ScannerResetException("Failing for test");
                }
                case UNKNOWN_SCANNER: {
                    throw new UnknownScannerException("Failing for test");
                }
                case REGION_TOO_BUSY: {
                    throw new RegionTooBusyException("Failing for test");
                }
                case OUT_OF_ORDER_SCANNER_NEXT: {
                    throw new OutOfOrderScannerNextException("Failing for test");
                }
                case QUOTA_EXCEEDED: {
                    throw new QuotaExceededException("Failing for test");
                }
                case RPC_THROTTLING: {
                    throw new RpcThrottlingException("Failing for test");
                }
                case CALL_DROPPED: {
                    throw new CallDroppedException("Failing for test");
                }
            }
            throw new DoNotRetryIOException("Failing for test");
        }
    }

    public static enum ErrorType {
        CALL_QUEUE_TOO_BIG("exceptions.callQueueTooBig"),
        MULTI_ACTION_RESULT_TOO_LARGE("exceptions.multiResponseTooLarge"),
        FAILED_SANITY_CHECK("exceptions.FailedSanityCheckException"),
        NOT_SERVING_REGION("exceptions.NotServingRegionException"),
        REGION_MOVED("exceptions.RegionMovedException"),
        SCANNER_RESET("exceptions.ScannerResetException"),
        UNKNOWN_SCANNER("exceptions.UnknownScannerException"),
        REGION_TOO_BUSY("exceptions.RegionTooBusyException"),
        OUT_OF_ORDER_SCANNER_NEXT("exceptions.OutOfOrderScannerNextException"),
        QUOTA_EXCEEDED("exceptions.quotaExceeded"),
        RPC_THROTTLING("exceptions.rpcThrottling"),
        CALL_DROPPED("exceptions.callDropped");

        private final String metricName;

        private ErrorType(String metricName) {
            this.metricName = metricName;
        }

        public String getMetricName() {
            return this.metricName;
        }
    }
}

