/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.thrift.TestThriftServer;
import org.apache.hadoop.hbase.thrift.ThriftServer;
import org.apache.hadoop.hbase.thrift.generated.Hbase;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.apache.hadoop.hbase.util.IncrementingEnvironmentEdge;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TTransport;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestThriftHttpServer {
    public static final Log LOG = LogFactory.getLog(TestThriftHttpServer.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Thread httpServerThread;
    private volatile Exception httpServerException;
    private Exception clientSideException;
    private ThriftServer thriftServer;
    private int port;
    private static volatile boolean tableCreated = false;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.regionserver.thrift.http", true);
        TEST_UTIL.getConfiguration().setBoolean("hbase.table.sanity.checks", false);
        TEST_UTIL.startMiniCluster();
        EnvironmentEdgeManagerTestHelper.injectEdge((EnvironmentEdge)new IncrementingEnvironmentEdge());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
        EnvironmentEdgeManager.reset();
    }

    private void startHttpServerThread(final String[] args) {
        LOG.info((Object)("Starting HBase Thrift server with HTTP server: " + Joiner.on((String)" ").join((Object[])args)));
        this.httpServerException = null;
        this.httpServerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TestThriftHttpServer.this.thriftServer.doMain(args);
                }
                catch (Exception e) {
                    TestThriftHttpServer.this.httpServerException = e;
                }
            }
        });
        this.httpServerThread.setName(ThriftServer.class.getSimpleName() + "-httpServer");
        this.httpServerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=600000L)
    public void testRunThriftServer() throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        this.port = HBaseTestingUtility.randomFreePort();
        args.add("-port");
        args.add(String.valueOf(this.port));
        args.add("start");
        this.thriftServer = new ThriftServer(TEST_UTIL.getConfiguration());
        this.startHttpServerThread(args.toArray(new String[args.size()]));
        for (int i = 0; i < 100 && (this.thriftServer.serverRunner == null || this.thriftServer.serverRunner.httpServer == null); ++i) {
            Thread.sleep(100L);
        }
        try {
            this.talkToThriftServer();
        }
        catch (Exception ex) {
            this.clientSideException = ex;
        }
        finally {
            this.stopHttpServerThread();
        }
        if (this.clientSideException != null) {
            LOG.error((Object)("Thrift client threw an exception " + this.clientSideException));
            throw new Exception(this.clientSideException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void talkToThriftServer() throws Exception {
        httpClient.open();
        try (THttpClient httpClient = new THttpClient("http://localhost:" + this.port);){
            TBinaryProtocol prot = new TBinaryProtocol((TTransport)httpClient);
            Hbase.Client client = new Hbase.Client((TProtocol)prot);
            if (!tableCreated) {
                TestThriftServer.createTestTables((Hbase.Iface)client);
                tableCreated = true;
            }
            TestThriftServer.checkTableList((Hbase.Iface)client);
        }
    }

    private void stopHttpServerThread() throws Exception {
        LOG.debug((Object)"Stopping  Thrift HTTP server");
        this.thriftServer.stop();
        this.httpServerThread.join();
        if (this.httpServerException != null) {
            LOG.error((Object)"Command-line invocation of HBase Thrift server threw an exception", (Throwable)this.httpServerException);
            throw new Exception(this.httpServerException);
        }
    }
}

