/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.thrift.CallQueue;
import org.apache.hadoop.hbase.thrift.ThriftMetrics;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={SmallTests.class})
@RunWith(value=Parameterized.class)
public class TestCallQueue {
    public static final Log LOG = LogFactory.getLog(TestCallQueue.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final MetricsAssertHelper metricsHelper = (MetricsAssertHelper)CompatibilitySingletonFactory.getInstance(MetricsAssertHelper.class);
    private int elementsAdded;
    private int elementsRemoved;

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        for (int elementsAdded : new int[]{100, 200, 300}) {
            for (int elementsRemoved : new int[]{0, 20, 100}) {
                parameters.add(new Object[]{new Integer(elementsAdded), new Integer(elementsRemoved)});
            }
        }
        return parameters;
    }

    public TestCallQueue(int elementsAdded, int elementsRemoved) {
        this.elementsAdded = elementsAdded;
        this.elementsRemoved = elementsRemoved;
        LOG.debug((Object)("elementsAdded:" + elementsAdded + " elementsRemoved:" + elementsRemoved));
    }

    @Test(timeout=60000L)
    public void testPutTake() throws Exception {
        int i;
        ThriftMetrics metrics = TestCallQueue.createMetrics();
        CallQueue callQueue = new CallQueue(new LinkedBlockingQueue(), metrics);
        for (i = 0; i < this.elementsAdded; ++i) {
            callQueue.put(TestCallQueue.createDummyRunnable());
        }
        for (i = 0; i < this.elementsRemoved; ++i) {
            callQueue.take();
        }
        TestCallQueue.verifyMetrics(metrics, "timeInQueue_num_ops", this.elementsRemoved);
    }

    @Test(timeout=60000L)
    public void testOfferPoll() throws Exception {
        int i;
        ThriftMetrics metrics = TestCallQueue.createMetrics();
        CallQueue callQueue = new CallQueue(new LinkedBlockingQueue(), metrics);
        for (i = 0; i < this.elementsAdded; ++i) {
            callQueue.offer(TestCallQueue.createDummyRunnable());
        }
        for (i = 0; i < this.elementsRemoved; ++i) {
            callQueue.poll();
        }
        TestCallQueue.verifyMetrics(metrics, "timeInQueue_num_ops", this.elementsRemoved);
    }

    private static ThriftMetrics createMetrics() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        ThriftMetrics m = new ThriftMetrics(conf, ThriftMetrics.ThriftServerType.ONE);
        m.getSource().init();
        return m;
    }

    private static void verifyMetrics(ThriftMetrics metrics, String name, int expectValue) throws Exception {
        metricsHelper.assertCounter(name, (long)expectValue, (BaseSource)metrics.getSource());
    }

    private static Runnable createDummyRunnable() {
        return new Runnable(){

            @Override
            public void run() {
            }
        };
    }
}

