/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.testing;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testing.TestingHBaseCluster;
import org.apache.hadoop.hbase.testing.TestingHBaseClusterOption;
import org.apache.hadoop.hbase.testing.TestingHBaseClusterReplicationTestBase;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, LargeTests.class})
public class TestTestingHBaseClusterReplicationShareZk
extends TestingHBaseClusterReplicationTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTestingHBaseClusterReplicationShareZk.class);
    private HBaseTestingUtility util = new HBaseTestingUtility();

    @Override
    protected void startClusters() throws Exception {
        this.util.startMiniZKCluster();
        String zkConnectString = this.util.getZkCluster().getAddress().toString();
        this.sourceCluster = TestingHBaseCluster.create((TestingHBaseClusterOption)TestingHBaseClusterOption.builder().useExternalZooKeeper(zkConnectString).build());
        this.sourceCluster.start();
        this.peerCluster = TestingHBaseCluster.create((TestingHBaseClusterOption)TestingHBaseClusterOption.builder().useExternalZooKeeper(zkConnectString).build());
        this.peerCluster.start();
        Assert.assertNotEquals((Object)this.sourceCluster.getConf().get("zookeeper.znode.parent"), (Object)this.peerCluster.getConf().get("zookeeper.znode.parent"));
    }

    @Override
    protected void stopClusters() throws Exception {
        this.util.shutdownMiniZKCluster();
    }
}

