/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.testing;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.OnlineRegions;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testing.TestingHBaseCluster;
import org.apache.hadoop.hbase.testing.TestingHBaseClusterOption;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, LargeTests.class})
public class TestTestingHBaseClusterImplForCPs {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTestingHBaseClusterImplForCPs.class);
    private static TestingHBaseCluster CLUSTER;
    private static TableName NAME;
    private static byte[] CF;
    private static Connection CONN;
    private static Admin ADMIN;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        CLUSTER = TestingHBaseCluster.create((TestingHBaseClusterOption)TestingHBaseClusterOption.builder().numMasters(2).numRegionServers(3).numDataNodes(3).build());
        CLUSTER.start();
        CONN = ConnectionFactory.createConnection((Configuration)CLUSTER.getConf());
        ADMIN = CONN.getAdmin();
        ADMIN.createTable(TableDescriptorBuilder.newBuilder((TableName)NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])CF)).build());
        ADMIN.balancerSwitch(false, true);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        Closeables.close((Closeable)ADMIN, (boolean)true);
        Closeables.close((Closeable)CONN, (boolean)true);
        if (CLUSTER.isClusterRunning()) {
            CLUSTER.stop();
        }
    }

    @Test
    public void testGetRegion() throws IOException {
        ServerName loc;
        List infos = ADMIN.getRegions(NAME);
        Assert.assertEquals((long)1L, (long)infos.size());
        RegionInfo info = (RegionInfo)infos.get(0);
        Region region = (Region)CLUSTER.getRegion(info).get();
        try (RegionLocator locator = CONN.getRegionLocator(NAME);){
            loc = locator.getRegionLocation(info.getStartKey()).getServerName();
        }
        OnlineRegions onlineRegionsInterface = (OnlineRegions)CLUSTER.getOnlineRegionsInterface(loc).get();
        List regions = onlineRegionsInterface.getRegions(NAME);
        Assert.assertEquals((long)1L, (long)regions.size());
        Assert.assertSame((Object)region, regions.get(0));
        Assert.assertFalse((boolean)CLUSTER.getRegion(RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)"whatever")).build()).isPresent());
        Assert.assertFalse((boolean)CLUSTER.getOnlineRegionsInterface(ServerName.valueOf((String)"whatever,1,1")).isPresent());
    }

    static {
        NAME = TableName.valueOf((String)"test");
        CF = Bytes.toBytes((String)"cf");
    }
}

