/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.TableOutputFormat;
import org.apache.hadoop.hbase.spark.AndLogicExpression;
import org.apache.hadoop.hbase.spark.DefaultSourceStaticUtils$;
import org.apache.hadoop.hbase.spark.DynamicLogicExpression;
import org.apache.hadoop.hbase.spark.EqualLogicExpression;
import org.apache.hadoop.hbase.spark.GreaterThanLogicExpression;
import org.apache.hadoop.hbase.spark.GreaterThanOrEqualLogicExpression;
import org.apache.hadoop.hbase.spark.HBaseConnectionCache$;
import org.apache.hadoop.hbase.spark.HBaseContext;
import org.apache.hadoop.hbase.spark.HBaseContext$;
import org.apache.hadoop.hbase.spark.HBaseRelation$;
import org.apache.hadoop.hbase.spark.IsNullLogicExpression;
import org.apache.hadoop.hbase.spark.LatestHBaseContextCache$;
import org.apache.hadoop.hbase.spark.LessThanLogicExpression;
import org.apache.hadoop.hbase.spark.LessThanOrEqualLogicExpression;
import org.apache.hadoop.hbase.spark.OrLogicExpression;
import org.apache.hadoop.hbase.spark.PassThroughLogicExpression;
import org.apache.hadoop.hbase.spark.RowKeyFilter;
import org.apache.hadoop.hbase.spark.RowKeyFilter$;
import org.apache.hadoop.hbase.spark.ScanRange;
import org.apache.hadoop.hbase.spark.SmartConnection;
import org.apache.hadoop.hbase.spark.SparkSQLPushDownFilter;
import org.apache.hadoop.hbase.spark.datasources.BoundRange;
import org.apache.hadoop.hbase.spark.datasources.BoundRanges;
import org.apache.hadoop.hbase.spark.datasources.BytesEncoder;
import org.apache.hadoop.hbase.spark.datasources.HBaseSparkConf$;
import org.apache.hadoop.hbase.spark.datasources.HBaseTableScanRDD;
import org.apache.hadoop.hbase.spark.datasources.JavaBytesEncoder$;
import org.apache.hadoop.hbase.spark.datasources.SerializableConfiguration;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.datasources.hbase.Field;
import org.apache.spark.sql.datasources.hbase.HBaseTableCatalog;
import org.apache.spark.sql.datasources.hbase.HBaseTableCatalog$;
import org.apache.spark.sql.datasources.hbase.Utils$;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.InsertableRelation;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.PrunedFilteredScan;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@InterfaceAudience.Private
@ScalaSignature(bytes="\u0006\u0001\rEd\u0001B\u0001\u0003\u00016\u0011Q\u0002\u0013\"bg\u0016\u0014V\r\\1uS>t'BA\u0002\u0005\u0003\u0015\u0019\b/\u0019:l\u0015\t)a!A\u0003iE\u0006\u001cXM\u0003\u0002\b\u0011\u00051\u0001.\u00193p_BT!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0002\u0001\u000f/ii\u0012e\n\t\u0003\u001fUi\u0011\u0001\u0005\u0006\u0003#I\tqa]8ve\u000e,7O\u0003\u0002\u0014)\u0005\u00191/\u001d7\u000b\u0005\rA\u0011B\u0001\f\u0011\u00051\u0011\u0015m]3SK2\fG/[8o!\ty\u0001$\u0003\u0002\u001a!\t\u0011\u0002K];oK\u00124\u0015\u000e\u001c;fe\u0016$7kY1o!\ty1$\u0003\u0002\u001d!\t\u0011\u0012J\\:feR\f'\r\\3SK2\fG/[8o!\tqr$D\u0001\u0015\u0013\t\u0001CCA\u0004M_\u001e<\u0017N\\4\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\u000fA\u0013x\u000eZ;diB\u0011!\u0005K\u0005\u0003S\r\u0012AbU3sS\u0006d\u0017N_1cY\u0016D\u0001b\u000b\u0001\u0003\u0016\u0004%\t\u0001L\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001cX#A\u0017\u0011\t9\nD\u0007\u000e\b\u0003E=J!\u0001M\u0012\u0002\rA\u0013X\rZ3g\u0013\t\u00114GA\u0002NCBT!\u0001M\u0012\u0011\u00059*\u0014B\u0001\u001c4\u0005\u0019\u0019FO]5oO\"A\u0001\b\u0001B\tB\u0003%Q&A\u0006qCJ\fW.\u001a;feN\u0004\u0003FA\u001c;!\t\u00113(\u0003\u0002=G\tIAO]1og&,g\u000e\u001e\u0005\t}\u0001\u0011)\u001a!C\u0001\u007f\u0005\u0019Ro]3s'B,7-\u001b4jK\u0012\u001c6\r[3nCV\t\u0001\tE\u0002#\u0003\u000eK!AQ\u0012\u0003\r=\u0003H/[8o!\t!u)D\u0001F\u0015\t1%#A\u0003usB,7/\u0003\u0002I\u000b\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u0011)\u0003!\u0011#Q\u0001\n\u0001\u000bA#^:feN\u0003XmY5gS\u0016$7k\u00195f[\u0006\u0004\u0003\u0002\u0003'\u0001\u0005\u000b\u0007I\u0011A'\u0002\u0015M\fHnQ8oi\u0016DH/F\u0001O!\ty\u0005+D\u0001\u0013\u0013\t\t&C\u0001\u0006T#2\u001buN\u001c;fqRD\u0001b\u0015\u0001\u0003\u0002\u0003\u0006IAT\u0001\fgFd7i\u001c8uKb$\b\u0005\u000b\u0002Su!)a\u000b\u0001C\u0001/\u00061A(\u001b8jiz\"2\u0001\u0017/^)\tI6\f\u0005\u0002[\u00015\t!\u0001C\u0003M+\u0002\u0007a\nC\u0003,+\u0002\u0007Q\u0006C\u0003?+\u0002\u0007\u0001\tC\u0004`\u0001\t\u0007I\u0011\u00011\u0002\u0013QLW.Z:uC6\u0004X#A1\u0011\u0007\t\n%\r\u0005\u0002#G&\u0011Am\t\u0002\u0005\u0019>tw\r\u0003\u0004g\u0001\u0001\u0006I!Y\u0001\u000bi&lWm\u001d;b[B\u0004\u0003b\u00025\u0001\u0005\u0004%\t\u0001Y\u0001\r[&tG+[7fgR\fW\u000e\u001d\u0005\u0007U\u0002\u0001\u000b\u0011B1\u0002\u001b5Lg\u000eV5nKN$\u0018-\u001c9!\u0011\u001da\u0007A1A\u0005\u0002\u0001\fA\"\\1y)&lWm\u001d;b[BDaA\u001c\u0001!\u0002\u0013\t\u0017!D7bqRKW.Z:uC6\u0004\b\u0005C\u0004q\u0001\t\u0007I\u0011A9\u0002\u00175\f\u0007PV3sg&|gn]\u000b\u0002eB\u0019!%Q:\u0011\u0005\t\"\u0018BA;$\u0005\rIe\u000e\u001e\u0005\u0007o\u0002\u0001\u000b\u0011\u0002:\u0002\u00195\f\u0007PV3sg&|gn\u001d\u0011\t\u000fe\u0004!\u0019!C\u0001u\u0006qQM\\2pI\u0016\u00148\t\\:OC6,W#\u0001\u001b\t\rq\u0004\u0001\u0015!\u00035\u0003=)gnY8eKJ\u001cEn\u001d(b[\u0016\u0004\u0003b\u0002@\u0001\u0005\u0004%\ta`\u0001\bK:\u001cw\u000eZ3s+\t\t\t\u0001\u0005\u0003\u0002\u0004\u0005%QBAA\u0003\u0015\r\t9AA\u0001\fI\u0006$\u0018m]8ve\u000e,7/\u0003\u0003\u0002\f\u0005\u0015!\u0001\u0004\"zi\u0016\u001cXI\\2pI\u0016\u0014\b\u0002CA\b\u0001\u0001\u0006I!!\u0001\u0002\u0011\u0015t7m\u001c3fe\u0002B3!!\u0004;\u0011%\t)\u0002\u0001b\u0001\n\u0003\t9\"A\u0004dCR\fGn\\4\u0016\u0005\u0005e\u0001\u0003BA\u000e\u0003Ci!!!\b\u000b\u0007\u0015\tyBC\u0002\u0002\bIIA!a\t\u0002\u001e\t\t\u0002JQ1tKR\u000b'\r\\3DCR\fGn\\4\t\u0011\u0005\u001d\u0002\u0001)A\u0005\u00033\t\u0001bY1uC2|w\r\t\u0005\u0007\u0003W\u0001A\u0011\u0001>\u0002\u0013Q\f'\r\\3OC6,\u0007\u0002CA\u0018\u0001\t\u0007I\u0011\u0001>\u0002\u001f\r|gNZ5h%\u0016\u001cx.\u001e:dKNDq!a\r\u0001A\u0003%A'\u0001\td_:4\u0017n\u001a*fg>,(oY3tA!I\u0011q\u0007\u0001C\u0002\u0013\u0005\u0011\u0011H\u0001\u0010kN,\u0007JQ1tK\u000e{g\u000e^3yiV\u0011\u00111\b\t\u0004E\u0005u\u0012bAA G\t9!i\\8mK\u0006t\u0007\u0002CA\"\u0001\u0001\u0006I!a\u000f\u0002!U\u001cX\r\u0013\"bg\u0016\u001cuN\u001c;fqR\u0004\u0003\"CA$\u0001\t\u0007I\u0011AA\u001d\u0003])8/\u001a)vg\"$un\u001e8D_2,XN\u001c$jYR,'\u000f\u0003\u0005\u0002L\u0001\u0001\u000b\u0011BA\u001e\u0003a)8/\u001a)vg\"$un\u001e8D_2,XN\u001c$jYR,'\u000f\t\u0005\n\u0003\u001f\u0002!\u0019!C\u0001\u0003s\t\u0001C\u00197pG.\u001c\u0015m\u00195f\u000b:\f'\r\\3\t\u0011\u0005M\u0003\u0001)A\u0005\u0003w\t\u0011C\u00197pG.\u001c\u0015m\u00195f\u000b:\f'\r\\3!\u0011%\t9\u0006\u0001b\u0001\n\u0003\tI&A\u0005dC\u000eDWmU5{KV\t1\u000fC\u0004\u0002^\u0001\u0001\u000b\u0011B:\u0002\u0015\r\f7\r[3TSj,\u0007\u0005C\u0005\u0002b\u0001\u0011\r\u0011\"\u0001\u0002Z\u0005A!-\u0019;dQ:+X\u000eC\u0004\u0002f\u0001\u0001\u000b\u0011B:\u0002\u0013\t\fGo\u00195Ok6\u0004\u0003\"CA5\u0001\t\u0007I\u0011AA-\u0003-\u0011W\u000f\\6HKR\u001c\u0016N_3\t\u000f\u00055\u0004\u0001)A\u0005g\u0006a!-\u001e7l\u000f\u0016$8+\u001b>fA!I\u0011\u0011\u000f\u0001C\u0002\u0013\u0005\u00111O\u0001\rQ\n\f7/Z\"p]R,\u0007\u0010^\u000b\u0003\u0003k\u00022AWA<\u0013\r\tIH\u0001\u0002\r\u0011\n\u000b7/Z\"p]R,\u0007\u0010\u001e\u0005\t\u0003{\u0002\u0001\u0015!\u0003\u0002v\u0005i\u0001NY1tK\u000e{g\u000e^3yi\u0002B\u0011\"!!\u0001\u0005\u0004%\t!a!\u0002\u0017]\u0014\u0018\r\u001d9fI\u000e{gNZ\u000b\u0003\u0003\u000b\u0003B!a\u0001\u0002\b&!\u0011\u0011RA\u0003\u0005e\u0019VM]5bY&T\u0018M\u00197f\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u0011\u00055\u0005\u0001)A\u0005\u0003\u000b\u000bAb\u001e:baB,GmQ8oM\u0002Bq!!%\u0001\t\u0003\t\u0019*A\u0005iE\u0006\u001cXmQ8oMV\u0011\u0011Q\u0013\t\u0005\u0003/\u000bi*\u0004\u0002\u0002\u001a*\u0019\u00111\u0014\u0004\u0002\t\r|gNZ\u0005\u0005\u0003?\u000bIJA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\n\u0003G\u0003!\u0019!C!\u0003K\u000baa]2iK6\fW#A\"\t\u000f\u0005%\u0006\u0001)A\u0005\u0007\u000691o\u00195f[\u0006\u0004\u0003bBAW\u0001\u0011\u0005\u0011qV\u0001\fGJ,\u0017\r^3UC\ndW\r\u0006\u0002\u00022B\u0019!%a-\n\u0007\u0005U6E\u0001\u0003V]&$\bbBA]\u0001\u0011\u0005\u00131X\u0001\u0007S:\u001cXM\u001d;\u0015\r\u0005E\u0016QXAd\u0011!\ty,a.A\u0002\u0005\u0005\u0017\u0001\u00023bi\u0006\u00042aTAb\u0013\r\t)M\u0005\u0002\n\t\u0006$\u0018M\u0012:b[\u0016D\u0001\"!3\u00028\u0002\u0007\u00111H\u0001\n_Z,'o\u001e:ji\u0016Dq!!4\u0001\t\u0003\ty-A\u000bhKRLe\u000eZ3yK\u0012\u0004&o\u001c6fGRLwN\\:\u0015\t\u0005E\u0017Q\u001f\t\u0007\u0003'\f\u0019/!;\u000f\t\u0005U\u0017q\u001c\b\u0005\u0003/\fi.\u0004\u0002\u0002Z*\u0019\u00111\u001c\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0013bAAqG\u00059\u0001/Y2lC\u001e,\u0017\u0002BAs\u0003O\u00141aU3r\u0015\r\t\to\t\t\u0007E\u0005-\u0018q^:\n\u0007\u000558E\u0001\u0004UkBdWM\r\t\u0005\u00037\t\t0\u0003\u0003\u0002t\u0006u!!\u0002$jK2$\u0007\u0002CA|\u0003\u0017\u0004\r!!?\u0002\u001fI,\u0017/^5sK\u0012\u001cu\u000e\\;n]N\u0004BAIA~i%\u0019\u0011Q`\u0012\u0003\u000b\u0005\u0013(/Y=\t\u000f\t\u0005\u0001\u0001\"\u0001\u0003\u0004\u0005Y\u0001/\u0019:tKJ{woS3z)\u0019\u0011)A!\u0004\u0003\u001aA1a&MAx\u0005\u000f\u00012A\tB\u0005\u0013\r\u0011Ya\t\u0002\u0004\u0003:L\b\u0002\u0003B\b\u0003\u007f\u0004\rA!\u0005\u0002\u0007I|w\u000fE\u0003#\u0003w\u0014\u0019\u0002E\u0002#\u0005+I1Aa\u0006$\u0005\u0011\u0011\u0015\u0010^3\t\u0011\tm\u0011q a\u0001\u0005;\t\u0011b[3z\r&,G\u000eZ:\u0011\r\u0005M\u00171]Ax\u0011\u001d\u0011\t\u0003\u0001C\u0001\u0005G\t\u0001BY;jY\u0012\u0014vn\u001e\u000b\u0007\u0005K\u0011YCa\f\u0011\u0007=\u00139#C\u0002\u0003*I\u00111AU8x\u0011!\u0011iCa\bA\u0002\tu\u0011A\u00024jK2$7\u000f\u0003\u0005\u00032\t}\u0001\u0019\u0001B\u001a\u0003\u0019\u0011Xm];miB!!Q\u0007B\u001e\u001b\t\u00119DC\u0002\u0003:\u0011\taa\u00197jK:$\u0018\u0002\u0002B\u001f\u0005o\u0011aAU3tk2$\bb\u0002B!\u0001\u0011\u0005#1I\u0001\nEVLG\u000eZ*dC:$bA!\u0012\u0003R\tM\u0003C\u0002B$\u0005\u001b\u0012)#\u0004\u0002\u0003J)\u0019!1\n\u000b\u0002\u0007I$G-\u0003\u0003\u0003P\t%#a\u0001*E\t\"A\u0011q\u001fB \u0001\u0004\tI\u0010\u0003\u0005\u0003V\t}\u0002\u0019\u0001B,\u0003\u001d1\u0017\u000e\u001c;feN\u0004RAIA~\u00053\u00022a\u0004B.\u0013\r\u0011i\u0006\u0005\u0002\u0007\r&dG/\u001a:\t\u000f\t\u0005\u0004\u0001\"\u0001\u0003d\u0005y\"-^5mIB+8\u000f\u001b#po:\u0004&/\u001a3jG\u0006$Xm\u001d*fg>,(oY3\u0015\t\t\u0015$\u0011\u0010\t\nE\t\u001d$1\u000eB9\u0005oJ1A!\u001b$\u0005\u0019!V\u000f\u001d7fgA\u0019!L!\u001c\n\u0007\t=$A\u0001\u0007S_^\\U-\u001f$jYR,'\u000fE\u0002[\u0005gJ1A!\u001e\u0003\u0005Y!\u0015P\\1nS\u000edunZ5d\u000bb\u0004(/Z:tS>t\u0007#\u0002\u0012\u0002|\nE\u0001\u0002\u0003B+\u0005?\u0002\rAa\u0016\t\u000f\tu\u0004\u0001\"\u0001\u0003\u0000\u0005!BO]1ogZ,'o]3GS2$XM\u001d+sK\u0016$\u0002B!\u001d\u0003\u0002\n\u0015%\u0011\u0014\u0005\t\u0005\u0007\u0013Y\b1\u0001\u0003l\u0005\u0011\u0002/\u0019:f]R\u0014vn^&fs\u001aKG\u000e^3s\u0011!\u00119Ia\u001fA\u0002\t%\u0015A\u0003<bYV,\u0017I\u001d:bsB1!1\u0012BK\u0005#i!A!$\u000b\t\t=%\u0011S\u0001\b[V$\u0018M\u00197f\u0015\r\u0011\u0019jI\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002BL\u0005\u001b\u00131\"T;uC\ndW\rT5ti\"A!1\u0014B>\u0001\u0004\u0011I&\u0001\u0004gS2$XM\u001d\u0005\n\u0005?\u0003\u0011\u0011!C\u0001\u0005C\u000bAaY8qsR1!1\u0015BT\u0005S#2!\u0017BS\u0011\u0019a%Q\u0014a\u0001\u001d\"A1F!(\u0011\u0002\u0003\u0007Q\u0006\u0003\u0005?\u0005;\u0003\n\u00111\u0001A\u0011%\u0011i\u000bAI\u0001\n\u0003\u0011y+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tE&fA\u0017\u00034.\u0012!Q\u0017\t\u0005\u0005o\u0013\t-\u0004\u0002\u0003:*!!1\u0018B_\u0003%)hn\u00195fG.,GMC\u0002\u0003@\u000e\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\u0019M!/\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0003H\u0002\t\n\u0011\"\u0001\u0003J\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001BfU\r\u0001%1\u0017\u0005\n\u0005\u001f\u0004\u0011\u0011!C!\u0005#\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001Bj!\u0011\u0011)Na8\u000e\u0005\t]'\u0002\u0002Bm\u00057\fA\u0001\\1oO*\u0011!Q\\\u0001\u0005U\u00064\u0018-C\u00027\u0005/D\u0011Ba9\u0001\u0003\u0003%\t!!\u0017\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\t\u0013\t\u001d\b!!A\u0005\u0002\t%\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005\u000f\u0011Y\u000fC\u0005\u0003n\n\u0015\u0018\u0011!a\u0001g\u0006\u0019\u0001\u0010J\u0019\t\u0013\tE\b!!A\u0005B\tM\u0018a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\tU\bC\u0002B|\u0005s\u00149!\u0004\u0002\u0003\u0012&!!1 BI\u0005!IE/\u001a:bi>\u0014\b\"\u0003B\u0000\u0001\u0005\u0005I\u0011AB\u0001\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u001e\u0007\u0007A!B!<\u0003~\u0006\u0005\t\u0019\u0001B\u0004\u0011%\u00199\u0001AA\u0001\n\u0003\u001aI!\u0001\u0005iCND7i\u001c3f)\u0005\u0019\b\"CB\u0007\u0001\u0005\u0005I\u0011IB\b\u0003!!xn\u0015;sS:<GC\u0001Bj\u0011%\u0019\u0019\u0002AA\u0001\n\u0003\u001a)\"\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003w\u00199\u0002\u0003\u0006\u0003n\u000eE\u0011\u0011!a\u0001\u0005\u000fA3\u0001AB\u000e!\u0011\u0019ib!\u000b\u000f\t\r}1QE\u0007\u0003\u0007CQ1aa\t\u0005\u00039\u0019G.Y:tS\u001aL7-\u0019;j_:LAaa\n\u0004\"\u0005\t\u0012J\u001c;fe\u001a\f7-Z!vI&,gnY3\n\t\r-2Q\u0006\u0002\b!JLg/\u0019;f\u0015\u0011\u00199c!\t\b\u0013\rE\"!!A\t\u0002\rM\u0012!\u0004%CCN,'+\u001a7bi&|g\u000eE\u0002[\u0007k1\u0001\"\u0001\u0002\u0002\u0002#\u00051qG\n\u0006\u0007k\u0019Id\n\t\u0004E\rm\u0012bAB\u001fG\t1\u0011I\\=SK\u001aDqAVB\u001b\t\u0003\u0019\t\u0005\u0006\u0002\u00044!Q1QBB\u001b\u0003\u0003%)ea\u0004\t\u0015\r\u001d3QGA\u0001\n\u0003\u001bI%A\u0003baBd\u0017\u0010\u0006\u0004\u0004L\rE3Q\u000b\u000b\u00043\u000e5\u0003B\u0002'\u0004F\u0001\u0007a\nK\u0002\u0004NiBaaKB#\u0001\u0004i\u0003fAB)u!1ah!\u0012A\u0002\u0001C!b!\u0017\u00046\u0005\u0005I\u0011QB.\u0003\u001d)h.\u00199qYf$Ba!\u0018\u0004bA!!%QB0!\u0015\u0011\u00131^\u0017A\u0011%\u0019\u0019ga\u0016\u0002\u0002\u0003\u0007\u0011,A\u0002yIAB!ba\u001a\u00046\u0005\u0005I\u0011BB5\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\r-\u0004\u0003\u0002Bk\u0007[JAaa\u001c\u0003X\n1qJ\u00196fGR\u0004")
public class HBaseRelation
extends BaseRelation
implements PrunedFilteredScan,
InsertableRelation,
Logging,
Product,
Serializable {
    private final transient Map<String, String> parameters;
    private final Option<StructType> userSpecifiedSchema;
    private final transient SQLContext sqlContext;
    private final Option<Object> timestamp;
    private final Option<Object> minTimestamp;
    private final Option<Object> maxTimestamp;
    private final Option<Object> maxVersions;
    private final String encoderClsName;
    private final transient BytesEncoder encoder;
    private final HBaseTableCatalog catalog;
    private final String configResources;
    private final boolean useHBaseContext;
    private final boolean usePushDownColumnFilter;
    private final boolean blockCacheEnable;
    private final int cacheSize;
    private final int batchNum;
    private final int bulkGetSize;
    private final HBaseContext hbaseContext;
    private final SerializableConfiguration wrappedConf;
    private final StructType schema;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public Option<StructType> userSpecifiedSchema() {
        return this.userSpecifiedSchema;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public Option<Object> timestamp() {
        return this.timestamp;
    }

    public Option<Object> minTimestamp() {
        return this.minTimestamp;
    }

    public Option<Object> maxTimestamp() {
        return this.maxTimestamp;
    }

    public Option<Object> maxVersions() {
        return this.maxVersions;
    }

    public String encoderClsName() {
        return this.encoderClsName;
    }

    public BytesEncoder encoder() {
        return this.encoder;
    }

    public HBaseTableCatalog catalog() {
        return this.catalog;
    }

    public String tableName() {
        return this.catalog().name();
    }

    public String configResources() {
        return this.configResources;
    }

    public boolean useHBaseContext() {
        return this.useHBaseContext;
    }

    public boolean usePushDownColumnFilter() {
        return this.usePushDownColumnFilter;
    }

    public boolean blockCacheEnable() {
        return this.blockCacheEnable;
    }

    public int cacheSize() {
        return this.cacheSize;
    }

    public int batchNum() {
        return this.batchNum;
    }

    public int bulkGetSize() {
        return this.bulkGetSize;
    }

    public HBaseContext hbaseContext() {
        return this.hbaseContext;
    }

    public SerializableConfiguration wrappedConf() {
        return this.wrappedConf;
    }

    public Configuration hbaseConf() {
        return this.wrappedConf().value();
    }

    public StructType schema() {
        return this.schema;
    }

    public void createTable() {
        Admin admin;
        SmartConnection connection;
        int numReg = BoxesRunTime.unboxToInt((Object)this.parameters().get((Object)HBaseTableCatalog$.MODULE$.newTable()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(String x) {
                return new StringOps(Predef$.MODULE$.augmentString(x)).toInt();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 0;
            }
        }));
        byte[] startKey = Bytes.toBytes((String)((String)this.parameters().get((Object)HBaseTableCatalog$.MODULE$.regionStart()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return HBaseTableCatalog$.MODULE$.defaultRegionStart();
            }
        })));
        byte[] endKey = Bytes.toBytes((String)((String)this.parameters().get((Object)HBaseTableCatalog$.MODULE$.regionEnd()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return HBaseTableCatalog$.MODULE$.defaultRegionEnd();
            }
        })));
        if (numReg > 3) {
            TableName tName = TableName.valueOf((String)this.catalog().name());
            Seq<String> cfs = this.catalog().getColumnFamilies();
            connection = HBaseConnectionCache$.MODULE$.getConnection(this.hbaseConf());
            admin = connection.getAdmin();
            if (!admin.isTableAvailable(tName)) {
                HTableDescriptor tableDesc = new HTableDescriptor(tName);
                cfs.foreach((Function1)new Serializable(this, tableDesc){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HBaseRelation $outer;
                    private final HTableDescriptor tableDesc$1;

                    public final HTableDescriptor apply(String x) {
                        HColumnDescriptor cf = new HColumnDescriptor(x.getBytes());
                        this.$outer.logDebug((Function0<String>)new Serializable(this, x){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$createTable$1 $outer;
                            private final String x$29;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"add family ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x$29, this.$outer.org$apache$hadoop$hbase$spark$HBaseRelation$$anonfun$$$outer().catalog().name()}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.x$29 = x$29;
                            }
                        });
                        return this.tableDesc$1.addFamily(cf);
                    }

                    public /* synthetic */ HBaseRelation org$apache$hadoop$hbase$spark$HBaseRelation$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.tableDesc$1 = tableDesc$1;
                    }
                });
                byte[][] splitKeys = Bytes.split((byte[])startKey, (byte[])endKey, (int)numReg);
                admin.createTable(tableDesc, splitKeys);
            }
        } else {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\n           |is not defined or no larger than 3, skip the create table"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HBaseTableCatalog$.MODULE$.newTable()})))).stripMargin();
                }
            });
        }
        return;
        finally {
            admin.close();
            connection.close();
        }
    }

    public void insert(DataFrame data, boolean overwrite) {
        JobConf jobConfig = new JobConf(this.hbaseConf(), ((Object)((Object)this)).getClass());
        jobConfig.setOutputFormat(TableOutputFormat.class);
        jobConfig.set("hbase.mapred.outputtable", this.catalog().name());
        IntRef count = new IntRef(0);
        Seq<Field> rkFields = this.catalog().getRowKey();
        Seq rkIdxedFields = (Seq)rkFields.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseRelation $outer;

            public final Tuple2<Object, Field> apply(Field x0$1) {
                Field field = x0$1;
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)this.$outer.schema().fieldIndex(field.colName())), (Object)field);
                return tuple2;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Tuple2[] colsIdxedFields = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.schema().fieldNames()).partition((Function1)new Serializable(this, rkFields){
            public static final long serialVersionUID = 0L;
            private final Seq rkFields$1;

            public final boolean apply(String x) {
                return ((SeqLike)this.rkFields$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Field x$11) {
                        return x$11.colName();
                    }
                }, Seq$.MODULE$.canBuildFrom())).contains((Object)x);
            }
            {
                this.rkFields$1 = rkFields$1;
            }
        })._2()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseRelation $outer;

            public final Tuple2<Object, Field> apply(String x) {
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)this.$outer.schema().fieldIndex(x)), (Object)this.$outer.catalog().getField(x));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        RDD rdd = data.rdd();
        RDD$.MODULE$.rddToPairRDDFunctions(rdd.map((Function1)new Serializable(this, count, rkIdxedFields, colsIdxedFields){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseRelation $outer;
            private final IntRef count$1;
            private final Seq rkIdxedFields$1;
            private final Tuple2[] colsIdxedFields$1;

            public final Tuple2<ImmutableBytesWritable, Put> apply(Row x$13) {
                return this.$outer.org$apache$hadoop$hbase$spark$HBaseRelation$$convertToPut$1(x$13, this.count$1, this.rkIdxedFields$1, this.colsIdxedFields$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.count$1 = count$1;
                this.rkIdxedFields$1 = rkIdxedFields$1;
                this.colsIdxedFields$1 = colsIdxedFields$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(ImmutableBytesWritable.class), ClassTag$.MODULE$.apply(Put.class), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms())).saveAsHadoopDataset(jobConfig);
    }

    public Seq<Tuple2<Field, Object>> getIndexedProjections(String[] requiredColumns) {
        return (Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])requiredColumns).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseRelation $outer;

            public final Field apply(String x$14) {
                return this.$outer.catalog().sMap().getField(x$14);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Field.class)))).zipWithIndex(Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public Map<Field, Object> parseRowKey(byte[] row, Seq<Field> keyFields) {
        return ((TraversableOnce)((Tuple2)keyFields.foldLeft((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), (Function2)new Serializable(this, row){
            public static final long serialVersionUID = 0L;
            private final byte[] row$2;

            public final Tuple2<Object, Seq<Tuple2<Field, Object>>> apply(Tuple2<Object, Seq<Tuple2<Field, Object>>> state, Field field) {
                Tuple2 tuple2;
                int idx = state._1$mcI$sp();
                Seq parsed = (Seq)state._2();
                if (field.length() != -1) {
                    Object value = Utils$.MODULE$.hbaseFieldToScalaType(field, this.row$2, idx, field.length());
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)(idx + field.length())), parsed.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)field, value)})), Seq$.MODULE$.canBuildFrom()));
                } else {
                    Tuple2 tuple22;
                    DataType dataType = field.dt();
                    StringType$ stringType$ = StringType$.MODULE$;
                    DataType dataType2 = dataType;
                    if (!(stringType$ != null ? !stringType$.equals(dataType2) : dataType2 != null)) {
                        Tuple2 tuple23;
                        int pos = Predef$.MODULE$.byteArrayOps(this.row$2).indexOf((Object)BoxesRunTime.boxToByte((byte)HBaseTableCatalog$.MODULE$.delimiter()), idx);
                        if (pos == -1 || pos > this.row$2.length) {
                            Object value = Utils$.MODULE$.hbaseFieldToScalaType(field, this.row$2, idx, this.row$2.length);
                            tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)(this.row$2.length + 1)), parsed.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)field, value)})), Seq$.MODULE$.canBuildFrom()));
                        } else {
                            Object value = Utils$.MODULE$.hbaseFieldToScalaType(field, this.row$2, idx, pos - idx);
                            tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)pos), parsed.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)field, value)})), Seq$.MODULE$.canBuildFrom()));
                        }
                        tuple22 = tuple23;
                    } else {
                        tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)(this.row$2.length + 1)), parsed.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)field, Utils$.MODULE$.hbaseFieldToScalaType(field, this.row$2, idx, this.row$2.length))})), Seq$.MODULE$.canBuildFrom()));
                    }
                    tuple2 = tuple22;
                }
                return tuple2;
            }
            {
                this.row$2 = row$2;
            }
        }))._2()).toMap(Predef$.MODULE$.conforms());
    }

    public Row buildRow(Seq<Field> fields, Result result) {
        byte[] r = result.getRow();
        Map<Field, Object> keySeq = this.parseRowKey(r, this.catalog().getRowKey());
        Map valueSeq = ((TraversableOnce)((TraversableLike)fields.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Field x$15) {
                return !x$15.isRowKey();
            }
        })).map((Function1)new Serializable(this, result){
            public static final long serialVersionUID = 0L;
            private final Result result$1;

            public final Tuple2<Field, Object> apply(Field x) {
                Tuple2 tuple2;
                Cell kv = this.result$1.getColumnLatestCell(Bytes.toBytes((String)x.cf()), Bytes.toBytes((String)x.col()));
                if (kv == null || kv.getValueLength() == 0) {
                    tuple2 = new Tuple2((Object)x, null);
                } else {
                    byte[] v = CellUtil.cloneValue((Cell)kv);
                    DataType dataType = x.dt();
                    BinaryType$ binaryType$ = BinaryType$.MODULE$;
                    DataType dataType2 = dataType;
                    Object object = !(binaryType$ != null ? !binaryType$.equals(dataType2) : dataType2 != null) ? v : (Object)Utils$.MODULE$.hbaseFieldToScalaType(x, v, 0, v.length);
                    Tuple2 tuple22 = new Tuple2((Object)x, object);
                    tuple2 = tuple22;
                }
                return tuple2;
            }
            {
                this.result$1 = result$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        Map unionedRow = keySeq.$plus$plus((GenTraversableOnce)valueSeq);
        return Row$.MODULE$.fromSeq((Seq)fields.map((Function1)new Serializable(this, unionedRow){
            public static final long serialVersionUID = 0L;
            private final Map unionedRow$1;

            public final Object apply(Field x$16) {
                return this.unionedRow$1.get((Object)x$16).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                });
            }
            {
                this.unionedRow$1 = unionedRow$1;
            }
        }, Seq$.MODULE$.canBuildFrom()));
    }

    public RDD<Row> buildScan(String[] requiredColumns, Filter[] filters) {
        RDD resultRDD;
        Tuple3<RowKeyFilter, DynamicLogicExpression, byte[][]> pushDownTuple = this.buildPushDownPredicatesResource(filters);
        RowKeyFilter pushDownRowKeyFilter = (RowKeyFilter)pushDownTuple._1();
        ObjectRef pushDownDynamicLogicExpression = new ObjectRef((Object)((DynamicLogicExpression)pushDownTuple._2()));
        byte[][] valueArray = (byte[][])pushDownTuple._3();
        if (!this.usePushDownColumnFilter()) {
            pushDownDynamicLogicExpression.elem = null;
        }
        this.logDebug((Function0<String>)new Serializable(this, pushDownRowKeyFilter){
            public static final long serialVersionUID = 0L;
            private final RowKeyFilter pushDownRowKeyFilter$1;

            public final String apply() {
                return new StringBuilder().append((Object)"pushDownRowKeyFilter:           ").append(this.pushDownRowKeyFilter$1.ranges()).toString();
            }
            {
                this.pushDownRowKeyFilter$1 = pushDownRowKeyFilter$1;
            }
        });
        if ((DynamicLogicExpression)pushDownDynamicLogicExpression.elem != null) {
            this.logDebug((Function0<String>)new Serializable(this, pushDownDynamicLogicExpression){
                public static final long serialVersionUID = 0L;
                private final ObjectRef pushDownDynamicLogicExpression$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"pushDownDynamicLogicExpression: ").append((Object)((DynamicLogicExpression)this.pushDownDynamicLogicExpression$1.elem).toExpressionString()).toString();
                }
                {
                    this.pushDownDynamicLogicExpression$1 = pushDownDynamicLogicExpression$1;
                }
            });
        }
        this.logDebug((Function0<String>)new Serializable(this, valueArray){
            public static final long serialVersionUID = 0L;
            private final byte[][] valueArray$1;

            public final String apply() {
                return new StringBuilder().append((Object)"valueArray:                     ").append((Object)BoxesRunTime.boxToInteger((int)this.valueArray$1.length)).toString();
            }
            {
                this.valueArray$1 = valueArray$1;
            }
        });
        MutableList requiredQualifierDefinitionList = new MutableList();
        Predef$.MODULE$.refArrayOps((Object[])requiredColumns).foreach((Function1)new Serializable(this, requiredQualifierDefinitionList){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseRelation $outer;
            private final MutableList requiredQualifierDefinitionList$1;

            public final MutableList<Field> apply(String c) {
                Field field = this.$outer.catalog().getField(c);
                return this.requiredQualifierDefinitionList$1.$plus$eq((Object)field);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.requiredQualifierDefinitionList$1 = requiredQualifierDefinitionList$1;
            }
        });
        DefaultSourceStaticUtils$.MODULE$.populateLatestExecutionRules(pushDownRowKeyFilter, (DynamicLogicExpression)pushDownDynamicLogicExpression.elem);
        ArrayList getList = new ArrayList();
        ArrayList rddList = new ArrayList();
        pushDownRowKeyFilter.points().foreach((Function1)new Serializable(this, requiredQualifierDefinitionList, getList){
            public static final long serialVersionUID = 0L;
            private final MutableList requiredQualifierDefinitionList$1;
            private final ArrayList getList$1;

            public final boolean apply(byte[] p) {
                Get get2 = new Get(p);
                this.requiredQualifierDefinitionList$1.foreach((Function1)new Serializable(this, get2){
                    public static final long serialVersionUID = 0L;
                    private final Get get$1;

                    public final Object apply(Field d) {
                        return d.isRowKey() ? this.get$1.addColumn(d.cfBytes(), d.colBytes()) : BoxedUnit.UNIT;
                    }
                    {
                        this.get$1 = get$1;
                    }
                });
                return this.getList$1.add(get2);
            }
            {
                this.requiredQualifierDefinitionList$1 = requiredQualifierDefinitionList$1;
                this.getList$1 = getList$1;
            }
        });
        None$ pushDownFilterJava = this.usePushDownColumnFilter() && (DynamicLogicExpression)pushDownDynamicLogicExpression.elem != null ? new Some((Object)new SparkSQLPushDownFilter((DynamicLogicExpression)pushDownDynamicLogicExpression.elem, valueArray, (MutableList<Field>)requiredQualifierDefinitionList, this.encoderClsName())) : None$.MODULE$;
        HBaseTableScanRDD hRdd = new HBaseTableScanRDD(this, this.hbaseContext(), (Option<SparkSQLPushDownFilter>)pushDownFilterJava, (Seq<Field>)requiredQualifierDefinitionList.seq());
        pushDownRowKeyFilter.points().foreach((Function1)new Serializable(this, hRdd){
            public static final long serialVersionUID = 0L;
            private final HBaseTableScanRDD hRdd$1;

            public final void apply(byte[] x$17) {
                this.hRdd$1.addPoint(x$17);
            }
            {
                this.hRdd$1 = hRdd$1;
            }
        });
        pushDownRowKeyFilter.ranges().foreach((Function1)new Serializable(this, hRdd){
            public static final long serialVersionUID = 0L;
            private final HBaseTableScanRDD hRdd$1;

            public final void apply(ScanRange x$18) {
                this.hRdd$1.addRange(x$18);
            }
            {
                this.hRdd$1 = hRdd$1;
            }
        });
        RDD tmp = hRdd.map((Function1)new Serializable(this, requiredColumns){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseRelation $outer;
            private final String[] requiredColumns$1;

            public final Row apply(Result r) {
                Seq indexedFields = (Seq)this.$outer.getIndexedProjections(this.requiredColumns$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Field apply(Tuple2<Field, Object> x$19) {
                        return (Field)x$19._1();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                return this.$outer.buildRow((Seq<Field>)indexedFields, r);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.requiredColumns$1 = requiredColumns$1;
            }
        }, ClassTag$.MODULE$.apply(Row.class));
        RDD rDD = Predef$.MODULE$.refArrayOps((Object[])tmp.partitions()).size() > 0 ? tmp : (resultRDD = null);
        if (resultRDD == null) {
            RDD rdd;
            Scan scan = new Scan();
            scan.setCacheBlocks(this.blockCacheEnable());
            scan.setBatch(this.batchNum());
            scan.setCaching(this.cacheSize());
            requiredQualifierDefinitionList.foreach((Function1)new Serializable(this, scan){
                public static final long serialVersionUID = 0L;
                private final Scan scan$1;

                public final Scan apply(Field d) {
                    return this.scan$1.addColumn(d.cfBytes(), d.colBytes());
                }
                {
                    this.scan$1 = scan$1;
                }
            });
            resultRDD = rdd = this.hbaseContext().hbaseRDD(TableName.valueOf((String)this.tableName()), scan).map((Function1)new Serializable(this, requiredColumns){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ HBaseRelation $outer;
                private final String[] requiredColumns$1;

                public final Row apply(Tuple2<ImmutableBytesWritable, Result> r) {
                    Seq indexedFields = (Seq)this.$outer.getIndexedProjections(this.requiredColumns$1).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Field apply(Tuple2<Field, Object> x$20) {
                            return (Field)x$20._1();
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    return this.$outer.buildRow((Seq<Field>)indexedFields, (Result)r._2());
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.requiredColumns$1 = requiredColumns$1;
                }
            }, ClassTag$.MODULE$.apply(Row.class));
        }
        return resultRDD;
    }

    public Tuple3<RowKeyFilter, DynamicLogicExpression, byte[][]> buildPushDownPredicatesResource(Filter[] filters) {
        ObjectRef superRowKeyFilter = new ObjectRef(null);
        MutableList queryValueList = new MutableList();
        ObjectRef superDynamicLogicExpression = new ObjectRef(null);
        Predef$.MODULE$.refArrayOps((Object[])filters).foreach((Function1)new Serializable(this, superRowKeyFilter, queryValueList, superDynamicLogicExpression){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseRelation $outer;
            private final ObjectRef superRowKeyFilter$1;
            private final MutableList queryValueList$1;
            private final ObjectRef superDynamicLogicExpression$1;

            public final Object apply(Filter f) {
                Object object;
                RowKeyFilter rowKeyFilter = new RowKeyFilter(RowKeyFilter$.MODULE$.$lessinit$greater$default$1(), RowKeyFilter$.MODULE$.$lessinit$greater$default$2(), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
                DynamicLogicExpression logicExpression = this.$outer.transverseFilterTree(rowKeyFilter, (MutableList<byte[]>)this.queryValueList$1, f);
                if ((DynamicLogicExpression)this.superDynamicLogicExpression$1.elem == null) {
                    this.superDynamicLogicExpression$1.elem = logicExpression;
                    this.superRowKeyFilter$1.elem = rowKeyFilter;
                    object = BoxedUnit.UNIT;
                } else {
                    this.superDynamicLogicExpression$1.elem = new AndLogicExpression((DynamicLogicExpression)this.superDynamicLogicExpression$1.elem, logicExpression);
                    object = ((RowKeyFilter)this.superRowKeyFilter$1.elem).mergeIntersect(rowKeyFilter);
                }
                return object;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.superRowKeyFilter$1 = superRowKeyFilter$1;
                this.queryValueList$1 = queryValueList$1;
                this.superDynamicLogicExpression$1 = superDynamicLogicExpression$1;
            }
        });
        byte[][] queryValueArray = (byte[][])queryValueList.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        if ((RowKeyFilter)superRowKeyFilter.elem == null) {
            superRowKeyFilter.elem = new RowKeyFilter(RowKeyFilter$.MODULE$.$lessinit$greater$default$1(), RowKeyFilter$.MODULE$.$lessinit$greater$default$2(), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
        }
        return new Tuple3((Object)((RowKeyFilter)superRowKeyFilter.elem), (Object)((DynamicLogicExpression)superDynamicLogicExpression.elem), (Object)queryValueArray);
    }

    public DynamicLogicExpression transverseFilterTree(RowKeyFilter parentRowKeyFilter, MutableList<byte[]> valueArray, Filter filter) {
        DynamicLogicExpression dynamicLogicExpression;
        Filter filter2 = filter;
        if (filter2 instanceof EqualTo) {
            BoxedUnit boxedUnit;
            EqualTo equalTo = (EqualTo)filter2;
            String attr = equalTo.attribute();
            Object value = equalTo.value();
            Field field = this.catalog().getField(attr);
            if (field == null) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Object object = field.isRowKey() ? parentRowKeyFilter.mergeIntersect(new RowKeyFilter(DefaultSourceStaticUtils$.MODULE$.getByteValue(field, value.toString()), null, RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4())) : BoxedUnit.UNIT;
                byte[] byteValue = DefaultSourceStaticUtils$.MODULE$.getByteValue(field, value.toString());
                boxedUnit = valueArray.$plus$eq((Object)byteValue);
            }
            dynamicLogicExpression = new EqualLogicExpression(attr, valueArray.length() - 1, false);
        } else if (filter2 instanceof LessThan) {
            BoxedUnit boxedUnit;
            LessThan lessThan = (LessThan)filter2;
            String attr = lessThan.attribute();
            Object value = lessThan.value();
            Field field = this.catalog().getField(attr);
            if (field == null) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit2;
                if (field.isRowKey()) {
                    Option<BoundRanges> b = this.encoder().ranges(value);
                    BooleanRef inc = new BooleanRef(false);
                    boxedUnit2 = b.map((Function1)new Serializable(this, inc){
                        public static final long serialVersionUID = 0L;
                        public final BooleanRef inc$1;

                        public final RowKeyFilter[] apply(BoundRanges x$21) {
                            return (RowKeyFilter[])Predef$.MODULE$.refArrayOps((Object[])x$21.less()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$transverseFilterTree$1 $outer;

                                /*
                                 * WARNING - void declaration
                                 */
                                public final RowKeyFilter apply(BoundRange x) {
                                    void var2_2;
                                    RowKeyFilter r = new RowKeyFilter(null, new ScanRange(x.upper(), this.$outer.inc$1.elem, x.low(), true), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
                                    this.$outer.inc$1.elem = true;
                                    return var2_2;
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RowKeyFilter.class)));
                        }
                        {
                            this.inc$1 = inc$1;
                        }
                    }).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final RowKeyFilter apply(RowKeyFilter[] x) {
                            return (RowKeyFilter)Predef$.MODULE$.refArrayOps((Object[])x).reduce((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final RowKeyFilter apply(RowKeyFilter i, RowKeyFilter j) {
                                    return i.mergeUnion(j);
                                }
                            });
                        }
                    }).map((Function1)new Serializable(this, parentRowKeyFilter){
                        public static final long serialVersionUID = 0L;
                        private final RowKeyFilter parentRowKeyFilter$1;

                        public final RowKeyFilter apply(RowKeyFilter x$22) {
                            return this.parentRowKeyFilter$1.mergeIntersect(x$22);
                        }
                        {
                            this.parentRowKeyFilter$1 = parentRowKeyFilter$1;
                        }
                    });
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                byte[] byteValue = this.encoder().encode(field.dt(), value);
                boxedUnit = valueArray.$plus$eq((Object)byteValue);
            }
            dynamicLogicExpression = new LessThanLogicExpression(attr, valueArray.length() - 1);
        } else if (filter2 instanceof GreaterThan) {
            BoxedUnit boxedUnit;
            GreaterThan greaterThan = (GreaterThan)filter2;
            String attr = greaterThan.attribute();
            Object value = greaterThan.value();
            Field field = this.catalog().getField(attr);
            if (field == null) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit3;
                if (field.isRowKey()) {
                    Option<BoundRanges> b = this.encoder().ranges(value);
                    BooleanRef inc = new BooleanRef(false);
                    boxedUnit3 = b.map((Function1)new Serializable(this, inc){
                        public static final long serialVersionUID = 0L;
                        public final BooleanRef inc$2;

                        public final RowKeyFilter[] apply(BoundRanges x$23) {
                            return (RowKeyFilter[])Predef$.MODULE$.refArrayOps((Object[])x$23.greater()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$transverseFilterTree$4 $outer;

                                /*
                                 * WARNING - void declaration
                                 */
                                public final RowKeyFilter apply(BoundRange x) {
                                    void var2_2;
                                    RowKeyFilter r = new RowKeyFilter(null, new ScanRange(x.upper(), true, x.low(), this.$outer.inc$2.elem), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
                                    this.$outer.inc$2.elem = true;
                                    return var2_2;
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RowKeyFilter.class)));
                        }
                        {
                            this.inc$2 = inc$2;
                        }
                    }).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final RowKeyFilter apply(RowKeyFilter[] x) {
                            return (RowKeyFilter)Predef$.MODULE$.refArrayOps((Object[])x).reduce((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final RowKeyFilter apply(RowKeyFilter i, RowKeyFilter j) {
                                    return i.mergeUnion(j);
                                }
                            });
                        }
                    }).map((Function1)new Serializable(this, parentRowKeyFilter){
                        public static final long serialVersionUID = 0L;
                        private final RowKeyFilter parentRowKeyFilter$1;

                        public final RowKeyFilter apply(RowKeyFilter x$24) {
                            return this.parentRowKeyFilter$1.mergeIntersect(x$24);
                        }
                        {
                            this.parentRowKeyFilter$1 = parentRowKeyFilter$1;
                        }
                    });
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                byte[] byteValue = this.encoder().encode(field.dt(), value);
                boxedUnit = valueArray.$plus$eq((Object)byteValue);
            }
            dynamicLogicExpression = new GreaterThanLogicExpression(attr, valueArray.length() - 1);
        } else if (filter2 instanceof LessThanOrEqual) {
            BoxedUnit boxedUnit;
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter2;
            String attr = lessThanOrEqual.attribute();
            Object value = lessThanOrEqual.value();
            Field field = this.catalog().getField(attr);
            if (field == null) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit4;
                if (field.isRowKey()) {
                    Option<BoundRanges> b = this.encoder().ranges(value);
                    boxedUnit4 = b.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final RowKeyFilter[] apply(BoundRanges x$25) {
                            return (RowKeyFilter[])Predef$.MODULE$.refArrayOps((Object[])x$25.less()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final RowKeyFilter apply(BoundRange x) {
                                    return new RowKeyFilter(null, new ScanRange(x.upper(), true, x.low(), true), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RowKeyFilter.class)));
                        }
                    }).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final RowKeyFilter apply(RowKeyFilter[] x) {
                            return (RowKeyFilter)Predef$.MODULE$.refArrayOps((Object[])x).reduce((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final RowKeyFilter apply(RowKeyFilter i, RowKeyFilter j) {
                                    return i.mergeUnion(j);
                                }
                            });
                        }
                    }).map((Function1)new Serializable(this, parentRowKeyFilter){
                        public static final long serialVersionUID = 0L;
                        private final RowKeyFilter parentRowKeyFilter$1;

                        public final RowKeyFilter apply(RowKeyFilter x$26) {
                            return this.parentRowKeyFilter$1.mergeIntersect(x$26);
                        }
                        {
                            this.parentRowKeyFilter$1 = parentRowKeyFilter$1;
                        }
                    });
                } else {
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                byte[] byteValue = this.encoder().encode(field.dt(), value);
                boxedUnit = valueArray.$plus$eq((Object)byteValue);
            }
            dynamicLogicExpression = new LessThanOrEqualLogicExpression(attr, valueArray.length() - 1);
        } else if (filter2 instanceof GreaterThanOrEqual) {
            BoxedUnit boxedUnit;
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter2;
            String attr = greaterThanOrEqual.attribute();
            Object value = greaterThanOrEqual.value();
            Field field = this.catalog().getField(attr);
            if (field == null) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit5;
                if (field.isRowKey()) {
                    Option<BoundRanges> b = this.encoder().ranges(value);
                    boxedUnit5 = b.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final RowKeyFilter[] apply(BoundRanges x$27) {
                            return (RowKeyFilter[])Predef$.MODULE$.refArrayOps((Object[])x$27.greater()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final RowKeyFilter apply(BoundRange x) {
                                    return new RowKeyFilter(null, new ScanRange(x.upper(), true, x.low(), true), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RowKeyFilter.class)));
                        }
                    }).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final RowKeyFilter apply(RowKeyFilter[] x) {
                            return (RowKeyFilter)Predef$.MODULE$.refArrayOps((Object[])x).reduce((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final RowKeyFilter apply(RowKeyFilter i, RowKeyFilter j) {
                                    return i.mergeUnion(j);
                                }
                            });
                        }
                    }).map((Function1)new Serializable(this, parentRowKeyFilter){
                        public static final long serialVersionUID = 0L;
                        private final RowKeyFilter parentRowKeyFilter$1;

                        public final RowKeyFilter apply(RowKeyFilter x$28) {
                            return this.parentRowKeyFilter$1.mergeIntersect(x$28);
                        }
                        {
                            this.parentRowKeyFilter$1 = parentRowKeyFilter$1;
                        }
                    });
                } else {
                    boxedUnit5 = BoxedUnit.UNIT;
                }
                byte[] byteValue = this.encoder().encode(field.dt(), value);
                boxedUnit = valueArray.$plus$eq((Object)byteValue);
            }
            dynamicLogicExpression = new GreaterThanOrEqualLogicExpression(attr, valueArray.length() - 1);
        } else if (filter2 instanceof Or) {
            Or or = (Or)filter2;
            Filter left = or.left();
            Filter right = or.right();
            DynamicLogicExpression leftExpression = this.transverseFilterTree(parentRowKeyFilter, valueArray, left);
            RowKeyFilter rightSideRowKeyFilter = new RowKeyFilter(RowKeyFilter$.MODULE$.$lessinit$greater$default$1(), RowKeyFilter$.MODULE$.$lessinit$greater$default$2(), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
            DynamicLogicExpression rightExpression = this.transverseFilterTree(rightSideRowKeyFilter, valueArray, right);
            parentRowKeyFilter.mergeUnion(rightSideRowKeyFilter);
            dynamicLogicExpression = new OrLogicExpression(leftExpression, rightExpression);
        } else if (filter2 instanceof And) {
            And and2 = (And)filter2;
            Filter left = and2.left();
            Filter right = and2.right();
            DynamicLogicExpression leftExpression = this.transverseFilterTree(parentRowKeyFilter, valueArray, left);
            RowKeyFilter rightSideRowKeyFilter = new RowKeyFilter(RowKeyFilter$.MODULE$.$lessinit$greater$default$1(), RowKeyFilter$.MODULE$.$lessinit$greater$default$2(), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
            DynamicLogicExpression rightExpression = this.transverseFilterTree(rightSideRowKeyFilter, valueArray, right);
            parentRowKeyFilter.mergeIntersect(rightSideRowKeyFilter);
            dynamicLogicExpression = new AndLogicExpression(leftExpression, rightExpression);
        } else if (filter2 instanceof IsNull) {
            IsNull isNull = (IsNull)filter2;
            String attr = isNull.attribute();
            dynamicLogicExpression = new IsNullLogicExpression(attr, false);
        } else if (filter2 instanceof IsNotNull) {
            IsNotNull isNotNull = (IsNotNull)filter2;
            String attr = isNotNull.attribute();
            dynamicLogicExpression = new IsNullLogicExpression(attr, true);
        } else {
            dynamicLogicExpression = new PassThroughLogicExpression();
        }
        return dynamicLogicExpression;
    }

    public HBaseRelation copy(Map<String, String> parameters, Option<StructType> userSpecifiedSchema, SQLContext sqlContext) {
        return new HBaseRelation(parameters, userSpecifiedSchema, sqlContext);
    }

    public Map<String, String> copy$default$1() {
        return this.parameters();
    }

    public Option<StructType> copy$default$2() {
        return this.userSpecifiedSchema();
    }

    public String productPrefix() {
        return "HBaseRelation";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Option<StructType> option;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                option = this.userSpecifiedSchema();
                break;
            }
            case 0: {
                option = this.parameters();
            }
        }
        return option;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HBaseRelation;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HBaseRelation)) return false;
        boolean bl = true;
        if (!bl) return false;
        HBaseRelation hBaseRelation = (HBaseRelation)((Object)x$1);
        Map<String, String> map = this.parameters();
        Map<String, String> map2 = hBaseRelation.parameters();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Option<StructType> option = this.userSpecifiedSchema();
        Option<StructType> option2 = hBaseRelation.userSpecifiedSchema();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!hBaseRelation.canEqual((Object)this)) return false;
        return true;
    }

    public final Tuple2 org$apache$hadoop$hbase$spark$HBaseRelation$$convertToPut$1(Row row, IntRef count$1, Seq rkIdxedFields$1, Tuple2[] colsIdxedFields$1) {
        Seq rowBytes = (Seq)rkIdxedFields$1.map((Function1)new Serializable(this, row){
            public static final long serialVersionUID = 0L;
            private final Row row$1;

            public final byte[] apply(Tuple2<Object, Field> x0$2) {
                Tuple2<Object, Field> tuple2 = x0$2;
                if (tuple2 != null) {
                    int x = tuple2._1$mcI$sp();
                    Field y = (Field)tuple2._2();
                    byte[] byArray = Utils$.MODULE$.toBytes(this.row$1.apply(x), y);
                    return byArray;
                }
                throw new MatchError(tuple2);
            }
            {
                this.row$1 = row$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        int rLen = BoxesRunTime.unboxToInt((Object)rowBytes.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(int x0$3, byte[] x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$3), (Object)x1$1);
                if (tuple2 != null) {
                    int x = tuple2._1$mcI$sp();
                    byte[] y = (byte[])tuple2._2();
                    int n = x + y.length;
                    return n;
                }
                throw new MatchError((Object)tuple2);
            }
        }));
        byte[] rBytes = new byte[rLen];
        IntRef offset = new IntRef(0);
        rowBytes.foreach((Function1)new Serializable(this, rBytes, offset){
            public static final long serialVersionUID = 0L;
            private final byte[] rBytes$1;
            private final IntRef offset$1;

            public final void apply(byte[] x) {
                System.arraycopy(x, 0, this.rBytes$1, this.offset$1.elem, x.length);
                this.offset$1.elem += x.length;
            }
            {
                this.rBytes$1 = rBytes$1;
                this.offset$1 = offset$1;
            }
        });
        Put put = (Put)this.timestamp().fold((Function0)new Serializable(this, rBytes){
            public static final long serialVersionUID = 0L;
            private final byte[] rBytes$1;

            public final Put apply() {
                return new Put(this.rBytes$1);
            }
            {
                this.rBytes$1 = rBytes$1;
            }
        }, (Function1)new Serializable(this, rBytes){
            public static final long serialVersionUID = 0L;
            private final byte[] rBytes$1;

            public final Put apply(long x$12) {
                return new Put(this.rBytes$1, x$12);
            }
            {
                this.rBytes$1 = rBytes$1;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])colsIdxedFields$1).foreach((Function1)new Serializable(this, row, put){
            public static final long serialVersionUID = 0L;
            private final Row row$1;
            private final Put put$1;

            public final Put apply(Tuple2<Object, Field> x0$4) {
                Tuple2<Object, Field> tuple2 = x0$4;
                if (tuple2 != null) {
                    int x = tuple2._1$mcI$sp();
                    Field y = (Field)tuple2._2();
                    byte[] b = Utils$.MODULE$.toBytes(this.row$1.apply(x), y);
                    Put put = this.put$1.addColumn(Bytes.toBytes((String)y.cf()), Bytes.toBytes((String)y.col()), b);
                    return put;
                }
                throw new MatchError(tuple2);
            }
            {
                this.row$1 = row$1;
                this.put$1 = put$1;
            }
        });
        ++count$1.elem;
        return new Tuple2((Object)new ImmutableBytesWritable(), (Object)put);
    }

    public HBaseRelation(Map<String, String> parameters, Option<StructType> userSpecifiedSchema, SQLContext sqlContext) {
        HBaseContext hBaseContext;
        this.parameters = parameters;
        this.userSpecifiedSchema = userSpecifiedSchema;
        this.sqlContext = sqlContext;
        Logging.class.$init$((Logging)this);
        Product.class.$init$((Product)this);
        this.timestamp = parameters.get((Object)HBaseSparkConf$.MODULE$.TIMESTAMP()).map((Function1)new $anonfun$8(this));
        this.minTimestamp = parameters.get((Object)HBaseSparkConf$.MODULE$.TIMERANGE_START()).map((Function1)new $anonfun$9(this));
        this.maxTimestamp = parameters.get((Object)HBaseSparkConf$.MODULE$.TIMERANGE_END()).map((Function1)new $anonfun$10(this));
        this.maxVersions = parameters.get((Object)HBaseSparkConf$.MODULE$.MAX_VERSIONS()).map((Function1)new $anonfun$11(this));
        this.encoderClsName = (String)parameters.get((Object)HBaseSparkConf$.MODULE$.QUERY_ENCODER()).getOrElse((Function0)new $anonfun$12(this));
        this.encoder = JavaBytesEncoder$.MODULE$.create(this.encoderClsName());
        this.catalog = HBaseTableCatalog$.MODULE$.apply(parameters);
        this.configResources = (String)parameters.getOrElse((Object)HBaseSparkConf$.MODULE$.HBASE_CONFIG_LOCATION(), (Function0)new $anonfun$13(this));
        this.useHBaseContext = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)HBaseSparkConf$.MODULE$.USE_HBASECONTEXT()).map((Function1)new $anonfun$14(this)).getOrElse((Function0)new $anonfun$1(this)));
        this.usePushDownColumnFilter = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)HBaseSparkConf$.MODULE$.PUSHDOWN_COLUMN_FILTER()).map((Function1)new $anonfun$15(this)).getOrElse((Function0)new $anonfun$2(this)));
        this.blockCacheEnable = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)HBaseSparkConf$.MODULE$.QUERY_CACHEBLOCKS()).map((Function1)new $anonfun$16(this)).getOrElse((Function0)new $anonfun$3(this)));
        this.cacheSize = BoxesRunTime.unboxToInt((Object)parameters.get((Object)HBaseSparkConf$.MODULE$.QUERY_CACHEDROWS()).map((Function1)new $anonfun$17(this)).getOrElse((Function0)new $anonfun$4(this)));
        this.batchNum = BoxesRunTime.unboxToInt((Object)parameters.get((Object)HBaseSparkConf$.MODULE$.QUERY_BATCHSIZE()).map((Function1)new $anonfun$18(this)).getOrElse((Function0)new $anonfun$5(this)));
        this.bulkGetSize = BoxesRunTime.unboxToInt((Object)parameters.get((Object)HBaseSparkConf$.MODULE$.BULKGET_SIZE()).map((Function1)new $anonfun$19(this)).getOrElse((Function0)new $anonfun$6(this)));
        if (this.useHBaseContext()) {
            hBaseContext = LatestHBaseContextCache$.MODULE$.latest();
        } else {
            Configuration config = HBaseConfiguration.create();
            Predef$.MODULE$.refArrayOps((Object[])this.configResources().split(",")).foreach((Function1)new $anonfun$20(this, config));
            hBaseContext = new HBaseContext(sqlContext.sparkContext(), config, HBaseContext$.MODULE$.$lessinit$greater$default$3());
        }
        this.hbaseContext = hBaseContext;
        this.wrappedConf = new SerializableConfiguration(this.hbaseContext().config());
        this.schema = (StructType)userSpecifiedSchema.getOrElse((Function0)new $anonfun$21(this));
    }
}

