/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.spark.ByteArrayWrapper;
import org.apache.hadoop.hbase.spark.KeyFamilyQualifier;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.spark.Partitioner;
import scala.reflect.ScalaSignature;

@InterfaceAudience.Public
@ScalaSignature(bytes="\u0006\u0001y2A!\u0001\u0002\u0001\u001b\t\u0019\")\u001e7l\u0019>\fG\rU1si&$\u0018n\u001c8fe*\u00111\u0001B\u0001\u0006gB\f'o\u001b\u0006\u0003\u000b\u0019\tQ\u0001\u001b2bg\u0016T!a\u0002\u0005\u0002\r!\fGm\\8q\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fEi\u0011\u0001\u0005\u0006\u0003\u0007!I!A\u0005\t\u0003\u0017A\u000b'\u000f^5uS>tWM\u001d\u0005\t)\u0001\u0011\t\u0011)A\u0005+\u0005I1\u000f^1si.+\u0017p\u001d\t\u0004-eYR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\u000b\u0005\u0013(/Y=\u0011\u0007YIB\u0004\u0005\u0002\u0017;%\u0011ad\u0006\u0002\u0005\u0005f$X\rC\u0003!\u0001\u0011\u0005\u0011%\u0001\u0004=S:LGO\u0010\u000b\u0003E\u0011\u0002\"a\t\u0001\u000e\u0003\tAQ\u0001F\u0010A\u0002UAQA\n\u0001\u0005B\u001d\nQB\\;n!\u0006\u0014H/\u001b;j_:\u001cX#\u0001\u0015\u0011\u0005YI\u0013B\u0001\u0016\u0018\u0005\rIe\u000e\u001e\u0005\u0006Y\u0001!\t%L\u0001\rO\u0016$\b+\u0019:uSRLwN\u001c\u000b\u0003Q9BQaL\u0016A\u0002A\n1a[3z!\t1\u0012'\u0003\u00023/\t\u0019\u0011I\\=)\u0005\u0001!\u0004CA\u001b<\u001d\t1\u0014(D\u00018\u0015\tAD!\u0001\bdY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8\n\u0005i:\u0014!E%oi\u0016\u0014h-Y2f\u0003V$\u0017.\u001a8dK&\u0011A(\u0010\u0002\u0007!V\u0014G.[2\u000b\u0005i:\u0004")
public class BulkLoadPartitioner
extends Partitioner {
    private final byte[][] startKeys;

    public int numPartitions() {
        return this.startKeys.length == 0 ? 1 : this.startKeys.length;
    }

    public int getPartition(Object key) {
        byte[] byArray;
        Comparator<byte[]> comparator = new Comparator<byte[]>(this){

            public int compare(byte[] o1, byte[] o2) {
                return Bytes.compareTo((byte[])o1, (byte[])o2);
            }
        };
        Object object = key;
        if (object instanceof KeyFamilyQualifier) {
            KeyFamilyQualifier keyFamilyQualifier = (KeyFamilyQualifier)object;
            byArray = keyFamilyQualifier.rowKey();
        } else if (object instanceof ByteArrayWrapper) {
            ByteArrayWrapper byteArrayWrapper = (ByteArrayWrapper)object;
            byArray = byteArrayWrapper.value();
        } else {
            byArray = (byte[])key;
        }
        byte[] rowKey = byArray;
        int partition = Arrays.binarySearch((Object[])this.startKeys, rowKey, comparator);
        if (partition < 0) {
            partition = partition * -1 + -2;
        }
        if (partition < 0) {
            partition = 0;
        }
        return partition;
    }

    public BulkLoadPartitioner(byte[][] startKeys) {
        this.startKeys = startKeys;
    }
}

