/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.AbstractTestShell;
import org.apache.hadoop.hbase.fs.ErasureCodingUtils;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClientTests.class, LargeTests.class})
public class TestAdminShell
extends AbstractTestShell {
    private static final Logger LOG = LoggerFactory.getLogger(TestAdminShell.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAdminShell.class);
    protected static boolean erasureCodingSupported = false;

    @Override
    protected String getIncludeList() {
        return "admin_test.rb";
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestAdminShell.setUpConfig();
        TEST_UTIL.startMiniCluster(3);
        try {
            ErasureCodingUtils.enablePolicy((FileSystem)FileSystem.get((Configuration)TEST_UTIL.getConfiguration()), (String)"XOR-2-1-1024k");
            erasureCodingSupported = true;
        }
        catch (UnsupportedOperationException e) {
            LOG.info("Current hadoop version does not support erasure coding, only validation tests will run.");
        }
        TestAdminShell.setUpJRubyRuntime(Collections.singletonMap("$ERASURE_CODING_SUPPORTED", erasureCodingSupported));
    }
}

