/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.visibility.VisibilityTestUtil;
import org.jruby.embed.PathType;
import org.jruby.embed.ScriptingContainer;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestShell {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTestShell.class);
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    protected static final ScriptingContainer jruby = new ScriptingContainer();

    protected static void setUpConfig() throws IOException {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.regionserver.msginterval", 100);
        conf.setInt("hbase.client.pause", 250);
        conf.setBoolean("hbase.quota.enabled", true);
        conf.setInt("hbase.client.retries.number", 6);
        conf.setBoolean("hbase.coprocessor.abortonerror", false);
        conf.setInt("hfile.format.version", 3);
        conf.setInt("hbase.master.info.port", 0);
        conf.setInt("hbase.regionserver.info.port", 0);
        conf.setBoolean("hbase.regionserver.info.port.auto", true);
        SecureTestUtil.enableSecurity((Configuration)conf);
        VisibilityTestUtil.enableVisiblityLabels((Configuration)conf);
    }

    protected static void setUpJRubyRuntime() {
        AbstractTestShell.setUpJRubyRuntime(Collections.emptyMap());
    }

    protected static void setUpJRubyRuntime(Map<String, Object> extraVars) {
        LOG.debug("Configure jruby runtime, cluster set to {}", (Object)TEST_UTIL);
        ArrayList<String> loadPaths = new ArrayList<String>(2);
        loadPaths.add("src/test/ruby");
        jruby.setLoadPaths(loadPaths);
        jruby.put("$TEST_CLUSTER", (Object)TEST_UTIL);
        for (Map.Entry<String, Object> entry : extraVars.entrySet()) {
            jruby.put(entry.getKey(), entry.getValue());
        }
        System.setProperty("jruby.jit.logging.verbose", "true");
        System.setProperty("jruby.jit.logging", "true");
        System.setProperty("jruby.native.verbose", "true");
    }

    protected String getIncludeList() {
        return "";
    }

    protected String getExcludeList() {
        return "";
    }

    @Test
    public void testRunShellTests() throws IOException {
        String tests = this.getIncludeList();
        String excludes = this.getExcludeList();
        if (!tests.isEmpty()) {
            System.setProperty("shell.test.include", tests);
        }
        if (!excludes.isEmpty()) {
            System.setProperty("shell.test.exclude", excludes);
        }
        LOG.info("Starting ruby tests. includes: {} excludes: {}", (Object)tests, (Object)excludes);
        jruby.runScriptlet(PathType.ABSOLUTE, "src/test/ruby/tests_runner.rb");
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        AbstractTestShell.setUpConfig();
        TEST_UTIL.startMiniCluster(1);
        AbstractTestShell.setUpJRubyRuntime();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }
}

