/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

@Category(value={SmallTests.class})
public class TestTableName
extends TestWatcher {
    private TableName tableName;
    String[] emptyTableNames = new String[]{"", " "};
    String[] invalidNamespace = new String[]{":a", "%:a"};
    String[] legalTableNames = new String[]{"foo", "with-dash_under.dot", "_under_start_ok", "with-dash.with_underscore", "02-01-2012.my_table_01-02", "xyz._mytable_", "9_9_0.table_02", "dot1.dot2.table", "new.-mytable", "with-dash.with.dot", "legal..t2", "legal..legal.t2", "trailingdots..", "trailing.dots...", "ns:mytable", "ns:_mytable_", "ns:my_table_01-02"};
    String[] illegalTableNames = new String[]{".dot_start_illegal", "-dash_start_illegal", "spaces not ok", "-dash-.start_illegal", "new.table with space", "01 .table", "ns:-illegaldash", "new:.illegaldot", "new:illegalcolon1:", "new:illegalcolon1:2"};

    protected void starting(Description description) {
        this.tableName = TableName.valueOf((String)description.getMethodName());
    }

    public TableName getTableName() {
        return this.tableName;
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidNamespace() {
        for (String tn : this.invalidNamespace) {
            TableName.isLegalFullyQualifiedTableName((byte[])Bytes.toBytes((String)tn));
            Assert.fail((String)("invalid namespace " + tn + " should have failed with IllegalArgumentException for namespace"));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyTableName() {
        for (String tn : this.emptyTableNames) {
            TableName.isLegalFullyQualifiedTableName((byte[])Bytes.toBytes((String)tn));
            Assert.fail((String)("invalid tablename " + tn + " should have failed with IllegalArgumentException"));
        }
    }

    @Test
    public void testLegalHTableNames() {
        for (String tn : this.legalTableNames) {
            TableName.isLegalFullyQualifiedTableName((byte[])Bytes.toBytes((String)tn));
        }
    }

    @Test
    public void testIllegalHTableNames() {
        for (String tn : this.illegalTableNames) {
            try {
                TableName.isLegalFullyQualifiedTableName((byte[])Bytes.toBytes((String)tn));
                Assert.fail((String)("invalid tablename " + tn + " should have failed"));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

