/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestHFileArchiveUtil {
    private Path rootDir = new Path("./");

    @Test
    public void testGetTableArchivePath() {
        Assert.assertNotNull((Object)HFileArchiveUtil.getTableArchivePath((Path)this.rootDir, (TableName)TableName.valueOf((String)"table")));
    }

    @Test
    public void testGetArchivePath() throws Exception {
        Configuration conf = new Configuration();
        FSUtils.setRootDir((Configuration)conf, (Path)new Path("root"));
        Assert.assertNotNull((Object)HFileArchiveUtil.getArchivePath((Configuration)conf));
    }

    @Test
    public void testRegionArchiveDir() {
        Path regionDir = new Path("region");
        Assert.assertNotNull((Object)HFileArchiveUtil.getRegionArchiveDir((Path)this.rootDir, (TableName)TableName.valueOf((String)"table"), (Path)regionDir));
    }

    @Test
    public void testGetStoreArchivePath() throws IOException {
        byte[] family = Bytes.toBytes((String)"Family");
        Path tabledir = FSUtils.getTableDir((Path)this.rootDir, (TableName)TableName.valueOf((String)"table"));
        HRegionInfo region = new HRegionInfo(TableName.valueOf((String)"table"));
        Configuration conf = new Configuration();
        FSUtils.setRootDir((Configuration)conf, (Path)new Path("root"));
        Assert.assertNotNull((Object)HFileArchiveUtil.getStoreArchivePath((Configuration)conf, (HRegionInfo)region, (Path)tabledir, (byte[])family));
    }
}

