/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.security.visibility.ScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.SimpleScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.VisibilityClient;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityTestUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestVisibilityLabelsWithDeletes {
    private static final String TOPSECRET = "TOPSECRET";
    private static final String PUBLIC = "PUBLIC";
    private static final String PRIVATE = "PRIVATE";
    private static final String CONFIDENTIAL = "CONFIDENTIAL";
    private static final String SECRET = "SECRET";
    public static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] row1 = Bytes.toBytes((String)"row1");
    private static final byte[] row2 = Bytes.toBytes((String)"row2");
    private static final byte[] fam = Bytes.toBytes((String)"info");
    private static final byte[] qual = Bytes.toBytes((String)"qual");
    private static final byte[] qual1 = Bytes.toBytes((String)"qual1");
    private static final byte[] qual2 = Bytes.toBytes((String)"qual2");
    private static final byte[] value = Bytes.toBytes((String)"value");
    private static final byte[] value1 = Bytes.toBytes((String)"value1");
    public static Configuration conf;
    @Rule
    public final TestName TEST_NAME = new TestName();
    public static User SUPERUSER;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.master.distributed.log.replay", false);
        VisibilityTestUtil.enableVisiblityLabels(conf);
        conf.setClass("hbase.regionserver.scan.visibility.label.generator.class", SimpleScanLabelGenerator.class, ScanLabelGenerator.class);
        conf.set("hbase.superuser", "admin");
        TEST_UTIL.startMiniCluster(2);
        SUPERUSER = User.createUserForTesting((Configuration)conf, (String)"admin", (String[])new String[]{"supergroup"});
        TEST_UTIL.waitTableEnabled(VisibilityConstants.LABELS_TABLE_NAME.getName(), 50000L);
        TestVisibilityLabelsWithDeletes.addLabels();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @After
    public void tearDown() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVisibilityLabelsWithDeleteColumns() throws Throwable {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = TestVisibilityLabelsWithDeletes.createTableAndWriteDataWithLabels(tableName, "SECRET&TOPSECRET", SECRET);
        try {
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    HTable table = null;
                    try {
                        table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("TOPSECRET&SECRET"));
                        d.deleteColumns(fam, qual);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    finally {
                        table.close();
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            Scan s = new Scan();
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 1 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVisibilityLabelsWithDeleteFamily() throws Exception {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = TestVisibilityLabelsWithDeletes.createTableAndWriteDataWithLabels(tableName, SECRET, "CONFIDENTIAL|TOPSECRET");
        try {
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row2);
                        d.setCellVisibility(new CellVisibility("TOPSECRET|CONFIDENTIAL"));
                        d.deleteFamily(fam);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            Scan s = new Scan();
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 1 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVisibilityLabelsWithDeleteFamilyVersion() throws Exception {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        long[] ts = new long[]{123L, 125L};
        HTable table = TestVisibilityLabelsWithDeletes.createTableAndWriteDataWithLabels(tableName, ts, "CONFIDENTIAL|TOPSECRET", SECRET);
        try {
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    HTable table = null;
                    try {
                        table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("TOPSECRET|CONFIDENTIAL"));
                        d.deleteFamilyVersion(fam, 123L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    finally {
                        table.close();
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            Scan s = new Scan();
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 1 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVisibilityLabelsWithDeleteColumnExactVersion() throws Exception {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        long[] ts = new long[]{123L, 125L};
        HTable table = TestVisibilityLabelsWithDeletes.createTableAndWriteDataWithLabels(tableName, ts, "CONFIDENTIAL|TOPSECRET", SECRET);
        try {
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    HTable table = null;
                    try {
                        table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("TOPSECRET|CONFIDENTIAL"));
                        d.deleteColumn(fam, qual, 123L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    finally {
                        table.close();
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            Scan s = new Scan();
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 1 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVisibilityLabelsWithDeleteColumnsWithMultipleVersions() throws Exception {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            table = this.doPuts(tableName);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(PRIVATE&CONFIDENTIAL)|(SECRET&TOPSECRET)"));
                        d.deleteColumns(fam, qual, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)125L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVisibilityLabelsWithDeleteColumnsWithMultipleVersionsNoTimestamp() throws Exception {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            table = this.doPuts(tableName);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.CONFIDENTIAL));
                        d.deleteColumns(fam, qual);
                        table.delete(d);
                        d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d.deleteColumns(fam, qual);
                        table.delete(d);
                        table.flushCommits();
                        d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(PRIVATE&CONFIDENTIAL)|(SECRET&TOPSECRET)"));
                        d.deleteColumns(fam, qual);
                        table.delete(d);
                        table.flushCommits();
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 1 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVisibilityLabelsWithDeleteColumnsWithNoMatchVisExpWithMultipleVersionsNoTimestamp() throws Exception {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            table = this.doPuts(tableName);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.CONFIDENTIAL));
                        d.deleteColumns(fam, qual);
                        table.delete(d);
                        d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.SECRET));
                        d.deleteColumns(fam, qual);
                        table.delete(d);
                        table.flushCommits();
                        d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(PRIVATE&CONFIDENTIAL)|(SECRET&TOPSECRET)"));
                        d.deleteColumns(fam, qual);
                        table.delete(d);
                        table.flushCommits();
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVisibilityLabelsWithDeleteFamilyWithMultipleVersionsNoTimestamp() throws Exception {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            table = this.doPuts(tableName);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.CONFIDENTIAL));
                        d.deleteFamily(fam);
                        table.delete(d);
                        d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d.deleteFamily(fam);
                        table.delete(d);
                        table.flushCommits();
                        d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(PRIVATE&CONFIDENTIAL)|(SECRET&TOPSECRET)"));
                        d.deleteFamily(fam);
                        table.delete(d);
                        table.flushCommits();
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 1 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVisibilityLabelsWithDeleteFamilyWithPutsReAppearing() throws Exception {
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            HBaseAdmin hBaseAdmin = TEST_UTIL.getHBaseAdmin();
            HColumnDescriptor colDesc = new HColumnDescriptor(fam);
            colDesc.setMaxVersions(5);
            HTableDescriptor desc = new HTableDescriptor(tableName);
            desc.addFamily(colDesc);
            hBaseAdmin.createTable(desc);
            table = new HTable(conf, tableName);
            Put put = new Put(Bytes.toBytes((String)"row1"));
            put.add(fam, qual, value);
            put.setCellVisibility(new CellVisibility(CONFIDENTIAL));
            table.put(put);
            put = new Put(Bytes.toBytes((String)"row1"));
            put.add(fam, qual, value);
            put.setCellVisibility(new CellVisibility(SECRET));
            table.put(put);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.CONFIDENTIAL));
                        d.deleteFamily(fam);
                        table.delete(d);
                        table.flushCommits();
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertEquals((long)next.length, (long)1L);
            put = new Put(Bytes.toBytes((String)"row1"));
            put.add(fam, qual, value1);
            put.setCellVisibility(new CellVisibility(CONFIDENTIAL));
            table.put(put);
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.SECRET));
                        d.deleteFamily(fam);
                        table.delete(d);
                        table.flushCommits();
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{CONFIDENTIAL}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertEquals((long)next.length, (long)1L);
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET}));
            scanner = table.getScanner(s);
            Result[] next1 = scanner.next(3);
            Assert.assertEquals((long)next1.length, (long)0L);
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVisibilityLabelsWithDeleteColumnsWithPutsReAppearing() throws Exception {
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            HBaseAdmin hBaseAdmin = TEST_UTIL.getHBaseAdmin();
            HColumnDescriptor colDesc = new HColumnDescriptor(fam);
            colDesc.setMaxVersions(5);
            HTableDescriptor desc = new HTableDescriptor(tableName);
            desc.addFamily(colDesc);
            hBaseAdmin.createTable(desc);
            table = new HTable(conf, tableName);
            Put put = new Put(Bytes.toBytes((String)"row1"));
            put.add(fam, qual, value);
            put.setCellVisibility(new CellVisibility(CONFIDENTIAL));
            table.put(put);
            put = new Put(Bytes.toBytes((String)"row1"));
            put.add(fam, qual, value);
            put.setCellVisibility(new CellVisibility(SECRET));
            table.put(put);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.CONFIDENTIAL));
                        d.deleteColumns(fam, qual);
                        table.delete(d);
                        table.flushCommits();
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertEquals((long)next.length, (long)1L);
            put = new Put(Bytes.toBytes((String)"row1"));
            put.add(fam, qual, value1);
            put.setCellVisibility(new CellVisibility(CONFIDENTIAL));
            table.put(put);
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.SECRET));
                        d.deleteColumns(fam, qual);
                        table.delete(d);
                        table.flushCommits();
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{CONFIDENTIAL}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertEquals((long)next.length, (long)1L);
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET}));
            scanner = table.getScanner(s);
            Result[] next1 = scanner.next(3);
            Assert.assertEquals((long)next1.length, (long)0L);
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVisibilityCombinations() throws Exception {
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            HBaseAdmin hBaseAdmin = TEST_UTIL.getHBaseAdmin();
            HColumnDescriptor colDesc = new HColumnDescriptor(fam);
            colDesc.setMaxVersions(5);
            HTableDescriptor desc = new HTableDescriptor(tableName);
            desc.addFamily(colDesc);
            hBaseAdmin.createTable(desc);
            table = new HTable(conf, tableName);
            Put put = new Put(Bytes.toBytes((String)"row1"));
            put.add(fam, qual, 123L, value);
            put.setCellVisibility(new CellVisibility(CONFIDENTIAL));
            table.put(put);
            put = new Put(Bytes.toBytes((String)"row1"));
            put.add(fam, qual, 124L, value1);
            put.setCellVisibility(new CellVisibility(SECRET));
            table.put(put);
            table.flushCommits();
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.SECRET));
                        d.deleteColumns(fam, qual, 126L);
                        table.delete(d);
                        table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.CONFIDENTIAL));
                        d.deleteColumn(fam, qual, 123L);
                        table.delete(d);
                        table.flushCommits();
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{CONFIDENTIAL, SECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertEquals((long)next.length, (long)0L);
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVisibilityLabelsWithDeleteColumnWithSpecificVersionWithPutsReAppearing() throws Exception {
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            HBaseAdmin hBaseAdmin = TEST_UTIL.getHBaseAdmin();
            HColumnDescriptor colDesc = new HColumnDescriptor(fam);
            colDesc.setMaxVersions(5);
            HTableDescriptor desc = new HTableDescriptor(tableName);
            desc.addFamily(colDesc);
            hBaseAdmin.createTable(desc);
            table = new HTable(conf, tableName);
            Put put = new Put(Bytes.toBytes((String)"row1"));
            put.add(fam, qual, 123L, value);
            put.setCellVisibility(new CellVisibility(CONFIDENTIAL));
            table.put(put);
            put = new Put(Bytes.toBytes((String)"row1"));
            put.add(fam, qual, 123L, value1);
            put.setCellVisibility(new CellVisibility(SECRET));
            table.put(put);
            table.flushCommits();
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{CONFIDENTIAL, SECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertEquals((long)next.length, (long)1L);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.CONFIDENTIAL));
                        d.deleteColumn(fam, qual, 123L);
                        table.delete(d);
                        table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.SECRET));
                        d.deleteColumn(fam, qual, 123L);
                        table.delete(d);
                        table.flushCommits();
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{CONFIDENTIAL}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertEquals((long)next.length, (long)0L);
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVisibilityLabelsWithDeleteFamilyWithNoMatchingVisExpWithMultipleVersionsNoTimestamp() throws Exception {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            table = this.doPuts(tableName);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.CONFIDENTIAL));
                        d.deleteFamily(fam);
                        table.delete(d);
                        d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.SECRET));
                        d.deleteFamily(fam);
                        table.delete(d);
                        table.flushCommits();
                        d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(PRIVATE&CONFIDENTIAL)|(SECRET&TOPSECRET)"));
                        d.deleteFamily(fam);
                        table.delete(d);
                        table.flushCommits();
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteFamilyAndDeleteColumnsWithAndWithoutVisibilityExp() throws Exception {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            table = this.doPuts(tableName);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.deleteFamily(fam);
                        table.delete(d);
                        d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d.deleteColumns(fam, qual);
                        table.delete(d);
                        table.flushCommits();
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    private HTable doPuts(TableName tableName) throws IOException, InterruptedIOException, RetriesExhaustedWithDetailsException, InterruptedException {
        HBaseAdmin hBaseAdmin = TEST_UTIL.getHBaseAdmin();
        HColumnDescriptor colDesc = new HColumnDescriptor(fam);
        colDesc.setMaxVersions(5);
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(colDesc);
        hBaseAdmin.createTable(desc);
        HTable table = new HTable(conf, tableName);
        Put put = new Put(Bytes.toBytes((String)"row1"));
        put.add(fam, qual, 123L, value);
        put.setCellVisibility(new CellVisibility(CONFIDENTIAL));
        table.put(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.add(fam, qual, 124L, value);
        put.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
        table.put(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.add(fam, qual, 125L, value);
        put.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
        table.put(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.add(fam, qual, 126L, value);
        put.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
        table.put(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.add(fam, qual, 127L, value);
        put.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
        table.put(put);
        TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
        put = new Put(Bytes.toBytes((String)"row2"));
        put.add(fam, qual, 127L, value);
        put.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
        table.put(put);
        return table;
    }

    private HTable doPutsWithDiffCols(TableName tableName) throws IOException, InterruptedIOException, RetriesExhaustedWithDetailsException, InterruptedException {
        HBaseAdmin hBaseAdmin = TEST_UTIL.getHBaseAdmin();
        HColumnDescriptor colDesc = new HColumnDescriptor(fam);
        colDesc.setMaxVersions(5);
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(colDesc);
        hBaseAdmin.createTable(desc);
        HTable table = new HTable(conf, tableName);
        Put put = new Put(Bytes.toBytes((String)"row1"));
        put.add(fam, qual, 123L, value);
        put.setCellVisibility(new CellVisibility(CONFIDENTIAL));
        table.put(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.add(fam, qual, 124L, value);
        put.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
        table.put(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.add(fam, qual, 125L, value);
        put.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
        table.put(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.add(fam, qual1, 126L, value);
        put.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
        table.put(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.add(fam, qual2, 127L, value);
        put.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
        table.put(put);
        return table;
    }

    private HTable doPutsWithoutVisibility(TableName tableName) throws IOException, InterruptedIOException, RetriesExhaustedWithDetailsException, InterruptedException {
        HBaseAdmin hBaseAdmin = TEST_UTIL.getHBaseAdmin();
        HColumnDescriptor colDesc = new HColumnDescriptor(fam);
        colDesc.setMaxVersions(5);
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(colDesc);
        hBaseAdmin.createTable(desc);
        HTable table = new HTable(conf, tableName);
        Put put = new Put(Bytes.toBytes((String)"row1"));
        put.add(fam, qual, 123L, value);
        table.put(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.add(fam, qual, 124L, value);
        table.put(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.add(fam, qual, 125L, value);
        table.put(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.add(fam, qual, 126L, value);
        table.put(put);
        put = new Put(Bytes.toBytes((String)"row1"));
        put.add(fam, qual, 127L, value);
        table.put(put);
        TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
        put = new Put(Bytes.toBytes((String)"row2"));
        put.add(fam, qual, 127L, value);
        table.put(put);
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteColumnWithSpecificTimeStampUsingMultipleVersionsUnMatchingVisExpression() throws Exception {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            table = this.doPuts(tableName);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(PRIVATE&CONFIDENTIAL)|(SECRET&TOPSECRET)"));
                        d.deleteColumn(fam, qual, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)125L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteColumnWithLatestTimeStampUsingMultipleVersions() throws Exception {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            table = this.doPuts(tableName);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d.deleteColumn(fam, qual);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testDeleteColumnWithLatestTimeStampWhenNoVersionMatches() throws Exception {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            table = this.doPuts(tableName);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            Put put = new Put(Bytes.toBytes((String)"row1"));
            put.add(fam, qual, 128L, value);
            put.setCellVisibility(new CellVisibility(TOPSECRET));
            table.put(put);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.SECRET));
                        d.deleteColumn(fam, qual);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)128L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)125L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            put = new Put(Bytes.toBytes((String)"row1"));
            put.add(fam, qual, 129L, value);
            put.setCellVisibility(new CellVisibility(SECRET));
            table.put(put);
            table.flushCommits();
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            cellScanner = next[0].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)129L);
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteColumnWithLatestTimeStampUsingMultipleVersionsAfterCompaction() throws Exception {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            table = this.doPuts(tableName);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d.deleteColumn(fam, qual);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            Put put = new Put(Bytes.toBytes((String)"row3"));
            put.add(fam, qual, 127L, value);
            put.setCellVisibility(new CellVisibility("CONFIDENTIAL&PRIVATE"));
            table.put(put);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            TEST_UTIL.getHBaseAdmin().majorCompact(tableName.getNameAsString());
            Thread.sleep(5000L);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 3 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteFamilyLatestTimeStampWithMulipleVersions() throws Exception {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            table = this.doPuts(tableName);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d.deleteFamily(fam);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteColumnswithMultipleColumnsWithMultipleVersions() throws Exception {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            table = this.doPutsWithDiffCols(tableName);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d.deleteColumns(fam, qual, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 1 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getQualifierArray(), (int)current.getQualifierOffset(), (int)current.getQualifierLength(), (byte[])qual1, (int)0, (int)qual1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getQualifierArray(), (int)current.getQualifierOffset(), (int)current.getQualifierLength(), (byte[])qual2, (int)0, (int)qual2.length));
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteColumnsWithDiffColsAndTags() throws Exception {
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            HBaseAdmin hBaseAdmin = TEST_UTIL.getHBaseAdmin();
            HColumnDescriptor colDesc = new HColumnDescriptor(fam);
            colDesc.setMaxVersions(5);
            HTableDescriptor desc = new HTableDescriptor(tableName);
            desc.addFamily(colDesc);
            hBaseAdmin.createTable(desc);
            table = new HTable(conf, tableName);
            Put put = new Put(Bytes.toBytes((String)"row1"));
            put.add(fam, qual1, 125L, value);
            put.setCellVisibility(new CellVisibility(CONFIDENTIAL));
            table.put(put);
            put = new Put(Bytes.toBytes((String)"row1"));
            put.add(fam, qual1, 126L, value);
            put.setCellVisibility(new CellVisibility(SECRET));
            table.put(put);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.SECRET));
                        d.deleteColumns(fam, qual, 126L);
                        table.delete(d);
                        d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.CONFIDENTIAL));
                        d.deleteColumns(fam, qual1, 125L);
                        table.delete(d);
                        table.flushCommits();
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, CONFIDENTIAL}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertEquals((long)next.length, (long)1L);
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteColumnsWithDiffColsAndTags1() throws Exception {
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            HBaseAdmin hBaseAdmin = TEST_UTIL.getHBaseAdmin();
            HColumnDescriptor colDesc = new HColumnDescriptor(fam);
            colDesc.setMaxVersions(5);
            HTableDescriptor desc = new HTableDescriptor(tableName);
            desc.addFamily(colDesc);
            hBaseAdmin.createTable(desc);
            table = new HTable(conf, tableName);
            Put put = new Put(Bytes.toBytes((String)"row1"));
            put.add(fam, qual1, 125L, value);
            put.setCellVisibility(new CellVisibility(CONFIDENTIAL));
            table.put(put);
            put = new Put(Bytes.toBytes((String)"row1"));
            put.add(fam, qual1, 126L, value);
            put.setCellVisibility(new CellVisibility(SECRET));
            table.put(put);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.SECRET));
                        d.deleteColumns(fam, qual, 126L);
                        table.delete(d);
                        d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.CONFIDENTIAL));
                        d.deleteColumns(fam, qual1, 126L);
                        table.delete(d);
                        table.flushCommits();
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, CONFIDENTIAL}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertEquals((long)next.length, (long)1L);
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteFamilyWithoutCellVisibilityWithMulipleVersions() throws Exception {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            table = this.doPutsWithoutVisibility(tableName);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.deleteFamily(fam);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 1 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteFamilyLatestTimeStampWithMulipleVersionsWithoutCellVisibilityInPuts() throws Exception {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            table = this.doPutsWithoutVisibility(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d.deleteFamily(fam);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)125L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteFamilySpecificTimeStampWithMulipleVersions() throws Exception {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            table = this.doPuts(tableName);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(PRIVATE&CONFIDENTIAL)|(SECRET&TOPSECRET)"));
                        d.deleteFamily(fam, 126L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(6);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)125L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanAfterCompaction() throws Exception {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            table = this.doPuts(tableName);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(PRIVATE&CONFIDENTIAL)|(SECRET&TOPSECRET)"));
                        d.deleteFamily(fam, 126L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            Put put = new Put(Bytes.toBytes((String)"row3"));
            put.add(fam, qual, 127L, value);
            put.setCellVisibility(new CellVisibility("CONFIDENTIAL&PRIVATE"));
            table.put(put);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            TEST_UTIL.getHBaseAdmin().compact(tableName.getNameAsString());
            Thread.sleep(5000L);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 3 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteFamilySpecificTimeStampWithMulipleVersionsDoneTwice() throws Exception {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            table = this.doPuts(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(PRIVATE&CONFIDENTIAL)|(TOPSECRET&SECRET)"));
                        d.deleteFamily(fam, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)125L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
                        d.deleteFamily(fam, 127L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            cellScanner = next[0].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)125L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleDeleteFamilyVersionWithDiffLabels() throws Exception {
        PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                try {
                    return VisibilityClient.setAuths((Configuration)conf, (String[])new String[]{TestVisibilityLabelsWithDeletes.CONFIDENTIAL, TestVisibilityLabelsWithDeletes.PRIVATE, TestVisibilityLabelsWithDeletes.SECRET}, (String)SUPERUSER.getShortName());
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
        };
        VisibilityLabelsProtos.VisibilityLabelsResponse response = (VisibilityLabelsProtos.VisibilityLabelsResponse)SUPERUSER.runAs((PrivilegedExceptionAction)action);
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = this.doPuts(tableName);
        try {
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.CONFIDENTIAL));
                        d.deleteFamilyVersion(fam, 123L);
                        table.delete(d);
                        d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d.deleteFamilyVersion(fam, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(5);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testSpecificDeletesFollowedByDeleteFamily() throws Exception {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = this.doPuts(tableName);
        try {
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
                        d.deleteColumn(fam, qual, 126L);
                        table.delete(d);
                        d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d.deleteFamilyVersion(fam, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(5);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.CONFIDENTIAL));
                        d.deleteFamily(fam);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            scanner = table.getScanner(s);
            next = scanner.next(5);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            cellScanner = next[0].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testSpecificDeletesFollowedByDeleteFamily1() throws Exception {
        PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                try {
                    return VisibilityClient.setAuths((Configuration)conf, (String[])new String[]{TestVisibilityLabelsWithDeletes.CONFIDENTIAL, TestVisibilityLabelsWithDeletes.PRIVATE, TestVisibilityLabelsWithDeletes.SECRET}, (String)SUPERUSER.getShortName());
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
        };
        VisibilityLabelsProtos.VisibilityLabelsResponse response = (VisibilityLabelsProtos.VisibilityLabelsResponse)SUPERUSER.runAs((PrivilegedExceptionAction)action);
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = this.doPuts(tableName);
        try {
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
                        d.deleteColumn(fam, qual);
                        table.delete(d);
                        d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d.deleteFamilyVersion(fam, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(5);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.CONFIDENTIAL));
                        d.deleteFamily(fam);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            scanner = table.getScanner(s);
            next = scanner.next(5);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            cellScanner = next[0].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteColumnSpecificTimeStampWithMulipleVersionsDoneTwice() throws Exception {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            table = this.doPuts(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d.deleteColumn(fam, qual, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
                        d.deleteColumn(fam, qual, 127L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            cellScanner = next[0].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteColumnSpecificTimeStampWithMulipleVersionsDoneTwice1() throws Exception {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            table = this.doPuts(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
                        d.deleteColumn(fam, qual, 127L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)125L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d.deleteColumn(fam, qual, 127L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            cellScanner = next[0].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)125L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteColumnSpecificTimeStampWithMulipleVersionsDoneTwice2() throws Exception {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            table = this.doPuts(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(PRIVATE&CONFIDENTIAL)|(TOPSECRET&SECRET)"));
                        d.deleteColumn(fam, qual, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)125L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
                        d.deleteColumn(fam, qual, 127L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            cellScanner = next[0].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)125L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteColumnAndDeleteFamilylSpecificTimeStampWithMulipleVersion() throws Exception {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            table = this.doPuts(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("SECRET&TOPSECRET"));
                        d.deleteColumn(fam, qual, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
                        d.deleteFamily(fam, 124L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            cellScanner = next[0].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    private void setAuths() throws IOException, InterruptedException {
        PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                try {
                    return VisibilityClient.setAuths((Configuration)conf, (String[])new String[]{TestVisibilityLabelsWithDeletes.CONFIDENTIAL, TestVisibilityLabelsWithDeletes.PRIVATE, TestVisibilityLabelsWithDeletes.SECRET, TestVisibilityLabelsWithDeletes.TOPSECRET}, (String)SUPERUSER.getShortName());
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
        };
        SUPERUSER.runAs((PrivilegedExceptionAction)action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDiffDeleteTypesForTheSameCellUsingMultipleVersions() throws Exception {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            table = this.doPuts(tableName);
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(PRIVATE&CONFIDENTIAL)|(TOPSECRET&SECRET)"));
                        d.deleteColumns(fam, qual, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)127L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)125L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.setCellVisibility(new CellVisibility("(CONFIDENTIAL&PRIVATE)|(TOPSECRET&SECRET)"));
                        d.deleteColumn(fam, qual, 127L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            cellScanner = next[0].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)126L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)125L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteColumnLatestWithNoCellVisibility() throws Exception {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            table = this.doPuts(tableName);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.deleteColumn(fam, qual, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            this.scanAll(next);
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.deleteColumns(fam, qual, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            this.scanAll(next);
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.deleteFamily(fam, 125L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            this.scanAll(next);
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.deleteFamily(fam);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            this.scanAll(next);
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.deleteColumns(fam, qual);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            this.scanAll(next);
            actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.deleteFamilyVersion(fam, 126L);
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            scanner = table.getScanner(s);
            next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            this.scanAll(next);
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    private void scanAll(Result[] next) throws IOException {
        CellScanner cellScanner = next[0].cellScanner();
        cellScanner.advance();
        Cell current = cellScanner.current();
        Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
        Assert.assertEquals((long)current.getTimestamp(), (long)127L);
        cellScanner.advance();
        current = cellScanner.current();
        Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
        Assert.assertEquals((long)current.getTimestamp(), (long)126L);
        cellScanner.advance();
        current = cellScanner.current();
        Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
        Assert.assertEquals((long)current.getTimestamp(), (long)125L);
        cellScanner.advance();
        current = cellScanner.current();
        Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
        Assert.assertEquals((long)current.getTimestamp(), (long)124L);
        cellScanner.advance();
        current = cellScanner.current();
        Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
        Assert.assertEquals((long)current.getTimestamp(), (long)123L);
        cellScanner = next[1].cellScanner();
        cellScanner.advance();
        current = cellScanner.current();
        Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVisibilityExpressionWithNotEqualORCondition() throws Exception {
        this.setAuths();
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            HBaseAdmin hBaseAdmin = TEST_UTIL.getHBaseAdmin();
            HColumnDescriptor colDesc = new HColumnDescriptor(fam);
            colDesc.setMaxVersions(5);
            HTableDescriptor desc = new HTableDescriptor(tableName);
            desc.addFamily(colDesc);
            hBaseAdmin.createTable(desc);
            table = new HTable(conf, tableName);
            Put put = new Put(Bytes.toBytes((String)"row1"));
            put.add(fam, qual, 123L, value);
            put.setCellVisibility(new CellVisibility(CONFIDENTIAL));
            table.put(put);
            put = new Put(Bytes.toBytes((String)"row1"));
            put.add(fam, qual, 124L, value);
            put.setCellVisibility(new CellVisibility("CONFIDENTIAL|PRIVATE"));
            table.put(put);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        HTable table = new HTable(conf, TestVisibilityLabelsWithDeletes.this.TEST_NAME.getMethodName());
                        Delete d = new Delete(row1);
                        d.deleteColumn(fam, qual, 124L);
                        d.setCellVisibility(new CellVisibility(TestVisibilityLabelsWithDeletes.PRIVATE));
                        table.delete(d);
                    }
                    catch (Throwable t) {
                        throw new IOException(t);
                    }
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)actiona);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            Scan s = new Scan();
            s.setMaxVersions(5);
            s.setAuthorizations(new Authorizations(new String[]{SECRET, PRIVATE, CONFIDENTIAL, TOPSECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 1 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)124L);
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            Assert.assertEquals((long)current.getTimestamp(), (long)123L);
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    public static HTable createTableAndWriteDataWithLabels(TableName tableName, String ... labelExps) throws Exception {
        HTable table = null;
        table = TEST_UTIL.createTable(tableName, fam);
        int i = 1;
        ArrayList<Put> puts = new ArrayList<Put>();
        for (String labelExp : labelExps) {
            Put put = new Put(Bytes.toBytes((String)("row" + i)));
            put.add(fam, qual, Long.MAX_VALUE, value);
            put.setCellVisibility(new CellVisibility(labelExp));
            puts.add(put);
            table.put(put);
            ++i;
        }
        return table;
    }

    public static HTable createTableAndWriteDataWithLabels(TableName tableName, long[] timestamp, String ... labelExps) throws Exception {
        HTable table = null;
        table = TEST_UTIL.createTable(tableName, fam);
        int i = 1;
        ArrayList<Put> puts = new ArrayList<Put>();
        for (String labelExp : labelExps) {
            Put put = new Put(Bytes.toBytes((String)("row" + i)));
            put.add(fam, qual, timestamp[i - 1], value);
            put.setCellVisibility(new CellVisibility(labelExp));
            puts.add(put);
            table.put(put);
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            ++i;
        }
        return table;
    }

    public static void addLabels() throws Exception {
        PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                String[] labels = new String[]{TestVisibilityLabelsWithDeletes.SECRET, TestVisibilityLabelsWithDeletes.TOPSECRET, TestVisibilityLabelsWithDeletes.CONFIDENTIAL, TestVisibilityLabelsWithDeletes.PUBLIC, TestVisibilityLabelsWithDeletes.PRIVATE};
                try {
                    VisibilityClient.addLabels((Configuration)conf, (String[])labels);
                }
                catch (Throwable t) {
                    throw new IOException(t);
                }
                return null;
            }
        };
        SUPERUSER.runAs((PrivilegedExceptionAction)action);
    }
}

