/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.ExpressionExpander;
import org.apache.hadoop.hbase.security.visibility.ExpressionParser;
import org.apache.hadoop.hbase.security.visibility.InvalidLabelException;
import org.apache.hadoop.hbase.security.visibility.ParseException;
import org.apache.hadoop.hbase.security.visibility.ScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityExpEvaluator;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelService;
import org.apache.hadoop.hbase.security.visibility.VisibilityUtils;
import org.apache.hadoop.hbase.security.visibility.expression.ExpressionNode;
import org.apache.hadoop.hbase.security.visibility.expression.LeafExpressionNode;
import org.apache.hadoop.hbase.security.visibility.expression.NonLeafExpressionNode;
import org.apache.hadoop.hbase.security.visibility.expression.Operator;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class ExpAsStringVisibilityLabelServiceImpl
implements VisibilityLabelService {
    private static final Log LOG = LogFactory.getLog(ExpAsStringVisibilityLabelServiceImpl.class);
    private static final byte[] DUMMY_VALUE = new byte[0];
    private static final byte STRING_SERIALIZATION_FORMAT = 2;
    private static final Tag STRING_SERIALIZATION_FORMAT_TAG = new Tag(4, new byte[]{2});
    private final ExpressionParser expressionParser = new ExpressionParser();
    private final ExpressionExpander expressionExpander = new ExpressionExpander();
    private Configuration conf;
    private HRegion labelsRegion;
    private List<ScanLabelGenerator> scanLabelGenerators;

    public OperationStatus[] addLabels(List<byte[]> labels) throws IOException {
        OperationStatus[] status = new OperationStatus[labels.size()];
        for (int i = 0; i < labels.size(); ++i) {
            status[i] = new OperationStatus(HConstants.OperationStatusCode.SUCCESS);
        }
        return status;
    }

    public OperationStatus[] setAuths(byte[] user, List<byte[]> authLabels) throws IOException {
        assert (this.labelsRegion != null);
        OperationStatus[] finalOpStatus = new OperationStatus[authLabels.size()];
        Put p = new Put(user);
        for (byte[] auth : authLabels) {
            p.addImmutable(VisibilityConstants.LABELS_TABLE_FAMILY, auth, DUMMY_VALUE);
        }
        this.labelsRegion.put(p);
        for (int i = 0; i < authLabels.size(); ++i) {
            finalOpStatus[i] = new OperationStatus(HConstants.OperationStatusCode.SUCCESS);
        }
        return finalOpStatus;
    }

    public OperationStatus[] clearAuths(byte[] user, List<byte[]> authLabels) throws IOException {
        assert (this.labelsRegion != null);
        OperationStatus[] finalOpStatus = new OperationStatus[authLabels.size()];
        List<String> currentAuths = this.getAuths(user, true);
        Delete d = new Delete(user);
        int i = 0;
        for (byte[] authLabel : authLabels) {
            String authLabelStr = Bytes.toString((byte[])authLabel);
            if (currentAuths.contains(authLabelStr)) {
                d.deleteColumns(VisibilityConstants.LABELS_TABLE_FAMILY, authLabel);
            } else {
                finalOpStatus[i] = new OperationStatus(HConstants.OperationStatusCode.FAILURE, (Exception)new InvalidLabelException("Label '" + authLabelStr + "' is not set for the user " + Bytes.toString((byte[])user)));
            }
            ++i;
        }
        this.labelsRegion.delete(d);
        for (i = 0; i < authLabels.size(); ++i) {
            if (finalOpStatus[i] != null) continue;
            finalOpStatus[i] = new OperationStatus(HConstants.OperationStatusCode.SUCCESS);
        }
        return finalOpStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAuths(byte[] user, boolean systemCall) throws IOException {
        assert (this.labelsRegion != null || systemCall);
        ArrayList<String> auths = new ArrayList<String>();
        Get get = new Get(user);
        List cells = null;
        if (this.labelsRegion == null) {
            HTable table = null;
            try {
                table = new HTable(this.conf, VisibilityConstants.LABELS_TABLE_NAME);
                Result result = table.get(get);
                cells = result.listCells();
            }
            finally {
                if (table != null) {
                    table.close();
                }
            }
        } else {
            cells = this.labelsRegion.get(get, false);
        }
        if (cells != null) {
            for (Cell cell : cells) {
                String auth = Bytes.toString((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength());
                auths.add(auth);
            }
        }
        return auths;
    }

    public List<Tag> createVisibilityExpTags(String visExpression, boolean withSerializationFormat, boolean checkAuths) throws IOException {
        ExpressionNode node = null;
        try {
            node = this.expressionParser.parse(visExpression);
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
        node = this.expressionExpander.expand(node);
        ArrayList<Tag> tags = new ArrayList<Tag>();
        if (withSerializationFormat) {
            tags.add(STRING_SERIALIZATION_FORMAT_TAG);
        }
        if (node instanceof NonLeafExpressionNode && ((NonLeafExpressionNode)node).getOperator() == Operator.OR) {
            for (ExpressionNode child : ((NonLeafExpressionNode)node).getChildExps()) {
                tags.add(this.createTag(child));
            }
        } else {
            tags.add(this.createTag(node));
        }
        return tags;
    }

    public VisibilityExpEvaluator getVisibilityExpEvaluator(Authorizations authorizations) throws IOException {
        if (this.isReadFromSuperUser()) {
            return new VisibilityExpEvaluator(){

                public boolean evaluate(Cell cell) throws IOException {
                    return true;
                }
            };
        }
        List authLabels = null;
        for (ScanLabelGenerator scanLabelGenerator : this.scanLabelGenerators) {
            try {
                authLabels = scanLabelGenerator.getLabels(VisibilityUtils.getActiveUser(), authorizations);
                authLabels = authLabels == null ? new ArrayList() : authLabels;
                authorizations = new Authorizations(authLabels);
            }
            catch (Throwable t) {
                LOG.error((Object)t);
                throw new IOException(t);
            }
        }
        final List authLabelsFinal = authLabels;
        return new VisibilityExpEvaluator(){

            public boolean evaluate(Cell cell) throws IOException {
                boolean visibilityTagPresent = false;
                if (cell.getTagsLengthUnsigned() > 0) {
                    Iterator tagsItr = CellUtil.tagsIterator((byte[])cell.getTagsArray(), (int)cell.getTagsOffset(), (int)cell.getTagsLengthUnsigned());
                    while (tagsItr.hasNext()) {
                        short len;
                        int offset;
                        boolean includeKV = true;
                        Tag tag = (Tag)tagsItr.next();
                        if (tag.getType() != 2) continue;
                        visibilityTagPresent = true;
                        int endOffset = offset + tag.getTagLength();
                        for (offset = tag.getTagOffset(); offset < endOffset; offset += len) {
                            String label;
                            len = Bytes.toShort((byte[])tag.getBuffer(), (int)offset);
                            offset += 2;
                            if (len < 0) {
                                len = (short)(-1 * len);
                                label = Bytes.toString((byte[])tag.getBuffer(), (int)offset, (int)len);
                                if (!authLabelsFinal.contains(label)) continue;
                                includeKV = false;
                                break;
                            }
                            label = Bytes.toString((byte[])tag.getBuffer(), (int)offset, (int)len);
                            if (authLabelsFinal.contains(label)) continue;
                            includeKV = false;
                            break;
                        }
                        if (!includeKV) continue;
                        return true;
                    }
                }
                return !visibilityTagPresent;
            }
        };
    }

    protected boolean isReadFromSuperUser() throws IOException {
        byte[] user = Bytes.toBytes((String)VisibilityUtils.getActiveUser().getShortName());
        return this.havingSystemAuth(user);
    }

    private Tag createTag(ExpressionNode node) throws IOException {
        byte[] bLabel;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        ArrayList<String> labels = new ArrayList<String>();
        ArrayList<String> notLabels = new ArrayList<String>();
        this.extractLabels(node, labels, notLabels);
        Collections.sort(labels);
        Collections.sort(notLabels);
        for (String label : notLabels) {
            bLabel = Bytes.toBytes((String)label);
            short length = (short)bLabel.length;
            length = (short)(-1 * length);
            dos.writeShort(length);
            dos.write(bLabel);
        }
        for (String label : labels) {
            bLabel = Bytes.toBytes((String)label);
            dos.writeShort(bLabel.length);
            dos.write(bLabel);
        }
        return new Tag(2, baos.toByteArray());
    }

    private void extractLabels(ExpressionNode node, List<String> labels, List<String> notLabels) {
        if (node.isSingleNode()) {
            if (node instanceof NonLeafExpressionNode) {
                LeafExpressionNode lNode = (LeafExpressionNode)((NonLeafExpressionNode)node).getChildExps().get(0);
                notLabels.add(lNode.getIdentifier());
            } else {
                labels.add(((LeafExpressionNode)node).getIdentifier());
            }
        } else {
            NonLeafExpressionNode nlNode = (NonLeafExpressionNode)node;
            assert (nlNode.getOperator() == Operator.AND);
            List childExps = nlNode.getChildExps();
            for (ExpressionNode child : childExps) {
                this.extractLabels(child, labels, notLabels);
            }
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public void init(RegionCoprocessorEnvironment e) throws IOException {
        this.scanLabelGenerators = VisibilityUtils.getScanLabelGenerators((Configuration)this.conf);
        if (e.getRegion().getRegionInfo().getTable().equals((Object)VisibilityConstants.LABELS_TABLE_NAME)) {
            this.labelsRegion = e.getRegion();
            List<String> superUsers = this.getSystemAndSuperUsers();
            for (String superUser : superUsers) {
                byte[] user = Bytes.toBytes((String)superUser);
                List<String> auths = this.getAuths(user, true);
                if (auths != null && !auths.isEmpty()) continue;
                Put p = new Put(user);
                p.addImmutable(VisibilityConstants.LABELS_TABLE_FAMILY, Bytes.toBytes((String)"system"), DUMMY_VALUE);
                this.labelsRegion.put(p);
            }
        }
    }

    private List<String> getSystemAndSuperUsers() throws IOException {
        User user = User.getCurrent();
        if (user == null) {
            throw new IOException("Unable to obtain the current user, authorization checks for internal operations will not work correctly!");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Current user name is " + user.getShortName()));
        }
        String currentUser = user.getShortName();
        List superUsers = Lists.asList((Object)currentUser, (Object[])this.conf.getStrings("hbase.superuser", new String[0]));
        return superUsers;
    }

    public boolean havingSystemAuth(byte[] user) throws IOException {
        List<String> auths = this.getAuths(user, true);
        return auths.contains("system");
    }

    public boolean matchVisibility(List<Tag> putTags, Byte putTagsFormat, List<Tag> deleteTags, Byte deleteTagsFormat) throws IOException {
        assert (putTagsFormat == 2);
        assert (deleteTagsFormat == 2);
        return ExpAsStringVisibilityLabelServiceImpl.checkForMatchingVisibilityTagsWithSortedOrder(putTags, deleteTags);
    }

    private static boolean checkForMatchingVisibilityTagsWithSortedOrder(List<Tag> putVisTags, List<Tag> deleteVisTags) {
        boolean matchFound = false;
        if (deleteVisTags.size() == putVisTags.size()) {
            for (Tag tag : deleteVisTags) {
                matchFound = false;
                for (Tag givenTag : putVisTags) {
                    if (!Bytes.equals((byte[])tag.getBuffer(), (int)tag.getTagOffset(), (int)tag.getTagLength(), (byte[])givenTag.getBuffer(), (int)givenTag.getTagOffset(), (int)givenTag.getTagLength())) continue;
                    matchFound = true;
                    break;
                }
                if (matchFound) continue;
                break;
            }
        }
        return matchFound;
    }
}

