/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.protobuf.generated.PingProtos;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlClient;
import org.apache.hadoop.hbase.security.access.AccessControlFilter;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.access.TableAuthManager;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.TestTableName;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestAccessController
extends SecureTestUtil {
    private static final Log LOG = LogFactory.getLog(TestAccessController.class);
    @Rule
    public TestTableName TEST_TABLE = new TestTableName();
    private static HBaseTestingUtility TEST_UTIL;
    private static Configuration conf;
    private static User SUPERUSER;
    private static User USER_ADMIN;
    private static User USER_RW;
    private static User USER_RO;
    private static User USER_OWNER;
    private static User USER_CREATE;
    private static User USER_NONE;
    private static TableName TEST_TABLE2;
    private static byte[] TEST_FAMILY;
    private static byte[] TEST_QUALIFIER;
    private static byte[] TEST_ROW;
    private static MasterCoprocessorEnvironment CP_ENV;
    private static AccessController ACCESS_CONTROLLER;
    private static RegionServerCoprocessorEnvironment RSCP_ENV;
    private RegionCoprocessorEnvironment RCP_ENV;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.master.hfilecleaner.plugins", "org.apache.hadoop.hbase.master.cleaner.HFileLinkCleaner,org.apache.hadoop.hbase.master.snapshot.SnapshotHFileCleaner");
        conf.set("hbase.master.logcleaner.plugins", "org.apache.hadoop.hbase.master.snapshot.SnapshotLogCleaner");
        TestAccessController.enableSecurity(conf);
        TestAccessController.verifyConfiguration(conf);
        conf.setBoolean("hbase.security.exec.permission.checks", true);
        TEST_UTIL.startMiniCluster();
        MasterCoprocessorHost cpHost = TEST_UTIL.getMiniHBaseCluster().getMaster().getCoprocessorHost();
        cpHost.load(AccessController.class, 0, conf);
        ACCESS_CONTROLLER = (AccessController)cpHost.findCoprocessor(AccessController.class.getName());
        CP_ENV = cpHost.createEnvironment(AccessController.class, (Coprocessor)ACCESS_CONTROLLER, 0, 1, conf);
        RegionServerCoprocessorHost rsHost = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0).getCoprocessorHost();
        RSCP_ENV = rsHost.createEnvironment(AccessController.class, (Coprocessor)ACCESS_CONTROLLER, 0, 1, conf);
        TEST_UTIL.waitTableEnabled(AccessControlLists.ACL_TABLE_NAME.getName());
        SUPERUSER = User.createUserForTesting((Configuration)conf, (String)"admin", (String[])new String[]{"supergroup"});
        USER_ADMIN = User.createUserForTesting((Configuration)conf, (String)"admin2", (String[])new String[0]);
        USER_RW = User.createUserForTesting((Configuration)conf, (String)"rwuser", (String[])new String[0]);
        USER_RO = User.createUserForTesting((Configuration)conf, (String)"rouser", (String[])new String[0]);
        USER_OWNER = User.createUserForTesting((Configuration)conf, (String)"owner", (String[])new String[0]);
        USER_CREATE = User.createUserForTesting((Configuration)conf, (String)"tbl_create", (String[])new String[0]);
        USER_NONE = User.createUserForTesting((Configuration)conf, (String)"nouser", (String[])new String[0]);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor htd = new HTableDescriptor(this.TEST_TABLE.getTableName());
        HColumnDescriptor hcd = new HColumnDescriptor(TEST_FAMILY);
        hcd.setMaxVersions(100);
        htd.addFamily(hcd);
        htd.setOwner(USER_OWNER);
        admin.createTable(htd, (byte[][])new byte[][]{Bytes.toBytes((String)"s")});
        TEST_UTIL.waitTableEnabled(this.TEST_TABLE.getTableName().getName());
        HRegion region = TEST_UTIL.getHBaseCluster().getRegions(this.TEST_TABLE.getTableName()).get(0);
        RegionCoprocessorHost rcpHost = region.getCoprocessorHost();
        this.RCP_ENV = rcpHost.createEnvironment(AccessController.class, (Coprocessor)ACCESS_CONTROLLER, 0, 1, conf);
        TestAccessController.grantGlobal(TEST_UTIL, USER_ADMIN.getShortName(), Permission.Action.ADMIN, Permission.Action.CREATE, Permission.Action.READ, Permission.Action.WRITE);
        TestAccessController.grantOnTable(TEST_UTIL, USER_RW.getShortName(), this.TEST_TABLE.getTableName(), TEST_FAMILY, null, Permission.Action.READ, Permission.Action.WRITE);
        TestAccessController.grantOnTable(TEST_UTIL, USER_CREATE.getShortName(), this.TEST_TABLE.getTableName(), null, null, Permission.Action.CREATE, Permission.Action.READ, Permission.Action.WRITE);
        TestAccessController.grantOnTable(TEST_UTIL, USER_RO.getShortName(), this.TEST_TABLE.getTableName(), TEST_FAMILY, null, Permission.Action.READ);
        Assert.assertEquals((long)4L, (long)AccessControlLists.getTablePermissions((Configuration)conf, (TableName)this.TEST_TABLE.getTableName()).size());
        try {
            Assert.assertEquals((long)4L, (long)AccessControlClient.getUserPermissions((Configuration)conf, (String)((Object)((Object)this.TEST_TABLE)).toString()).size());
        }
        catch (Throwable e) {
            LOG.error((Object)("error during call of AccessControlClient.getUserPermissions. " + e.getStackTrace()));
        }
    }

    @After
    public void tearDown() throws Exception {
        try {
            TEST_UTIL.deleteTable(this.TEST_TABLE.getTableName());
        }
        catch (TableNotFoundException ex) {
            LOG.info((Object)("Test deleted table " + this.TEST_TABLE.getTableName()));
        }
        Assert.assertEquals((long)0L, (long)AccessControlLists.getTablePermissions((Configuration)conf, (TableName)this.TEST_TABLE.getTableName()).size());
    }

    @Test
    public void testTableCreate() throws Exception {
        SecureTestUtil.AccessTestAction createTable = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)"testnewtable"));
                htd.addFamily(new HColumnDescriptor(TEST_FAMILY));
                ACCESS_CONTROLLER.preCreateTable(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), htd, null);
                return null;
            }
        };
        TestAccessController.verifyAllowed(createTable, SUPERUSER, USER_ADMIN);
        TestAccessController.verifyDenied(createTable, USER_CREATE, USER_RW, USER_RO, USER_NONE);
    }

    @Test
    public void testTableModify() throws Exception {
        SecureTestUtil.AccessTestAction modifyTable = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                HTableDescriptor htd = new HTableDescriptor(TestAccessController.this.TEST_TABLE.getTableName());
                htd.addFamily(new HColumnDescriptor(TEST_FAMILY));
                htd.addFamily(new HColumnDescriptor("fam_" + User.getCurrent().getShortName()));
                ACCESS_CONTROLLER.preModifyTable(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), TestAccessController.this.TEST_TABLE.getTableName(), htd);
                return null;
            }
        };
        TestAccessController.verifyAllowed(modifyTable, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER);
        TestAccessController.verifyDenied(modifyTable, USER_RW, USER_RO, USER_NONE);
    }

    @Test
    public void testTableDelete() throws Exception {
        SecureTestUtil.AccessTestAction deleteTable = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preDeleteTable(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), TestAccessController.this.TEST_TABLE.getTableName());
                return null;
            }
        };
        TestAccessController.verifyAllowed(deleteTable, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER);
        TestAccessController.verifyDenied(deleteTable, USER_RW, USER_RO, USER_NONE);
    }

    @Test
    public void testAddColumn() throws Exception {
        final HColumnDescriptor hcd = new HColumnDescriptor("fam_new");
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preAddColumn(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), TestAccessController.this.TEST_TABLE.getTableName(), hcd);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER);
        TestAccessController.verifyDenied(action, USER_RW, USER_RO, USER_NONE);
    }

    @Test
    public void testModifyColumn() throws Exception {
        final HColumnDescriptor hcd = new HColumnDescriptor(TEST_FAMILY);
        hcd.setMaxVersions(10);
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preModifyColumn(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), TestAccessController.this.TEST_TABLE.getTableName(), hcd);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER);
        TestAccessController.verifyDenied(action, USER_RW, USER_RO, USER_NONE);
    }

    @Test
    public void testDeleteColumn() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preDeleteColumn(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), TestAccessController.this.TEST_TABLE.getTableName(), TEST_FAMILY);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER);
        TestAccessController.verifyDenied(action, USER_RW, USER_RO, USER_NONE);
    }

    @Test
    public void testTableDisable() throws Exception {
        SecureTestUtil.AccessTestAction disableTable = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preDisableTable(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), TestAccessController.this.TEST_TABLE.getTableName());
                return null;
            }
        };
        SecureTestUtil.AccessTestAction disableAclTable = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preDisableTable(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), AccessControlLists.ACL_TABLE_NAME);
                return null;
            }
        };
        TestAccessController.verifyAllowed(disableTable, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER);
        TestAccessController.verifyDenied(disableTable, USER_RW, USER_RO, USER_NONE);
        TestAccessController.verifyDenied(disableAclTable, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER, USER_RW, USER_RO);
    }

    @Test
    public void testTableEnable() throws Exception {
        SecureTestUtil.AccessTestAction enableTable = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preEnableTable(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), TestAccessController.this.TEST_TABLE.getTableName());
                return null;
            }
        };
        TestAccessController.verifyAllowed(enableTable, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER);
        TestAccessController.verifyDenied(enableTable, USER_RW, USER_RO, USER_NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMove() throws Exception {
        NavigableMap regions;
        HTable table = new HTable(TEST_UTIL.getConfiguration(), this.TEST_TABLE.getTableName());
        try {
            regions = table.getRegionLocations();
        }
        finally {
            table.close();
        }
        final Map.Entry firstRegion = regions.entrySet().iterator().next();
        final ServerName server = TEST_UTIL.getHBaseCluster().getRegionServer(0).getServerName();
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preMove(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), (HRegionInfo)firstRegion.getKey(), server, server);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAssign() throws Exception {
        NavigableMap regions;
        HTable table = new HTable(TEST_UTIL.getConfiguration(), this.TEST_TABLE.getTableName());
        try {
            regions = table.getRegionLocations();
        }
        finally {
            table.close();
        }
        final Map.Entry firstRegion = regions.entrySet().iterator().next();
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preAssign(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), (HRegionInfo)firstRegion.getKey());
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnassign() throws Exception {
        NavigableMap regions;
        HTable table = new HTable(TEST_UTIL.getConfiguration(), this.TEST_TABLE.getTableName());
        try {
            regions = table.getRegionLocations();
        }
        finally {
            table.close();
        }
        final Map.Entry firstRegion = regions.entrySet().iterator().next();
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preUnassign(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), (HRegionInfo)firstRegion.getKey(), false);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegionOffline() throws Exception {
        NavigableMap regions;
        HTable table = new HTable(TEST_UTIL.getConfiguration(), this.TEST_TABLE.getTableName());
        try {
            regions = table.getRegionLocations();
        }
        finally {
            table.close();
        }
        final Map.Entry firstRegion = regions.entrySet().iterator().next();
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preRegionOffline(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), (HRegionInfo)firstRegion.getKey());
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE);
    }

    @Test
    public void testBalance() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preBalance(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null));
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE);
    }

    @Test
    public void testBalanceSwitch() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preBalanceSwitch(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), true);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE);
    }

    @Test
    public void testShutdown() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preShutdown(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null));
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE);
    }

    @Test
    public void testStopMaster() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preStopMaster(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null));
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE);
    }

    private void verifyWrite(SecureTestUtil.AccessTestAction action) throws Exception {
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_RW);
        TestAccessController.verifyDenied(action, USER_NONE, USER_RO);
    }

    @Test
    public void testSplit() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preSplit(ObserverContext.createAndPrepare((CoprocessorEnvironment)TestAccessController.this.RCP_ENV, null));
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE);
    }

    @Test
    public void testSplitWithSplitRow() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preSplit(ObserverContext.createAndPrepare((CoprocessorEnvironment)TestAccessController.this.RCP_ENV, null), TEST_ROW);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE);
    }

    @Test
    public void testMergeRegions() throws Exception {
        final List<HRegion> regions = TEST_UTIL.getHBaseCluster().findRegionsForTable(this.TEST_TABLE.getTableName());
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preMerge(ObserverContext.createAndPrepare((CoprocessorEnvironment)RSCP_ENV, null), (HRegion)regions.get(0), (HRegion)regions.get(1));
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE);
    }

    @Test
    public void testFlush() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preFlush(ObserverContext.createAndPrepare((CoprocessorEnvironment)TestAccessController.this.RCP_ENV, null));
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE);
        TestAccessController.verifyDenied(action, USER_RW, USER_RO, USER_NONE);
    }

    @Test
    public void testCompact() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preCompact(ObserverContext.createAndPrepare((CoprocessorEnvironment)TestAccessController.this.RCP_ENV, null), null, null, ScanType.COMPACT_RETAIN_DELETES);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE);
        TestAccessController.verifyDenied(action, USER_RW, USER_RO, USER_NONE);
    }

    @Test
    public void testPreCompactSelection() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preCompactSelection(ObserverContext.createAndPrepare((CoprocessorEnvironment)TestAccessController.this.RCP_ENV, null), null, null);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE);
    }

    private void verifyRead(SecureTestUtil.AccessTestAction action) throws Exception {
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_RW, USER_RO);
        TestAccessController.verifyDenied(action, USER_NONE);
    }

    private void verifyReadWrite(SecureTestUtil.AccessTestAction action) throws Exception {
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_RW);
        TestAccessController.verifyDenied(action, USER_NONE, USER_RO);
    }

    @Test
    public void testRead() throws Exception {
        SecureTestUtil.AccessTestAction getAction = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Get g = new Get(TEST_ROW);
                g.addFamily(TEST_FAMILY);
                HTable t = new HTable(conf, TestAccessController.this.TEST_TABLE.getTableName());
                try {
                    t.get(g);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        this.verifyRead(getAction);
        SecureTestUtil.AccessTestAction scanAction = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Object run() throws Exception {
                Scan s = new Scan();
                s.addFamily(TEST_FAMILY);
                HTable table = new HTable(conf, TestAccessController.this.TEST_TABLE.getTableName());
                try {
                    ResultScanner scanner = table.getScanner(s);
                    try {
                        Result r = scanner.next();
                        while (r != null) {
                            r = scanner.next();
                        }
                        return null;
                    }
                    catch (IOException e) {
                        return null;
                    }
                    finally {
                        scanner.close();
                    }
                }
                finally {
                    table.close();
                }
            }
        };
        this.verifyRead(scanAction);
    }

    @Test
    public void testWrite() throws Exception {
        SecureTestUtil.AccessTestAction putAction = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Put p = new Put(TEST_ROW);
                p.add(TEST_FAMILY, TEST_QUALIFIER, Bytes.toBytes((int)1));
                HTable t = new HTable(conf, TestAccessController.this.TEST_TABLE.getTableName());
                try {
                    t.put(p);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        this.verifyWrite(putAction);
        SecureTestUtil.AccessTestAction deleteAction = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Delete d = new Delete(TEST_ROW);
                d.deleteFamily(TEST_FAMILY);
                HTable t = new HTable(conf, TestAccessController.this.TEST_TABLE.getTableName());
                try {
                    t.delete(d);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        this.verifyWrite(deleteAction);
        SecureTestUtil.AccessTestAction incrementAction = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Increment inc = new Increment(TEST_ROW);
                inc.addColumn(TEST_FAMILY, TEST_QUALIFIER, 1L);
                HTable t = new HTable(conf, TestAccessController.this.TEST_TABLE.getTableName());
                try {
                    t.increment(inc);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        this.verifyWrite(incrementAction);
    }

    @Test
    public void testReadWrite() throws Exception {
        SecureTestUtil.AccessTestAction checkAndDeleteAction = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Delete d = new Delete(TEST_ROW);
                d.deleteFamily(TEST_FAMILY);
                HTable t = new HTable(conf, TestAccessController.this.TEST_TABLE.getTableName());
                try {
                    t.checkAndDelete(TEST_ROW, TEST_FAMILY, TEST_QUALIFIER, Bytes.toBytes((String)"test_value"), d);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        this.verifyReadWrite(checkAndDeleteAction);
        SecureTestUtil.AccessTestAction checkAndPut = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Put p = new Put(TEST_ROW);
                p.add(TEST_FAMILY, TEST_QUALIFIER, Bytes.toBytes((int)1));
                HTable t = new HTable(conf, TestAccessController.this.TEST_TABLE.getTableName());
                try {
                    t.checkAndPut(TEST_ROW, TEST_FAMILY, TEST_QUALIFIER, Bytes.toBytes((String)"test_value"), p);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        this.verifyReadWrite(checkAndPut);
    }

    @Test
    public void testBulkLoad() throws Exception {
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        final Path dir = TEST_UTIL.getDataTestDirOnTestFS("testBulkLoad");
        fs.mkdirs(dir);
        fs.setPermission(dir, FsPermission.valueOf((String)"-rwxrwxrwx"));
        SecureTestUtil.AccessTestAction bulkLoadAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                int numRows = 3;
                byte[][][] hfileRanges = new byte[][][]{new byte[][]{{0}, {9}}};
                Path bulkLoadBasePath = new Path(dir, new Path(User.getCurrent().getName()));
                new BulkLoadHelper(bulkLoadBasePath).bulkLoadHFile(TestAccessController.this.TEST_TABLE.getTableName(), TEST_FAMILY, TEST_QUALIFIER, hfileRanges, numRows);
                return null;
            }
        };
        TestAccessController.verifyAllowed(bulkLoadAction, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE);
        TestAccessController.verifyDenied(bulkLoadAction, USER_RW, USER_NONE, USER_RO);
        TEST_UTIL.getHBaseAdmin().disableTable(this.TEST_TABLE.getTableName());
        TEST_UTIL.getHBaseAdmin().enableTable(this.TEST_TABLE.getTableName());
    }

    @Test
    public void testAppend() throws Exception {
        SecureTestUtil.AccessTestAction appendAction = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                byte[] row = TEST_ROW;
                byte[] qualifier = TEST_QUALIFIER;
                Put put = new Put(row);
                put.add(TEST_FAMILY, qualifier, Bytes.toBytes((int)1));
                Append append = new Append(row);
                append.add(TEST_FAMILY, qualifier, Bytes.toBytes((int)2));
                HTable t = new HTable(conf, TestAccessController.this.TEST_TABLE.getTableName());
                try {
                    t.put(put);
                    t.append(append);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        TestAccessController.verifyAllowed(appendAction, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_RW);
        TestAccessController.verifyDenied(appendAction, USER_RO, USER_NONE);
    }

    @Test
    public void testGrantRevoke() throws Exception {
        SecureTestUtil.AccessTestAction grantAction = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
                try {
                    CoprocessorRpcChannel service = acl.coprocessorService(TestAccessController.this.TEST_TABLE.getTableName().getName());
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
                    ProtobufUtil.grant((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)USER_RO.getShortName(), (TableName)TestAccessController.this.TEST_TABLE.getTableName(), (byte[])TEST_FAMILY, null, (Permission.Action[])new Permission.Action[]{Permission.Action.READ});
                }
                finally {
                    acl.close();
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction revokeAction = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
                try {
                    CoprocessorRpcChannel service = acl.coprocessorService(TestAccessController.this.TEST_TABLE.getTableName().getName());
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
                    ProtobufUtil.revoke((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)USER_RO.getShortName(), (TableName)TestAccessController.this.TEST_TABLE.getTableName(), (byte[])TEST_FAMILY, null, (Permission.Action[])new Permission.Action[]{Permission.Action.READ});
                }
                finally {
                    acl.close();
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction getPermissionsAction = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
                try {
                    CoprocessorRpcChannel service = acl.coprocessorService(TestAccessController.this.TEST_TABLE.getTableName().getName());
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
                    ProtobufUtil.getUserPermissions((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (TableName)TestAccessController.this.TEST_TABLE.getTableName());
                }
                finally {
                    acl.close();
                }
                return null;
            }
        };
        TestAccessController.verifyAllowed(grantAction, SUPERUSER, USER_ADMIN, USER_OWNER);
        TestAccessController.verifyDenied(grantAction, USER_CREATE, USER_RW, USER_RO, USER_NONE);
        TestAccessController.verifyAllowed(revokeAction, SUPERUSER, USER_ADMIN, USER_OWNER);
        TestAccessController.verifyDenied(revokeAction, USER_CREATE, USER_RW, USER_RO, USER_NONE);
        TestAccessController.verifyAllowed(getPermissionsAction, SUPERUSER, USER_ADMIN, USER_OWNER);
        TestAccessController.verifyDenied(getPermissionsAction, USER_CREATE, USER_RW, USER_RO, USER_NONE);
    }

    @Test
    public void testPostGrantRevoke() throws Exception {
        final TableName tableName = TableName.valueOf((String)"TempTable");
        final byte[] family1 = Bytes.toBytes((String)"f1");
        final byte[] family2 = Bytes.toBytes((String)"f2");
        final byte[] qualifier = Bytes.toBytes((String)"q");
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        if (admin.tableExists(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor(family1));
        htd.addFamily(new HColumnDescriptor(family2));
        admin.createTable(htd);
        User tblUser = User.createUserForTesting((Configuration)TEST_UTIL.getConfiguration(), (String)"tbluser", (String[])new String[0]);
        User gblUser = User.createUserForTesting((Configuration)TEST_UTIL.getConfiguration(), (String)"gbluser", (String[])new String[0]);
        SecureTestUtil.AccessTestAction putActionAll = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Put p = new Put(Bytes.toBytes((String)"a"));
                p.add(family1, qualifier, Bytes.toBytes((String)"v1"));
                p.add(family2, qualifier, Bytes.toBytes((String)"v2"));
                HTable t = new HTable(conf, tableName);
                try {
                    t.put(p);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction putAction1 = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Put p = new Put(Bytes.toBytes((String)"a"));
                p.add(family1, qualifier, Bytes.toBytes((String)"v1"));
                HTable t = new HTable(conf, tableName);
                try {
                    t.put(p);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction putAction2 = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Put p = new Put(Bytes.toBytes((String)"a"));
                p.add(family2, qualifier, Bytes.toBytes((String)"v2"));
                HTable t = new HTable(conf, tableName);
                try {
                    t.put(p);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction getActionAll = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Get g = new Get(TEST_ROW);
                g.addFamily(family1);
                g.addFamily(family2);
                HTable t = new HTable(conf, tableName);
                try {
                    t.get(g);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction getAction1 = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Get g = new Get(TEST_ROW);
                g.addFamily(family1);
                HTable t = new HTable(conf, tableName);
                try {
                    t.get(g);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction getAction2 = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Get g = new Get(TEST_ROW);
                g.addFamily(family2);
                HTable t = new HTable(conf, tableName);
                try {
                    t.get(g);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction deleteActionAll = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Delete d = new Delete(TEST_ROW);
                d.deleteFamily(family1);
                d.deleteFamily(family2);
                HTable t = new HTable(conf, tableName);
                try {
                    t.delete(d);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction deleteAction1 = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Delete d = new Delete(TEST_ROW);
                d.deleteFamily(family1);
                HTable t = new HTable(conf, tableName);
                try {
                    t.delete(d);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction deleteAction2 = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Delete d = new Delete(TEST_ROW);
                d.deleteFamily(family2);
                HTable t = new HTable(conf, tableName);
                try {
                    t.delete(d);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        TestAccessController.verifyDenied(tblUser, getActionAll, getAction1, getAction2);
        TestAccessController.verifyDenied(tblUser, putActionAll, putAction1, putAction2);
        TestAccessController.verifyDenied(tblUser, deleteActionAll, deleteAction1, deleteAction2);
        TestAccessController.verifyDenied(gblUser, getActionAll, getAction1, getAction2);
        TestAccessController.verifyDenied(gblUser, putActionAll, putAction1, putAction2);
        TestAccessController.verifyDenied(gblUser, deleteActionAll, deleteAction1, deleteAction2);
        TestAccessController.grantGlobal(TEST_UTIL, gblUser.getShortName(), Permission.Action.READ);
        TestAccessController.grantOnTable(TEST_UTIL, tblUser.getShortName(), tableName, null, null, Permission.Action.READ);
        TestAccessController.verifyAllowed(tblUser, getActionAll, getAction1, getAction2);
        TestAccessController.verifyDenied(tblUser, putActionAll, putAction1, putAction2);
        TestAccessController.verifyDenied(tblUser, deleteActionAll, deleteAction1, deleteAction2);
        TestAccessController.verifyAllowed(gblUser, getActionAll, getAction1, getAction2);
        TestAccessController.verifyDenied(gblUser, putActionAll, putAction1, putAction2);
        TestAccessController.verifyDenied(gblUser, deleteActionAll, deleteAction1, deleteAction2);
        TestAccessController.grantGlobal(TEST_UTIL, gblUser.getShortName(), Permission.Action.WRITE);
        TestAccessController.grantOnTable(TEST_UTIL, tblUser.getShortName(), tableName, null, null, Permission.Action.WRITE);
        TestAccessController.verifyDenied(tblUser, getActionAll, getAction1, getAction2);
        TestAccessController.verifyAllowed(tblUser, putActionAll, putAction1, putAction2);
        TestAccessController.verifyAllowed(tblUser, deleteActionAll, deleteAction1, deleteAction2);
        TestAccessController.verifyDenied(gblUser, getActionAll, getAction1, getAction2);
        TestAccessController.verifyAllowed(gblUser, putActionAll, putAction1, putAction2);
        TestAccessController.verifyAllowed(gblUser, deleteActionAll, deleteAction1, deleteAction2);
        TestAccessController.revokeGlobal(TEST_UTIL, gblUser.getShortName(), new Permission.Action[0]);
        TestAccessController.revokeFromTable(TEST_UTIL, tblUser.getShortName(), tableName, null, null, new Permission.Action[0]);
        TestAccessController.verifyDenied(tblUser, getActionAll, getAction1, getAction2);
        TestAccessController.verifyDenied(tblUser, putActionAll, putAction1, putAction2);
        TestAccessController.verifyDenied(tblUser, deleteActionAll, deleteAction1, deleteAction2);
        TestAccessController.verifyDenied(gblUser, getActionAll, getAction1, getAction2);
        TestAccessController.verifyDenied(gblUser, putActionAll, putAction1, putAction2);
        TestAccessController.verifyDenied(gblUser, deleteActionAll, deleteAction1, deleteAction2);
        TestAccessController.grantGlobal(TEST_UTIL, gblUser.getShortName(), Permission.Action.READ);
        TestAccessController.grantOnTable(TEST_UTIL, tblUser.getShortName(), tableName, family1, null, Permission.Action.READ);
        TestAccessController.verifyAllowed(tblUser, getActionAll, getAction1);
        TestAccessController.verifyDenied(tblUser, getAction2);
        TestAccessController.verifyDenied(tblUser, putActionAll, putAction1, putAction2);
        TestAccessController.verifyDenied(tblUser, deleteActionAll, deleteAction1, deleteAction2);
        TestAccessController.verifyAllowed(gblUser, getActionAll, getAction1, getAction2);
        TestAccessController.verifyDenied(gblUser, putActionAll, putAction1, putAction2);
        TestAccessController.verifyDenied(gblUser, deleteActionAll, deleteAction1, deleteAction2);
        TestAccessController.grantGlobal(TEST_UTIL, gblUser.getShortName(), Permission.Action.WRITE);
        TestAccessController.grantOnTable(TEST_UTIL, tblUser.getShortName(), tableName, family2, null, Permission.Action.WRITE);
        TestAccessController.verifyAllowed(tblUser, getActionAll, getAction1);
        TestAccessController.verifyAllowed(tblUser, putAction2, deleteAction2);
        TestAccessController.verifyDenied(tblUser, getAction2);
        TestAccessController.verifyDenied(tblUser, putActionAll, putAction1);
        TestAccessController.verifyDenied(tblUser, deleteActionAll, deleteAction1);
        TestAccessController.verifyDenied(gblUser, getActionAll, getAction1, getAction2);
        TestAccessController.verifyAllowed(gblUser, putActionAll, putAction1, putAction2);
        TestAccessController.verifyAllowed(gblUser, deleteActionAll, deleteAction1, deleteAction2);
        TestAccessController.revokeGlobal(TEST_UTIL, gblUser.getShortName(), new Permission.Action[0]);
        TestAccessController.revokeFromTable(TEST_UTIL, tblUser.getShortName(), tableName, family2, null, new Permission.Action[0]);
        TestAccessController.verifyAllowed(tblUser, getActionAll, getAction1);
        TestAccessController.verifyDenied(tblUser, getAction2);
        TestAccessController.verifyDenied(tblUser, putActionAll, putAction1, putAction2);
        TestAccessController.verifyDenied(tblUser, deleteActionAll, deleteAction1, deleteAction2);
        TestAccessController.verifyDenied(gblUser, getActionAll, getAction1, getAction2);
        TestAccessController.verifyDenied(gblUser, putActionAll, putAction1, putAction2);
        TestAccessController.verifyDenied(gblUser, deleteActionAll, deleteAction1, deleteAction2);
        admin.disableTable(tableName);
        admin.deleteTable(tableName);
    }

    private boolean hasFoundUserPermission(UserPermission userPermission, List<UserPermission> perms) {
        return perms.contains(userPermission);
    }

    @Test
    public void testPostGrantRevokeAtQualifierLevel() throws Exception {
        final TableName tableName = TableName.valueOf((String)"testGrantRevokeAtQualifierLevel");
        final byte[] family1 = Bytes.toBytes((String)"f1");
        byte[] family2 = Bytes.toBytes((String)"f2");
        final byte[] qualifier = Bytes.toBytes((String)"q");
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        if (admin.tableExists(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor(family1));
        htd.addFamily(new HColumnDescriptor(family2));
        admin.createTable(htd);
        User user = User.createUserForTesting((Configuration)TEST_UTIL.getConfiguration(), (String)"user", (String[])new String[0]);
        SecureTestUtil.AccessTestAction getQualifierAction = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Get g = new Get(TEST_ROW);
                g.addColumn(family1, qualifier);
                HTable t = new HTable(conf, tableName);
                try {
                    t.get(g);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction putQualifierAction = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Put p = new Put(TEST_ROW);
                p.add(family1, qualifier, Bytes.toBytes((String)"v1"));
                HTable t = new HTable(conf, tableName);
                try {
                    t.put(p);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction deleteQualifierAction = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Delete d = new Delete(TEST_ROW);
                d.deleteColumn(family1, qualifier);
                HTable t = new HTable(conf, tableName);
                try {
                    t.delete(d);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        TestAccessController.revokeFromTable(TEST_UTIL, user.getShortName(), tableName, family1, null, new Permission.Action[0]);
        TestAccessController.verifyDenied(user, getQualifierAction);
        TestAccessController.verifyDenied(user, putQualifierAction);
        TestAccessController.verifyDenied(user, deleteQualifierAction);
        TestAccessController.grantOnTable(TEST_UTIL, user.getShortName(), tableName, family1, qualifier, Permission.Action.READ);
        TestAccessController.verifyAllowed(user, getQualifierAction);
        TestAccessController.verifyDenied(user, putQualifierAction);
        TestAccessController.verifyDenied(user, deleteQualifierAction);
        TestAccessController.grantOnTable(TEST_UTIL, user.getShortName(), tableName, family1, qualifier, Permission.Action.WRITE);
        TestAccessController.verifyDenied(user, getQualifierAction);
        TestAccessController.verifyAllowed(user, putQualifierAction);
        TestAccessController.verifyAllowed(user, deleteQualifierAction);
        TestAccessController.grantOnTable(TEST_UTIL, user.getShortName(), tableName, family1, qualifier, Permission.Action.READ, Permission.Action.WRITE);
        TestAccessController.verifyAllowed(user, getQualifierAction);
        TestAccessController.verifyAllowed(user, putQualifierAction);
        TestAccessController.verifyAllowed(user, deleteQualifierAction);
        TestAccessController.revokeFromTable(TEST_UTIL, user.getShortName(), tableName, family1, qualifier, new Permission.Action[0]);
        TestAccessController.verifyDenied(user, getQualifierAction);
        TestAccessController.verifyDenied(user, putQualifierAction);
        TestAccessController.verifyDenied(user, deleteQualifierAction);
        admin.disableTable(tableName);
        admin.deleteTable(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPermissionList() throws Exception {
        AccessControlProtos.AccessControlService.BlockingInterface protocol;
        CoprocessorRpcChannel service;
        List perms;
        TableName tableName = TableName.valueOf((String)"testPermissionList");
        byte[] family1 = Bytes.toBytes((String)"f1");
        byte[] family2 = Bytes.toBytes((String)"f2");
        byte[] qualifier = Bytes.toBytes((String)"q");
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        if (admin.tableExists(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor(family1));
        htd.addFamily(new HColumnDescriptor(family2));
        htd.setOwner(USER_OWNER);
        admin.createTable(htd);
        HTable acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        try {
            CoprocessorRpcChannel service2 = acl.coprocessorService(tableName.getName());
            AccessControlProtos.AccessControlService.BlockingInterface protocol2 = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service2);
            perms = ProtobufUtil.getUserPermissions((AccessControlProtos.AccessControlService.BlockingInterface)protocol2, (TableName)tableName);
        }
        finally {
            acl.close();
        }
        UserPermission ownerperm = new UserPermission(Bytes.toBytes((String)USER_OWNER.getName()), tableName, null, Permission.Action.values());
        Assert.assertTrue((String)"Owner should have all permissions on table", (boolean)this.hasFoundUserPermission(ownerperm, perms));
        User user = User.createUserForTesting((Configuration)TEST_UTIL.getConfiguration(), (String)"user", (String[])new String[0]);
        byte[] userName = Bytes.toBytes((String)user.getShortName());
        UserPermission up = new UserPermission(userName, tableName, family1, qualifier, new Permission.Action[]{Permission.Action.READ});
        Assert.assertFalse((String)("User should not be granted permission: " + up.toString()), (boolean)this.hasFoundUserPermission(up, perms));
        TestAccessController.grantOnTable(TEST_UTIL, user.getShortName(), tableName, family1, qualifier, Permission.Action.READ);
        acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        try {
            CoprocessorRpcChannel service3 = acl.coprocessorService(tableName.getName());
            AccessControlProtos.AccessControlService.BlockingInterface protocol3 = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service3);
            perms = ProtobufUtil.getUserPermissions((AccessControlProtos.AccessControlService.BlockingInterface)protocol3, (TableName)tableName);
        }
        finally {
            acl.close();
        }
        UserPermission upToVerify = new UserPermission(userName, tableName, family1, qualifier, new Permission.Action[]{Permission.Action.READ});
        Assert.assertTrue((String)("User should be granted permission: " + upToVerify.toString()), (boolean)this.hasFoundUserPermission(upToVerify, perms));
        upToVerify = new UserPermission(userName, tableName, family1, qualifier, new Permission.Action[]{Permission.Action.WRITE});
        Assert.assertFalse((String)("User should not be granted permission: " + upToVerify.toString()), (boolean)this.hasFoundUserPermission(upToVerify, perms));
        TestAccessController.grantOnTable(TEST_UTIL, user.getShortName(), tableName, family1, qualifier, Permission.Action.WRITE, Permission.Action.READ);
        acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        try {
            service = acl.coprocessorService(tableName.getName());
            protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
            perms = ProtobufUtil.getUserPermissions((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (TableName)tableName);
        }
        finally {
            acl.close();
        }
        upToVerify = new UserPermission(userName, tableName, family1, qualifier, new Permission.Action[]{Permission.Action.WRITE, Permission.Action.READ});
        Assert.assertTrue((String)("User should be granted permission: " + upToVerify.toString()), (boolean)this.hasFoundUserPermission(upToVerify, perms));
        TestAccessController.revokeFromTable(TEST_UTIL, user.getShortName(), tableName, family1, qualifier, Permission.Action.WRITE, Permission.Action.READ);
        acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        try {
            service = acl.coprocessorService(tableName.getName());
            protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
            perms = ProtobufUtil.getUserPermissions((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (TableName)tableName);
        }
        finally {
            acl.close();
        }
        Assert.assertFalse((String)("User should not be granted permission: " + upToVerify.toString()), (boolean)this.hasFoundUserPermission(upToVerify, perms));
        admin.disableTable(tableName);
        User newOwner = User.createUserForTesting((Configuration)conf, (String)"new_owner", (String[])new String[0]);
        htd.setOwner(newOwner);
        admin.modifyTable(tableName, htd);
        acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        try {
            CoprocessorRpcChannel service4 = acl.coprocessorService(tableName.getName());
            AccessControlProtos.AccessControlService.BlockingInterface protocol4 = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service4);
            perms = ProtobufUtil.getUserPermissions((AccessControlProtos.AccessControlService.BlockingInterface)protocol4, (TableName)tableName);
        }
        finally {
            acl.close();
        }
        UserPermission newOwnerperm = new UserPermission(Bytes.toBytes((String)newOwner.getName()), tableName, null, Permission.Action.values());
        Assert.assertTrue((String)"New owner should have all permissions on table", (boolean)this.hasFoundUserPermission(newOwnerperm, perms));
        admin.deleteTable(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGlobalPermissionList() throws Exception {
        List perms;
        HTable acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        try {
            CoprocessorRpcChannel service = acl.coprocessorService(HConstants.EMPTY_START_ROW);
            AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
            perms = ProtobufUtil.getUserPermissions((AccessControlProtos.AccessControlService.BlockingInterface)protocol);
        }
        finally {
            acl.close();
        }
        UserPermission adminPerm = new UserPermission(Bytes.toBytes((String)USER_ADMIN.getShortName()), AccessControlLists.ACL_TABLE_NAME, null, null, Bytes.toBytes((String)"ACRW"));
        Assert.assertTrue((String)"Only user admin has permission on table _acl_ per setup", (perms.size() == 1 && this.hasFoundUserPermission(adminPerm, perms) ? 1 : 0) != 0);
    }

    private void verifyGlobal(SecureTestUtil.AccessTestAction action) throws Exception {
        TestAccessController.verifyAllowed(action, SUPERUSER);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_NONE, USER_RO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkGlobalPerms(Permission.Action ... actions) throws IOException {
        Permission[] perms = new Permission[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            perms[i] = new Permission(new Permission.Action[]{actions[i]});
        }
        AccessControlProtos.CheckPermissionsRequest.Builder request = AccessControlProtos.CheckPermissionsRequest.newBuilder();
        for (Permission.Action a : actions) {
            request.addPermission(AccessControlProtos.Permission.newBuilder().setType(AccessControlProtos.Permission.Type.Global).setGlobalPermission(AccessControlProtos.GlobalPermission.newBuilder().addAction(ProtobufUtil.toPermissionAction((Permission.Action)a)).build()));
        }
        HTable acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        try {
            CoprocessorRpcChannel channel = acl.coprocessorService(new byte[0]);
            AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)channel);
            try {
                protocol.checkPermissions(null, request.build());
            }
            catch (ServiceException se) {
                ProtobufUtil.toIOException((ServiceException)se);
            }
        }
        finally {
            acl.close();
        }
    }

    public void checkTablePerms(TableName table, byte[] family, byte[] column, Permission.Action ... actions) throws IOException {
        Permission[] perms = new Permission[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            perms[i] = new TablePermission(table, family, column, new Permission.Action[]{actions[i]});
        }
        this.checkTablePerms(table, perms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkTablePerms(TableName table, Permission ... perms) throws IOException {
        AccessControlProtos.CheckPermissionsRequest.Builder request = AccessControlProtos.CheckPermissionsRequest.newBuilder();
        for (Permission p : perms) {
            request.addPermission(ProtobufUtil.toPermission((Permission)p));
        }
        HTable acl = new HTable(conf, table);
        try {
            AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)acl.coprocessorService(new byte[0]));
            try {
                protocol.checkPermissions(null, request.build());
            }
            catch (ServiceException se) {
                ProtobufUtil.toIOException((ServiceException)se);
            }
        }
        finally {
            acl.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckPermissions() throws Exception {
        SecureTestUtil.AccessTestAction globalAdmin = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                TestAccessController.this.checkGlobalPerms(Permission.Action.ADMIN);
                return null;
            }
        };
        this.verifyGlobal(globalAdmin);
        SecureTestUtil.AccessTestAction globalReadWrite = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                TestAccessController.this.checkGlobalPerms(Permission.Action.READ, Permission.Action.WRITE);
                return null;
            }
        };
        this.verifyGlobal(globalReadWrite);
        final byte[] TEST_Q1 = Bytes.toBytes((String)"q1");
        final byte[] TEST_Q2 = Bytes.toBytes((String)"q2");
        User userTable = User.createUserForTesting((Configuration)conf, (String)"user_check_perms_table", (String[])new String[0]);
        User userColumn = User.createUserForTesting((Configuration)conf, (String)"user_check_perms_family", (String[])new String[0]);
        User userQualifier = User.createUserForTesting((Configuration)conf, (String)"user_check_perms_q", (String[])new String[0]);
        TestAccessController.grantOnTable(TEST_UTIL, userTable.getShortName(), this.TEST_TABLE.getTableName(), null, null, Permission.Action.READ);
        TestAccessController.grantOnTable(TEST_UTIL, userColumn.getShortName(), this.TEST_TABLE.getTableName(), TEST_FAMILY, null, Permission.Action.READ);
        TestAccessController.grantOnTable(TEST_UTIL, userQualifier.getShortName(), this.TEST_TABLE.getTableName(), TEST_FAMILY, TEST_Q1, Permission.Action.READ);
        SecureTestUtil.AccessTestAction tableRead = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                TestAccessController.this.checkTablePerms(TestAccessController.this.TEST_TABLE.getTableName(), null, null, Permission.Action.READ);
                return null;
            }
        };
        SecureTestUtil.AccessTestAction columnRead = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                TestAccessController.this.checkTablePerms(TestAccessController.this.TEST_TABLE.getTableName(), TEST_FAMILY, null, Permission.Action.READ);
                return null;
            }
        };
        SecureTestUtil.AccessTestAction qualifierRead = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                TestAccessController.this.checkTablePerms(TestAccessController.this.TEST_TABLE.getTableName(), TEST_FAMILY, TEST_Q1, Permission.Action.READ);
                return null;
            }
        };
        SecureTestUtil.AccessTestAction multiQualifierRead = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                TestAccessController.this.checkTablePerms(TestAccessController.this.TEST_TABLE.getTableName(), new Permission[]{new TablePermission(TestAccessController.this.TEST_TABLE.getTableName(), TEST_FAMILY, TEST_Q1, new Permission.Action[]{Permission.Action.READ}), new TablePermission(TestAccessController.this.TEST_TABLE.getTableName(), TEST_FAMILY, TEST_Q2, new Permission.Action[]{Permission.Action.READ})});
                return null;
            }
        };
        SecureTestUtil.AccessTestAction globalAndTableRead = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                TestAccessController.this.checkTablePerms(TestAccessController.this.TEST_TABLE.getTableName(), new Permission[]{new Permission(new Permission.Action[]{Permission.Action.READ}), new TablePermission(TestAccessController.this.TEST_TABLE.getTableName(), null, (byte[])null, new Permission.Action[]{Permission.Action.READ})});
                return null;
            }
        };
        SecureTestUtil.AccessTestAction noCheck = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                TestAccessController.this.checkTablePerms(TestAccessController.this.TEST_TABLE.getTableName(), new Permission[0]);
                return null;
            }
        };
        TestAccessController.verifyAllowed(tableRead, SUPERUSER, userTable);
        TestAccessController.verifyDenied(tableRead, userColumn, userQualifier);
        TestAccessController.verifyAllowed(columnRead, SUPERUSER, userTable, userColumn);
        TestAccessController.verifyDenied(columnRead, userQualifier);
        TestAccessController.verifyAllowed(qualifierRead, SUPERUSER, userTable, userColumn, userQualifier);
        TestAccessController.verifyAllowed(multiQualifierRead, SUPERUSER, userTable, userColumn);
        TestAccessController.verifyDenied(multiQualifierRead, userQualifier);
        TestAccessController.verifyAllowed(globalAndTableRead, SUPERUSER);
        TestAccessController.verifyDenied(globalAndTableRead, userTable, userColumn, userQualifier);
        TestAccessController.verifyAllowed(noCheck, SUPERUSER, userTable, userColumn, userQualifier);
        SecureTestUtil.AccessTestAction familyReadWrite = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                TestAccessController.this.checkTablePerms(TestAccessController.this.TEST_TABLE.getTableName(), TEST_FAMILY, null, Permission.Action.READ, Permission.Action.WRITE);
                return null;
            }
        };
        TestAccessController.verifyAllowed(familyReadWrite, SUPERUSER, USER_OWNER, USER_CREATE, USER_RW);
        TestAccessController.verifyDenied(familyReadWrite, USER_NONE, USER_RO);
        AccessControlProtos.CheckPermissionsRequest checkRequest = AccessControlProtos.CheckPermissionsRequest.newBuilder().addPermission(AccessControlProtos.Permission.newBuilder().setType(AccessControlProtos.Permission.Type.Table).setTablePermission(AccessControlProtos.TablePermission.newBuilder().setTableName(ProtobufUtil.toProtoTableName((TableName)this.TEST_TABLE.getTableName())).addAction(AccessControlProtos.Permission.Action.CREATE))).build();
        HTable acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        try {
            CoprocessorRpcChannel channel = acl.coprocessorService(new byte[0]);
            AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)channel);
            try {
                protocol.checkPermissions(null, checkRequest);
                Assert.fail((String)"this should have thrown CoprocessorException");
            }
            catch (ServiceException ex) {
                // empty catch block
            }
        }
        finally {
            acl.close();
        }
    }

    @Test
    public void testStopRegionServer() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preStopRegionServer(ObserverContext.createAndPrepare((CoprocessorEnvironment)RSCP_ENV, null));
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE);
    }

    @Test
    public void testOpenRegion() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preOpen(ObserverContext.createAndPrepare((CoprocessorEnvironment)TestAccessController.this.RCP_ENV, null));
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER);
    }

    @Test
    public void testCloseRegion() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preClose(ObserverContext.createAndPrepare((CoprocessorEnvironment)TestAccessController.this.RCP_ENV, null), false);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER);
    }

    @Test
    public void testSnapshot() throws Exception {
        SecureTestUtil.AccessTestAction snapshotAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preSnapshot(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), null, null);
                return null;
            }
        };
        SecureTestUtil.AccessTestAction deleteAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preDeleteSnapshot(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), null);
                return null;
            }
        };
        SecureTestUtil.AccessTestAction restoreAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preRestoreSnapshot(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), null, null);
                return null;
            }
        };
        SecureTestUtil.AccessTestAction cloneAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preCloneSnapshot(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), null, null);
                return null;
            }
        };
        TestAccessController.verifyAllowed(snapshotAction, SUPERUSER, USER_ADMIN);
        TestAccessController.verifyDenied(snapshotAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER);
        TestAccessController.verifyAllowed(cloneAction, SUPERUSER, USER_ADMIN);
        TestAccessController.verifyDenied(deleteAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER);
        TestAccessController.verifyAllowed(restoreAction, SUPERUSER, USER_ADMIN);
        TestAccessController.verifyDenied(restoreAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER);
        TestAccessController.verifyAllowed(deleteAction, SUPERUSER, USER_ADMIN);
        TestAccessController.verifyDenied(cloneAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGlobalAuthorizationForNewRegisteredRS() throws Exception {
        LOG.debug((Object)"Test for global authorization for a new registered RegionServer.");
        MiniHBaseCluster hbaseCluster = TEST_UTIL.getHBaseCluster();
        String currentUser = User.getCurrent().getShortName();
        String activeUserForNewRs = currentUser + ".hfs." + hbaseCluster.getLiveRegionServerThreads().size();
        TestAccessController.grantGlobal(TEST_UTIL, activeUserForNewRs, Permission.Action.ADMIN, Permission.Action.CREATE, Permission.Action.READ, Permission.Action.WRITE);
        final HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor htd = new HTableDescriptor(TEST_TABLE2);
        htd.addFamily(new HColumnDescriptor(TEST_FAMILY));
        admin.createTable(htd);
        JVMClusterUtil.RegionServerThread newRsThread = hbaseCluster.startRegionServer();
        final HRegionServer newRs = newRsThread.getRegionServer();
        final HTable table = new HTable(TEST_UTIL.getConfiguration(), TEST_TABLE2);
        try {
            NavigableMap regions = table.getRegionLocations();
            final Map.Entry firstRegion = regions.entrySet().iterator().next();
            SecureTestUtil.AccessTestAction moveAction = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    admin.move(((HRegionInfo)firstRegion.getKey()).getEncodedNameAsBytes(), Bytes.toBytes((String)newRs.getServerName().getServerName()));
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)moveAction);
            int RETRIES_LIMIT = 10;
            int retries = 0;
            while (newRs.getOnlineRegions(TEST_TABLE2).size() < 1 && retries < 10) {
                LOG.debug((Object)("Waiting for region to be opened. Already retried " + retries + " times."));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (++retries != 9) continue;
                Assert.fail((String)"Retry exhaust for waiting region to be opened.");
            }
            SecureTestUtil.AccessTestAction putAction = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    Put put = new Put(Bytes.toBytes((String)"test"));
                    put.add(TEST_FAMILY, Bytes.toBytes((String)"qual"), Bytes.toBytes((String)"value"));
                    table.put(put);
                    return null;
                }
            };
            USER_ADMIN.runAs((PrivilegedExceptionAction)putAction);
        }
        finally {
            table.close();
        }
    }

    @Test
    public void testTableDescriptorsEnumeration() throws Exception {
        User TABLE_ADMIN = User.createUserForTesting((Configuration)conf, (String)"UserA", (String[])new String[0]);
        TestAccessController.grantOnTable(TEST_UTIL, TABLE_ADMIN.getShortName(), this.TEST_TABLE.getTableName(), null, null, Permission.Action.ADMIN);
        SecureTestUtil.AccessTestAction listTablesAction = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
                try {
                    admin.listTables();
                }
                finally {
                    admin.close();
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction getTableDescAction = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
                try {
                    admin.getTableDescriptor(TestAccessController.this.TEST_TABLE.getTableName());
                }
                finally {
                    admin.close();
                }
                return null;
            }
        };
        TestAccessController.verifyAllowed(listTablesAction, SUPERUSER, USER_ADMIN);
        TestAccessController.verifyDenied(listTablesAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, TABLE_ADMIN);
        TestAccessController.verifyAllowed(getTableDescAction, SUPERUSER, USER_ADMIN, USER_CREATE, TABLE_ADMIN);
        TestAccessController.verifyDenied(getTableDescAction, USER_RW, USER_RO, USER_NONE);
    }

    @Test
    public void testTableDeletion() throws Exception {
        User TABLE_ADMIN = User.createUserForTesting((Configuration)conf, (String)"TestUser", (String[])new String[0]);
        TestAccessController.grantOnTable(TEST_UTIL, TABLE_ADMIN.getShortName(), this.TEST_TABLE.getTableName(), null, null, Permission.Action.ADMIN);
        SecureTestUtil.AccessTestAction deleteTableAction = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
                try {
                    admin.disableTable(TestAccessController.this.TEST_TABLE.getTableName());
                    admin.deleteTable(TestAccessController.this.TEST_TABLE.getTableName());
                }
                finally {
                    admin.close();
                }
                return null;
            }
        };
        TestAccessController.verifyDenied(deleteTableAction, USER_RW, USER_RO, USER_NONE);
        TestAccessController.verifyAllowed(deleteTableAction, TABLE_ADMIN);
    }

    @Test
    public void testNamespaceUserGrant() throws Exception {
        SecureTestUtil.AccessTestAction getAction = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable t = new HTable(conf, TestAccessController.this.TEST_TABLE.getTableName());
                try {
                    Result result = t.get(new Get(TEST_ROW));
                    return result;
                }
                finally {
                    t.close();
                }
            }
        };
        TestAccessController.verifyDenied(getAction, USER_NONE);
        TestAccessController.grantOnNamespace(TEST_UTIL, USER_NONE.getShortName(), this.TEST_TABLE.getTableName().getNamespaceAsString(), Permission.Action.READ);
        TestAccessController.verifyAllowed(getAction, USER_NONE);
    }

    @Test
    public void testCoprocessorExec() throws Exception {
        for (JVMClusterUtil.RegionServerThread thread : TEST_UTIL.getMiniHBaseCluster().getRegionServerThreads()) {
            HRegionServer rs = thread.getRegionServer();
            for (HRegion region : rs.getOnlineRegions(this.TEST_TABLE.getTableName())) {
                region.getCoprocessorHost().load(PingCoprocessor.class, 0x3FFFFFFF, conf);
            }
        }
        User userA = User.createUserForTesting((Configuration)conf, (String)"UserA", (String[])new String[0]);
        User userB = User.createUserForTesting((Configuration)conf, (String)"UserB", (String[])new String[0]);
        TestAccessController.grantOnTable(TEST_UTIL, userA.getShortName(), this.TEST_TABLE.getTableName(), null, null, Permission.Action.EXEC);
        SecureTestUtil.AccessTestAction execEndpointAction = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable t = new HTable(conf, TestAccessController.this.TEST_TABLE.getTableName());
                try {
                    CoprocessorRpcChannel service = t.coprocessorService(HConstants.EMPTY_BYTE_ARRAY);
                    PingCoprocessor.newBlockingStub((BlockingRpcChannel)service).noop(null, PingProtos.NoopRequest.newBuilder().build());
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        TestAccessController.verifyDenied(execEndpointAction, userB);
        TestAccessController.verifyAllowed(execEndpointAction, userA);
        TestAccessController.grantOnNamespace(TEST_UTIL, userB.getShortName(), this.TEST_TABLE.getTableName().getNamespaceAsString(), Permission.Action.EXEC);
        TestAccessController.verifyAllowed(execEndpointAction, userA, userB);
    }

    @Test
    public void testReservedCellTags() throws Exception {
        SecureTestUtil.AccessTestAction putWithReservedTag = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable t = new HTable(conf, TestAccessController.this.TEST_TABLE.getTableName());
                try {
                    KeyValue kv = new KeyValue(TEST_ROW, TEST_FAMILY, TEST_QUALIFIER, Long.MAX_VALUE, HConstants.EMPTY_BYTE_ARRAY, new Tag[]{new Tag(1, ProtobufUtil.toUsersAndPermissions((String)USER_OWNER.getShortName(), (Permission)new Permission(new Permission.Action[]{Permission.Action.READ})).toByteArray())});
                    t.put(new Put(TEST_ROW).add((Cell)kv));
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        TestAccessController.verifyAllowed(putWithReservedTag, User.getCurrent());
        TestAccessController.verifyDenied(putWithReservedTag, USER_OWNER, USER_ADMIN, USER_CREATE, USER_RW, USER_RO);
    }

    static {
        Logger.getLogger(AccessController.class).setLevel(Level.TRACE);
        Logger.getLogger(AccessControlFilter.class).setLevel(Level.TRACE);
        Logger.getLogger(TableAuthManager.class).setLevel(Level.TRACE);
        TEST_UTIL = new HBaseTestingUtility();
        TEST_TABLE2 = TableName.valueOf((String)"testtable2");
        TEST_FAMILY = Bytes.toBytes((String)"f1");
        TEST_QUALIFIER = Bytes.toBytes((String)"q1");
        TEST_ROW = Bytes.toBytes((String)"r1");
    }

    public static class PingCoprocessor
    extends PingProtos.PingService
    implements Coprocessor,
    CoprocessorService {
        public void start(CoprocessorEnvironment env) throws IOException {
        }

        public void stop(CoprocessorEnvironment env) throws IOException {
        }

        public Service getService() {
            return this;
        }

        @Override
        public void ping(RpcController controller, PingProtos.PingRequest request, RpcCallback<PingProtos.PingResponse> callback) {
            callback.run((Object)PingProtos.PingResponse.newBuilder().setPong("Pong!").build());
        }

        @Override
        public void count(RpcController controller, PingProtos.CountRequest request, RpcCallback<PingProtos.CountResponse> callback) {
            callback.run((Object)PingProtos.CountResponse.newBuilder().build());
        }

        @Override
        public void increment(RpcController controller, PingProtos.IncrementCountRequest requet, RpcCallback<PingProtos.IncrementCountResponse> callback) {
            callback.run((Object)PingProtos.IncrementCountResponse.newBuilder().build());
        }

        @Override
        public void hello(RpcController controller, PingProtos.HelloRequest request, RpcCallback<PingProtos.HelloResponse> callback) {
            callback.run((Object)PingProtos.HelloResponse.newBuilder().setResponse("Hello!").build());
        }

        @Override
        public void noop(RpcController controller, PingProtos.NoopRequest request, RpcCallback<PingProtos.NoopResponse> callback) {
            callback.run((Object)PingProtos.NoopResponse.newBuilder().build());
        }
    }

    public class BulkLoadHelper {
        private final FileSystem fs = TestAccessController.access$900().getTestFileSystem();
        private final Path loadPath;
        private final Configuration conf = TestAccessController.access$900().getConfiguration();

        public BulkLoadHelper(Path loadPath) throws IOException {
            this.loadPath = loadPath = loadPath.makeQualified(this.fs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createHFile(Path path, byte[] family, byte[] qualifier, byte[] startKey, byte[] endKey, int numRows) throws IOException {
            HFile.Writer writer = null;
            long now = System.currentTimeMillis();
            try {
                HFileContext context = new HFileContextBuilder().build();
                writer = HFile.getWriterFactory((Configuration)this.conf, (CacheConfig)new CacheConfig(this.conf)).withPath(this.fs, path).withFileContext(context).create();
                for (byte[] key : Bytes.iterateOnSplits((byte[])startKey, (byte[])endKey, (boolean)true, (int)(numRows - 2))) {
                    KeyValue kv = new KeyValue(key, family, qualifier, now, key);
                    writer.append(kv);
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void bulkLoadHFile(TableName tableName, byte[] family, byte[] qualifier, byte[][][] hfileRanges, int numRowsPerRange) throws Exception {
            Path familyDir = new Path(this.loadPath, Bytes.toString((byte[])family));
            this.fs.mkdirs(familyDir);
            int hfileIdx = 0;
            for (byte[][] range : hfileRanges) {
                byte[] from = range[0];
                byte[] to = range[1];
                this.createHFile(new Path(familyDir, "hfile_" + hfileIdx++), family, qualifier, from, to, numRowsPerRange);
            }
            this.setPermission(this.loadPath, FsPermission.valueOf((String)"-rwxrwxrwx"));
            HTable table = new HTable(this.conf, tableName);
            try {
                HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
                TEST_UTIL.waitTableEnabled(admin, tableName.getName());
                LoadIncrementalHFiles loader = new LoadIncrementalHFiles(this.conf);
                loader.doBulkLoad(this.loadPath, table);
            }
            finally {
                table.close();
            }
        }

        public void setPermission(Path dir, FsPermission perm) throws IOException {
            if (!this.fs.getFileStatus(dir).isDir()) {
                this.fs.setPermission(dir, perm);
            } else {
                for (FileStatus el : this.fs.listStatus(dir)) {
                    this.fs.setPermission(el.getPath(), perm);
                    this.setPermission(el.getPath(), perm);
                }
            }
        }
    }
}

