/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;

public class FaultyHLog
extends FSHLog {
    FailureType ft = FailureType.NONE;

    public FaultyHLog(FileSystem fs, Path rootDir, String logName, Configuration conf) throws IOException {
        super(fs, rootDir, logName, conf);
    }

    public void setFailureType(FailureType fType) {
        this.ft = fType;
    }

    public void sync(long txid) throws IOException {
        if (this.ft == FailureType.SYNC) {
            throw new IOException("sync");
        }
        super.sync(txid);
    }

    public long appendNoSync(HRegionInfo info, TableName tableName, WALEdit edits, List<UUID> clusterIds, long now, HTableDescriptor htd, AtomicLong sequenceId, boolean isInMemstore, long nonceGroup, long nonce) throws IOException {
        if (this.ft == FailureType.APPENDNOSYNC) {
            throw new IOException("appendNoSync");
        }
        return super.appendNoSync(info, tableName, edits, clusterIds, now, htd, sequenceId, isInMemstore, nonceGroup, nonce);
    }

    public static enum FailureType {
        NONE,
        APPENDNOSYNC,
        SYNC;

    }
}

