/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math.random.GaussianRandomGenerator;
import org.apache.commons.math.random.MersenneTwister;
import org.apache.commons.math.random.RandomGenerator;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.StoreFileListGenerator;

class GaussianFileListGenerator
extends StoreFileListGenerator {
    GaussianFileListGenerator() {
        super(GaussianFileListGenerator.class);
    }

    @Override
    public Iterator<List<StoreFile>> iterator() {
        return new Iterator<List<StoreFile>>(){
            private GaussianRandomGenerator gen;
            private int count;
            {
                this.gen = new GaussianRandomGenerator((RandomGenerator)new MersenneTwister(GaussianFileListGenerator.this.random.nextInt()));
                this.count = 0;
            }

            @Override
            public boolean hasNext() {
                return this.count < 10;
            }

            @Override
            public List<StoreFile> next() {
                ++this.count;
                ArrayList<StoreFile> files = new ArrayList<StoreFile>(1000);
                for (int i = 0; i < 1000; ++i) {
                    files.add(GaussianFileListGenerator.this.createMockStoreFile((int)Math.ceil(Math.max(0.0, this.gen.nextNormalizedDouble() * 32.0 + 32.0))));
                }
                return files;
            }

            @Override
            public void remove() {
            }
        };
    }
}

