/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestParallelPut {
    static final Log LOG = LogFactory.getLog(TestParallelPut.class);
    @Rule
    public TestName name = new TestName();
    private static HRegion region = null;
    private static HBaseTestingUtility hbtu = new HBaseTestingUtility();
    static byte[] tableName;
    static final byte[] qual1;
    static final byte[] qual2;
    static final byte[] qual3;
    static final byte[] value1;
    static final byte[] value2;
    static final byte[] row;
    static final byte[] row2;

    @Before
    public void setUp() throws Exception {
        tableName = Bytes.toBytes((String)this.name.getMethodName());
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentEdgeManagerTestHelper.reset();
    }

    public String getName() {
        return this.name.getMethodName();
    }

    @Test
    public void testPut() throws IOException {
        LOG.info((Object)"Starting testPut");
        this.initHRegion(tableName, this.getName(), new byte[][]{HBaseTestingUtility.fam1});
        long value = 1L;
        Put put = new Put(row);
        put.add(HBaseTestingUtility.fam1, qual1, Bytes.toBytes((long)value));
        region.put(put);
        TestParallelPut.assertGet(row, HBaseTestingUtility.fam1, qual1, Bytes.toBytes((long)value));
    }

    @Test
    public void testParallelPuts() throws IOException {
        int i;
        LOG.info((Object)"Starting testParallelPuts");
        this.initHRegion(tableName, this.getName(), new byte[][]{HBaseTestingUtility.fam1});
        int numOps = 1000;
        int numThreads = 100;
        Putter[] all = new Putter[numThreads];
        for (i = 0; i < numThreads; ++i) {
            all[i] = new Putter(region, i, numOps);
        }
        for (i = 0; i < numThreads; ++i) {
            all[i].start();
        }
        for (i = 0; i < numThreads; ++i) {
            try {
                all[i].join();
                continue;
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"testParallelPuts encountered InterruptedException. Ignoring....", (Throwable)e);
            }
        }
        LOG.info((Object)("testParallelPuts successfully verified " + numOps * numThreads + " put operations."));
    }

    private static void assertGet(byte[] row, byte[] familiy, byte[] qualifier, byte[] value) throws IOException {
        Get get = new Get(row);
        get.addColumn(familiy, qualifier);
        Result result = region.get(get);
        Assert.assertEquals((long)1L, (long)result.size());
        Cell kv = result.rawCells()[0];
        byte[] r = CellUtil.cloneValue((Cell)kv);
        Assert.assertTrue((Bytes.compareTo((byte[])r, (byte[])value) == 0 ? 1 : 0) != 0);
    }

    private void initHRegion(byte[] tableName, String callingMethod, byte[] ... families) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((byte[])tableName));
        for (byte[] family : families) {
            htd.addFamily(new HColumnDescriptor(family));
        }
        HRegionInfo info = new HRegionInfo(htd.getTableName(), null, null, false);
        region = hbtu.createLocalHRegion(info, htd);
    }

    static {
        qual1 = Bytes.toBytes((String)"qual1");
        qual2 = Bytes.toBytes((String)"qual2");
        qual3 = Bytes.toBytes((String)"qual3");
        value1 = Bytes.toBytes((String)"value1");
        value2 = Bytes.toBytes((String)"value2");
        row = Bytes.toBytes((String)"rowA");
        row2 = Bytes.toBytes((String)"rowB");
    }

    public static class Putter
    extends Thread {
        private final HRegion region;
        private final int threadNumber;
        private final int numOps;
        private final Random rand = new Random();
        byte[] rowkey = null;

        public Putter(HRegion region, int threadNumber, int numOps) {
            this.region = region;
            this.threadNumber = threadNumber;
            this.numOps = numOps;
            this.rowkey = Bytes.toBytes((long)threadNumber);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            byte[] value = new byte[100];
            Put[] in = new Put[1];
            for (int i = 0; i < this.numOps; ++i) {
                this.rand.nextBytes(value);
                Put put = new Put(this.rowkey);
                put.add(HBaseTestingUtility.fam1, qual1, value);
                in[0] = put;
                try {
                    OperationStatus[] ret = this.region.batchMutate((Mutation[])in);
                    Assert.assertEquals((long)1L, (long)ret.length);
                    Assert.assertEquals((Object)HConstants.OperationStatusCode.SUCCESS, (Object)ret[0].getOperationStatusCode());
                    TestParallelPut.assertGet(this.rowkey, HBaseTestingUtility.fam1, qual1, value);
                    continue;
                }
                catch (IOException e) {
                    Assert.assertTrue((String)("Thread id " + this.threadNumber + " operation " + i + " failed."), (boolean)false);
                }
            }
        }
    }
}

