/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.MockStoreFile;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.compactions.RatioBasedCompactionPolicy;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogFactory;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.After;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestDefaultCompactSelection
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestDefaultCompactSelection.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    protected Configuration conf;
    protected HStore store;
    private static final String DIR = TEST_UTIL.getDataTestDir(TestDefaultCompactSelection.class.getSimpleName()).toString();
    private static Path TEST_FILE;
    protected static final int minFiles = 3;
    protected static final int maxFiles = 5;
    protected static final long minSize = 10L;
    protected static final long maxSize = 2100L;
    private HLog hlog;
    private HRegion region;

    public void setUp() throws Exception {
        this.conf = TEST_UTIL.getConfiguration();
        this.conf.setLong("hbase.hregion.majorcompaction", 0L);
        this.conf.setInt("hbase.hstore.compaction.min", 3);
        this.conf.setInt("hbase.hstore.compaction.max", 5);
        this.conf.setLong("hbase.hregion.memstore.flush.size", 10L);
        this.conf.setLong("hbase.hstore.compaction.max.size", 2100L);
        this.conf.setFloat("hbase.hstore.compaction.ratio", 1.0f);
        Path basedir = new Path(DIR);
        String logName = "logs";
        Path logdir = new Path(DIR, logName);
        HColumnDescriptor hcd = new HColumnDescriptor(Bytes.toBytes((String)"family"));
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        fs.delete(logdir, true);
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((byte[])Bytes.toBytes((String)"table")));
        htd.addFamily(hcd);
        HRegionInfo info = new HRegionInfo(htd.getTableName(), null, null, false);
        this.hlog = HLogFactory.createHLog((FileSystem)fs, (Path)basedir, (String)logName, (Configuration)this.conf);
        this.region = HRegion.createHRegion((HRegionInfo)info, (Path)basedir, (Configuration)this.conf, (HTableDescriptor)htd);
        HRegion.closeHRegion((HRegion)this.region);
        Path tableDir = FSUtils.getTableDir((Path)basedir, (TableName)htd.getTableName());
        this.region = new HRegion(tableDir, this.hlog, fs, this.conf, info, htd, null);
        this.store = new HStore(this.region, hcd, this.conf);
        TEST_FILE = this.region.getRegionFileSystem().createTempName();
        fs.createNewFile(TEST_FILE);
    }

    @After
    public void tearDown() throws IOException {
        IOException ex = null;
        try {
            this.region.close();
        }
        catch (IOException e) {
            LOG.warn((Object)"Caught Exception", (Throwable)e);
            ex = e;
        }
        try {
            this.hlog.closeAndDelete();
        }
        catch (IOException e) {
            LOG.warn((Object)"Caught Exception", (Throwable)e);
            ex = e;
        }
        if (ex != null) {
            throw ex;
        }
    }

    ArrayList<Long> toArrayList(long ... numbers) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (long i : numbers) {
            result.add(i);
        }
        return result;
    }

    List<StoreFile> sfCreate(long ... sizes) throws IOException {
        ArrayList<Long> ageInDisk = new ArrayList<Long>();
        for (int i = 0; i < sizes.length; ++i) {
            ageInDisk.add(0L);
        }
        return this.sfCreate(this.toArrayList(sizes), ageInDisk);
    }

    List<StoreFile> sfCreate(ArrayList<Long> sizes, ArrayList<Long> ageInDisk) throws IOException {
        return this.sfCreate(false, sizes, ageInDisk);
    }

    List<StoreFile> sfCreate(boolean isReference, long ... sizes) throws IOException {
        ArrayList<Long> ageInDisk = new ArrayList<Long>(sizes.length);
        for (int i = 0; i < sizes.length; ++i) {
            ageInDisk.add(0L);
        }
        return this.sfCreate(isReference, this.toArrayList(sizes), ageInDisk);
    }

    List<StoreFile> sfCreate(boolean isReference, ArrayList<Long> sizes, ArrayList<Long> ageInDisk) throws IOException {
        ArrayList ret = Lists.newArrayList();
        for (int i = 0; i < sizes.size(); ++i) {
            ret.add(new MockStoreFile(TEST_UTIL, TEST_FILE, sizes.get(i), ageInDisk.get(i), isReference, i));
        }
        return ret;
    }

    long[] getSizes(List<StoreFile> sfList) {
        long[] aNums = new long[sfList.size()];
        for (int i = 0; i < sfList.size(); ++i) {
            aNums[i] = sfList.get(i).getReader().length();
        }
        return aNums;
    }

    void compactEquals(List<StoreFile> candidates, long ... expected) throws IOException {
        this.compactEquals(candidates, false, false, expected);
    }

    void compactEquals(List<StoreFile> candidates, boolean forcemajor, long ... expected) throws IOException {
        this.compactEquals(candidates, forcemajor, false, expected);
    }

    void compactEquals(List<StoreFile> candidates, boolean forcemajor, boolean isOffPeak, long ... expected) throws IOException {
        this.store.forceMajor = forcemajor;
        CompactionRequest result = ((RatioBasedCompactionPolicy)this.store.storeEngine.getCompactionPolicy()).selectCompaction(candidates, new ArrayList(), false, isOffPeak, forcemajor);
        ArrayList<StoreFile> actual = new ArrayList<StoreFile>(result.getFiles());
        if (isOffPeak && !forcemajor) {
            TestDefaultCompactSelection.assertTrue((boolean)result.isOffPeak());
        }
        TestDefaultCompactSelection.assertEquals((String)Arrays.toString(expected), (String)Arrays.toString(this.getSizes(actual)));
        this.store.forceMajor = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCompactionRatio() throws IOException {
        long tooBig = 2101L;
        this.compactEquals(this.sfCreate(100L, 50L, 23L, 12L, 12L), 23L, 12L, 12L);
        this.compactEquals(this.sfCreate(100L, 50L, 25L, 12L, 12L), new long[0]);
        this.compactEquals(this.sfCreate(tooBig, tooBig, 700L, 700L, 700L), 700L, 700L, 700L);
        this.compactEquals(this.sfCreate(tooBig, tooBig, 700L, 700L), new long[0]);
        this.compactEquals(this.sfCreate(7L, 1L, 1L), 7L, 1L, 1L);
        this.compactEquals(this.sfCreate(7L, 6L, 5L, 4L, 3L, 2L, 1L), 5L, 4L, 3L, 2L, 1L);
        this.compactEquals(this.sfCreate(50L, 10L, 10L, 10L, 10L), 10L, 10L, 10L, 10L);
        this.compactEquals(this.sfCreate(10L, 10L, 10L, 10L, 50L), 10L, 10L, 10L, 10L);
        this.compactEquals(this.sfCreate(251L, 253L, 251L, 2099L), 251L, 253L, 251L);
        this.compactEquals(this.sfCreate(2099L, 2099L, 2099L), new long[0]);
        this.conf.setLong("hbase.hstore.compaction.min.size", 1L);
        this.store.storeEngine.getCompactionPolicy().setConf(this.conf);
        this.compactEquals(this.sfCreate(512L, 256L, 128L, 64L, 32L, 16L, 8L, 4L, 2L, 1L), 4L, 2L, 1L);
        this.conf.setLong("hbase.hstore.compaction.min.size", 10L);
        this.store.storeEngine.getCompactionPolicy().setConf(this.conf);
        this.compactEquals(this.sfCreate(50L, 25L, 12L, 12L), true, 50L, 25L, 12L, 12L);
        this.compactEquals(this.sfCreate(12L, 12L), true, 12L, 12L);
        this.compactEquals(this.sfCreate(tooBig, 12L, 12L), true, tooBig, 12L, 12L);
        this.store.forceMajor = true;
        this.compactEquals(this.sfCreate(7L, 6L, 5L, 4L, 3L, 2L, 1L), 5L, 4L, 3L, 2L, 1L);
        this.store.forceMajor = false;
        this.compactEquals(this.sfCreate(100L, 50L, 23L, 12L, 12L), true, 23L, 12L, 12L);
        this.conf.setLong("hbase.hregion.majorcompaction", 1L);
        this.conf.setFloat("hbase.hregion.majorcompaction.jitter", 0.0f);
        this.store.storeEngine.getCompactionPolicy().setConf(this.conf);
        try {
            this.compactEquals(this.sfCreate(50L, 25L, 12L, 12L), 50L, 25L, 12L, 12L);
            this.compactEquals(this.sfCreate(100L, 50L, 23L, 12L, 12L), 23L, 12L, 12L);
        }
        finally {
            this.conf.setLong("hbase.hregion.majorcompaction", 86400000L);
            this.conf.setFloat("hbase.hregion.majorcompaction.jitter", 0.2f);
        }
        this.compactEquals(this.sfCreate(true, 100L, 50L, 25L, 12L, 12L), 100L, 50L, 25L, 12L, 12L);
        this.compactEquals(this.sfCreate(true, tooBig, 12L, 12L), tooBig, 12L, 12L);
        this.compactEquals(this.sfCreate(true, 7L, 6L, 5L, 4L, 3L, 2L, 1L), 7L, 6L, 5L, 4L, 3L);
        this.compactEquals(new ArrayList<StoreFile>(), new long[0]);
        this.compactEquals(this.sfCreate(tooBig, tooBig), new long[0]);
    }

    public void testOffPeakCompactionRatio() throws IOException {
        this.conf.setFloat("hbase.hstore.compaction.ratio.offpeak", 5.0f);
        this.store.storeEngine.getCompactionPolicy().setConf(this.conf);
        this.compactEquals(this.sfCreate(999L, 50L, 12L, 12L, 1L), false, true, 50L, 12L, 12L, 1L);
        this.compactEquals(this.sfCreate(999L, 50L, 12L, 12L, 1L), 12L, 12L, 1L);
    }

    public void testStuckStoreCompaction() throws IOException {
        this.compactEquals(this.sfCreate(99L, 99L, 99L, 99L, 99L, 99L, 30L, 30L, 30L, 30L), 30L, 30L, 30L);
        this.compactEquals(this.sfCreate(99L, 99L, 99L, 99L, 99L, 30L, 30L, 30L, 30L), 99L, 30L, 30L, 30L, 30L);
        this.compactEquals(this.sfCreate(99L, 99L, 99L, 99L, 99L, 99L, 30L, 30L, 30L, 15L), 30L, 30L, 30L, 15L);
        this.compactEquals(this.sfCreate(99L, 99L, 99L, 99L, 30L, 26L, 26L, 29L, 25L, 25L), 30L, 26L, 26L);
        this.compactEquals(this.sfCreate(99L, 99L, 99L, 99L, 27L, 27L, 27L, 20L, 20L, 20L), 20L, 20L, 20L);
    }

    public void testCompactionEmptyHFile() throws IOException {
        ScanInfo oldScanInfo = this.store.getScanInfo();
        ScanInfo newScanInfo = new ScanInfo(oldScanInfo.getFamily(), oldScanInfo.getMinVersions(), oldScanInfo.getMaxVersions(), 600L, oldScanInfo.getKeepDeletedCells(), oldScanInfo.getTimeToPurgeDeletes(), oldScanInfo.getComparator());
        this.store.setScanInfo(newScanInfo);
        List<StoreFile> candidates = this.sfCreate(0L);
        for (StoreFile file : candidates) {
            if (!(file instanceof MockStoreFile)) continue;
            MockStoreFile mockFile = (MockStoreFile)file;
            mockFile.setTimeRangeTracker(new TimeRangeTracker(-1L, -1L));
            mockFile.setEntries(0L);
        }
        CompactionRequest result = ((RatioBasedCompactionPolicy)this.store.storeEngine.getCompactionPolicy()).selectCompaction(candidates, new ArrayList(), false, false, false);
        TestDefaultCompactSelection.assertTrue((result.getFiles().size() == 0 ? 1 : 0) != 0);
        this.store.setScanInfo(oldScanInfo);
    }
}

