/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.procedure.Procedure;
import org.apache.hadoop.hbase.procedure.ProcedureCoordinator;
import org.apache.hadoop.hbase.procedure.ProcedureMember;
import org.apache.hadoop.hbase.procedure.Subprocedure;
import org.apache.hadoop.hbase.procedure.ZKProcedureCoordinatorRpcs;
import org.apache.hadoop.hbase.procedure.ZKProcedureMemberRpcs;
import org.apache.hadoop.hbase.procedure.ZKProcedureUtil;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@Category(value={MediumTests.class})
public class TestZKProcedureControllers {
    static final Log LOG = LogFactory.getLog(TestZKProcedureControllers.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final String COHORT_NODE_NAME = "expected";
    private static final String CONTROLLER_NODE_NAME = "controller";
    private static final VerificationMode once = Mockito.times((int)1);
    private final StartControllers startCoordinatorFirst = new StartControllers(){

        @Override
        public Pair<ZKProcedureCoordinatorRpcs, List<ZKProcedureMemberRpcs>> start(ZooKeeperWatcher watcher, String operationName, ProcedureCoordinator coordinator, String controllerName, ProcedureMember member, List<String> expected) throws Exception {
            ZKProcedureCoordinatorRpcs controller = new ZKProcedureCoordinatorRpcs(watcher, operationName, TestZKProcedureControllers.CONTROLLER_NODE_NAME);
            controller.start(coordinator);
            ArrayList<ZKProcedureMemberRpcs> cohortControllers = new ArrayList<ZKProcedureMemberRpcs>();
            for (String nodeName : expected) {
                ZKProcedureMemberRpcs cc = new ZKProcedureMemberRpcs(watcher, operationName);
                cc.start(nodeName, member);
                cohortControllers.add(cc);
            }
            return new Pair((Object)controller, cohortControllers);
        }
    };
    private final StartControllers startCohortFirst = new StartControllers(){

        @Override
        public Pair<ZKProcedureCoordinatorRpcs, List<ZKProcedureMemberRpcs>> start(ZooKeeperWatcher watcher, String operationName, ProcedureCoordinator coordinator, String controllerName, ProcedureMember member, List<String> expected) throws Exception {
            ArrayList<ZKProcedureMemberRpcs> cohortControllers = new ArrayList<ZKProcedureMemberRpcs>();
            for (String nodeName : expected) {
                ZKProcedureMemberRpcs cc = new ZKProcedureMemberRpcs(watcher, operationName);
                cc.start(nodeName, member);
                cohortControllers.add(cc);
            }
            ZKProcedureCoordinatorRpcs controller = new ZKProcedureCoordinatorRpcs(watcher, operationName, TestZKProcedureControllers.CONTROLLER_NODE_NAME);
            controller.start(coordinator);
            return new Pair((Object)controller, cohortControllers);
        }
    };

    @BeforeClass
    public static void setupTest() throws Exception {
        UTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        UTIL.shutdownMiniZKCluster();
    }

    @Test(timeout=60000L)
    public void testSimpleZKCohortMemberController() throws Exception {
        ZooKeeperWatcher watcher = UTIL.getZooKeeperWatcher();
        String operationName = "instanceTest";
        final Subprocedure sub = (Subprocedure)Mockito.mock(Subprocedure.class);
        Mockito.when((Object)sub.getName()).thenReturn((Object)"instanceTest");
        byte[] data = new byte[]{1, 2, 3};
        final CountDownLatch prepared = new CountDownLatch(1);
        final CountDownLatch committed = new CountDownLatch(1);
        ForeignExceptionDispatcher monitor = (ForeignExceptionDispatcher)Mockito.spy((Object)new ForeignExceptionDispatcher());
        final ZKProcedureMemberRpcs controller = new ZKProcedureMemberRpcs(watcher, "testSimple");
        ProcedureMember member = (ProcedureMember)Mockito.mock(ProcedureMember.class);
        ((ProcedureMember)Mockito.doReturn((Object)sub).when((Object)member)).createSubprocedure("instanceTest", data);
        ((ProcedureMember)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                controller.sendMemberAcquired(sub);
                prepared.countDown();
                return null;
            }
        }).when((Object)member)).submitSubprocedure(sub);
        ((ProcedureMember)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                controller.sendMemberCompleted(sub);
                committed.countDown();
                return null;
            }
        }).when((Object)member)).receivedReachedGlobalBarrier("instanceTest");
        controller.start(COHORT_NODE_NAME, member);
        String prepare = ZKProcedureUtil.getAcquireBarrierNode((ZKProcedureUtil)controller.getZkController(), (String)"instanceTest");
        ZKUtil.createSetData((ZooKeeperWatcher)watcher, (String)prepare, (byte[])ProtobufUtil.prependPBMagic((byte[])data));
        prepared.await();
        String commit = ZKProcedureUtil.getReachedBarrierNode((ZKProcedureUtil)controller.getZkController(), (String)"instanceTest");
        LOG.debug((Object)("Found prepared, posting commit node:" + commit));
        ZKUtil.createAndFailSilent((ZooKeeperWatcher)watcher, (String)commit);
        LOG.debug((Object)("Commit node:" + commit + ", exists:" + ZKUtil.checkExists((ZooKeeperWatcher)watcher, (String)commit)));
        committed.await();
        ((ForeignExceptionDispatcher)Mockito.verify((Object)monitor, (VerificationMode)Mockito.never())).receive((ForeignException)((Object)Mockito.any(ForeignException.class)));
        ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)watcher, (String)controller.getZkController().getBaseZnode());
        Assert.assertEquals((String)"Didn't delete prepare node", (long)-1L, (long)ZKUtil.checkExists((ZooKeeperWatcher)watcher, (String)prepare));
        Assert.assertEquals((String)"Didn't delete commit node", (long)-1L, (long)ZKUtil.checkExists((ZooKeeperWatcher)watcher, (String)commit));
    }

    @Test(timeout=60000L)
    public void testZKCoordinatorControllerWithNoCohort() throws Exception {
        String operationName = "no cohort controller test";
        byte[] data = new byte[]{1, 2, 3};
        this.runMockCommitWithOrchestratedControllers(this.startCoordinatorFirst, "no cohort controller test", data, new String[0]);
        this.runMockCommitWithOrchestratedControllers(this.startCohortFirst, "no cohort controller test", data, new String[0]);
    }

    @Test(timeout=60000L)
    public void testZKCoordinatorControllerWithSingleMemberCohort() throws Exception {
        String operationName = "single member controller test";
        byte[] data = new byte[]{1, 2, 3};
        this.runMockCommitWithOrchestratedControllers(this.startCoordinatorFirst, "single member controller test", data, "cohort");
        this.runMockCommitWithOrchestratedControllers(this.startCohortFirst, "single member controller test", data, "cohort");
    }

    @Test(timeout=60000L)
    public void testZKCoordinatorControllerMultipleCohort() throws Exception {
        String operationName = "multi member controller test";
        byte[] data = new byte[]{1, 2, 3};
        this.runMockCommitWithOrchestratedControllers(this.startCoordinatorFirst, "multi member controller test", data, "cohort", "cohort2", "cohort3");
        this.runMockCommitWithOrchestratedControllers(this.startCohortFirst, "multi member controller test", data, "cohort", "cohort2", "cohort3");
    }

    private void runMockCommitWithOrchestratedControllers(StartControllers controllers, String operationName, byte[] data, String ... cohort) throws Exception {
        ZooKeeperWatcher watcher = UTIL.getZooKeeperWatcher();
        ArrayList expected = Lists.newArrayList((Object[])cohort);
        Subprocedure sub = (Subprocedure)Mockito.mock(Subprocedure.class);
        Mockito.when((Object)sub.getName()).thenReturn((Object)operationName);
        CountDownLatch prepared = new CountDownLatch(expected.size());
        CountDownLatch committed = new CountDownLatch(expected.size());
        ProcedureCoordinator coordinator = this.setupMockCoordinator(operationName, prepared, committed);
        ProcedureMember member = (ProcedureMember)Mockito.mock(ProcedureMember.class);
        Pair<ZKProcedureCoordinatorRpcs, List<ZKProcedureMemberRpcs>> pair = controllers.start(watcher, operationName, coordinator, CONTROLLER_NODE_NAME, member, expected);
        ZKProcedureCoordinatorRpcs controller = (ZKProcedureCoordinatorRpcs)pair.getFirst();
        List cohortControllers = (List)pair.getSecond();
        Procedure p = (Procedure)Mockito.mock(Procedure.class);
        Mockito.when((Object)p.getName()).thenReturn((Object)operationName);
        controller.sendGlobalBarrierAcquire(p, data, (List)expected);
        for (ZKProcedureMemberRpcs cc : cohortControllers) {
            cc.sendMemberAcquired(sub);
        }
        prepared.await();
        ((ProcedureCoordinator)Mockito.verify((Object)coordinator, (VerificationMode)Mockito.times((int)expected.size()))).memberAcquiredBarrier((String)Mockito.eq((Object)operationName), Mockito.anyString());
        controller.sendGlobalBarrierReached(p, (List)expected);
        for (ZKProcedureMemberRpcs cc : cohortControllers) {
            cc.sendMemberCompleted(sub);
        }
        committed.await();
        ((ProcedureCoordinator)Mockito.verify((Object)coordinator, (VerificationMode)Mockito.times((int)expected.size()))).memberFinishedBarrier((String)Mockito.eq((Object)operationName), Mockito.anyString());
        controller.resetMembers(p);
        this.verifyZooKeeperClean(operationName, watcher, controller.getZkProcedureUtil());
        this.verifyCohort(member, cohortControllers.size(), operationName, data);
        this.verifyCoordinator(operationName, coordinator, expected);
    }

    public void runEarlyPrepareNodes(StartControllers controllers, String operationName, byte[] data, String ... cohort) throws Exception {
        ZooKeeperWatcher watcher = UTIL.getZooKeeperWatcher();
        ArrayList expected = Lists.newArrayList((Object[])cohort);
        Subprocedure sub = (Subprocedure)Mockito.mock(Subprocedure.class);
        Mockito.when((Object)sub.getName()).thenReturn((Object)operationName);
        CountDownLatch prepared = new CountDownLatch(expected.size());
        CountDownLatch committed = new CountDownLatch(expected.size());
        ProcedureCoordinator coordinator = this.setupMockCoordinator(operationName, prepared, committed);
        ProcedureMember member = (ProcedureMember)Mockito.mock(ProcedureMember.class);
        Procedure p = (Procedure)Mockito.mock(Procedure.class);
        Mockito.when((Object)p.getName()).thenReturn((Object)operationName);
        Pair<ZKProcedureCoordinatorRpcs, List<ZKProcedureMemberRpcs>> pair = controllers.start(watcher, operationName, coordinator, CONTROLLER_NODE_NAME, member, expected);
        ZKProcedureCoordinatorRpcs controller = (ZKProcedureCoordinatorRpcs)pair.getFirst();
        List cohortControllers = (List)pair.getSecond();
        for (int i = 0; i < cohortControllers.size() / 2; ++i) {
            ((ZKProcedureMemberRpcs)cohortControllers.get(i)).sendMemberAcquired(sub);
        }
        controller.sendGlobalBarrierAcquire(p, data, (List)expected);
        for (ZKProcedureMemberRpcs cc : cohortControllers) {
            cc.sendMemberAcquired(sub);
        }
        prepared.await();
        ((ProcedureCoordinator)Mockito.verify((Object)coordinator, (VerificationMode)Mockito.times((int)expected.size()))).memberAcquiredBarrier((String)Mockito.eq((Object)operationName), Mockito.anyString());
        controller.sendGlobalBarrierReached(p, (List)expected);
        for (ZKProcedureMemberRpcs cc : cohortControllers) {
            cc.sendMemberCompleted(sub);
        }
        committed.await();
        ((ProcedureCoordinator)Mockito.verify((Object)coordinator, (VerificationMode)Mockito.times((int)expected.size()))).memberFinishedBarrier((String)Mockito.eq((Object)operationName), Mockito.anyString());
        controller.resetMembers(p);
        this.verifyZooKeeperClean(operationName, watcher, controller.getZkProcedureUtil());
        this.verifyCohort(member, cohortControllers.size(), operationName, data);
        this.verifyCoordinator(operationName, coordinator, expected);
    }

    private ProcedureCoordinator setupMockCoordinator(String operationName, final CountDownLatch prepared, final CountDownLatch committed) {
        ProcedureCoordinator coordinator = (ProcedureCoordinator)Mockito.mock(ProcedureCoordinator.class);
        Mockito.mock(ProcedureCoordinator.class);
        ((ProcedureCoordinator)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                prepared.countDown();
                return null;
            }
        }).when((Object)coordinator)).memberAcquiredBarrier((String)Mockito.eq((Object)operationName), Mockito.anyString());
        ((ProcedureCoordinator)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                committed.countDown();
                return null;
            }
        }).when((Object)coordinator)).memberFinishedBarrier((String)Mockito.eq((Object)operationName), Mockito.anyString());
        return coordinator;
    }

    private void verifyZooKeeperClean(String operationName, ZooKeeperWatcher watcher, ZKProcedureUtil controller) throws Exception {
        String prepare = ZKProcedureUtil.getAcquireBarrierNode((ZKProcedureUtil)controller, (String)operationName);
        String commit = ZKProcedureUtil.getReachedBarrierNode((ZKProcedureUtil)controller, (String)operationName);
        String abort = ZKProcedureUtil.getAbortNode((ZKProcedureUtil)controller, (String)operationName);
        Assert.assertEquals((String)"Didn't delete prepare node", (long)-1L, (long)ZKUtil.checkExists((ZooKeeperWatcher)watcher, (String)prepare));
        Assert.assertEquals((String)"Didn't delete commit node", (long)-1L, (long)ZKUtil.checkExists((ZooKeeperWatcher)watcher, (String)commit));
        Assert.assertEquals((String)"Didn't delete abort node", (long)-1L, (long)ZKUtil.checkExists((ZooKeeperWatcher)watcher, (String)abort));
    }

    private void verifyCohort(ProcedureMember member, int cohortSize, String operationName, byte[] data) {
        ((ProcedureMember)Mockito.verify((Object)member, (VerificationMode)Mockito.times((int)cohortSize))).submitSubprocedure((Subprocedure)Mockito.any(Subprocedure.class));
    }

    private void verifyCoordinator(String operationName, ProcedureCoordinator coordinator, List<String> expected) {
        for (String node : expected) {
            ((ProcedureCoordinator)Mockito.verify((Object)coordinator, (VerificationMode)once)).memberAcquiredBarrier(operationName, node);
            ((ProcedureCoordinator)Mockito.verify((Object)coordinator, (VerificationMode)once)).memberFinishedBarrier(operationName, node);
        }
    }

    private abstract class StartControllers {
        private StartControllers() {
        }

        public abstract Pair<ZKProcedureCoordinatorRpcs, List<ZKProcedureMemberRpcs>> start(ZooKeeperWatcher var1, String var2, ProcedureCoordinator var3, String var4, ProcedureMember var5, List<String> var6) throws Exception;
    }
}

