/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketAllocator;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketAllocatorException;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hadoop.hbase.io.hfile.bucket.CacheFullException;
import org.apache.hadoop.hbase.io.hfile.bucket.IOEngine;
import org.apache.hadoop.hbase.io.hfile.bucket.UniqueIndexMap;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestBucketWriterThread {
    private BucketCache bc;
    private BucketCache.WriterThread wt;
    private BlockingQueue<BucketCache.RAMQueueEntry> q;
    private Cacheable plainCacheable;
    private BlockCacheKey plainKey;

    @Before
    public void setUp() throws Exception {
        int capacity = 16;
        boolean writerThreadsCount = true;
        this.bc = new BucketCache("heap", 16L, 1, new int[]{1}, 1, 16, null, 100);
        Assert.assertEquals((long)1L, (long)this.bc.writerThreads.length);
        Assert.assertEquals((long)1L, (long)this.bc.writerQueues.size());
        this.wt = this.bc.writerThreads[0];
        this.q = (BlockingQueue)this.bc.writerQueues.get(0);
        this.wt.disableWriter();
        this.plainKey = new BlockCacheKey("f", 0L);
        this.plainCacheable = (Cacheable)Mockito.mock(Cacheable.class);
        this.bc.cacheBlock(this.plainKey, this.plainCacheable);
        while (!this.bc.ramCache.isEmpty()) {
            Threads.sleep((long)1L);
        }
        Assert.assertTrue((boolean)this.q.isEmpty());
    }

    @After
    public void tearDown() throws Exception {
        if (this.bc != null) {
            this.bc.shutdown();
        }
    }

    @Test(timeout=30000L)
    public void testNonErrorCase() throws FileNotFoundException, IOException, InterruptedException {
        this.bc.cacheBlock(this.plainKey, this.plainCacheable);
        TestBucketWriterThread.doDrainOfOneEntry(this.bc, this.wt, this.q);
    }

    @Test
    public void testTooBigEntry() throws InterruptedException {
        Cacheable tooBigCacheable = (Cacheable)Mockito.mock(Cacheable.class);
        Mockito.when((Object)tooBigCacheable.getSerializedLength()).thenReturn((Object)Integer.MAX_VALUE);
        this.bc.cacheBlock(this.plainKey, tooBigCacheable);
        TestBucketWriterThread.doDrainOfOneEntry(this.bc, this.wt, this.q);
    }

    @Test(timeout=30000L)
    public void testIOE() throws CacheFullException, BucketAllocatorException, IOException, InterruptedException {
        this.bc.cacheBlock(this.plainKey, this.plainCacheable);
        BucketCache.RAMQueueEntry rqe = (BucketCache.RAMQueueEntry)this.q.remove();
        BucketCache.RAMQueueEntry spiedRqe = (BucketCache.RAMQueueEntry)Mockito.spy((Object)rqe);
        ((BucketCache.RAMQueueEntry)Mockito.doThrow((Throwable)new IOException("Mocked!")).when((Object)spiedRqe)).writeToCache((IOEngine)Mockito.any(), (BucketAllocator)Mockito.any(), (UniqueIndexMap)Mockito.any(), (AtomicLong)Mockito.any());
        this.q.add(spiedRqe);
        TestBucketWriterThread.doDrainOfOneEntry(this.bc, this.wt, this.q);
        Assert.assertTrue((!this.bc.isCacheEnabled() ? 1 : 0) != 0);
    }

    @Test(timeout=30000L)
    public void testCacheFullException() throws CacheFullException, BucketAllocatorException, IOException, InterruptedException {
        this.bc.cacheBlock(this.plainKey, this.plainCacheable);
        BucketCache.RAMQueueEntry rqe = (BucketCache.RAMQueueEntry)this.q.remove();
        BucketCache.RAMQueueEntry spiedRqe = (BucketCache.RAMQueueEntry)Mockito.spy((Object)rqe);
        CacheFullException cfe = new CacheFullException(0, 0);
        BucketCache.BucketEntry mockedBucketEntry = (BucketCache.BucketEntry)Mockito.mock(BucketCache.BucketEntry.class);
        ((BucketCache.RAMQueueEntry)Mockito.doThrow((Throwable)cfe).doReturn((Object)mockedBucketEntry).when((Object)spiedRqe)).writeToCache((IOEngine)Mockito.any(), (BucketAllocator)Mockito.any(), (UniqueIndexMap)Mockito.any(), (AtomicLong)Mockito.any());
        this.q.add(spiedRqe);
        TestBucketWriterThread.doDrainOfOneEntry(this.bc, this.wt, this.q);
    }

    private static void doDrainOfOneEntry(BucketCache bc, BucketCache.WriterThread wt, BlockingQueue<BucketCache.RAMQueueEntry> q) throws InterruptedException {
        List rqes = BucketCache.getRAMQueueEntries(q, new ArrayList(1));
        wt.doDrain(rqes);
        Assert.assertTrue((boolean)q.isEmpty());
        Assert.assertTrue((boolean)bc.ramCache.isEmpty());
        Assert.assertEquals((long)0L, (long)bc.heapSize());
    }
}

