// Autogenerated Jamon implementation
// /home/apurtell/src/hbase/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/regionserver/ServerMetricsTmpl.jamon

package org.apache.hadoop.hbase.tmpl.regionserver;

// 24, 1
import java.util.*;
// 25, 1
import org.apache.hadoop.hbase.regionserver.HRegionServer;
// 26, 1
import org.apache.hadoop.hbase.ipc.MetricsHBaseServerWrapper;
// 27, 1
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
// 28, 1
import org.apache.hadoop.hbase.util.Bytes;
// 29, 1
import org.apache.hadoop.hbase.HRegionInfo;
// 30, 1
import org.apache.hadoop.hbase.ServerName;
// 31, 1
import org.apache.hadoop.hbase.HBaseConfiguration;
// 32, 1
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
// 33, 1
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos.ServerInfo;
// 34, 1
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos.RegionLoad;
// 35, 1
import org.apache.hadoop.hbase.metrics.histogram.MetricsHistogram;
// 36, 1
import org.apache.hadoop.hbase.util.DirectMemoryUtils;
// 37, 1
import org.apache.hadoop.util.StringUtils;
// 38, 1
import com.yammer.metrics.stats.Snapshot;
// 39, 1
import java.lang.management.ManagementFactory;

public class ServerMetricsTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.regionserver.ServerMetricsTmpl.Intf

{
  private final MetricsRegionServerWrapper mWrap;
  private final MetricsHBaseServerWrapper mServerWrap;
  protected static org.apache.hadoop.hbase.tmpl.regionserver.ServerMetricsTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.regionserver.ServerMetricsTmpl.ImplData p_implData)
  {
    return p_implData;
  }
  public ServerMetricsTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.regionserver.ServerMetricsTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    mWrap = p_implData.getMWrap();
    mServerWrap = p_implData.getMServerWrap();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 41, 1
    jamonWriter.write("<div class=\"tabbable\">\n    <ul class=\"nav nav-pills\">\n        <li class=\"active\"><a href=\"#tab_baseStats\" data-toggle=\"tab\">Base Stats</a></li>\n        <li class=\"\"><a href=\"#tab_memoryStats\" data-toggle=\"tab\">Memory</a></li>\n        <li class=\"\"><a href=\"#tab_requestStats\" data-toggle=\"tab\">Requests</a></li>\n        <li class=\"\"><a href=\"#tab_hlogStats\" data-toggle=\"tab\">hlogs</a></li>\n        <li class=\"\"><a href=\"#tab_storeStats\" data-toggle=\"tab\">Storefiles</a></li>\n        <li class=\"\"><a href=\"#tab_queueStats\" data-toggle=\"tab\">Queues</a></li>\n    </ul>\n    <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n        <div class=\"tab-pane active\" id=\"tab_baseStats\">\n            ");
    // 52, 13
    {
      // 52, 13
      __jamon_innerUnit__baseStats(jamonWriter, mWrap );
    }
    // 52, 43
    jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_memoryStats\">\n            ");
    // 55, 13
    {
      // 55, 13
      __jamon_innerUnit__memoryStats(jamonWriter, mWrap );
    }
    // 55, 45
    jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_requestStats\">\n            ");
    // 58, 13
    {
      // 58, 13
      __jamon_innerUnit__requestStats(jamonWriter, mWrap );
    }
    // 58, 46
    jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_hlogStats\">\n            ");
    // 61, 13
    {
      // 61, 13
      __jamon_innerUnit__hlogStats(jamonWriter, mWrap );
    }
    // 61, 43
    jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_storeStats\">\n            ");
    // 64, 13
    {
      // 64, 13
      __jamon_innerUnit__storeStats(jamonWriter, mWrap );
    }
    // 64, 44
    jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_queueStats\">\n            ");
    // 67, 13
    {
      // 67, 13
      __jamon_innerUnit__queueStats(jamonWriter, mWrap, mServerWrap);
    }
    // 67, 72
    jamonWriter.write("\n        </div>\n    </div>\n</div>\n\n");
  }
  
  
  // 167, 1
  private void __jamon_innerUnit__requestStats(final java.io.Writer jamonWriter, final MetricsRegionServerWrapper mWrap)
    throws java.io.IOException
  {
    // 171, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>Request Per Second</th>\n    <th>Read Request Count</th>\n    <th>Write Request Count</th>\n</tr>\n<tr>\n    <td>");
    // 178, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.0f", mWrap.getRequestsPerSecond())), jamonWriter);
    // 178, 66
    jamonWriter.write("</td>\n    <td>");
    // 179, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(mWrap.getReadRequestsCount()), jamonWriter);
    // 179, 43
    jamonWriter.write("</td>\n    <td>");
    // 180, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(mWrap.getWriteRequestsCount()), jamonWriter);
    // 180, 44
    jamonWriter.write("</td>\n</tr>\n</table>\n");
  }
  
  
  // 185, 1
  private void __jamon_innerUnit__queueStats(final java.io.Writer jamonWriter, final MetricsRegionServerWrapper mWrap, final MetricsHBaseServerWrapper mServerWrap)
    throws java.io.IOException
  {
    // 190, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>Compaction Queue Size</th>\n    <th>Flush Queue Size</th>\n    <th>Call Queue Size (bytes)</th>\n\n</tr>\n<tr>\n    <td>");
    // 198, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(mWrap.getCompactionQueueSize()), jamonWriter);
    // 198, 45
    jamonWriter.write("</td>\n    <td>");
    // 199, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(mWrap.getFlushQueueSize()), jamonWriter);
    // 199, 40
    jamonWriter.write("</td>\n    <td>");
    // 200, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(StringUtils.humanReadableInt(mServerWrap.getTotalQueueSize())), jamonWriter);
    // 200, 76
    jamonWriter.write("</td>\n</tr>\n</table>\n");
  }
  
  
  // 125, 1
  private void __jamon_innerUnit__hlogStats(final java.io.Writer jamonWriter, final MetricsRegionServerWrapper mWrap)
    throws java.io.IOException
  {
    // 129, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <tr>\n        <th>Num. HLog Files</th>\n        <th>Size. HLog Files (bytes)</th>\n    </tr>\n</tr>\n<tr>\n    <td>");
    // 137, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(mWrap.getNumHLogFiles()), jamonWriter);
    // 137, 38
    jamonWriter.write("</td>\n    <td>");
    // 138, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(mWrap.getHLogFileSize()), jamonWriter);
    // 138, 38
    jamonWriter.write("</td>\n</tr>\n</table>\n");
  }
  
  
  // 93, 1
  private void __jamon_innerUnit__memoryStats(final java.io.Writer jamonWriter, final MetricsRegionServerWrapper mWrap)
    throws java.io.IOException
  {
    // 97, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <tr>\n        <th>Used Heap</th>\n        <th>Max Heap</th>\n        <th>Direct Memory Used</th>\n        <th>Direct Memory Configured</th>\n        <th>Memstore Size</th>\n    </tr>\n</tr>\n<tr>\n    <td>\n        ");
    // 109, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(StringUtils.humanReadableInt(ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed())), jamonWriter);
    // 109, 111
    jamonWriter.write("\n    </td>\n    <td>\n        ");
    // 112, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(StringUtils.humanReadableInt(ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax())), jamonWriter);
    // 112, 110
    jamonWriter.write("\n    </td>\n    <td>\n        ");
    // 115, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(StringUtils.humanReadableInt(DirectMemoryUtils.getDirectMemoryUsage())), jamonWriter);
    // 115, 85
    jamonWriter.write("\n    </td>\n    <td>\n        ");
    // 118, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(StringUtils.humanReadableInt(DirectMemoryUtils.getDirectMemorySize())), jamonWriter);
    // 118, 84
    jamonWriter.write("\n    </td>\n    <td>");
    // 120, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(StringUtils.humanReadableInt(mWrap.getMemstoreSize())), jamonWriter);
    // 120, 68
    jamonWriter.write("</td>\n</tr>\n</table>\n");
  }
  
  
  // 72, 1
  private void __jamon_innerUnit__baseStats(final java.io.Writer jamonWriter, final MetricsRegionServerWrapper mWrap)
    throws java.io.IOException
  {
    // 76, 1
    jamonWriter.write("<table class=\"table table-striped\">\n    <tr>\n\n        <th>Requests Per Second</th>\n        <th>Num. Regions</th>\n        <th>Block locality</th>\n        <th>Slow HLog Append Count</th>\n    </tr>\n    <tr>\n        <td>");
    // 85, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.0f", mWrap.getRequestsPerSecond())), jamonWriter);
    // 85, 70
    jamonWriter.write("</td>\n        <td>");
    // 86, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(mWrap.getNumOnlineRegions()), jamonWriter);
    // 86, 46
    jamonWriter.write("</td>\n        <td>");
    // 87, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(mWrap.getPercentFileLocal()), jamonWriter);
    // 87, 46
    jamonWriter.write("</td>\n        <td>");
    // 88, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(0), jamonWriter);
    // 88, 20
    jamonWriter.write("</td>\n    </tr>\n</table>\n");
  }
  
  
  // 143, 1
  private void __jamon_innerUnit__storeStats(final java.io.Writer jamonWriter, final MetricsRegionServerWrapper mWrap)
    throws java.io.IOException
  {
    // 147, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n\n    <th>Num. Stores</th>\n    <th>Num. Storefiles</th>\n    <th>Root Index Size (bytes)</th>\n    <th>Index Size (bytes)</th>\n    <th>Bloom Size (bytes)</th>\n</tr>\n<tr>\n    <td>");
    // 157, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(StringUtils.humanReadableInt(mWrap.getNumStores())), jamonWriter);
    // 157, 65
    jamonWriter.write("</td>\n    <td>");
    // 158, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(StringUtils.humanReadableInt(mWrap.getNumStoreFiles())), jamonWriter);
    // 158, 69
    jamonWriter.write("</td>\n    <td>");
    // 159, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(StringUtils.humanReadableInt(mWrap.getStoreFileIndexSize())), jamonWriter);
    // 159, 74
    jamonWriter.write("</td>\n    <td>");
    // 160, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(StringUtils.humanReadableInt(mWrap.getTotalStaticIndexSize())), jamonWriter);
    // 160, 76
    jamonWriter.write("</td>\n    <td>");
    // 161, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(StringUtils.humanReadableInt(mWrap.getTotalStaticBloomSize())), jamonWriter);
    // 161, 76
    jamonWriter.write("</td>\n</tr>\n</table>\n");
  }
  
  
}
