/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.util.SortedCopyOnWriteSet;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestSortedCopyOnWriteSet {
    @Test
    public void testSorting() throws Exception {
        SortedCopyOnWriteSet set = new SortedCopyOnWriteSet();
        set.add((Object)"c");
        set.add((Object)"d");
        set.add((Object)"a");
        set.add((Object)"b");
        Object[] expected = new String[]{"a", "b", "c", "d"};
        Object[] stored = (String[])set.toArray((Object[])new String[4]);
        Assert.assertArrayEquals((Object[])expected, (Object[])stored);
        set.add((Object)"c");
        Assert.assertEquals((long)4L, (long)set.size());
        stored = (String[])set.toArray((Object[])new String[4]);
        Assert.assertArrayEquals((Object[])expected, (Object[])stored);
    }

    @Test
    public void testIteratorIsolation() throws Exception {
        String next;
        SortedCopyOnWriteSet set = new SortedCopyOnWriteSet((Collection)Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d", "e"}));
        Iterator iter = set.iterator();
        set.remove((Object)"c");
        boolean found = false;
        while (iter.hasNext() && !found) {
            found = "c".equals(iter.next());
        }
        Assert.assertTrue((boolean)found);
        iter = set.iterator();
        found = false;
        while (iter.hasNext() && !found) {
            found = "c".equals(iter.next());
        }
        Assert.assertFalse((boolean)found);
        iter = set.iterator();
        set.add((Object)"f");
        found = false;
        while (iter.hasNext() && !found) {
            next = (String)iter.next();
            found = "f".equals(next);
        }
        Assert.assertFalse((boolean)found);
        iter = set.iterator();
        set.addAll((Collection)Lists.newArrayList((Object[])new String[]{"g", "h", "i"}));
        found = false;
        while (iter.hasNext() && !found) {
            next = (String)iter.next();
            found = "g".equals(next) || "h".equals(next) || "i".equals(next);
        }
        Assert.assertFalse((boolean)found);
        iter = set.iterator();
        set.clear();
        Assert.assertEquals((long)0L, (long)set.size());
        int size = 0;
        while (iter.hasNext()) {
            iter.next();
            ++size;
        }
        Assert.assertTrue((size > 0 ? 1 : 0) != 0);
    }
}

