/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotHelper;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestRestoreSnapshotHelper {
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final String TEST_FAMILY = "cf";
    private static final String TEST_HFILE = "abc";
    private Configuration conf;
    private Path archiveDir;
    private FileSystem fs;
    private Path rootDir;

    @Before
    public void setup() throws Exception {
        this.rootDir = TEST_UTIL.getDataTestDir("testRestore");
        this.archiveDir = new Path(this.rootDir, "archive");
        this.fs = TEST_UTIL.getTestFileSystem();
        this.conf = TEST_UTIL.getConfiguration();
        FSUtils.setRootDir((Configuration)this.conf, (Path)this.rootDir);
    }

    @After
    public void tearDown() throws Exception {
        this.fs.delete(TEST_UTIL.getDataTestDir(), true);
    }

    @Test
    public void testRestore() throws IOException {
        HTableDescriptor htd = this.createTableDescriptor("testtb");
        Path snapshotDir = new Path(this.rootDir, "snapshot");
        this.createSnapshot(this.rootDir, snapshotDir, htd);
        HTableDescriptor htdClone = this.createTableDescriptor("testtb-clone");
        this.testRestore(snapshotDir, htd.getTableName().getNameAsString(), htdClone);
        this.verifyRestore(this.rootDir, htd, htdClone);
        Path cloneDir = FSUtils.getTableDir((Path)this.rootDir, (TableName)htdClone.getTableName());
        HTableDescriptor htdClone2 = this.createTableDescriptor("testtb-clone2");
        this.testRestore(cloneDir, htdClone.getTableName().getNameAsString(), htdClone2);
        this.verifyRestore(this.rootDir, htd, htdClone2);
    }

    private void verifyRestore(Path rootDir, HTableDescriptor sourceHtd, HTableDescriptor htdClone) throws IOException {
        String[] files = this.getHFiles(FSUtils.getTableDir((Path)rootDir, (TableName)htdClone.getTableName()));
        Assert.assertEquals((long)2L, (long)files.length);
        Assert.assertTrue((String)(files[0] + " should be a HFileLink"), (boolean)HFileLink.isHFileLink((String)files[0]));
        Assert.assertTrue((String)(files[1] + " should be a Referene"), (boolean)StoreFileInfo.isReference((String)files[1]));
        Assert.assertEquals((Object)sourceHtd.getTableName(), (Object)HFileLink.getReferencedTableName((String)files[0]));
        Assert.assertEquals((Object)TEST_HFILE, (Object)HFileLink.getReferencedHFileName((String)files[0]));
        Path refPath = this.getReferredToFile(files[1]);
        Assert.assertTrue((String)(refPath.getName() + " should be a HFileLink"), (boolean)HFileLink.isHFileLink((String)refPath.getName()));
        Assert.assertEquals((Object)files[0], (Object)refPath.getName());
    }

    public void testRestore(Path snapshotDir, String sourceTableName, HTableDescriptor htdClone) throws IOException {
        this.LOG.debug((Object)("pre-restore table=" + htdClone.getTableName() + " snapshot=" + snapshotDir));
        FSUtils.logFileSystemState((FileSystem)this.fs, (Path)this.rootDir, (Log)this.LOG);
        new FSTableDescriptors(this.conf).createTableDescriptor(htdClone);
        RestoreSnapshotHelper helper = this.getRestoreHelper(this.rootDir, snapshotDir, sourceTableName, htdClone);
        helper.restoreHdfsRegions();
        this.LOG.debug((Object)("post-restore table=" + htdClone.getTableName() + " snapshot=" + snapshotDir));
        FSUtils.logFileSystemState((FileSystem)this.fs, (Path)this.rootDir, (Log)this.LOG);
    }

    private RestoreSnapshotHelper getRestoreHelper(Path rootDir, Path snapshotDir, String sourceTableName, HTableDescriptor htdClone) throws IOException {
        CatalogTracker catalogTracker = (CatalogTracker)Mockito.mock(CatalogTracker.class);
        HTableDescriptor tableDescriptor = (HTableDescriptor)Mockito.mock(HTableDescriptor.class);
        ForeignExceptionDispatcher monitor = (ForeignExceptionDispatcher)Mockito.mock(ForeignExceptionDispatcher.class);
        MonitoredTask status = (MonitoredTask)Mockito.mock(MonitoredTask.class);
        HBaseProtos.SnapshotDescription sd = HBaseProtos.SnapshotDescription.newBuilder().setName("snapshot").setTable(sourceTableName).build();
        return new RestoreSnapshotHelper(this.conf, this.fs, sd, snapshotDir, htdClone, rootDir, monitor, status);
    }

    private void createSnapshot(Path rootDir, Path snapshotDir, HTableDescriptor htd) throws IOException {
        HRegionInfo hri = new HRegionInfo(htd.getTableName());
        HRegionFileSystem r0fs = HRegionFileSystem.createRegionOnFileSystem((Configuration)this.conf, (FileSystem)this.fs, (Path)FSUtils.getTableDir((Path)this.archiveDir, (TableName)hri.getTable()), (HRegionInfo)hri);
        Path storeFile = new Path(rootDir, TEST_HFILE);
        this.fs.createNewFile(storeFile);
        r0fs.commitStoreFile(TEST_FAMILY, storeFile);
        hri = new HRegionInfo(htd.getTableName());
        HRegionFileSystem r1fs = HRegionFileSystem.createRegionOnFileSystem((Configuration)this.conf, (FileSystem)this.fs, (Path)FSUtils.getTableDir((Path)this.archiveDir, (TableName)hri.getTable()), (HRegionInfo)hri);
        storeFile = new Path(rootDir, "abc." + r0fs.getRegionInfo().getEncodedName());
        this.fs.createNewFile(storeFile);
        r1fs.commitStoreFile(TEST_FAMILY, storeFile);
        Path tableDir = FSUtils.getTableDir((Path)this.archiveDir, (TableName)htd.getTableName());
        FileUtil.copy((FileSystem)this.fs, (Path)tableDir, (FileSystem)this.fs, (Path)snapshotDir, (boolean)false, (Configuration)this.conf);
    }

    private HTableDescriptor createTableDescriptor(String tableName) {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)tableName));
        htd.addFamily(new HColumnDescriptor(TEST_FAMILY));
        return htd;
    }

    private Path getReferredToFile(String referenceName) {
        Path fakeBasePath = new Path(new Path("table", "region"), TEST_FAMILY);
        return StoreFileInfo.getReferredToFile((Path)new Path(fakeBasePath, referenceName));
    }

    private String[] getHFiles(Path tableDir) throws IOException {
        ArrayList<String> files = new ArrayList<String>();
        for (Path regionDir : FSUtils.getRegionDirs((FileSystem)this.fs, (Path)tableDir)) {
            for (Path familyDir : FSUtils.getFamilyDirs((FileSystem)this.fs, (Path)regionDir)) {
                for (FileStatus file : FSUtils.listStatus((FileSystem)this.fs, (Path)familyDir)) {
                    files.add(file.getPath().getName());
                }
            }
        }
        Collections.sort(files);
        return files.toArray(new String[files.size()]);
    }
}

