/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import javax.xml.bind.JAXBException;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.rest.RowResourceBase;
import org.apache.hadoop.hbase.rest.client.Response;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestDeleteRow
extends RowResourceBase {
    @Test
    public void testDeleteNonExistentColumn() throws Exception {
        Response response = TestDeleteRow.putValueJson("TestRowResource", "testrow1", "a:1", "testvalue1");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        response = TestDeleteRow.checkAndDeleteJson("TestRowResource", "testrow1", "a:1", "testvalue2");
        Assert.assertEquals((long)304L, (long)response.getCode());
        Assert.assertEquals((long)200L, (long)TestDeleteRow.getValueJson("TestRowResource", "testrow1", "a:1").getCode());
        response = TestDeleteRow.checkAndDeleteJson("TestRowResource", "testrow2", "a:1", "testvalue2");
        Assert.assertEquals((long)304L, (long)response.getCode());
        Assert.assertEquals((long)200L, (long)TestDeleteRow.getValueJson("TestRowResource", "testrow1", "a:1").getCode());
        response = TestDeleteRow.checkAndDeleteJson("TestRowResource", "testrow1", "dummy", "testvalue1");
        Assert.assertEquals((long)400L, (long)response.getCode());
        Assert.assertEquals((long)200L, (long)TestDeleteRow.getValueJson("TestRowResource", "testrow1", "a:1").getCode());
        response = TestDeleteRow.checkAndDeleteJson("TestRowResource", "testrow1", "dummy:test", "testvalue1");
        Assert.assertEquals((long)404L, (long)response.getCode());
        Assert.assertEquals((long)200L, (long)TestDeleteRow.getValueJson("TestRowResource", "testrow1", "a:1").getCode());
        response = TestDeleteRow.checkAndDeleteJson("TestRowResource", "testrow1", "a:test", "testvalue1");
        Assert.assertEquals((long)304L, (long)response.getCode());
        Assert.assertEquals((long)200L, (long)TestDeleteRow.getValueJson("TestRowResource", "testrow1", "a:1").getCode());
    }

    @Test
    public void testDeleteXML() throws IOException, JAXBException {
        Response response = TestDeleteRow.putValueXML("TestRowResource", "testrow1", "a:1", "testvalue1");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        response = TestDeleteRow.putValueXML("TestRowResource", "testrow1", "b:2", "testvalue2");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        TestDeleteRow.checkValueXML("TestRowResource", "testrow1", "a:1", "testvalue1");
        TestDeleteRow.checkValueXML("TestRowResource", "testrow1", "b:2", "testvalue2");
        response = TestDeleteRow.deleteValue("TestRowResource", "testrow1", "a:1");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        response = TestDeleteRow.getValueXML("TestRowResource", "testrow1", "a:1");
        Assert.assertEquals((long)response.getCode(), (long)404L);
        TestDeleteRow.checkValueXML("TestRowResource", "testrow1", "b:2", "testvalue2");
        response = TestDeleteRow.putValueXML("TestRowResource", "testrow1", "a:1", "testvalue1");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        response = TestDeleteRow.checkAndDeletePB("TestRowResource", "testrow1", "a:1", "testvalue1");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        response = TestDeleteRow.getValueXML("TestRowResource", "testrow1", "a:1");
        Assert.assertEquals((long)response.getCode(), (long)404L);
        response = TestDeleteRow.deleteRow("TestRowResource", "testrow1");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        response = TestDeleteRow.getValueXML("TestRowResource", "testrow1", "a:1");
        Assert.assertEquals((long)response.getCode(), (long)404L);
        response = TestDeleteRow.getValueXML("TestRowResource", "testrow1", "b:2");
        Assert.assertEquals((long)response.getCode(), (long)404L);
        response = TestDeleteRow.deleteValue("dummy", "testrow1", "a:1");
        Assert.assertEquals((long)response.getCode(), (long)404L);
        response = TestDeleteRow.deleteValue("TestRowResource", "testrow1", "dummy");
        Assert.assertEquals((long)response.getCode(), (long)404L);
    }
}

