/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.FaultySequenceFileLogReader;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogFactory;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.HLogSplitter;
import org.apache.hadoop.hbase.regionserver.wal.HLogUtil;
import org.apache.hadoop.hbase.regionserver.wal.InstrumentedSequenceFileLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogReader;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={LargeTests.class})
public class TestHLogSplit {
    private static final Log LOG = LogFactory.getLog(TestHLogSplit.class);
    private Configuration conf;
    private FileSystem fs;
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Path HBASEDIR = new Path("/hbase");
    private static final Path HLOGDIR = new Path(HBASEDIR, "hlog");
    private static final Path OLDLOGDIR = new Path(HBASEDIR, "hlog.old");
    private static final Path CORRUPTDIR = new Path(HBASEDIR, "corrupt");
    private static final int NUM_WRITERS = 10;
    private static final int ENTRIES = 10;
    private static final TableName TABLE_NAME = TableName.valueOf((String)"t1");
    private static final byte[] FAMILY = "f1".getBytes();
    private static final byte[] QUALIFIER = "q1".getBytes();
    private static final byte[] VALUE = "v1".getBytes();
    private static final String HLOG_FILE_PREFIX = "hlog.dat.";
    private static List<String> REGIONS = new ArrayList<String>();
    private static final String HBASE_SKIP_ERRORS = "hbase.hlog.split.skip.errors";
    private static final Path TABLEDIR = FSUtils.getTableDir((Path)HBASEDIR, (TableName)TABLE_NAME);
    private static String ROBBER;
    private static String ZOMBIE;
    private static String[] GROUP;

    public TestHLogSplit() {
        ((Log4JLogger)DataNode.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LeaseManager.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)FSNamesystem.LOG).getLogger().setLevel(Level.ALL);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        FSUtils.setRootDir((Configuration)TEST_UTIL.getConfiguration(), (Path)HBASEDIR);
        TEST_UTIL.getConfiguration().setClass("hbase.regionserver.hlog.writer.impl", InstrumentedSequenceFileLogWriter.class, HLog.Writer.class);
        TEST_UTIL.getConfiguration().setBoolean("dfs.support.broken.append", true);
        TEST_UTIL.getConfiguration().setBoolean("dfs.support.append", true);
        System.setProperty("hbase.tests.use.shortcircuit.reads", "false");
        HashMap<String, String[]> u2g_map = new HashMap<String, String[]>(2);
        ROBBER = User.getCurrent().getName() + "-robber";
        ZOMBIE = User.getCurrent().getName() + "-zombie";
        u2g_map.put(ROBBER, GROUP);
        u2g_map.put(ZOMBIE, GROUP);
        DFSTestUtil.updateConfWithFakeGroupMapping((Configuration)TEST_UTIL.getConfiguration(), u2g_map);
        TEST_UTIL.getConfiguration().setInt("dfs.heartbeat.interval", 1);
        TEST_UTIL.startMiniDFSCluster(2);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniDFSCluster();
    }

    @Before
    public void setUp() throws Exception {
        TestHLogSplit.flushToConsole("Cleaning up cluster for new test\n--------------------------");
        this.conf = TEST_UTIL.getConfiguration();
        this.fs = TEST_UTIL.getDFSCluster().getFileSystem();
        FileStatus[] entries = this.fs.listStatus(new Path("/"));
        TestHLogSplit.flushToConsole("Num entries in /:" + entries.length);
        for (FileStatus dir : entries) {
            Assert.assertTrue((String)("Deleting " + dir.getPath()), (boolean)this.fs.delete(dir.getPath(), true));
        }
        this.fs.mkdirs(HLOGDIR);
        REGIONS.clear();
        Collections.addAll(REGIONS, "bbb", "ccc");
        InstrumentedSequenceFileLogWriter.activateFailure = false;
    }

    @After
    public void tearDown() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testLogCannotBeWrittenOnceParsed() throws IOException, InterruptedException {
        AtomicLong counter = new AtomicLong(0L);
        AtomicBoolean stop = new AtomicBoolean(false);
        final String region = REGIONS.get(0);
        ZombieLastLogWriterRegionServer zombie = new ZombieLastLogWriterRegionServer(this.conf, counter, stop, region);
        try {
            long startCount = counter.get();
            zombie.start();
            while (startCount == counter.get()) {
                Threads.sleep((long)1L);
            }
            Threads.sleep((long)1000L);
            final Configuration conf2 = HBaseConfiguration.create((Configuration)this.conf);
            User robber = User.createUserForTesting((Configuration)conf2, (String)ROBBER, (String[])GROUP);
            int count = (Integer)robber.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Integer>(){

                @Override
                public Integer run() throws Exception {
                    FileSystem fs = FileSystem.get((Configuration)conf2);
                    int expectedFiles = fs.listStatus(HLOGDIR).length;
                    HLogSplitter.split((Path)HBASEDIR, (Path)HLOGDIR, (Path)OLDLOGDIR, (FileSystem)fs, (Configuration)conf2);
                    Path[] logfiles = TestHLogSplit.this.getLogForRegion(HBASEDIR, TABLE_NAME, region);
                    Assert.assertEquals((long)expectedFiles, (long)logfiles.length);
                    int count = 0;
                    for (Path logfile : logfiles) {
                        count += TestHLogSplit.this.countHLog(logfile, fs, conf2);
                    }
                    return count;
                }
            });
            LOG.info((Object)("zombie=" + counter.get() + ", robber=" + count));
            Assert.assertTrue((String)("The log file could have at most 1 extra log entry, but can't have less. Zombie could write " + counter.get() + " and logfile had only " + count), (counter.get() == (long)count || counter.get() + 1L == (long)count ? 1 : 0) != 0);
        }
        finally {
            stop.set(true);
            zombie.interrupt();
            Threads.threadDumpingIsAlive((Thread)zombie);
        }
    }

    @Test(timeout=300000L)
    public void testRecoveredEditsPathForMeta() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)TEST_UTIL.getConfiguration());
        byte[] encoded = HRegionInfo.FIRST_META_REGIONINFO.getEncodedNameAsBytes();
        Path tdir = FSUtils.getTableDir((Path)HBASEDIR, (TableName)TableName.META_TABLE_NAME);
        Path regiondir = new Path(tdir, HRegionInfo.FIRST_META_REGIONINFO.getEncodedName());
        fs.mkdirs(regiondir);
        long now = System.currentTimeMillis();
        HLog.Entry entry = new HLog.Entry(new HLogKey(encoded, TableName.META_TABLE_NAME, 1L, now, HConstants.DEFAULT_CLUSTER_ID), new WALEdit());
        Path p = HLogSplitter.getRegionSplitEditsPath((FileSystem)fs, (HLog.Entry)entry, (Path)HBASEDIR, (boolean)true);
        String parentOfParent = p.getParent().getParent().getName();
        Assert.assertEquals((Object)parentOfParent, (Object)HRegionInfo.FIRST_META_REGIONINFO.getEncodedName());
    }

    @Test(timeout=300000L)
    public void testOldRecoveredEditsFileSidelined() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)TEST_UTIL.getConfiguration());
        byte[] encoded = HRegionInfo.FIRST_META_REGIONINFO.getEncodedNameAsBytes();
        Path tdir = FSUtils.getTableDir((Path)HBASEDIR, (TableName)TableName.META_TABLE_NAME);
        Path regiondir = new Path(tdir, HRegionInfo.FIRST_META_REGIONINFO.getEncodedName());
        fs.mkdirs(regiondir);
        long now = System.currentTimeMillis();
        HLog.Entry entry = new HLog.Entry(new HLogKey(encoded, TableName.META_TABLE_NAME, 1L, now, HConstants.DEFAULT_CLUSTER_ID), new WALEdit());
        Path parent = HLogUtil.getRegionDirRecoveredEditsDir((Path)regiondir);
        Assert.assertEquals((Object)parent.getName(), (Object)"recovered.edits");
        fs.createNewFile(parent);
        Path p = HLogSplitter.getRegionSplitEditsPath((FileSystem)fs, (HLog.Entry)entry, (Path)HBASEDIR, (boolean)true);
        String parentOfParent = p.getParent().getParent().getName();
        Assert.assertEquals((Object)parentOfParent, (Object)HRegionInfo.FIRST_META_REGIONINFO.getEncodedName());
        HLogFactory.createRecoveredEditsWriter((FileSystem)fs, (Path)p, (Configuration)this.conf).close();
    }

    @Test(timeout=300000L)
    public void testSplitPreservesEdits() throws IOException {
        String REGION = "region__1";
        REGIONS.removeAll(REGIONS);
        REGIONS.add("region__1");
        this.generateHLogs(1, 10, -1);
        this.fs.initialize(this.fs.getUri(), this.conf);
        HLogSplitter.split((Path)HBASEDIR, (Path)HLOGDIR, (Path)OLDLOGDIR, (FileSystem)this.fs, (Configuration)this.conf);
        Path originalLog = this.fs.listStatus(OLDLOGDIR)[0].getPath();
        Path[] splitLog = this.getLogForRegion(HBASEDIR, TABLE_NAME, "region__1");
        Assert.assertEquals((long)1L, (long)splitLog.length);
        Assert.assertEquals((String)"edits differ after split", (Object)true, (Object)this.logsAreEqual(originalLog, splitLog[0]));
    }

    @Test(timeout=300000L)
    public void testEmptyLogFiles() throws IOException {
        this.injectEmptyFile(".empty", true);
        this.generateHLogs(Integer.MAX_VALUE);
        this.injectEmptyFile("empty", true);
        this.fs.initialize(this.fs.getUri(), this.conf);
        int expectedFiles = this.fs.listStatus(HLOGDIR).length - 2;
        HLogSplitter.split((Path)HBASEDIR, (Path)HLOGDIR, (Path)OLDLOGDIR, (FileSystem)this.fs, (Configuration)this.conf);
        for (String region : REGIONS) {
            Path[] logfiles = this.getLogForRegion(HBASEDIR, TABLE_NAME, region);
            Assert.assertEquals((long)expectedFiles, (long)logfiles.length);
            int count = 0;
            for (Path logfile : logfiles) {
                count += this.countHLog(logfile, this.fs, this.conf);
            }
            Assert.assertEquals((long)100L, (long)count);
        }
    }

    @Test(timeout=300000L)
    public void testEmptyOpenLogFiles() throws IOException {
        this.injectEmptyFile(".empty", false);
        this.generateHLogs(Integer.MAX_VALUE);
        this.injectEmptyFile("empty", false);
        this.fs.initialize(this.fs.getUri(), this.conf);
        int expectedFiles = this.fs.listStatus(HLOGDIR).length - 2;
        HLogSplitter.split((Path)HBASEDIR, (Path)HLOGDIR, (Path)OLDLOGDIR, (FileSystem)this.fs, (Configuration)this.conf);
        for (String region : REGIONS) {
            Path[] logfiles = this.getLogForRegion(HBASEDIR, TABLE_NAME, region);
            Assert.assertEquals((long)expectedFiles, (long)logfiles.length);
            int count = 0;
            for (Path logfile : logfiles) {
                count += this.countHLog(logfile, this.fs, this.conf);
            }
            Assert.assertEquals((long)100L, (long)count);
        }
    }

    @Test(timeout=300000L)
    public void testOpenZeroLengthReportedFileButWithDataGetsSplit() throws IOException {
        this.generateHLogs(5);
        this.fs.initialize(this.fs.getUri(), this.conf);
        int expectedFiles = this.fs.listStatus(HLOGDIR).length;
        HLogSplitter.split((Path)HBASEDIR, (Path)HLOGDIR, (Path)OLDLOGDIR, (FileSystem)this.fs, (Configuration)this.conf);
        for (String region : REGIONS) {
            Path[] logfiles = this.getLogForRegion(HBASEDIR, TABLE_NAME, region);
            Assert.assertEquals((long)expectedFiles, (long)logfiles.length);
            int count = 0;
            for (Path logfile : logfiles) {
                count += this.countHLog(logfile, this.fs, this.conf);
            }
            Assert.assertEquals((long)100L, (long)count);
        }
    }

    @Test(timeout=300000L)
    public void testTralingGarbageCorruptionFileSkipErrorsPasses() throws IOException {
        this.conf.setBoolean(HBASE_SKIP_ERRORS, true);
        this.generateHLogs(Integer.MAX_VALUE);
        this.corruptHLog(new Path(HLOGDIR, "hlog.dat.5"), Corruptions.APPEND_GARBAGE, true, this.fs);
        this.fs.initialize(this.fs.getUri(), this.conf);
        int expectedFiles = this.fs.listStatus(HLOGDIR).length;
        HLogSplitter.split((Path)HBASEDIR, (Path)HLOGDIR, (Path)OLDLOGDIR, (FileSystem)this.fs, (Configuration)this.conf);
        for (String region : REGIONS) {
            Path[] logfiles = this.getLogForRegion(HBASEDIR, TABLE_NAME, region);
            Assert.assertEquals((long)expectedFiles, (long)logfiles.length);
            int count = 0;
            for (Path logfile : logfiles) {
                count += this.countHLog(logfile, this.fs, this.conf);
            }
            Assert.assertEquals((long)100L, (long)count);
        }
    }

    @Test(timeout=300000L)
    public void testFirstLineCorruptionLogFileSkipErrorsPasses() throws IOException {
        this.conf.setBoolean(HBASE_SKIP_ERRORS, true);
        this.generateHLogs(Integer.MAX_VALUE);
        this.corruptHLog(new Path(HLOGDIR, "hlog.dat.5"), Corruptions.INSERT_GARBAGE_ON_FIRST_LINE, true, this.fs);
        this.fs.initialize(this.fs.getUri(), this.conf);
        int expectedFiles = this.fs.listStatus(HLOGDIR).length - 1;
        HLogSplitter.split((Path)HBASEDIR, (Path)HLOGDIR, (Path)OLDLOGDIR, (FileSystem)this.fs, (Configuration)this.conf);
        for (String region : REGIONS) {
            Path[] logfiles = this.getLogForRegion(HBASEDIR, TABLE_NAME, region);
            Assert.assertEquals((long)expectedFiles, (long)logfiles.length);
            int count = 0;
            for (Path logfile : logfiles) {
                count += this.countHLog(logfile, this.fs, this.conf);
            }
            Assert.assertEquals((long)90L, (long)count);
        }
    }

    @Test(timeout=300000L)
    public void testMiddleGarbageCorruptionSkipErrorsReadsHalfOfFile() throws IOException {
        this.conf.setBoolean(HBASE_SKIP_ERRORS, true);
        this.generateHLogs(Integer.MAX_VALUE);
        this.corruptHLog(new Path(HLOGDIR, "hlog.dat.5"), Corruptions.INSERT_GARBAGE_IN_THE_MIDDLE, false, this.fs);
        this.fs.initialize(this.fs.getUri(), this.conf);
        int expectedFiles = this.fs.listStatus(HLOGDIR).length;
        HLogSplitter.split((Path)HBASEDIR, (Path)HLOGDIR, (Path)OLDLOGDIR, (FileSystem)this.fs, (Configuration)this.conf);
        for (String region : REGIONS) {
            Path[] logfiles = this.getLogForRegion(HBASEDIR, TABLE_NAME, region);
            Assert.assertEquals((long)expectedFiles, (long)logfiles.length);
            int count = 0;
            for (Path logfile : logfiles) {
                count += this.countHLog(logfile, this.fs, this.conf);
            }
            int goodEntries = 90;
            int firstHalfEntries = (int)Math.ceil(5.0) - 1;
            Assert.assertTrue((String)"The file up to the corrupted area hasn't been parsed", (goodEntries + firstHalfEntries <= count ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testCorruptedFileGetsArchivedIfSkipErrors() throws IOException {
        this.conf.setBoolean(HBASE_SKIP_ERRORS, true);
        Class backupClass = this.conf.getClass("hbase.regionserver.hlog.reader.impl", HLog.Reader.class);
        InstrumentedSequenceFileLogWriter.activateFailure = false;
        HLogFactory.resetLogReaderClass();
        try {
            Path c1 = new Path(HLOGDIR, "hlog.dat.0");
            this.conf.setClass("hbase.regionserver.hlog.reader.impl", FaultySequenceFileLogReader.class, HLog.Reader.class);
            for (FaultySequenceFileLogReader.FailureType failureType : FaultySequenceFileLogReader.FailureType.values()) {
                this.conf.set("faultysequencefilelogreader.failuretype", failureType.name());
                this.generateHLogs(1, 10, -1);
                this.fs.initialize(this.fs.getUri(), this.conf);
                HLogSplitter.split((Path)HBASEDIR, (Path)HLOGDIR, (Path)OLDLOGDIR, (FileSystem)this.fs, (Configuration)this.conf);
                FileStatus[] archivedLogs = this.fs.listStatus(CORRUPTDIR);
                Assert.assertEquals((String)"expected a different file", (Object)c1.getName(), (Object)archivedLogs[0].getPath().getName());
                Assert.assertEquals((long)archivedLogs.length, (long)1L);
                this.fs.delete(new Path(OLDLOGDIR, "hlog.dat.0"), false);
            }
        }
        finally {
            this.conf.setClass("hbase.regionserver.hlog.reader.impl", backupClass, HLog.Reader.class);
            HLogFactory.resetLogReaderClass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L, expected=IOException.class)
    public void testTrailingGarbageCorruptionLogFileSkipErrorsFalseThrows() throws IOException {
        this.conf.setBoolean(HBASE_SKIP_ERRORS, false);
        Class backupClass = this.conf.getClass("hbase.regionserver.hlog.reader.impl", HLog.Reader.class);
        InstrumentedSequenceFileLogWriter.activateFailure = false;
        HLogFactory.resetLogReaderClass();
        try {
            this.conf.setClass("hbase.regionserver.hlog.reader.impl", FaultySequenceFileLogReader.class, HLog.Reader.class);
            this.conf.set("faultysequencefilelogreader.failuretype", FaultySequenceFileLogReader.FailureType.BEGINNING.name());
            this.generateHLogs(Integer.MAX_VALUE);
            this.fs.initialize(this.fs.getUri(), this.conf);
            HLogSplitter.split((Path)HBASEDIR, (Path)HLOGDIR, (Path)OLDLOGDIR, (FileSystem)this.fs, (Configuration)this.conf);
        }
        finally {
            this.conf.setClass("hbase.regionserver.hlog.reader.impl", backupClass, HLog.Reader.class);
            HLogFactory.resetLogReaderClass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testCorruptedLogFilesSkipErrorsFalseDoesNotTouchLogs() throws IOException {
        this.conf.setBoolean(HBASE_SKIP_ERRORS, false);
        Class backupClass = this.conf.getClass("hbase.regionserver.hlog.reader.impl", HLog.Reader.class);
        InstrumentedSequenceFileLogWriter.activateFailure = false;
        HLogFactory.resetLogReaderClass();
        try {
            this.conf.setClass("hbase.regionserver.hlog.reader.impl", FaultySequenceFileLogReader.class, HLog.Reader.class);
            this.conf.set("faultysequencefilelogreader.failuretype", FaultySequenceFileLogReader.FailureType.BEGINNING.name());
            this.generateHLogs(-1);
            this.fs.initialize(this.fs.getUri(), this.conf);
            try {
                HLogSplitter.split((Path)HBASEDIR, (Path)HLOGDIR, (Path)OLDLOGDIR, (FileSystem)this.fs, (Configuration)this.conf);
            }
            catch (IOException e) {
                Assert.assertEquals((String)"if skip.errors is false all files should remain in place", (long)10L, (long)this.fs.listStatus(HLOGDIR).length);
            }
        }
        finally {
            this.conf.setClass("hbase.regionserver.hlog.reader.impl", backupClass, HLog.Reader.class);
            HLogFactory.resetLogReaderClass();
        }
    }

    @Test(timeout=300000L)
    public void testEOFisIgnored() throws IOException {
        HLog.Entry entry;
        this.conf.setBoolean(HBASE_SKIP_ERRORS, false);
        String REGION = "region__1";
        REGIONS.removeAll(REGIONS);
        REGIONS.add("region__1");
        int entryCount = 10;
        Path c1 = new Path(HLOGDIR, "hlog.dat.0");
        this.generateHLogs(1, entryCount, -1);
        this.corruptHLog(c1, Corruptions.TRUNCATE, true, this.fs);
        this.fs.initialize(this.fs.getUri(), this.conf);
        HLogSplitter.split((Path)HBASEDIR, (Path)HLOGDIR, (Path)OLDLOGDIR, (FileSystem)this.fs, (Configuration)this.conf);
        Path[] splitLog = this.getLogForRegion(HBASEDIR, TABLE_NAME, "region__1");
        Assert.assertEquals((long)1L, (long)splitLog.length);
        int actualCount = 0;
        HLog.Reader in = HLogFactory.createReader((FileSystem)this.fs, (Path)splitLog[0], (Configuration)this.conf);
        while ((entry = in.next()) != null) {
            ++actualCount;
        }
        Assert.assertEquals((long)(entryCount - 1), (long)actualCount);
        FileStatus[] archivedLogs = this.fs.listStatus(CORRUPTDIR);
        Assert.assertEquals((long)archivedLogs.length, (long)0L);
    }

    @Test(timeout=300000L)
    public void testCorruptWALTrailer() throws IOException {
        HLog.Entry entry;
        this.conf.setBoolean(HBASE_SKIP_ERRORS, false);
        String REGION = "region__1";
        REGIONS.removeAll(REGIONS);
        REGIONS.add("region__1");
        int entryCount = 10;
        Path c1 = new Path(HLOGDIR, "hlog.dat.0");
        this.generateHLogs(1, entryCount, -1);
        this.corruptHLog(c1, Corruptions.TRUNCATE_TRAILER, true, this.fs);
        this.fs.initialize(this.fs.getUri(), this.conf);
        HLogSplitter.split((Path)HBASEDIR, (Path)HLOGDIR, (Path)OLDLOGDIR, (FileSystem)this.fs, (Configuration)this.conf);
        Path[] splitLog = this.getLogForRegion(HBASEDIR, TABLE_NAME, "region__1");
        Assert.assertEquals((long)1L, (long)splitLog.length);
        int actualCount = 0;
        HLog.Reader in = HLogFactory.createReader((FileSystem)this.fs, (Path)splitLog[0], (Configuration)this.conf);
        while ((entry = in.next()) != null) {
            ++actualCount;
        }
        Assert.assertEquals((long)entryCount, (long)actualCount);
        FileStatus[] archivedLogs = this.fs.listStatus(CORRUPTDIR);
        Assert.assertEquals((long)archivedLogs.length, (long)0L);
    }

    @Test(timeout=300000L)
    public void testLogsGetArchivedAfterSplit() throws IOException {
        this.conf.setBoolean(HBASE_SKIP_ERRORS, false);
        this.generateHLogs(-1);
        this.fs.initialize(this.fs.getUri(), this.conf);
        HLogSplitter.split((Path)HBASEDIR, (Path)HLOGDIR, (Path)OLDLOGDIR, (FileSystem)this.fs, (Configuration)this.conf);
        FileStatus[] archivedLogs = this.fs.listStatus(OLDLOGDIR);
        Assert.assertEquals((String)"wrong number of files in the archive log", (long)10L, (long)archivedLogs.length);
    }

    @Test(timeout=300000L)
    public void testSplit() throws IOException {
        this.generateHLogs(-1);
        this.fs.initialize(this.fs.getUri(), this.conf);
        int expectedFiles = this.fs.listStatus(HLOGDIR).length;
        HLogSplitter.split((Path)HBASEDIR, (Path)HLOGDIR, (Path)OLDLOGDIR, (FileSystem)this.fs, (Configuration)this.conf);
        for (String region : REGIONS) {
            Path[] logfiles = this.getLogForRegion(HBASEDIR, TABLE_NAME, region);
            Assert.assertEquals((long)expectedFiles, (long)logfiles.length);
            int count = 0;
            for (Path logfile : logfiles) {
                count += this.countHLog(logfile, this.fs, this.conf);
            }
            Assert.assertEquals((long)100L, (long)count);
        }
    }

    @Test(timeout=300000L)
    public void testLogDirectoryShouldBeDeletedAfterSuccessfulSplit() throws IOException {
        this.generateHLogs(-1);
        this.fs.initialize(this.fs.getUri(), this.conf);
        HLogSplitter.split((Path)HBASEDIR, (Path)HLOGDIR, (Path)OLDLOGDIR, (FileSystem)this.fs, (Configuration)this.conf);
        FileStatus[] statuses = null;
        try {
            statuses = this.fs.listStatus(HLOGDIR);
            if (statuses != null) {
                Assert.fail((String)("Files left in log dir: " + Joiner.on((String)",").join((Object[])FileUtil.stat2Paths((FileStatus[])statuses))));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Test(timeout=300000L, expected=IOException.class)
    public void testSplitWillFailIfWritingToRegionFails() throws Exception {
        HLog.Writer[] writer = this.generateHLogs(4);
        this.fs.initialize(this.fs.getUri(), this.conf);
        String region = "break";
        Path regiondir = new Path(TABLEDIR, region);
        this.fs.mkdirs(regiondir);
        InstrumentedSequenceFileLogWriter.activateFailure = false;
        TestHLogSplit.appendEntry(writer[4], TABLE_NAME, Bytes.toBytes((String)region), "r999".getBytes(), FAMILY, QUALIFIER, VALUE, 0L);
        writer[4].close();
        try {
            InstrumentedSequenceFileLogWriter.activateFailure = true;
            HLogSplitter.split((Path)HBASEDIR, (Path)HLOGDIR, (Path)OLDLOGDIR, (FileSystem)this.fs, (Configuration)this.conf);
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("This exception is instrumented and should only be thrown for testing"));
            throw e;
        }
        finally {
            InstrumentedSequenceFileLogWriter.activateFailure = false;
        }
    }

    public void testSplittingLargeNumberOfRegionsConsistency() throws IOException {
        REGIONS.removeAll(REGIONS);
        for (int i = 0; i < 100; ++i) {
            REGIONS.add("region__" + i);
        }
        this.generateHLogs(1, 100, -1);
        this.fs.initialize(this.fs.getUri(), this.conf);
        HLogSplitter.split((Path)HBASEDIR, (Path)HLOGDIR, (Path)OLDLOGDIR, (FileSystem)this.fs, (Configuration)this.conf);
        this.fs.rename(OLDLOGDIR, HLOGDIR);
        Path firstSplitPath = new Path(HBASEDIR, TABLE_NAME + ".first");
        Path splitPath = new Path(HBASEDIR, TABLE_NAME.getNameAsString());
        this.fs.rename(splitPath, firstSplitPath);
        this.fs.initialize(this.fs.getUri(), this.conf);
        HLogSplitter.split((Path)HBASEDIR, (Path)HLOGDIR, (Path)OLDLOGDIR, (FileSystem)this.fs, (Configuration)this.conf);
        Assert.assertEquals((long)0L, (long)this.compareHLogSplitDirs(firstSplitPath, splitPath));
    }

    @Test(timeout=300000L)
    public void testSplitDeletedRegion() throws IOException {
        REGIONS.removeAll(REGIONS);
        String region = "region_that_splits";
        REGIONS.add(region);
        this.generateHLogs(1);
        this.fs.initialize(this.fs.getUri(), this.conf);
        Path regiondir = new Path(TABLEDIR, region);
        this.fs.delete(regiondir, true);
        HLogSplitter.split((Path)HBASEDIR, (Path)HLOGDIR, (Path)OLDLOGDIR, (FileSystem)this.fs, (Configuration)this.conf);
        Assert.assertFalse((boolean)this.fs.exists(regiondir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testIOEOnOutputThread() throws Exception {
        this.conf.setBoolean(HBASE_SKIP_ERRORS, false);
        this.generateHLogs(-1);
        this.fs.initialize(this.fs.getUri(), this.conf);
        FileStatus[] logfiles = this.fs.listStatus(HLOGDIR);
        Assert.assertTrue((String)"There should be some log file", (logfiles != null && logfiles.length > 0 ? 1 : 0) != 0);
        HLogSplitter logSplitter = new HLogSplitter(this.conf, HBASEDIR, this.fs, null, null){

            protected HLog.Writer createWriter(FileSystem fs, Path logfile, Configuration conf) throws IOException {
                HLog.Writer mockWriter = (HLog.Writer)Mockito.mock(HLog.Writer.class);
                ((HLog.Writer)Mockito.doThrow((Throwable)new IOException("Injected")).when((Object)mockWriter)).append((HLog.Entry)Mockito.any());
                return mockWriter;
            }
        };
        final AtomicBoolean stop = new AtomicBoolean(false);
        final Thread someOldThread = new Thread("Some-old-thread"){

            @Override
            public void run() {
                while (!stop.get()) {
                    Threads.sleep((long)10L);
                }
            }
        };
        someOldThread.setDaemon(true);
        someOldThread.start();
        Thread t = new Thread("Background-thread-dumper"){

            @Override
            public void run() {
                try {
                    Threads.threadDumpingIsAlive((Thread)someOldThread);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        t.setDaemon(true);
        t.start();
        try {
            logSplitter.splitLogFile(logfiles[0], null);
            Assert.fail((String)"Didn't throw!");
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)ioe.toString().contains("Injected"));
        }
        finally {
            stop.set(true);
        }
    }

    @Test(timeout=300000L)
    public void testMovedHLogDuringRecovery() throws Exception {
        this.generateHLogs(-1);
        this.fs.initialize(this.fs.getUri(), this.conf);
        FileSystem spiedFs = (FileSystem)Mockito.spy((Object)this.fs);
        ((FileSystem)Mockito.doThrow((Throwable)new LeaseExpiredException("Injected: File does not exist")).when((Object)spiedFs)).append((Path)Mockito.any());
        try {
            HLogSplitter.split((Path)HBASEDIR, (Path)HLOGDIR, (Path)OLDLOGDIR, (FileSystem)spiedFs, (Configuration)this.conf);
            Assert.assertEquals((long)10L, (long)this.fs.listStatus(OLDLOGDIR).length);
            Assert.assertFalse((boolean)this.fs.exists(HLOGDIR));
        }
        catch (IOException e) {
            Assert.fail((String)("There shouldn't be any exception but: " + e.toString()));
        }
    }

    @Test(timeout=300000L)
    public void testRetryOpenDuringRecovery() throws Exception {
        this.generateHLogs(-1);
        this.fs.initialize(this.fs.getUri(), this.conf);
        FileSystem spiedFs = (FileSystem)Mockito.spy((Object)this.fs);
        ((FileSystem)Mockito.doAnswer((Answer)new Answer<FSDataInputStream>(){
            private final String[] errors = new String[]{"Cannot obtain block length", "Could not obtain the last block", "Blocklist for " + TestHLogSplit.access$200() + " has changed"};
            private int count = 0;

            public FSDataInputStream answer(InvocationOnMock invocation) throws Throwable {
                if (this.count < 3) {
                    throw new IOException(this.errors[this.count++]);
                }
                return (FSDataInputStream)invocation.callRealMethod();
            }
        }).when((Object)spiedFs)).open((Path)Mockito.any(), Mockito.anyInt());
        try {
            HLogSplitter.split((Path)HBASEDIR, (Path)HLOGDIR, (Path)OLDLOGDIR, (FileSystem)spiedFs, (Configuration)this.conf);
            Assert.assertEquals((long)10L, (long)this.fs.listStatus(OLDLOGDIR).length);
            Assert.assertFalse((boolean)this.fs.exists(HLOGDIR));
        }
        catch (IOException e) {
            Assert.fail((String)("There shouldn't be any exception but: " + e.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testTerminationAskedByReporter() throws IOException, HLogSplitter.CorruptedLogFileException {
        this.generateHLogs(1, 10, -1);
        FileStatus logfile = this.fs.listStatus(HLOGDIR)[0];
        this.fs.initialize(this.fs.getUri(), this.conf);
        final AtomicInteger count = new AtomicInteger();
        CancelableProgressable localReporter = new CancelableProgressable(){

            public boolean progress() {
                count.getAndIncrement();
                return false;
            }
        };
        FileSystem spiedFs = (FileSystem)Mockito.spy((Object)this.fs);
        ((FileSystem)Mockito.doAnswer((Answer)new Answer<FSDataInputStream>(){

            public FSDataInputStream answer(InvocationOnMock invocation) throws Throwable {
                Thread.sleep(1500L);
                return (FSDataInputStream)invocation.callRealMethod();
            }
        }).when((Object)spiedFs)).open((Path)Mockito.any(), Mockito.anyInt());
        try {
            this.conf.setInt("hbase.splitlog.report.period", 1000);
            boolean ret = HLogSplitter.splitLogFile((Path)HBASEDIR, (FileStatus)logfile, (FileSystem)spiedFs, (Configuration)this.conf, (CancelableProgressable)localReporter, null, null);
            Assert.assertFalse((String)"Log splitting should failed", (boolean)ret);
            Assert.assertTrue((count.get() > 0 ? 1 : 0) != 0);
        }
        catch (IOException e) {
            Assert.fail((String)("There shouldn't be any exception but: " + e.toString()));
        }
        finally {
            this.conf.setInt("hbase.splitlog.report.period", 59000);
        }
    }

    @Test(timeout=300000L)
    public void testThreading() throws Exception {
        this.doTestThreading(20000, 0x8000000, 0);
    }

    @Test(timeout=300000L)
    public void testThreadingSlowWriterSmallBuffer() throws Exception {
        this.doTestThreading(200, 1024, 50);
    }

    private void doTestThreading(final int numFakeEdits, int bufferSize, final int writerSlowness) throws Exception {
        Configuration localConf = new Configuration(this.conf);
        localConf.setInt("hbase.regionserver.hlog.splitlog.buffersize", bufferSize);
        Path logPath = new Path(HLOGDIR, "hlog.dat..fake");
        FSDataOutputStream out = this.fs.create(logPath);
        out.close();
        ImmutableList regions = ImmutableList.of((Object)"r0", (Object)"r1", (Object)"r2", (Object)"r3", (Object)"r4");
        TestHLogSplit.makeRegionDirs(this.fs, (List<String>)regions);
        HLogSplitter logSplitter = new HLogSplitter(localConf, HBASEDIR, this.fs, null, null, (List)regions){
            final /* synthetic */ List val$regions;
            {
                this.val$regions = list;
                super(x0, x1, x2, x3, x4);
            }

            protected HLog.Writer createWriter(FileSystem fs, Path logfile, Configuration conf) throws IOException {
                HLog.Writer mockWriter = (HLog.Writer)Mockito.mock(HLog.Writer.class);
                ((HLog.Writer)Mockito.doAnswer((Answer)new Answer<Void>(){
                    int expectedIndex = 0;

                    public Void answer(InvocationOnMock invocation) {
                        if (writerSlowness > 0) {
                            try {
                                Thread.sleep(writerSlowness);
                            }
                            catch (InterruptedException ie) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        HLog.Entry entry = (HLog.Entry)invocation.getArguments()[0];
                        WALEdit edit = entry.getEdit();
                        ArrayList keyValues = edit.getKeyValues();
                        Assert.assertEquals((long)1L, (long)keyValues.size());
                        KeyValue kv = (KeyValue)keyValues.get(0);
                        Assert.assertEquals((long)this.expectedIndex, (long)Bytes.toInt((byte[])kv.getRow()));
                        ++this.expectedIndex;
                        return null;
                    }
                }).when((Object)mockWriter)).append((HLog.Entry)Mockito.any());
                return mockWriter;
            }

            protected HLog.Reader getReader(FileSystem fs, Path curLogFile, Configuration conf, CancelableProgressable reporter) throws IOException {
                HLog.Reader mockReader = (HLog.Reader)Mockito.mock(HLog.Reader.class);
                ((HLog.Reader)Mockito.doAnswer((Answer)new Answer<HLog.Entry>(){
                    int index = 0;

                    public HLog.Entry answer(InvocationOnMock invocation) throws Throwable {
                        if (this.index >= numFakeEdits) {
                            return null;
                        }
                        int regionIdx = this.index % val$regions.size();
                        byte[] region = new byte[]{114, (byte)(48 + regionIdx)};
                        HLog.Entry ret = TestHLogSplit.createTestEntry(TABLE_NAME, region, Bytes.toBytes((int)(this.index / val$regions.size())), FAMILY, QUALIFIER, VALUE, this.index);
                        ++this.index;
                        return ret;
                    }
                }).when((Object)mockReader)).next();
                return mockReader;
            }
        };
        logSplitter.splitLogFile(this.fs.getFileStatus(logPath), null);
        Map outputCounts = logSplitter.outputSink.getOutputCounts();
        for (Map.Entry entry : outputCounts.entrySet()) {
            LOG.info((Object)("Got " + entry.getValue() + " output edits for region " + Bytes.toString((byte[])((byte[])entry.getKey()))));
            Assert.assertEquals((long)((Long)entry.getValue()), (long)(numFakeEdits / regions.size()));
        }
        Assert.assertEquals((long)regions.size(), (long)outputCounts.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    @Ignore(value="Need HADOOP-6886, HADOOP-6840, & HDFS-617 for this. HDFS 0.20.205.1+ should have this")
    public void testLogRollAfterSplitStart() throws IOException {
        block9: {
            HLog log = null;
            String logName = "testLogRollAfterSplitStart";
            Path thisTestsDir = new Path(HBASEDIR, logName);
            try {
                TableName tableName = TableName.valueOf((String)this.getClass().getName());
                HRegionInfo regioninfo = new HRegionInfo(tableName, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
                log = HLogFactory.createHLog((FileSystem)this.fs, (Path)HBASEDIR, (String)logName, (Configuration)this.conf);
                AtomicLong sequenceId = new AtomicLong(1L);
                int total = 20;
                for (int i = 0; i < 20; ++i) {
                    WALEdit kvs = new WALEdit();
                    kvs.add(new KeyValue(Bytes.toBytes((int)i), tableName.getName(), tableName.getName()));
                    HTableDescriptor htd = new HTableDescriptor(tableName);
                    htd.addFamily(new HColumnDescriptor("column"));
                    log.append(regioninfo, tableName, kvs, System.currentTimeMillis(), htd, sequenceId);
                }
                log.sync();
                ((FSHLog)log).cleanupCurrentWriter(log.getFilenum());
                Path rsSplitDir = new Path(thisTestsDir.getParent(), thisTestsDir.getName() + "-splitting");
                this.fs.rename(thisTestsDir, rsSplitDir);
                LOG.debug((Object)("Renamed region directory: " + rsSplitDir));
                HLogSplitter.split((Path)HBASEDIR, (Path)rsSplitDir, (Path)OLDLOGDIR, (FileSystem)this.fs, (Configuration)this.conf);
                try {
                    log.rollWriter();
                    Assert.fail((String)"rollWriter() did not throw any exception.");
                }
                catch (IOException ioe) {
                    if (ioe.getCause().getMessage().contains("FileNotFound")) {
                        LOG.info((Object)"Got the expected exception: ", ioe.getCause());
                        break block9;
                    }
                    Assert.fail((String)("Unexpected exception: " + ioe));
                }
            }
            finally {
                if (log != null) {
                    log.close();
                }
                if (this.fs.exists(thisTestsDir)) {
                    this.fs.delete(thisTestsDir, true);
                }
            }
        }
    }

    @Test(timeout=300000L)
    public void testSplitLogFileWithOneRegion() throws IOException {
        LOG.info((Object)"testSplitLogFileWithOneRegion");
        String REGION = "region__1";
        REGIONS.removeAll(REGIONS);
        REGIONS.add("region__1");
        this.generateHLogs(1, 10, -1);
        this.fs.initialize(this.fs.getUri(), this.conf);
        HLogSplitter.split((Path)HBASEDIR, (Path)HLOGDIR, (Path)OLDLOGDIR, (FileSystem)this.fs, (Configuration)this.conf);
        Path originalLog = this.fs.listStatus(OLDLOGDIR)[0].getPath();
        Path[] splitLog = this.getLogForRegion(HBASEDIR, TABLE_NAME, "region__1");
        Assert.assertEquals((long)1L, (long)splitLog.length);
        Assert.assertEquals((Object)true, (Object)this.logsAreEqual(originalLog, splitLog[0]));
    }

    @Test(timeout=300000L)
    public void testSplitLogFileDeletedRegionDir() throws IOException {
        LOG.info((Object)"testSplitLogFileDeletedRegionDir");
        String REGION = "region__1";
        REGIONS.removeAll(REGIONS);
        REGIONS.add("region__1");
        this.generateHLogs(1, 10, -1);
        this.fs.initialize(this.fs.getUri(), this.conf);
        Path regiondir = new Path(TABLEDIR, "region__1");
        LOG.info((Object)("Region directory is" + regiondir));
        this.fs.delete(regiondir, true);
        HLogSplitter.split((Path)HBASEDIR, (Path)HLOGDIR, (Path)OLDLOGDIR, (FileSystem)this.fs, (Configuration)this.conf);
        Assert.assertTrue((!this.fs.exists(regiondir) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)true);
    }

    @Test(timeout=300000L)
    public void testSplitLogFileEmpty() throws IOException {
        LOG.info((Object)"testSplitLogFileEmpty");
        this.injectEmptyFile(".empty", true);
        this.fs.initialize(this.fs.getUri(), this.conf);
        HLogSplitter.split((Path)HBASEDIR, (Path)HLOGDIR, (Path)OLDLOGDIR, (FileSystem)this.fs, (Configuration)this.conf);
        Path tdir = FSUtils.getTableDir((Path)HBASEDIR, (TableName)TABLE_NAME);
        Assert.assertFalse((boolean)this.fs.exists(tdir));
        Assert.assertEquals((long)0L, (long)this.countHLog(this.fs.listStatus(OLDLOGDIR)[0].getPath(), this.fs, this.conf));
    }

    @Test(timeout=300000L)
    public void testSplitLogFileMultipleRegions() throws IOException {
        LOG.info((Object)"testSplitLogFileMultipleRegions");
        this.generateHLogs(1, 10, -1);
        this.fs.initialize(this.fs.getUri(), this.conf);
        HLogSplitter.split((Path)HBASEDIR, (Path)HLOGDIR, (Path)OLDLOGDIR, (FileSystem)this.fs, (Configuration)this.conf);
        for (String region : REGIONS) {
            Path[] recovered = this.getLogForRegion(HBASEDIR, TABLE_NAME, region);
            Assert.assertEquals((long)1L, (long)recovered.length);
            Assert.assertEquals((long)10L, (long)this.countHLog(recovered[0], this.fs, this.conf));
        }
    }

    @Test(timeout=300000L)
    public void testSplitLogFileFirstLineCorruptionLog() throws IOException {
        this.conf.setBoolean(HBASE_SKIP_ERRORS, true);
        this.generateHLogs(1, 10, -1);
        FileStatus logfile = this.fs.listStatus(HLOGDIR)[0];
        this.corruptHLog(logfile.getPath(), Corruptions.INSERT_GARBAGE_ON_FIRST_LINE, true, this.fs);
        this.fs.initialize(this.fs.getUri(), this.conf);
        HLogSplitter.split((Path)HBASEDIR, (Path)HLOGDIR, (Path)OLDLOGDIR, (FileSystem)this.fs, (Configuration)this.conf);
        Path corruptDir = new Path(FSUtils.getRootDir((Configuration)this.conf), this.conf.get("hbase.regionserver.hlog.splitlog.corrupt.dir", "corrupt"));
        Assert.assertEquals((long)1L, (long)this.fs.listStatus(corruptDir).length);
    }

    @Test(timeout=300000L)
    public void testConcurrentSplitLogAndReplayRecoverEdit() throws IOException {
        LOG.info((Object)"testConcurrentSplitLogAndReplayRecoverEdit");
        String regionName = "r0";
        final Path regiondir = new Path(TABLEDIR, regionName);
        REGIONS = new ArrayList<String>();
        REGIONS.add(regionName);
        this.generateHLogs(-1);
        HLogFactory.createHLog((FileSystem)this.fs, (Path)regiondir, (String)regionName, (Configuration)this.conf);
        FileStatus[] logfiles = this.fs.listStatus(HLOGDIR);
        Assert.assertTrue((String)"There should be some log file", (logfiles != null && logfiles.length > 0 ? 1 : 0) != 0);
        HLogSplitter logSplitter = new HLogSplitter(this.conf, HBASEDIR, this.fs, null, null){

            protected HLog.Writer createWriter(FileSystem fs, Path logfile, Configuration conf) throws IOException {
                HLog.Writer writer = HLogFactory.createRecoveredEditsWriter((FileSystem)fs, (Path)logfile, (Configuration)conf);
                NavigableSet files = HLogUtil.getSplitEditFilesSorted((FileSystem)fs, (Path)regiondir);
                if (files != null && !files.isEmpty()) {
                    for (Path file : files) {
                        if (!this.fs.delete(file, false)) {
                            LOG.error((Object)("Failed delete of " + file));
                            continue;
                        }
                        LOG.debug((Object)("Deleted recovered.edits file=" + file));
                    }
                }
                return writer;
            }
        };
        try {
            logSplitter.splitLogFile(logfiles[0], null);
        }
        catch (IOException e) {
            LOG.info((Object)e);
            Assert.fail((String)"Throws IOException when spliting log, it is most likely because writing file does not exist which is caused by concurrent replayRecoveredEditsIfAny()");
        }
        if (this.fs.exists(CORRUPTDIR) && this.fs.listStatus(CORRUPTDIR).length > 0) {
            Assert.fail((String)"There are some corrupt logs, it is most likely caused by concurrent replayRecoveredEditsIfAny()");
        }
    }

    private static void flushToConsole(String s) {
        System.out.println(s);
        System.out.flush();
    }

    private HLog.Writer[] generateHLogs(int leaveOpen) throws IOException {
        return this.generateHLogs(10, 10, leaveOpen);
    }

    private HLog.Writer[] generateHLogs(int writers, int entries, int leaveOpen) throws IOException {
        return TestHLogSplit.generateHLogs((DistributedFileSystem)this.fs, writers, entries, leaveOpen);
    }

    private static void makeRegionDirs(FileSystem fs, List<String> regions) throws IOException {
        for (String region : regions) {
            TestHLogSplit.flushToConsole("Creating dir for region " + region);
            fs.mkdirs(new Path(TABLEDIR, region));
        }
    }

    private static HLog.Writer[] generateHLogs(DistributedFileSystem dfs, int writers, int entries, int leaveOpen) throws IOException {
        TestHLogSplit.makeRegionDirs((FileSystem)dfs, REGIONS);
        dfs.mkdirs(HLOGDIR);
        HLog.Writer[] ws = new HLog.Writer[writers];
        int seq = 0;
        for (int i = 0; i < writers; ++i) {
            ws[i] = HLogFactory.createWALWriter((FileSystem)dfs, (Path)new Path(HLOGDIR, HLOG_FILE_PREFIX + i), (Configuration)dfs.getConf());
            for (int j = 0; j < entries; ++j) {
                int prefix = 0;
                for (String region : REGIONS) {
                    String row_key = region + prefix++ + i + j;
                    TestHLogSplit.appendEntry(ws[i], TABLE_NAME, region.getBytes(), row_key.getBytes(), FAMILY, QUALIFIER, VALUE, seq++);
                }
            }
            if (i == leaveOpen) continue;
            ws[i].close();
            LOG.info((Object)("Closing writer " + i));
        }
        return ws;
    }

    private Path[] getLogForRegion(Path rootdir, TableName table, String region) throws IOException {
        Path tdir = FSUtils.getTableDir((Path)rootdir, (TableName)table);
        Path editsdir = HLogUtil.getRegionDirRecoveredEditsDir((Path)HRegion.getRegionDir((Path)tdir, (String)Bytes.toString((byte[])region.getBytes())));
        FileStatus[] files = this.fs.listStatus(editsdir);
        Path[] paths = new Path[files.length];
        for (int i = 0; i < files.length; ++i) {
            paths[i] = files[i].getPath();
        }
        return paths;
    }

    private void corruptHLog(Path path, Corruptions corruption, boolean close, FileSystem fs) throws IOException {
        int fileSize = (int)fs.listStatus(path)[0].getLen();
        FSDataInputStream in = fs.open(path);
        byte[] corrupted_bytes = new byte[fileSize];
        in.readFully(0L, corrupted_bytes, 0, fileSize);
        in.close();
        switch (corruption) {
            case APPEND_GARBAGE: {
                fs.delete(path, false);
                FSDataOutputStream out = fs.create(path);
                out.write(corrupted_bytes);
                out.write("-----".getBytes());
                this.closeOrFlush(close, out);
                break;
            }
            case INSERT_GARBAGE_ON_FIRST_LINE: {
                fs.delete(path, false);
                FSDataOutputStream out = fs.create(path);
                out.write(0);
                out.write(corrupted_bytes);
                this.closeOrFlush(close, out);
                break;
            }
            case INSERT_GARBAGE_IN_THE_MIDDLE: {
                fs.delete(path, false);
                FSDataOutputStream out = fs.create(path);
                int middle = (int)Math.floor(corrupted_bytes.length / 2);
                out.write(corrupted_bytes, 0, middle);
                out.write(0);
                out.write(corrupted_bytes, middle, corrupted_bytes.length - middle);
                this.closeOrFlush(close, out);
                break;
            }
            case TRUNCATE: {
                fs.delete(path, false);
                FSDataOutputStream out = fs.create(path);
                out.write(corrupted_bytes, 0, fileSize - (32 + ProtobufLogReader.PB_WAL_COMPLETE_MAGIC.length + 4));
                this.closeOrFlush(close, out);
                break;
            }
            case TRUNCATE_TRAILER: {
                fs.delete(path, false);
                FSDataOutputStream out = fs.create(path);
                out.write(corrupted_bytes, 0, fileSize - 4);
                this.closeOrFlush(close, out);
            }
        }
    }

    private void closeOrFlush(boolean close, FSDataOutputStream out) throws IOException {
        if (close) {
            out.close();
        } else {
            Method syncMethod = null;
            try {
                syncMethod = out.getClass().getMethod("hflush", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                try {
                    syncMethod = out.getClass().getMethod("sync", new Class[0]);
                }
                catch (NoSuchMethodException ex) {
                    throw new IOException("This version of Hadoop supports neither Syncable.sync() nor Syncable.hflush().");
                }
            }
            try {
                syncMethod.invoke((Object)out, new Object[0]);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    private void dumpHLog(Path log, FileSystem fs, Configuration conf) throws IOException {
        HLog.Entry entry;
        HLog.Reader in = HLogFactory.createReader((FileSystem)fs, (Path)log, (Configuration)conf);
        while ((entry = in.next()) != null) {
            System.out.println(entry);
        }
    }

    private int countHLog(Path log, FileSystem fs, Configuration conf) throws IOException {
        int count = 0;
        HLog.Reader in = HLogFactory.createReader((FileSystem)fs, (Path)log, (Configuration)conf);
        while (in.next() != null) {
            ++count;
        }
        return count;
    }

    public static long appendEntry(HLog.Writer writer, TableName table, byte[] region, byte[] row, byte[] family, byte[] qualifier, byte[] value, long seq) throws IOException {
        LOG.info((Object)(Thread.currentThread().getName() + " append"));
        writer.append(TestHLogSplit.createTestEntry(table, region, row, family, qualifier, value, seq));
        LOG.info((Object)(Thread.currentThread().getName() + " sync"));
        writer.sync();
        return seq;
    }

    private static HLog.Entry createTestEntry(TableName table, byte[] region, byte[] row, byte[] family, byte[] qualifier, byte[] value, long seq) {
        long time = System.nanoTime();
        WALEdit edit = new WALEdit();
        edit.add(new KeyValue(row, family, qualifier, time, KeyValue.Type.Put, value));
        return new HLog.Entry(new HLogKey(region, table, ++seq, time, HConstants.DEFAULT_CLUSTER_ID), edit);
    }

    private void injectEmptyFile(String suffix, boolean closeFile) throws IOException {
        HLog.Writer writer = HLogFactory.createWALWriter((FileSystem)this.fs, (Path)new Path(HLOGDIR, HLOG_FILE_PREFIX + suffix), (Configuration)this.conf);
        if (closeFile) {
            writer.close();
        }
    }

    private void listLogs(FileSystem fs, Path dir) throws IOException {
        for (FileStatus file : fs.listStatus(dir)) {
            System.out.println(file.getPath());
        }
    }

    private int compareHLogSplitDirs(Path p1, Path p2) throws IOException {
        FileStatus[] f1 = this.fs.listStatus(p1);
        FileStatus[] f2 = this.fs.listStatus(p2);
        Assert.assertNotNull((String)("Path " + p1 + " doesn't exist"), (Object)f1);
        Assert.assertNotNull((String)("Path " + p2 + " doesn't exist"), (Object)f2);
        System.out.println("Files in " + p1 + ": " + Joiner.on((String)",").join((Object[])FileUtil.stat2Paths((FileStatus[])f1)));
        System.out.println("Files in " + p2 + ": " + Joiner.on((String)",").join((Object[])FileUtil.stat2Paths((FileStatus[])f2)));
        Assert.assertEquals((long)f1.length, (long)f2.length);
        for (int i = 0; i < f1.length; ++i) {
            Path rd1 = HLogUtil.getRegionDirRecoveredEditsDir((Path)f1[i].getPath());
            FileStatus[] rd1fs = this.fs.listStatus(rd1);
            Assert.assertEquals((long)1L, (long)rd1fs.length);
            Path rd2 = HLogUtil.getRegionDirRecoveredEditsDir((Path)f2[i].getPath());
            FileStatus[] rd2fs = this.fs.listStatus(rd2);
            Assert.assertEquals((long)1L, (long)rd2fs.length);
            if (this.logsAreEqual(rd1fs[0].getPath(), rd2fs[0].getPath())) continue;
            return -1;
        }
        return 0;
    }

    private boolean logsAreEqual(Path p1, Path p2) throws IOException {
        HLog.Entry entry1;
        HLog.Reader in1 = HLogFactory.createReader((FileSystem)this.fs, (Path)p1, (Configuration)this.conf);
        HLog.Reader in2 = HLogFactory.createReader((FileSystem)this.fs, (Path)p2, (Configuration)this.conf);
        while ((entry1 = in1.next()) != null) {
            HLog.Entry entry2 = in2.next();
            if (entry1.getKey().compareTo(entry2.getKey()) == 0 && entry1.getEdit().toString().equals(entry2.getEdit().toString())) continue;
            return false;
        }
        return true;
    }

    static {
        GROUP = new String[]{"supergroup"};
    }

    class ZombieNewLogWriterRegionServer
    extends Thread {
        AtomicBoolean stop;
        CountDownLatch latch;

        public ZombieNewLogWriterRegionServer(CountDownLatch latch, AtomicBoolean stop) {
            super("ZombieNewLogWriterRegionServer");
            this.latch = latch;
            this.stop = stop;
        }

        @Override
        public void run() {
            if (this.stop.get()) {
                return;
            }
            Path tableDir = FSUtils.getTableDir((Path)HBASEDIR, (TableName)TABLE_NAME);
            Path regionDir = new Path(tableDir, (String)REGIONS.get(0));
            Path recoveredEdits = new Path(regionDir, "recovered.edits");
            String region = "juliet";
            Path julietLog = new Path(HLOGDIR, "hlog.dat..juliet");
            try {
                while (!TestHLogSplit.this.fs.exists(recoveredEdits) && !this.stop.get()) {
                    LOG.info((Object)"Juliet: split not started, sleeping a bit...");
                    Threads.sleep((long)10L);
                }
                TestHLogSplit.this.fs.mkdirs(new Path(tableDir, region));
                HLog.Writer writer = HLogFactory.createWALWriter((FileSystem)TestHLogSplit.this.fs, (Path)julietLog, (Configuration)TestHLogSplit.this.conf);
                TestHLogSplit.appendEntry(writer, TableName.valueOf((String)"juliet"), "juliet".getBytes(), "r".getBytes(), FAMILY, QUALIFIER, VALUE, 0L);
                writer.close();
                LOG.info((Object)("Juliet file creator: created file " + julietLog));
                this.latch.countDown();
            }
            catch (IOException e1) {
                LOG.error((Object)("Failed to create file " + julietLog), (Throwable)e1);
                Assert.assertTrue((String)("Failed to create file " + julietLog), (boolean)false);
            }
        }
    }

    static class ZombieLastLogWriterRegionServer
    extends Thread {
        final AtomicLong editsCount;
        final AtomicBoolean stop;
        final String region;
        final Configuration conf;
        final User user;

        public ZombieLastLogWriterRegionServer(Configuration conf, AtomicLong counter, AtomicBoolean stop, String region) throws IOException, InterruptedException {
            super("ZombieLastLogWriterRegionServer");
            this.setDaemon(true);
            this.stop = stop;
            this.editsCount = counter;
            this.region = region;
            this.conf = HBaseConfiguration.create((Configuration)conf);
            this.user = User.createUserForTesting((Configuration)this.conf, (String)ZOMBIE, (String[])GROUP);
        }

        @Override
        public void run() {
            try {
                this.doWriting();
            }
            catch (IOException e) {
                LOG.warn((Object)(this.getName() + " Writer exiting " + e));
            }
            catch (InterruptedException e) {
                LOG.warn((Object)(this.getName() + " Writer exiting " + e));
            }
        }

        private void doWriting() throws IOException, InterruptedException {
            this.user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    int walToKeepOpen = 2;
                    int numOfWriters = walToKeepOpen + 1;
                    HLog.Writer[] writers = null;
                    try {
                        DistributedFileSystem dfs = (DistributedFileSystem)FileSystem.get((Configuration)ZombieLastLogWriterRegionServer.this.conf);
                        writers = TestHLogSplit.generateHLogs(dfs, numOfWriters, 10, walToKeepOpen);
                    }
                    catch (IOException e1) {
                        throw new RuntimeException("Failed", e1);
                    }
                    ZombieLastLogWriterRegionServer.this.editsCount.addAndGet(numOfWriters * 10);
                    HLog.Writer writer = writers[walToKeepOpen];
                    ZombieLastLogWriterRegionServer.this.loop(writer);
                    return null;
                }
            });
        }

        private void loop(HLog.Writer writer) {
            byte[] regionBytes = Bytes.toBytes((String)this.region);
            block5: while (true) {
                try {
                    while (true) {
                        long seq = TestHLogSplit.appendEntry(writer, TABLE_NAME, regionBytes, ("r" + this.editsCount.get()).getBytes(), regionBytes, QUALIFIER, VALUE, 0L);
                        long count = this.editsCount.incrementAndGet();
                        TestHLogSplit.flushToConsole(this.getName() + " sync count=" + count + ", seq=" + seq);
                        try {
                            Thread.sleep(1L);
                            continue block5;
                        }
                        catch (InterruptedException e) {
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException ex) {
                    TestHLogSplit.flushToConsole(this.getName() + " ex " + ex.toString());
                    if (ex instanceof RemoteException) {
                        TestHLogSplit.flushToConsole("Juliet: got RemoteException " + ex.getMessage() + " while writing " + (this.editsCount.get() + 1L));
                        break;
                    }
                    TestHLogSplit.flushToConsole(this.getName() + " failed to write....at " + this.editsCount.get());
                    Assert.assertTrue((String)("Failed to write " + this.editsCount.get()), (boolean)false);
                    break;
                }
                catch (Throwable t) {
                    TestHLogSplit.flushToConsole(this.getName() + " HOW? " + t);
                    t.printStackTrace();
                    break;
                }
            }
            TestHLogSplit.flushToConsole(this.getName() + " Writer exiting");
        }
    }

    static enum Corruptions {
        INSERT_GARBAGE_ON_FIRST_LINE,
        INSERT_GARBAGE_IN_THE_MIDDLE,
        APPEND_GARBAGE,
        TRUNCATE,
        TRUNCATE_TRAILER;

    }
}

