/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestMiniBatchOperationInProgress {
    @Test
    public void testMiniBatchOperationInProgressMethods() {
        Object[] operations = new Pair[10];
        OperationStatus[] retCodeDetails = new OperationStatus[10];
        WALEdit[] walEditsFromCoprocessors = new WALEdit[10];
        for (int i = 0; i < 10; ++i) {
            operations[i] = new Pair((Object)new Put(Bytes.toBytes((int)i)), null);
        }
        MiniBatchOperationInProgress miniBatch = new MiniBatchOperationInProgress(operations, retCodeDetails, walEditsFromCoprocessors, 0, 5);
        Assert.assertEquals((long)5L, (long)miniBatch.size());
        Assert.assertTrue((boolean)Bytes.equals((byte[])Bytes.toBytes((int)0), (byte[])((Mutation)((Pair)miniBatch.getOperation(0)).getFirst()).getRow()));
        Assert.assertTrue((boolean)Bytes.equals((byte[])Bytes.toBytes((int)2), (byte[])((Mutation)((Pair)miniBatch.getOperation(2)).getFirst()).getRow()));
        Assert.assertTrue((boolean)Bytes.equals((byte[])Bytes.toBytes((int)4), (byte[])((Mutation)((Pair)miniBatch.getOperation(4)).getFirst()).getRow()));
        try {
            miniBatch.getOperation(5);
            Assert.fail((String)"Should throw Exception while accessing out of range");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        miniBatch.setOperationStatus(1, OperationStatus.FAILURE);
        Assert.assertEquals((Object)OperationStatus.FAILURE, (Object)retCodeDetails[1]);
        try {
            miniBatch.setOperationStatus(6, OperationStatus.FAILURE);
            Assert.fail((String)"Should throw Exception while accessing out of range");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            miniBatch.setWalEdit(5, new WALEdit());
            Assert.fail((String)"Should throw Exception while accessing out of range");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        miniBatch = new MiniBatchOperationInProgress(operations, retCodeDetails, walEditsFromCoprocessors, 7, 10);
        try {
            miniBatch.setWalEdit(-1, new WALEdit());
            Assert.fail((String)"Should throw Exception while accessing out of range");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            miniBatch.getOperation(-1);
            Assert.fail((String)"Should throw Exception while accessing out of range");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            miniBatch.getOperation(3);
            Assert.fail((String)"Should throw Exception while accessing out of range");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            miniBatch.getOperationStatus(9);
            Assert.fail((String)"Should throw Exception while accessing out of range");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            miniBatch.setOperationStatus(3, OperationStatus.FAILURE);
            Assert.fail((String)"Should throw Exception while accessing out of range");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        Assert.assertTrue((boolean)Bytes.equals((byte[])Bytes.toBytes((int)7), (byte[])((Mutation)((Pair)miniBatch.getOperation(0)).getFirst()).getRow()));
        Assert.assertTrue((boolean)Bytes.equals((byte[])Bytes.toBytes((int)9), (byte[])((Mutation)((Pair)miniBatch.getOperation(2)).getFirst()).getRow()));
        miniBatch.setOperationStatus(1, OperationStatus.SUCCESS);
        Assert.assertEquals((Object)OperationStatus.SUCCESS, (Object)retCodeDetails[8]);
        WALEdit wal = new WALEdit();
        miniBatch.setWalEdit(0, wal);
        Assert.assertEquals((Object)wal, (Object)walEditsFromCoprocessors[7]);
    }
}

