/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.SimpleBlockCache;
import org.apache.hadoop.hbase.util.Bytes;

public class RandomSeek {
    private static List<String> slurp(String fname) throws IOException {
        String str;
        BufferedReader istream = new BufferedReader(new FileReader(fname));
        ArrayList<String> l = new ArrayList<String>();
        while ((str = istream.readLine()) != null) {
            String[] parts = str.split(",");
            l.add(parts[0] + ":" + parts[1] + ":" + parts[2]);
        }
        istream.close();
        return l;
    }

    private static String randKey(List<String> keys) {
        Random r = new Random();
        return "2" + Integer.toString(7 + r.nextInt(2)) + Integer.toString(r.nextInt(100));
    }

    public static void main(String[] argv) throws IOException {
        Configuration conf = new Configuration();
        conf.setInt("io.file.buffer.size", 65536);
        RawLocalFileSystem rlfs = new RawLocalFileSystem();
        rlfs.setConf(conf);
        LocalFileSystem lfs = new LocalFileSystem((FileSystem)rlfs);
        Path path = new Path("/Users/ryan/rfile.big.txt");
        long start = System.currentTimeMillis();
        SimpleBlockCache cache = new SimpleBlockCache();
        CacheConfig cacheConf = new CacheConfig((BlockCache)cache, true, false, false, false, false, false, false);
        HFile.Reader reader = HFile.createReader((FileSystem)lfs, (Path)path, (CacheConfig)cacheConf, (Configuration)conf);
        reader.loadFileInfo();
        System.out.println(reader.getTrailer());
        long end = System.currentTimeMillis();
        System.out.println("Index read time: " + (end - start));
        List<String> keys = RandomSeek.slurp("/Users/ryan/xaa.50k");
        HFileScanner scanner = reader.getScanner(false, true);
        long totalBytes = 0L;
        int notFound = 0;
        start = System.nanoTime();
        for (int count = 0; count < 500000; ++count) {
            String key = RandomSeek.randKey(keys);
            byte[] bkey = Bytes.toBytes((String)key);
            int res = scanner.seekTo(bkey);
            if (res == 0) {
                ByteBuffer k = scanner.getKey();
                ByteBuffer v = scanner.getValue();
                totalBytes += (long)k.limit();
                totalBytes += (long)v.limit();
            } else {
                ++notFound;
            }
            if (res == -1) {
                scanner.seekTo();
            }
            for (int i = 0; i < 1000 && scanner.next(); ++i) {
                ByteBuffer k = scanner.getKey();
                ByteBuffer v = scanner.getValue();
                totalBytes += (long)k.limit();
                totalBytes += (long)v.limit();
            }
            if (count % 1000 != 0) continue;
            end = System.nanoTime();
            System.out.println("Cache block count: " + cache.size() + " dumped: " + cache.dumps);
            double msTime = (double)(end - start) / 1000000.0;
            System.out.println("Seeked: " + count + " in " + msTime + " (ms) " + 1000.0 / msTime + " seeks/ms " + msTime / 1000.0 + " ms/seek");
            start = System.nanoTime();
        }
        System.out.println("Total bytes: " + totalBytes + " not found: " + notFound);
    }
}

