/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import com.google.protobuf.HBaseZeroCopyByteString;
import com.google.protobuf.Message;
import com.google.protobuf.ServiceException;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.coprocessor.ColumnAggregationEndpoint;
import org.apache.hadoop.hbase.coprocessor.ColumnAggregationEndpointNullResponse;
import org.apache.hadoop.hbase.coprocessor.ColumnAggregationEndpointWithErrors;
import org.apache.hadoop.hbase.coprocessor.ProtobufCoprocessorService;
import org.apache.hadoop.hbase.coprocessor.protobuf.generated.ColumnAggregationProtos;
import org.apache.hadoop.hbase.coprocessor.protobuf.generated.ColumnAggregationWithErrorsProtos;
import org.apache.hadoop.hbase.coprocessor.protobuf.generated.ColumnAggregationWithNullResponseProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestBatchCoprocessorEndpoint {
    private static final Log LOG = LogFactory.getLog(TestBatchCoprocessorEndpoint.class);
    private static final TableName TEST_TABLE = TableName.valueOf((String)"TestTable");
    private static final byte[] TEST_FAMILY = Bytes.toBytes((String)"TestFamily");
    private static final byte[] TEST_QUALIFIER = Bytes.toBytes((String)"TestQualifier");
    private static byte[] ROW = Bytes.toBytes((String)"testRow");
    private static final int ROWSIZE = 20;
    private static final int rowSeperator1 = 5;
    private static final int rowSeperator2 = 12;
    private static byte[][] ROWS = TestBatchCoprocessorEndpoint.makeN(ROW, 20);
    private static HBaseTestingUtility util = new HBaseTestingUtility();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = util.getConfiguration();
        conf.setStrings("hbase.coprocessor.region.classes", new String[]{ColumnAggregationEndpoint.class.getName(), ProtobufCoprocessorService.class.getName(), ColumnAggregationEndpointWithErrors.class.getName(), ColumnAggregationEndpointNullResponse.class.getName()});
        conf.setStrings("hbase.coprocessor.master.classes", new String[]{ProtobufCoprocessorService.class.getName()});
        util.startMiniCluster(2);
        HBaseAdmin admin = new HBaseAdmin(conf);
        HTableDescriptor desc = new HTableDescriptor(TEST_TABLE);
        desc.addFamily(new HColumnDescriptor(TEST_FAMILY));
        admin.createTable(desc, (byte[][])new byte[][]{ROWS[5], ROWS[12]});
        util.waitUntilAllRegionsAssigned(TEST_TABLE);
        admin.close();
        HTable table = new HTable(conf, TEST_TABLE);
        for (int i = 0; i < 20; ++i) {
            Put put = new Put(ROWS[i]);
            put.add(TEST_FAMILY, TEST_QUALIFIER, Bytes.toBytes((int)i));
            table.put(put);
        }
        table.close();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        util.shutdownMiniCluster();
    }

    @Test
    public void testAggregationNullResponse() throws Throwable {
        HTable table = new HTable(util.getConfiguration(), TEST_TABLE);
        ColumnAggregationWithNullResponseProtos.SumRequest.Builder builder = ColumnAggregationWithNullResponseProtos.SumRequest.newBuilder();
        builder.setFamily(HBaseZeroCopyByteString.wrap((byte[])TEST_FAMILY));
        if (TEST_QUALIFIER != null && TEST_QUALIFIER.length > 0) {
            builder.setQualifier(HBaseZeroCopyByteString.wrap((byte[])TEST_QUALIFIER));
        }
        Map results = table.batchCoprocessorService(ColumnAggregationWithNullResponseProtos.ColumnAggregationServiceNullResponse.getDescriptor().findMethodByName("sum"), (Message)builder.build(), ROWS[0], ROWS[ROWS.length - 1], (Message)ColumnAggregationWithNullResponseProtos.SumResponse.getDefaultInstance());
        int sumResult = 0;
        int expectedResult = 0;
        for (Map.Entry e : results.entrySet()) {
            LOG.info((Object)("Got value " + ((ColumnAggregationWithNullResponseProtos.SumResponse)e.getValue()).getSum() + " for region " + Bytes.toStringBinary((byte[])((byte[])e.getKey()))));
            sumResult = (int)((long)sumResult + ((ColumnAggregationWithNullResponseProtos.SumResponse)e.getValue()).getSum());
        }
        for (int i = 0; i < 12; ++i) {
            expectedResult += i;
        }
        Assert.assertEquals((String)"Invalid result", (long)expectedResult, (long)sumResult);
        table.close();
    }

    private static byte[][] makeN(byte[] base, int n) {
        byte[][] ret = new byte[n][];
        for (int i = 0; i < n; ++i) {
            ret[i] = Bytes.add((byte[])base, (byte[])Bytes.toBytes((String)String.format("%02d", i)));
        }
        return ret;
    }

    private Map<byte[], ColumnAggregationProtos.SumResponse> sum(HTable table, byte[] family, byte[] qualifier, byte[] start, byte[] end) throws ServiceException, Throwable {
        ColumnAggregationProtos.SumRequest.Builder builder = ColumnAggregationProtos.SumRequest.newBuilder();
        builder.setFamily(HBaseZeroCopyByteString.wrap((byte[])family));
        if (qualifier != null && qualifier.length > 0) {
            builder.setQualifier(HBaseZeroCopyByteString.wrap((byte[])qualifier));
        }
        return table.batchCoprocessorService(ColumnAggregationProtos.ColumnAggregationService.getDescriptor().findMethodByName("sum"), (Message)builder.build(), start, end, (Message)ColumnAggregationProtos.SumResponse.getDefaultInstance());
    }

    @Test
    public void testAggregationWithReturnValue() throws Throwable {
        HTable table = new HTable(util.getConfiguration(), TEST_TABLE);
        Map<byte[], ColumnAggregationProtos.SumResponse> results = this.sum(table, TEST_FAMILY, TEST_QUALIFIER, ROWS[0], ROWS[ROWS.length - 1]);
        int sumResult = 0;
        int expectedResult = 0;
        for (Map.Entry<byte[], ColumnAggregationProtos.SumResponse> e : results.entrySet()) {
            LOG.info((Object)("Got value " + e.getValue().getSum() + " for region " + Bytes.toStringBinary((byte[])e.getKey())));
            sumResult = (int)((long)sumResult + e.getValue().getSum());
        }
        for (int i = 0; i < 20; ++i) {
            expectedResult += i;
        }
        Assert.assertEquals((String)"Invalid result", (long)expectedResult, (long)sumResult);
        results.clear();
        results = this.sum(table, TEST_FAMILY, TEST_QUALIFIER, ROWS[5], ROWS[ROWS.length - 1]);
        sumResult = 0;
        expectedResult = 0;
        for (Map.Entry<byte[], ColumnAggregationProtos.SumResponse> e : results.entrySet()) {
            LOG.info((Object)("Got value " + e.getValue().getSum() + " for region " + Bytes.toStringBinary((byte[])e.getKey())));
            sumResult = (int)((long)sumResult + e.getValue().getSum());
        }
        for (int i = 5; i < 20; ++i) {
            expectedResult += i;
        }
        Assert.assertEquals((String)"Invalid result", (long)expectedResult, (long)sumResult);
        table.close();
    }

    @Test
    public void testAggregation() throws Throwable {
        HTable table = new HTable(util.getConfiguration(), TEST_TABLE);
        Map<byte[], ColumnAggregationProtos.SumResponse> results = this.sum(table, TEST_FAMILY, TEST_QUALIFIER, ROWS[0], ROWS[ROWS.length - 1]);
        int sumResult = 0;
        int expectedResult = 0;
        for (Map.Entry<byte[], ColumnAggregationProtos.SumResponse> e : results.entrySet()) {
            LOG.info((Object)("Got value " + e.getValue().getSum() + " for region " + Bytes.toStringBinary((byte[])e.getKey())));
            sumResult = (int)((long)sumResult + e.getValue().getSum());
        }
        for (int i = 0; i < 20; ++i) {
            expectedResult += i;
        }
        Assert.assertEquals((String)"Invalid result", (long)expectedResult, (long)sumResult);
        results = this.sum(table, TEST_FAMILY, TEST_QUALIFIER, ROWS[5], ROWS[ROWS.length - 1]);
        sumResult = 0;
        expectedResult = 0;
        for (Map.Entry<byte[], ColumnAggregationProtos.SumResponse> e : results.entrySet()) {
            LOG.info((Object)("Got value " + e.getValue().getSum() + " for region " + Bytes.toStringBinary((byte[])e.getKey())));
            sumResult = (int)((long)sumResult + e.getValue().getSum());
        }
        for (int i = 5; i < 20; ++i) {
            expectedResult += i;
        }
        Assert.assertEquals((String)"Invalid result", (long)expectedResult, (long)sumResult);
        table.close();
    }

    @Test
    public void testAggregationWithErrors() throws Throwable {
        HTable table = new HTable(util.getConfiguration(), TEST_TABLE);
        final Map results = Collections.synchronizedMap(new TreeMap(Bytes.BYTES_COMPARATOR));
        ColumnAggregationWithErrorsProtos.SumRequest.Builder builder = ColumnAggregationWithErrorsProtos.SumRequest.newBuilder();
        builder.setFamily(HBaseZeroCopyByteString.wrap((byte[])TEST_FAMILY));
        if (TEST_QUALIFIER != null && TEST_QUALIFIER.length > 0) {
            builder.setQualifier(HBaseZeroCopyByteString.wrap((byte[])TEST_QUALIFIER));
        }
        boolean hasError = false;
        try {
            table.batchCoprocessorService(ColumnAggregationWithErrorsProtos.ColumnAggregationServiceWithErrors.getDescriptor().findMethodByName("sum"), (Message)builder.build(), ROWS[0], ROWS[ROWS.length - 1], (Message)ColumnAggregationWithErrorsProtos.SumResponse.getDefaultInstance(), (Batch.Callback)new Batch.Callback<ColumnAggregationWithErrorsProtos.SumResponse>(){

                public void update(byte[] region, byte[] row, ColumnAggregationWithErrorsProtos.SumResponse result) {
                    results.put(region, result);
                }
            });
        }
        catch (Throwable t) {
            LOG.info((Object)"Exceptions in coprocessor service", t);
            hasError = true;
        }
        int sumResult = 0;
        int expectedResult = 0;
        for (Map.Entry e : results.entrySet()) {
            LOG.info((Object)("Got value " + ((ColumnAggregationWithErrorsProtos.SumResponse)e.getValue()).getSum() + " for region " + Bytes.toStringBinary((byte[])((byte[])e.getKey()))));
            sumResult = (int)((long)sumResult + ((ColumnAggregationWithErrorsProtos.SumResponse)e.getValue()).getSum());
        }
        for (int i = 0; i < 12; ++i) {
            expectedResult += i;
        }
        Assert.assertEquals((String)"Invalid result", (long)expectedResult, (long)sumResult);
        Assert.assertTrue((boolean)hasError);
        table.close();
    }
}

