// Autogenerated Jamon implementation
// /home/stack/0.96.1RC2/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/master/BackupMasterStatusTmpl.jamon

package org.apache.hadoop.hbase.tmpl.master;

// 23, 1
import java.util.*;
// 24, 1
import org.apache.hadoop.hbase.ServerName;
// 25, 1
import org.apache.hadoop.hbase.ClusterStatus;
// 26, 1
import org.apache.hadoop.hbase.master.HMaster;

public class BackupMasterStatusTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl.Intf

{
  private final HMaster master;
  protected static org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl.ImplData p_implData)
  {
    return p_implData;
  }
  public BackupMasterStatusTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    master = p_implData.getMaster();
  }
  
  public void renderNoFlush(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 28, 1
    
Collection<ServerName> masters = null;

if (master.isActiveMaster()) {
  ClusterStatus status = master.getClusterStatus();
  masters = status.getBackupMasters();
} else{
  ServerName sn = master.getMasterAddressManager().getMasterAddress();
  assert sn != null : "Failed to retreive master's ServerName!";
  masters = Collections.singletonList(sn);
}

    // 41, 1
    
ServerName [] serverNames = masters.toArray(new ServerName[masters.size()]);

    // 44, 1
    if ((!master.isActiveMaster()) )
    {
      // 44, 35
      jamonWriter.write("\n    ");
      // 45, 5
      if (serverNames[0] != null )
      {
        // 45, 35
        jamonWriter.write("\n        <h2>Master</h2>\n        <a href=\"//");
        // 47, 20
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverNames[0].getHostname()), jamonWriter);
        // 47, 54
        jamonWriter.write(":");
        // 47, 55
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(master.getConfiguration().getInt("hbase.master.info.port", 60010)), jamonWriter);
        // 47, 126
        jamonWriter.write("/master-status\" target=\"_blank\">");
        // 47, 158
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverNames[0].getHostname()), jamonWriter);
        // 47, 192
        jamonWriter.write("</a>\n    ");
      }
      // 48, 5
      else
      {
        // 48, 12
        jamonWriter.write("\n        Unable to parse master hostname.\n    ");
      }
      // 50, 11
      jamonWriter.write("\n");
    }
    // 51, 1
    else
    {
      // 51, 8
      jamonWriter.write("\n    <h2>Backup Masters</h2>\n\n    <table class=\"table table-striped\">\n    <tr>\n        <th>ServerName</th>\n        <th>Port</th>\n        <th>Start Time</th>\n    </tr>\n    ");
      // 60, 5
      
    Arrays.sort(serverNames);
    for (ServerName serverName : serverNames) {
    
      // 64, 5
      jamonWriter.write("<tr>\n        <td><a href=\"//");
      // 65, 24
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName.getHostname()), jamonWriter);
      // 65, 54
      jamonWriter.write(":");
      // 65, 55
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(master.getConfiguration().getInt("hbase.master.info.port", 60010)), jamonWriter);
      // 65, 126
      jamonWriter.write("/master-status\" target=\"_blank\">");
      // 65, 158
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName.getHostname()), jamonWriter);
      // 65, 188
      jamonWriter.write("</a></td>\n        <td>");
      // 66, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName.getPort()), jamonWriter);
      // 66, 39
      jamonWriter.write("</td>\n        <td>");
      // 67, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(new Date(serverName.getStartcode())), jamonWriter);
      // 67, 54
      jamonWriter.write("</td>\n    </tr>\n    ");
      // 69, 5
      
    }
    
      // 72, 5
      jamonWriter.write("<tr><td>Total:");
      // 72, 19
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf((masters != null) ? masters.size() : 0), jamonWriter);
      // 72, 63
      jamonWriter.write("</td>\n    </table>\n");
    }
    // 74, 7
    jamonWriter.write("\n");
  }
  
  
}
