/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import java.util.Iterator;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.rest.model.StorageClusterStatusModel;
import org.apache.hadoop.hbase.rest.model.TestModelBase;
import org.apache.hadoop.hbase.testclassification.RestTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;

@Category(value={RestTests.class, SmallTests.class})
public class TestStorageClusterStatusModel
extends TestModelBase<StorageClusterStatusModel> {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestStorageClusterStatusModel.class);

    public TestStorageClusterStatusModel() throws Exception {
        super(StorageClusterStatusModel.class);
        this.AS_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><ClusterStatus averageLoad=\"1.0\" regions=\"2\" requests=\"0\"><DeadNodes/><LiveNodes><Node heapSizeMB=\"128\" maxHeapSizeMB=\"1024\" name=\"test1\" requests=\"0\" startCode=\"1245219839331\"><Region currentCompactedKVs=\"1\" memstoreSizeMB=\"0\" name=\"aGJhc2U6cm9vdCwsMA==\" readRequestsCount=\"1\" rootIndexSizeKB=\"1\" storefileIndexSizeKB=\"0\" storefileSizeMB=\"0\" storefiles=\"1\" stores=\"1\" totalCompactingKVs=\"1\" totalStaticBloomSizeKB=\"1\" totalStaticIndexSizeKB=\"1\" writeRequestsCount=\"2\"/></Node><Node heapSizeMB=\"512\" maxHeapSizeMB=\"1024\" name=\"test2\" requests=\"0\" startCode=\"1245239331198\"><Region currentCompactedKVs=\"1\" memstoreSizeMB=\"0\" name=\"aGJhc2U6bWV0YSwsMTI0NjAwMDA0MzcyNA==\" readRequestsCount=\"1\" rootIndexSizeKB=\"1\" storefileIndexSizeKB=\"0\" storefileSizeMB=\"0\" storefiles=\"1\" stores=\"1\" totalCompactingKVs=\"1\" totalStaticBloomSizeKB=\"1\" totalStaticIndexSizeKB=\"1\" writeRequestsCount=\"2\"/></Node></LiveNodes></ClusterStatus>";
        this.AS_PB = "Cj8KBXRlc3QxEOO6i+eeJBgAIIABKIAIMicKDWhiYXNlOnJvb3QsLDAQARgBIAAoADAAOAFAAkgBUAFYAWABaAEKSwoFdGVzdDIQ/pKx8J4kGAAggAQogAgyMwoZaGJhc2U6bWV0YSwsMTI0NjAwMDA0MzcyNBABGAEgACgAMAA4AUACSAFQAVgBYAFoARgCIAApAAAAAAAA8D8=";
        this.AS_JSON = "{\"regions\":2,\"requests\":0,\"averageLoad\":1.0,\"LiveNodes\":[{\"name\":\"test1\",\"Region\":[{\"name\":\"aGJhc2U6cm9vdCwsMA==\",\"stores\":1,\"storefiles\":1,\"storefileSizeMB\":0,\"memStoreSizeMB\":0,\"storefileIndexSizeKB\":0,\"readRequestsCount\":1,\"writeRequestsCount\":2,\"rootIndexSizeKB\":1,\"totalStaticIndexSizeKB\":1,\"totalStaticBloomSizeKB\":1,\"totalCompactingKVs\":1,\"currentCompactedKVs\":1}],\"requests\":0,\"startCode\":1245219839331,\"heapSizeMB\":128,\"maxHeapSizeMB\":1024},{\"name\":\"test2\",\"Region\":[{\"name\":\"aGJhc2U6bWV0YSwsMTI0NjAwMDA0MzcyNA==\",\"stores\":1,\"storefiles\":1,\"storefileSizeMB\":0,\"memStoreSizeMB\":0,\"storefileIndexSizeKB\":0,\"readRequestsCount\":1,\"writeRequestsCount\":2,\"rootIndexSizeKB\":1,\"totalStaticIndexSizeKB\":1,\"totalStaticBloomSizeKB\":1,\"totalCompactingKVs\":1,\"currentCompactedKVs\":1}],\"requests\":0,\"startCode\":1245239331198,\"heapSizeMB\":512,\"maxHeapSizeMB\":1024}],\"DeadNodes\":[]}";
    }

    @Override
    protected StorageClusterStatusModel buildTestModel() {
        StorageClusterStatusModel model = new StorageClusterStatusModel();
        model.setRegions(2);
        model.setRequests(0L);
        model.setAverageLoad(1.0);
        model.addLiveNode("test1", 1245219839331L, 128, 1024).addRegion(Bytes.toBytes((String)"hbase:root,,0"), 1, 1, 0, 0, 0L, 1L, 2L, 1, 1, 1, 1L, 1L);
        model.addLiveNode("test2", 1245239331198L, 512, 1024).addRegion(Bytes.toBytes((String)(TableName.META_TABLE_NAME + ",,1246000043724")), 1, 1, 0, 0, 0L, 1L, 2L, 1, 1, 1, 1L, 1L);
        return model;
    }

    @Override
    protected void checkModel(StorageClusterStatusModel model) {
        Assert.assertEquals((long)2L, (long)model.getRegions());
        Assert.assertEquals((long)0L, (long)model.getRequests());
        Assert.assertEquals((double)1.0, (double)model.getAverageLoad(), (double)0.0);
        Iterator nodes = model.getLiveNodes().iterator();
        StorageClusterStatusModel.Node node = (StorageClusterStatusModel.Node)nodes.next();
        Assert.assertEquals((Object)"test1", (Object)node.getName());
        Assert.assertEquals((long)1245219839331L, (long)node.getStartCode());
        Assert.assertEquals((long)128L, (long)node.getHeapSizeMB());
        Assert.assertEquals((long)1024L, (long)node.getMaxHeapSizeMB());
        Iterator regions = node.getRegions().iterator();
        StorageClusterStatusModel.Node.Region region = (StorageClusterStatusModel.Node.Region)regions.next();
        Assert.assertTrue((boolean)Bytes.toString((byte[])region.getName()).equals("hbase:root,,0"));
        Assert.assertEquals((long)1L, (long)region.getStores());
        Assert.assertEquals((long)1L, (long)region.getStorefiles());
        Assert.assertEquals((long)0L, (long)region.getStorefileSizeMB());
        Assert.assertEquals((long)0L, (long)region.getMemStoreSizeMB());
        Assert.assertEquals((long)0L, (long)region.getStorefileIndexSizeKB());
        Assert.assertEquals((long)1L, (long)region.getReadRequestsCount());
        Assert.assertEquals((long)2L, (long)region.getWriteRequestsCount());
        Assert.assertEquals((long)1L, (long)region.getRootIndexSizeKB());
        Assert.assertEquals((long)1L, (long)region.getTotalStaticIndexSizeKB());
        Assert.assertEquals((long)1L, (long)region.getTotalStaticBloomSizeKB());
        Assert.assertEquals((long)1L, (long)region.getTotalCompactingKVs());
        Assert.assertEquals((long)1L, (long)region.getCurrentCompactedKVs());
        Assert.assertFalse((boolean)regions.hasNext());
        node = (StorageClusterStatusModel.Node)nodes.next();
        Assert.assertEquals((Object)"test2", (Object)node.getName());
        Assert.assertEquals((long)1245239331198L, (long)node.getStartCode());
        Assert.assertEquals((long)512L, (long)node.getHeapSizeMB());
        Assert.assertEquals((long)1024L, (long)node.getMaxHeapSizeMB());
        regions = node.getRegions().iterator();
        region = (StorageClusterStatusModel.Node.Region)regions.next();
        Assert.assertEquals((Object)Bytes.toString((byte[])region.getName()), (Object)(TableName.META_TABLE_NAME + ",,1246000043724"));
        Assert.assertEquals((long)1L, (long)region.getStores());
        Assert.assertEquals((long)1L, (long)region.getStorefiles());
        Assert.assertEquals((long)0L, (long)region.getStorefileSizeMB());
        Assert.assertEquals((long)0L, (long)region.getMemStoreSizeMB());
        Assert.assertEquals((long)0L, (long)region.getStorefileIndexSizeKB());
        Assert.assertEquals((long)1L, (long)region.getReadRequestsCount());
        Assert.assertEquals((long)2L, (long)region.getWriteRequestsCount());
        Assert.assertEquals((long)1L, (long)region.getRootIndexSizeKB());
        Assert.assertEquals((long)1L, (long)region.getTotalStaticIndexSizeKB());
        Assert.assertEquals((long)1L, (long)region.getTotalStaticBloomSizeKB());
        Assert.assertEquals((long)1L, (long)region.getTotalCompactingKVs());
        Assert.assertEquals((long)1L, (long)region.getCurrentCompactedKVs());
        Assert.assertFalse((boolean)regions.hasNext());
        Assert.assertFalse((boolean)nodes.hasNext());
    }
}

