/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.CheckAndMutate;
import org.apache.hadoop.hbase.client.CheckAndMutateResult;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.rest.client.Client;
import org.apache.hadoop.hbase.rest.client.Response;
import org.apache.hadoop.hbase.rest.model.CellModel;
import org.apache.hadoop.hbase.rest.model.CellSetModel;
import org.apache.hadoop.hbase.rest.model.RowModel;
import org.apache.hadoop.hbase.rest.model.ScannerModel;
import org.apache.hadoop.hbase.rest.model.TableSchemaModel;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.StringUtils;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RemoteHTable
implements Table {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteHTable.class);
    final Client client;
    final Configuration conf;
    final byte[] name;
    final int maxRetries;
    final long sleepTime;
    private String pathPrefix = "/";

    protected String buildRowSpec(byte[] row, Map familyMap, long startTime, long endTime, int maxVersions) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.pathPrefix);
        sb.append(Bytes.toString((byte[])this.name));
        sb.append('/');
        sb.append(RemoteHTable.toURLEncodedBytes(row));
        Set families = familyMap.entrySet();
        if (families != null) {
            Iterator i = familyMap.entrySet().iterator();
            sb.append('/');
            while (i.hasNext()) {
                Map.Entry e = i.next();
                Collection quals = (Collection)e.getValue();
                if (quals == null || quals.isEmpty()) {
                    sb.append(RemoteHTable.toURLEncodedBytes((byte[])e.getKey()));
                } else {
                    Iterator ii = quals.iterator();
                    while (ii.hasNext()) {
                        sb.append(RemoteHTable.toURLEncodedBytes((byte[])e.getKey()));
                        Object o = ii.next();
                        if (o instanceof byte[]) {
                            sb.append(':');
                            sb.append(RemoteHTable.toURLEncodedBytes((byte[])o));
                        } else if (o instanceof KeyValue) {
                            if (((KeyValue)o).getQualifierLength() != 0) {
                                sb.append(':');
                                sb.append(RemoteHTable.toURLEncodedBytes(CellUtil.cloneQualifier((Cell)((KeyValue)o))));
                            }
                        } else {
                            throw new RuntimeException("object type not handled");
                        }
                        if (!ii.hasNext()) continue;
                        sb.append(',');
                    }
                }
                if (!i.hasNext()) continue;
                sb.append(',');
            }
        }
        if (startTime >= 0L && endTime != Long.MAX_VALUE) {
            sb.append('/');
            sb.append(startTime);
            if (startTime != endTime) {
                sb.append(',');
                sb.append(endTime);
            }
        } else if (endTime != Long.MAX_VALUE) {
            sb.append('/');
            sb.append(endTime);
        }
        if (maxVersions > 1) {
            sb.append("?v=");
            sb.append(maxVersions);
        }
        return sb.toString();
    }

    protected String buildMultiRowSpec(byte[][] rows, int maxVersions) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.pathPrefix);
        sb.append(Bytes.toString((byte[])this.name));
        sb.append("/multiget/");
        if (rows == null || rows.length == 0) {
            return sb.toString();
        }
        sb.append("?");
        for (int i = 0; i < rows.length; ++i) {
            byte[] rk = rows[i];
            if (i != 0) {
                sb.append('&');
            }
            sb.append("row=");
            sb.append(RemoteHTable.toURLEncodedBytes(rk));
        }
        sb.append("&v=");
        sb.append(maxVersions);
        return sb.toString();
    }

    protected Result[] buildResultFromModel(CellSetModel model) {
        ArrayList<Result> results = new ArrayList<Result>();
        for (RowModel row : model.getRows()) {
            ArrayList<KeyValue> kvs = new ArrayList<KeyValue>(row.getCells().size());
            for (CellModel cell : row.getCells()) {
                byte[][] split = CellUtil.parseColumn((byte[])cell.getColumn());
                byte[] column = split[0];
                byte[] qualifier = null;
                if (split.length == 1) {
                    qualifier = HConstants.EMPTY_BYTE_ARRAY;
                } else if (split.length == 2) {
                    qualifier = split[1];
                } else {
                    throw new IllegalArgumentException("Invalid familyAndQualifier provided.");
                }
                kvs.add(new KeyValue(row.getKey(), column, qualifier, cell.getTimestamp(), cell.getValue()));
            }
            results.add(Result.create(kvs));
        }
        return results.toArray(new Result[results.size()]);
    }

    protected CellSetModel buildModelFromPut(Put put) {
        RowModel row = new RowModel(put.getRow());
        long ts = put.getTimestamp();
        for (List cells : put.getFamilyCellMap().values()) {
            for (Cell cell : cells) {
                row.addCell(new CellModel(CellUtil.cloneFamily((Cell)cell), CellUtil.cloneQualifier((Cell)cell), ts != Long.MAX_VALUE ? ts : cell.getTimestamp(), CellUtil.cloneValue((Cell)cell)));
            }
        }
        CellSetModel model = new CellSetModel();
        model.addRow(row);
        return model;
    }

    public RemoteHTable(Client client, String name) {
        this(client, HBaseConfiguration.create(), Bytes.toBytes((String)name));
    }

    public RemoteHTable(Client client, Configuration conf, String name) {
        this(client, conf, Bytes.toBytes((String)name));
    }

    public RemoteHTable(Client client, Configuration conf, byte[] name) {
        this.client = client;
        this.conf = conf;
        this.name = name;
        this.maxRetries = conf.getInt("hbase.rest.client.max.retries", 10);
        this.sleepTime = conf.getLong("hbase.rest.client.sleep", 1000L);
    }

    public RemoteHTable(Client client, Configuration conf, byte[] name, String pathPrefix) {
        this(client, conf, name);
        this.pathPrefix = pathPrefix + "/";
    }

    public byte[] getTableName() {
        return (byte[])this.name.clone();
    }

    public TableName getName() {
        return TableName.valueOf((byte[])this.name);
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    @Deprecated
    public HTableDescriptor getTableDescriptor() throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.pathPrefix);
        sb.append(Bytes.toString((byte[])this.name));
        sb.append('/');
        sb.append("schema");
        block6: for (int i = 0; i < this.maxRetries; ++i) {
            Response response = this.client.get(sb.toString(), "application/x-protobuf");
            int code = response.getCode();
            switch (code) {
                case 200: {
                    TableSchemaModel schema = new TableSchemaModel();
                    schema.getObjectFromMessage(response.getBody());
                    return schema.getTableDescriptor();
                }
                case 509: {
                    try {
                        Thread.sleep(this.sleepTime);
                        continue block6;
                    }
                    catch (InterruptedException e) {
                        throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                    }
                }
                default: {
                    throw new IOException("schema request returned " + code);
                }
            }
        }
        throw new IOException("schema request timed out");
    }

    public void close() throws IOException {
        this.client.shutdown();
    }

    public Result get(Get get) throws IOException {
        Result[] results;
        TimeRange range = get.getTimeRange();
        String spec = this.buildRowSpec(get.getRow(), get.getFamilyMap(), range.getMin(), range.getMax(), get.getMaxVersions());
        if (get.getFilter() != null) {
            LOG.warn("filters not supported on gets");
        }
        if ((results = this.getResults(spec)).length > 0) {
            if (results.length > 1) {
                LOG.warn("too many results for get (" + results.length + ")");
            }
            return results[0];
        }
        return new Result();
    }

    public Result[] get(List<Get> gets) throws IOException {
        byte[][] rows = new byte[gets.size()][];
        int maxVersions = 1;
        int count = 0;
        for (Get g : gets) {
            if (count == 0) {
                maxVersions = g.getMaxVersions();
            } else if (g.getMaxVersions() != maxVersions) {
                LOG.warn("MaxVersions on Gets do not match, using the first in the list (" + maxVersions + ")");
            }
            if (g.getFilter() != null) {
                LOG.warn("filters not supported on gets");
            }
            rows[count] = g.getRow();
            ++count;
        }
        String spec = this.buildMultiRowSpec(rows, maxVersions);
        return this.getResults(spec);
    }

    private Result[] getResults(String spec) throws IOException {
        block7: for (int i = 0; i < this.maxRetries; ++i) {
            Response response = this.client.get(spec, "application/x-protobuf");
            int code = response.getCode();
            switch (code) {
                case 200: {
                    CellSetModel model = new CellSetModel();
                    model.getObjectFromMessage(response.getBody());
                    Result[] results = this.buildResultFromModel(model);
                    if (results.length > 0) {
                        return results;
                    }
                }
                case 404: {
                    return new Result[0];
                }
                case 509: {
                    try {
                        Thread.sleep(this.sleepTime);
                        continue block7;
                    }
                    catch (InterruptedException e) {
                        throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                    }
                }
                default: {
                    throw new IOException("get request returned " + code);
                }
            }
        }
        throw new IOException("get request timed out");
    }

    public boolean exists(Get get) throws IOException {
        LOG.warn("exists() is really get(), just use get()");
        Result result = this.get(get);
        return result != null && !result.isEmpty();
    }

    public boolean[] exists(List<Get> gets) throws IOException {
        LOG.warn("exists(List<Get>) is really list of get() calls, just use get()");
        boolean[] results = new boolean[gets.size()];
        for (int i = 0; i < results.length; ++i) {
            results[i] = this.exists(gets.get(i));
        }
        return results;
    }

    public void put(Put put) throws IOException {
        CellSetModel model = this.buildModelFromPut(put);
        StringBuilder sb = new StringBuilder();
        sb.append(this.pathPrefix);
        sb.append(Bytes.toString((byte[])this.name));
        sb.append('/');
        sb.append(RemoteHTable.toURLEncodedBytes(put.getRow()));
        block6: for (int i = 0; i < this.maxRetries; ++i) {
            Response response = this.client.put(sb.toString(), "application/x-protobuf", model.createProtobufOutput());
            int code = response.getCode();
            switch (code) {
                case 200: {
                    return;
                }
                case 509: {
                    try {
                        Thread.sleep(this.sleepTime);
                        continue block6;
                    }
                    catch (InterruptedException e) {
                        throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                    }
                }
                default: {
                    throw new IOException("put request failed with " + code);
                }
            }
        }
        throw new IOException("put request timed out");
    }

    /*
     * WARNING - void declaration
     */
    public void put(List<Put> puts) throws IOException {
        void var5_11;
        TreeMap map = new TreeMap(Bytes.BYTES_COMPARATOR);
        for (Put put : puts) {
            byte[] byArray = put.getRow();
            ArrayList cells = (ArrayList)map.get(byArray);
            if (cells == null) {
                cells = new ArrayList();
                map.put(byArray, cells);
            }
            for (List l : put.getFamilyCellMap().values()) {
                cells.addAll(l);
            }
        }
        CellSetModel model = new CellSetModel();
        for (Map.Entry entry : map.entrySet()) {
            RowModel row = new RowModel((byte[])entry.getKey());
            for (Cell cell : (List)entry.getValue()) {
                row.addCell(new CellModel(cell));
            }
            model.addRow(row);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.pathPrefix);
        stringBuilder.append(Bytes.toString((byte[])this.name));
        stringBuilder.append("/$multiput");
        boolean bl = false;
        while (var5_11 < this.maxRetries) {
            Response response = this.client.put(stringBuilder.toString(), "application/x-protobuf", model.createProtobufOutput());
            int code = response.getCode();
            switch (code) {
                case 200: {
                    return;
                }
                case 509: {
                    try {
                        Thread.sleep(this.sleepTime);
                        break;
                    }
                    catch (InterruptedException e) {
                        throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                    }
                }
                default: {
                    throw new IOException("multiput request failed with " + code);
                }
            }
            ++var5_11;
        }
        throw new IOException("multiput request timed out");
    }

    public void delete(Delete delete) throws IOException {
        String spec = this.buildRowSpec(delete.getRow(), delete.getFamilyCellMap(), delete.getTimestamp(), delete.getTimestamp(), 1);
        block6: for (int i = 0; i < this.maxRetries; ++i) {
            Response response = this.client.delete(spec);
            int code = response.getCode();
            switch (code) {
                case 200: {
                    return;
                }
                case 509: {
                    try {
                        Thread.sleep(this.sleepTime);
                        continue block6;
                    }
                    catch (InterruptedException e) {
                        throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                    }
                }
                default: {
                    throw new IOException("delete request failed with " + code);
                }
            }
        }
        throw new IOException("delete request timed out");
    }

    public void delete(List<Delete> deletes) throws IOException {
        for (Delete delete : deletes) {
            this.delete(delete);
        }
    }

    public void flushCommits() throws IOException {
    }

    public TableDescriptor getDescriptor() throws IOException {
        return this.getTableDescriptor();
    }

    public ResultScanner getScanner(Scan scan) throws IOException {
        return new Scanner(scan);
    }

    public ResultScanner getScanner(byte[] family) throws IOException {
        Scan scan = new Scan();
        scan.addFamily(family);
        return new Scanner(scan);
    }

    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        Scan scan = new Scan();
        scan.addColumn(family, qualifier);
        return new Scanner(scan);
    }

    public boolean isAutoFlush() {
        return true;
    }

    @Deprecated
    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put) throws IOException {
        return this.doCheckAndPut(row, family, qualifier, value, put);
    }

    private boolean doCheckAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put) throws IOException {
        put.add((Cell)new KeyValue(row, family, qualifier, value));
        CellSetModel model = this.buildModelFromPut(put);
        StringBuilder sb = new StringBuilder();
        sb.append(this.pathPrefix);
        sb.append(Bytes.toString((byte[])this.name));
        sb.append('/');
        sb.append(RemoteHTable.toURLEncodedBytes(put.getRow()));
        sb.append("?check=put");
        block7: for (int i = 0; i < this.maxRetries; ++i) {
            Response response = this.client.put(sb.toString(), "application/x-protobuf", model.createProtobufOutput());
            int code = response.getCode();
            switch (code) {
                case 200: {
                    return true;
                }
                case 304: {
                    return false;
                }
                case 509: {
                    try {
                        Thread.sleep(this.sleepTime);
                        continue block7;
                    }
                    catch (InterruptedException e) {
                        throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                    }
                }
                default: {
                    throw new IOException("checkAndPut request failed with " + code);
                }
            }
        }
        throw new IOException("checkAndPut request timed out");
    }

    @Deprecated
    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Put put) throws IOException {
        throw new IOException("checkAndPut for non-equal comparison not implemented");
    }

    @Deprecated
    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, CompareOperator compareOp, byte[] value, Put put) throws IOException {
        throw new IOException("checkAndPut for non-equal comparison not implemented");
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
        return this.doCheckAndDelete(row, family, qualifier, value, delete);
    }

    private boolean doCheckAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
        Put put = new Put(row);
        put.setFamilyCellMap(delete.getFamilyCellMap());
        put.add((Cell)new KeyValue(row, family, qualifier, value));
        CellSetModel model = this.buildModelFromPut(put);
        StringBuilder sb = new StringBuilder();
        sb.append(this.pathPrefix);
        sb.append(Bytes.toString((byte[])this.name));
        sb.append('/');
        sb.append(RemoteHTable.toURLEncodedBytes(row));
        sb.append("?check=delete");
        block7: for (int i = 0; i < this.maxRetries; ++i) {
            Response response = this.client.put(sb.toString(), "application/x-protobuf", model.createProtobufOutput());
            int code = response.getCode();
            switch (code) {
                case 200: {
                    return true;
                }
                case 304: {
                    return false;
                }
                case 509: {
                    try {
                        Thread.sleep(this.sleepTime);
                        continue block7;
                    }
                    catch (InterruptedException e) {
                        throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                    }
                }
                default: {
                    throw new IOException("checkAndDelete request failed with " + code);
                }
            }
        }
        throw new IOException("checkAndDelete request timed out");
    }

    @Deprecated
    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Delete delete) throws IOException {
        throw new IOException("checkAndDelete for non-equal comparison not implemented");
    }

    @Deprecated
    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareOperator compareOp, byte[] value, Delete delete) throws IOException {
        throw new IOException("checkAndDelete for non-equal comparison not implemented");
    }

    public Table.CheckAndMutateBuilder checkAndMutate(byte[] row, byte[] family) {
        return new CheckAndMutateBuilderImpl(row, family);
    }

    public Table.CheckAndMutateWithFilterBuilder checkAndMutate(byte[] row, Filter filter) {
        throw new NotImplementedException("Implement later");
    }

    @Deprecated
    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, RowMutations rm) throws IOException {
        throw new UnsupportedOperationException("checkAndMutate not implemented");
    }

    @Deprecated
    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareOperator compareOp, byte[] value, RowMutations rm) throws IOException {
        throw new UnsupportedOperationException("checkAndMutate not implemented");
    }

    public CheckAndMutateResult checkAndMutate(CheckAndMutate checkAndMutate) {
        throw new NotImplementedException("Implement later");
    }

    public List<CheckAndMutateResult> checkAndMutate(List<CheckAndMutate> checkAndMutates) {
        throw new NotImplementedException("Implement later");
    }

    public Result increment(Increment increment) throws IOException {
        throw new IOException("Increment not supported");
    }

    public Result append(Append append) throws IOException {
        throw new IOException("Append not supported");
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        throw new IOException("incrementColumnValue not supported");
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability) throws IOException {
        throw new IOException("incrementColumnValue not supported");
    }

    public void batch(List<? extends Row> actions, Object[] results) throws IOException {
        throw new IOException("batch not supported");
    }

    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        throw new IOException("batchCallback not supported");
    }

    public CoprocessorRpcChannel coprocessorService(byte[] row) {
        throw new UnsupportedOperationException("coprocessorService not implemented");
    }

    public Result mutateRow(RowMutations rm) throws IOException {
        throw new IOException("atomicMutation not supported");
    }

    @Deprecated
    public void setOperationTimeout(int operationTimeout) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public int getOperationTimeout() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setRpcTimeout(int rpcTimeout) {
        throw new UnsupportedOperationException();
    }

    public long getReadRpcTimeout(TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public int getRpcTimeout() {
        throw new UnsupportedOperationException();
    }

    public long getRpcTimeout(TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public int getReadRpcTimeout() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setReadRpcTimeout(int readRpcTimeout) {
        throw new UnsupportedOperationException();
    }

    public long getWriteRpcTimeout(TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public int getWriteRpcTimeout() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setWriteRpcTimeout(int writeRpcTimeout) {
        throw new UnsupportedOperationException();
    }

    public long getOperationTimeout(TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    private static String toURLEncodedBytes(byte[] row) {
        try {
            return URLEncoder.encode(new String(row, "UTF-8"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("URLEncoder doesn't support UTF-8", e);
        }
    }

    public RegionLocator getRegionLocator() throws IOException {
        throw new UnsupportedOperationException();
    }

    private class CheckAndMutateBuilderImpl
    implements Table.CheckAndMutateBuilder {
        private final byte[] row;
        private final byte[] family;
        private byte[] qualifier;
        private byte[] value;

        CheckAndMutateBuilderImpl(byte[] row, byte[] family) {
            this.row = (byte[])Preconditions.checkNotNull((Object)row, (Object)"row is null");
            this.family = (byte[])Preconditions.checkNotNull((Object)family, (Object)"family is null");
        }

        public Table.CheckAndMutateBuilder qualifier(byte[] qualifier) {
            this.qualifier = (byte[])Preconditions.checkNotNull((Object)qualifier, (Object)"qualifier is null. Consider using an empty byte array, or just do not call this method if you want a null qualifier");
            return this;
        }

        public Table.CheckAndMutateBuilder timeRange(TimeRange timeRange) {
            throw new UnsupportedOperationException("timeRange not implemented");
        }

        public Table.CheckAndMutateBuilder ifNotExists() {
            throw new UnsupportedOperationException("CheckAndMutate for non-equal comparison not implemented");
        }

        public Table.CheckAndMutateBuilder ifMatches(CompareOperator compareOp, byte[] value) {
            if (compareOp == CompareOperator.EQUAL) {
                this.value = (byte[])Preconditions.checkNotNull((Object)value, (Object)"value is null");
                return this;
            }
            throw new UnsupportedOperationException("CheckAndMutate for non-equal comparison not implemented");
        }

        public Table.CheckAndMutateBuilder ifEquals(byte[] value) {
            this.value = (byte[])Preconditions.checkNotNull((Object)value, (Object)"value is null");
            return this;
        }

        public boolean thenPut(Put put) throws IOException {
            return RemoteHTable.this.doCheckAndPut(this.row, this.family, this.qualifier, this.value, put);
        }

        public boolean thenDelete(Delete delete) throws IOException {
            return RemoteHTable.this.doCheckAndDelete(this.row, this.family, this.qualifier, this.value, delete);
        }

        public boolean thenMutate(RowMutations mutation) throws IOException {
            throw new UnsupportedOperationException("thenMutate not implemented");
        }
    }

    class Scanner
    implements ResultScanner {
        String uri;
        private Result[] cachedResults;
        private int nextCachedResultsRow = 0;

        public Scanner(Scan scan) throws IOException {
            ScannerModel model;
            try {
                model = ScannerModel.fromScan((Scan)scan);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(RemoteHTable.this.pathPrefix);
            sb.append(Bytes.toString((byte[])RemoteHTable.this.name));
            sb.append('/');
            sb.append("scanner");
            block8: for (int i = 0; i < RemoteHTable.this.maxRetries; ++i) {
                Response response = RemoteHTable.this.client.post(sb.toString(), "application/x-protobuf", model.createProtobufOutput());
                int code = response.getCode();
                switch (code) {
                    case 201: {
                        this.uri = response.getLocation();
                        return;
                    }
                    case 509: {
                        try {
                            Thread.sleep(RemoteHTable.this.sleepTime);
                            continue block8;
                        }
                        catch (InterruptedException e) {
                            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                        }
                    }
                    default: {
                        throw new IOException("scan request failed with " + code);
                    }
                }
            }
            throw new IOException("scan request timed out");
        }

        public Result[] nextBatch() throws IOException {
            StringBuilder sb = new StringBuilder(this.uri);
            block7: for (int i = 0; i < RemoteHTable.this.maxRetries; ++i) {
                Response response = RemoteHTable.this.client.get(sb.toString(), "application/x-protobuf");
                int code = response.getCode();
                switch (code) {
                    case 200: {
                        CellSetModel model = new CellSetModel();
                        model.getObjectFromMessage(response.getBody());
                        return RemoteHTable.this.buildResultFromModel(model);
                    }
                    case 204: 
                    case 206: {
                        return null;
                    }
                    case 509: {
                        try {
                            Thread.sleep(RemoteHTable.this.sleepTime);
                            continue block7;
                        }
                        catch (InterruptedException e) {
                            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                        }
                    }
                    default: {
                        throw new IOException("scanner.next request failed with " + code);
                    }
                }
            }
            throw new IOException("scanner.next request timed out");
        }

        private boolean updateCachedResults() throws IOException {
            if (this.cachedResults == null || this.nextCachedResultsRow >= this.cachedResults.length) {
                this.nextCachedResultsRow = 0;
                this.cachedResults = this.nextBatch();
            }
            return this.cachedResults != null && this.cachedResults.length >= 1;
        }

        public Result[] next(int nbRows) throws IOException {
            if (!this.updateCachedResults()) {
                return null;
            }
            int endIndex = Math.min(this.cachedResults.length, this.nextCachedResultsRow + nbRows);
            Result[] chunk = Arrays.copyOfRange(this.cachedResults, this.nextCachedResultsRow, endIndex);
            this.nextCachedResultsRow = endIndex;
            return chunk;
        }

        public Result next() throws IOException {
            if (!this.updateCachedResults()) {
                return null;
            }
            return this.cachedResults[this.nextCachedResultsRow++];
        }

        public Iterator<Result> iterator() {
            return new Iter();
        }

        public void close() {
            try {
                RemoteHTable.this.client.delete(this.uri);
            }
            catch (IOException e) {
                LOG.warn(StringUtils.stringifyException((Throwable)e));
            }
        }

        public boolean renewLease() {
            throw new RuntimeException("renewLease() not supported");
        }

        public ScanMetrics getScanMetrics() {
            throw new RuntimeException("getScanMetrics() not supported");
        }

        class Iter
        implements Iterator<Result> {
            Result cache;

            public Iter() {
                try {
                    this.cache = Scanner.this.next();
                }
                catch (IOException e) {
                    LOG.warn(StringUtils.stringifyException((Throwable)e));
                }
            }

            @Override
            public boolean hasNext() {
                return this.cache != null;
            }

            @Override
            public Result next() {
                Result result = this.cache;
                try {
                    this.cache = Scanner.this.next();
                }
                catch (IOException e) {
                    LOG.warn(StringUtils.stringifyException((Throwable)e));
                    this.cache = null;
                }
                return result;
            }

            @Override
            public void remove() {
                throw new RuntimeException("remove() not supported");
            }
        }
    }
}

