/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.rest.HBaseRESTTestingUtility;
import org.apache.hadoop.hbase.rest.client.Client;
import org.apache.hadoop.hbase.rest.client.Cluster;
import org.apache.hadoop.hbase.rest.client.Response;
import org.apache.hadoop.hbase.rest.model.NamespacesInstanceModel;
import org.apache.hadoop.hbase.rest.model.TableListModel;
import org.apache.hadoop.hbase.rest.model.TableModel;
import org.apache.hadoop.hbase.rest.model.TestNamespacesInstanceModel;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RestTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import org.apache.hbase.thirdparty.javax.ws.rs.core.MediaType;
import org.apache.http.Header;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RestTests.class, MediumTests.class})
public class TestNamespacesInstanceResource {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestNamespacesInstanceResource.class);
    private static String NAMESPACE1 = "TestNamespacesInstanceResource1";
    private static Map<String, String> NAMESPACE1_PROPS = new HashMap<String, String>();
    private static String NAMESPACE2 = "TestNamespacesInstanceResource2";
    private static Map<String, String> NAMESPACE2_PROPS = new HashMap<String, String>();
    private static String NAMESPACE3 = "TestNamespacesInstanceResource3";
    private static Map<String, String> NAMESPACE3_PROPS = new HashMap<String, String>();
    private static String NAMESPACE4 = "TestNamespacesInstanceResource4";
    private static Map<String, String> NAMESPACE4_PROPS = new HashMap<String, String>();
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final HBaseRESTTestingUtility REST_TEST_UTIL = new HBaseRESTTestingUtility();
    private static Client client;
    private static JAXBContext context;
    private static Configuration conf;
    private static TestNamespacesInstanceModel testNamespacesInstanceModel;
    protected static ObjectMapper jsonMapper;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        TEST_UTIL.startMiniCluster();
        REST_TEST_UTIL.startServletContainer(conf);
        client = new Client(new Cluster().add("localhost", REST_TEST_UTIL.getServletPort()));
        testNamespacesInstanceModel = new TestNamespacesInstanceModel();
        context = JAXBContext.newInstance((Class[])new Class[]{NamespacesInstanceModel.class, TableListModel.class});
        jsonMapper = new JacksonJaxbJsonProvider().locateMapper(NamespacesInstanceModel.class, MediaType.APPLICATION_JSON_TYPE);
        NAMESPACE1_PROPS.put("key1", "value1");
        NAMESPACE2_PROPS.put("key2a", "value2a");
        NAMESPACE2_PROPS.put("key2b", "value2b");
        NAMESPACE3_PROPS.put("key3", "value3");
        NAMESPACE4_PROPS.put("key4a", "value4a");
        NAMESPACE4_PROPS.put("key4b", "value4b");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        REST_TEST_UTIL.shutdownServletContainer();
        TEST_UTIL.shutdownMiniCluster();
    }

    private static byte[] toXML(NamespacesInstanceModel model) throws JAXBException {
        StringWriter writer = new StringWriter();
        context.createMarshaller().marshal((Object)model, (Writer)writer);
        return Bytes.toBytes((String)writer.toString());
    }

    private static <T> T fromXML(byte[] content) throws JAXBException {
        return (T)context.createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(content));
    }

    private NamespaceDescriptor findNamespace(Admin admin, String namespaceName) throws IOException {
        NamespaceDescriptor[] nd;
        for (NamespaceDescriptor namespaceDescriptor : nd = admin.listNamespaceDescriptors()) {
            if (!namespaceDescriptor.getName().equals(namespaceName)) continue;
            return namespaceDescriptor;
        }
        return null;
    }

    private void checkNamespaceProperties(NamespaceDescriptor nd, Map<String, String> testProps) {
        this.checkNamespaceProperties(nd.getConfiguration(), testProps);
    }

    private void checkNamespaceProperties(Map<String, String> namespaceProps, Map<String, String> testProps) {
        Assert.assertTrue((namespaceProps.size() == testProps.size() ? 1 : 0) != 0);
        for (String key : testProps.keySet()) {
            Assert.assertEquals((Object)testProps.get(key), (Object)namespaceProps.get(key));
        }
    }

    private void checkNamespaceTables(List<TableModel> namespaceTables, List<String> testTables) {
        Assert.assertEquals((long)namespaceTables.size(), (long)testTables.size());
        for (TableModel namespaceTable : namespaceTables) {
            String tableName = namespaceTable.getName();
            Assert.assertTrue((boolean)testTables.contains(tableName));
        }
    }

    @Test
    public void testCannotDeleteDefaultAndHbaseNamespaces() throws IOException {
        String defaultPath = "/namespaces/default";
        String hbasePath = "/namespaces/hbase";
        Admin admin = TEST_UTIL.getAdmin();
        Assert.assertNotNull((Object)this.findNamespace(admin, "default"));
        Assert.assertNotNull((Object)this.findNamespace(admin, "hbase"));
        Response response = client.delete(defaultPath);
        Assert.assertEquals((long)503L, (long)response.getCode());
        response = client.delete(hbasePath);
        Assert.assertEquals((long)503L, (long)response.getCode());
        Assert.assertNotNull((Object)this.findNamespace(admin, "default"));
        Assert.assertNotNull((Object)this.findNamespace(admin, "hbase"));
    }

    @Test
    public void testGetNamespaceTablesAndCannotDeleteNamespace() throws IOException, JAXBException {
        Admin admin = TEST_UTIL.getAdmin();
        String nsName = "TestNamespacesInstanceResource5";
        NamespaceDescriptor.Builder nsBuilder = NamespaceDescriptor.create((String)nsName);
        NamespaceDescriptor nsd = nsBuilder.build();
        nsd.setConfiguration("key1", "value1");
        admin.createNamespace(nsd);
        HColumnDescriptor colDesc = new HColumnDescriptor("cf1");
        TableName tn1 = TableName.valueOf((String)(nsName + ":table1"));
        HTableDescriptor table = new HTableDescriptor(tn1);
        table.addFamily(colDesc);
        admin.createTable((TableDescriptor)table);
        TableName tn2 = TableName.valueOf((String)(nsName + ":table2"));
        table = new HTableDescriptor(tn2);
        table.addFamily(colDesc);
        admin.createTable((TableDescriptor)table);
        HashMap<String, String> nsProperties = new HashMap<String, String>();
        nsProperties.put("key1", "value1");
        List<String> nsTables = Arrays.asList("table1", "table2");
        String namespacePath = "/namespaces/" + nsName;
        Response response = client.get(namespacePath);
        Assert.assertEquals((long)200L, (long)response.getCode());
        response = client.get(namespacePath, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getCode());
        NamespacesInstanceModel model = (NamespacesInstanceModel)TestNamespacesInstanceResource.fromXML(response.getBody());
        this.checkNamespaceProperties(model.getProperties(), nsProperties);
        response = client.get(namespacePath, "application/json");
        Assert.assertEquals((long)200L, (long)response.getCode());
        model = (NamespacesInstanceModel)jsonMapper.readValue(response.getBody(), NamespacesInstanceModel.class);
        this.checkNamespaceProperties(model.getProperties(), nsProperties);
        response = client.get(namespacePath, "application/x-protobuf");
        Assert.assertEquals((long)200L, (long)response.getCode());
        model.getObjectFromMessage(response.getBody());
        this.checkNamespaceProperties(model.getProperties(), nsProperties);
        namespacePath = "/namespaces/" + nsName + "/tables";
        response = client.get(namespacePath);
        Assert.assertEquals((long)200L, (long)response.getCode());
        response = client.get(namespacePath, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getCode());
        TableListModel tablemodel = (TableListModel)TestNamespacesInstanceResource.fromXML(response.getBody());
        this.checkNamespaceTables(tablemodel.getTables(), nsTables);
        response = client.get(namespacePath, "application/json");
        Assert.assertEquals((long)200L, (long)response.getCode());
        tablemodel = (TableListModel)jsonMapper.readValue(response.getBody(), TableListModel.class);
        this.checkNamespaceTables(tablemodel.getTables(), nsTables);
        response = client.get(namespacePath, "application/x-protobuf");
        Assert.assertEquals((long)200L, (long)response.getCode());
        tablemodel.setTables(new ArrayList());
        tablemodel.getObjectFromMessage(response.getBody());
        this.checkNamespaceTables(tablemodel.getTables(), nsTables);
        response = client.delete(namespacePath);
        namespacePath = "/namespaces/" + nsName;
        Assert.assertEquals((long)503L, (long)response.getCode());
    }

    @Ignore(value="HBASE-19210")
    @Test
    public void testInvalidNamespacePostsAndPuts() throws IOException, JAXBException {
        String namespacePath1 = "/namespaces/" + NAMESPACE1;
        String namespacePath2 = "/namespaces/" + NAMESPACE2;
        String namespacePath3 = "/namespaces/" + NAMESPACE3;
        Admin admin = TEST_UTIL.getAdmin();
        Assert.assertNull((Object)this.findNamespace(admin, NAMESPACE1));
        Assert.assertNull((Object)this.findNamespace(admin, NAMESPACE2));
        Assert.assertNull((Object)this.findNamespace(admin, NAMESPACE3));
        NamespacesInstanceModel model1 = testNamespacesInstanceModel.buildTestModel(NAMESPACE1, NAMESPACE1_PROPS);
        testNamespacesInstanceModel.checkModel(model1, NAMESPACE1, NAMESPACE1_PROPS);
        NamespacesInstanceModel model2 = testNamespacesInstanceModel.buildTestModel(NAMESPACE2, NAMESPACE2_PROPS);
        testNamespacesInstanceModel.checkModel(model2, NAMESPACE2, NAMESPACE2_PROPS);
        NamespacesInstanceModel model3 = testNamespacesInstanceModel.buildTestModel(NAMESPACE3, NAMESPACE3_PROPS);
        testNamespacesInstanceModel.checkModel(model3, NAMESPACE3, NAMESPACE3_PROPS);
        Response response = client.post(namespacePath1, "application/json", TestNamespacesInstanceResource.toXML(model1));
        Assert.assertEquals((long)500L, (long)response.getCode());
        String jsonString = jsonMapper.writeValueAsString((Object)model2);
        response = client.put(namespacePath2, "text/xml", Bytes.toBytes((String)jsonString));
        Assert.assertEquals((long)400L, (long)response.getCode());
        response = client.post(namespacePath3, "application/x-protobuf", TestNamespacesInstanceResource.toXML(model3));
        Assert.assertEquals((long)500L, (long)response.getCode());
        NamespaceDescriptor nd1 = this.findNamespace(admin, NAMESPACE1);
        NamespaceDescriptor nd2 = this.findNamespace(admin, NAMESPACE2);
        NamespaceDescriptor nd3 = this.findNamespace(admin, NAMESPACE3);
        Assert.assertNull((Object)nd1);
        Assert.assertNull((Object)nd2);
        Assert.assertNull((Object)nd3);
    }

    @Test
    public void testNamespaceCreateAndDeleteXMLAndJSON() throws IOException, JAXBException {
        String namespacePath1 = "/namespaces/" + NAMESPACE1;
        String namespacePath2 = "/namespaces/" + NAMESPACE2;
        Admin admin = TEST_UTIL.getAdmin();
        Assert.assertNull((Object)this.findNamespace(admin, NAMESPACE1));
        Assert.assertNull((Object)this.findNamespace(admin, NAMESPACE2));
        NamespacesInstanceModel model1 = testNamespacesInstanceModel.buildTestModel(NAMESPACE1, NAMESPACE1_PROPS);
        testNamespacesInstanceModel.checkModel(model1, NAMESPACE1, NAMESPACE1_PROPS);
        NamespacesInstanceModel model2 = testNamespacesInstanceModel.buildTestModel(NAMESPACE2, NAMESPACE2_PROPS);
        testNamespacesInstanceModel.checkModel(model2, NAMESPACE2, NAMESPACE2_PROPS);
        Response response = client.put(namespacePath1, "text/xml", TestNamespacesInstanceResource.toXML(model1));
        Assert.assertEquals((long)403L, (long)response.getCode());
        String jsonString = jsonMapper.writeValueAsString((Object)model2);
        response = client.put(namespacePath2, "application/json", Bytes.toBytes((String)jsonString));
        Assert.assertEquals((long)403L, (long)response.getCode());
        conf.set("hbase.rest.readonly", "true");
        response = client.post(namespacePath1, "text/xml", TestNamespacesInstanceResource.toXML(model1));
        Assert.assertEquals((long)403L, (long)response.getCode());
        jsonString = jsonMapper.writeValueAsString((Object)model2);
        response = client.post(namespacePath2, "application/json", Bytes.toBytes((String)jsonString));
        Assert.assertEquals((long)403L, (long)response.getCode());
        NamespaceDescriptor nd1 = this.findNamespace(admin, NAMESPACE1);
        NamespaceDescriptor nd2 = this.findNamespace(admin, NAMESPACE2);
        Assert.assertNull((Object)nd1);
        Assert.assertNull((Object)nd2);
        conf.set("hbase.rest.readonly", "false");
        response = client.post(namespacePath1, "text/xml", TestNamespacesInstanceResource.toXML(model1));
        Assert.assertEquals((long)201L, (long)response.getCode());
        jsonString = jsonMapper.writeValueAsString((Object)model2);
        response = client.post(namespacePath2, "application/json", Bytes.toBytes((String)jsonString));
        Assert.assertEquals((long)201L, (long)response.getCode());
        Header[] nullHeaders = null;
        response = client.post(namespacePath1, nullHeaders, TestNamespacesInstanceResource.toXML(model1));
        Assert.assertEquals((long)415L, (long)response.getCode());
        response = client.post(namespacePath1, nullHeaders, Bytes.toBytes((String)jsonString));
        Assert.assertEquals((long)415L, (long)response.getCode());
        nd1 = this.findNamespace(admin, NAMESPACE1);
        nd2 = this.findNamespace(admin, NAMESPACE2);
        Assert.assertNotNull((Object)nd1);
        Assert.assertNotNull((Object)nd2);
        this.checkNamespaceProperties(nd1, NAMESPACE1_PROPS);
        this.checkNamespaceProperties(nd1, NAMESPACE1_PROPS);
        conf.set("hbase.rest.readonly", "true");
        response = client.delete(namespacePath1);
        Assert.assertEquals((long)403L, (long)response.getCode());
        response = client.delete(namespacePath2);
        Assert.assertEquals((long)403L, (long)response.getCode());
        nd1 = this.findNamespace(admin, NAMESPACE1);
        nd2 = this.findNamespace(admin, NAMESPACE2);
        Assert.assertNotNull((Object)nd1);
        Assert.assertNotNull((Object)nd2);
        conf.set("hbase.rest.readonly", "false");
        response = client.delete(namespacePath1);
        Assert.assertEquals((long)200L, (long)response.getCode());
        response = client.delete(namespacePath2);
        Assert.assertEquals((long)200L, (long)response.getCode());
        nd1 = this.findNamespace(admin, NAMESPACE1);
        nd2 = this.findNamespace(admin, NAMESPACE2);
        Assert.assertNull((Object)nd1);
        Assert.assertNull((Object)nd2);
    }

    @Test
    public void testNamespaceCreateAndDeletePBAndNoBody() throws IOException {
        String namespacePath3 = "/namespaces/" + NAMESPACE3;
        String namespacePath4 = "/namespaces/" + NAMESPACE4;
        Admin admin = TEST_UTIL.getAdmin();
        Assert.assertNull((Object)this.findNamespace(admin, NAMESPACE3));
        Assert.assertNull((Object)this.findNamespace(admin, NAMESPACE4));
        NamespacesInstanceModel model3 = testNamespacesInstanceModel.buildTestModel(NAMESPACE3, NAMESPACE3_PROPS);
        testNamespacesInstanceModel.checkModel(model3, NAMESPACE3, NAMESPACE3_PROPS);
        NamespacesInstanceModel model4 = testNamespacesInstanceModel.buildTestModel(NAMESPACE4, NAMESPACE4_PROPS);
        testNamespacesInstanceModel.checkModel(model4, NAMESPACE4, NAMESPACE4_PROPS);
        Header[] nullHeaders = null;
        Response response = client.put(namespacePath3, nullHeaders, new byte[0]);
        Assert.assertEquals((long)403L, (long)response.getCode());
        response = client.put(namespacePath4, "application/x-protobuf", model4.createProtobufOutput());
        Assert.assertEquals((long)403L, (long)response.getCode());
        conf.set("hbase.rest.readonly", "true");
        response = client.post(namespacePath3, nullHeaders, new byte[0]);
        Assert.assertEquals((long)403L, (long)response.getCode());
        response = client.put(namespacePath4, "application/x-protobuf", model4.createProtobufOutput());
        Assert.assertEquals((long)403L, (long)response.getCode());
        NamespaceDescriptor nd3 = this.findNamespace(admin, NAMESPACE3);
        NamespaceDescriptor nd4 = this.findNamespace(admin, NAMESPACE4);
        Assert.assertNull((Object)nd3);
        Assert.assertNull((Object)nd4);
        conf.set("hbase.rest.readonly", "false");
        response = client.post(namespacePath3, nullHeaders, new byte[0]);
        Assert.assertEquals((long)201L, (long)response.getCode());
        response = client.post(namespacePath4, "application/x-protobuf", model4.createProtobufOutput());
        Assert.assertEquals((long)201L, (long)response.getCode());
        response = client.post(namespacePath3, "application/octet-stream", new byte[0]);
        Assert.assertEquals((long)415L, (long)response.getCode());
        nd3 = this.findNamespace(admin, NAMESPACE3);
        nd4 = this.findNamespace(admin, NAMESPACE4);
        Assert.assertNotNull((Object)nd3);
        Assert.assertNotNull((Object)nd4);
        this.checkNamespaceProperties(nd3, new HashMap<String, String>());
        this.checkNamespaceProperties(nd4, NAMESPACE4_PROPS);
        response = client.post(namespacePath3, nullHeaders, new byte[0]);
        Assert.assertEquals((long)403L, (long)response.getCode());
        response = client.post(namespacePath4, "application/x-protobuf", model4.createProtobufOutput());
        Assert.assertEquals((long)403L, (long)response.getCode());
        conf.set("hbase.rest.readonly", "true");
        response = client.delete(namespacePath3);
        Assert.assertEquals((long)403L, (long)response.getCode());
        response = client.delete(namespacePath4);
        Assert.assertEquals((long)403L, (long)response.getCode());
        nd3 = this.findNamespace(admin, NAMESPACE3);
        nd4 = this.findNamespace(admin, NAMESPACE4);
        Assert.assertNotNull((Object)nd3);
        Assert.assertNotNull((Object)nd4);
        conf.set("hbase.rest.readonly", "false");
        response = client.delete(namespacePath3);
        Assert.assertEquals((long)200L, (long)response.getCode());
        response = client.delete(namespacePath4);
        Assert.assertEquals((long)200L, (long)response.getCode());
        nd3 = this.findNamespace(admin, NAMESPACE3);
        nd4 = this.findNamespace(admin, NAMESPACE4);
        Assert.assertNull((Object)nd3);
        Assert.assertNull((Object)nd4);
    }
}

