/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.rest.HBaseRESTTestingUtility;
import org.apache.hadoop.hbase.rest.client.Client;
import org.apache.hadoop.hbase.rest.client.Cluster;
import org.apache.hadoop.hbase.rest.client.Response;
import org.apache.hadoop.hbase.rest.model.CellModel;
import org.apache.hadoop.hbase.rest.model.CellSetModel;
import org.apache.hadoop.hbase.rest.model.RowModel;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RestTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import org.apache.hbase.thirdparty.javax.ws.rs.core.MediaType;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={RestTests.class, MediumTests.class})
@RunWith(value=Parameterized.class)
public class TestMultiRowResource {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMultiRowResource.class);
    private static final TableName TABLE = TableName.valueOf((String)"TestRowResource");
    private static final String CFA = "a";
    private static final String CFB = "b";
    private static final String COLUMN_1 = "a:1";
    private static final String COLUMN_2 = "b:2";
    private static final String ROW_1 = "testrow5";
    private static final String VALUE_1 = "testvalue5";
    private static final String ROW_2 = "testrow6";
    private static final String VALUE_2 = "testvalue6";
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final HBaseRESTTestingUtility REST_TEST_UTIL = new HBaseRESTTestingUtility();
    private static final Base64.Encoder base64UrlEncoder = Base64.getUrlEncoder().withoutPadding();
    private static Client client;
    private static Configuration conf;
    private static Header extraHdr;
    private static boolean csrfEnabled;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return HBaseCommonTestingUtility.BOOLEAN_PARAMETERIZED;
    }

    public TestMultiRowResource(Boolean csrf) {
        csrfEnabled = csrf;
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.rest.csrf.enabled", csrfEnabled);
        if (csrfEnabled) {
            conf.set("hbase.rest-csrf.browser-useragents-regex", ".*");
        }
        extraHdr = new BasicHeader("X-XSRF-HEADER", "");
        TEST_UTIL.startMiniCluster();
        REST_TEST_UTIL.startServletContainer(conf);
        client = new Client(new Cluster().add("localhost", REST_TEST_UTIL.getServletPort()));
        Admin admin = TEST_UTIL.getAdmin();
        if (admin.tableExists(TABLE)) {
            return;
        }
        HTableDescriptor htd = new HTableDescriptor(TABLE);
        htd.addFamily(new HColumnDescriptor(CFA));
        htd.addFamily(new HColumnDescriptor(CFB));
        admin.createTable((TableDescriptor)htd);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        REST_TEST_UTIL.shutdownServletContainer();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMultiCellGetJSON() throws IOException {
        Response response;
        String row_5_url = "/" + TABLE + "/" + ROW_1 + "/" + COLUMN_1;
        String row_6_url = "/" + TABLE + "/" + ROW_2 + "/" + COLUMN_2;
        StringBuilder path = new StringBuilder();
        path.append("/");
        path.append(TABLE);
        path.append("/multiget/?row=");
        path.append(ROW_1);
        path.append("&row=");
        path.append(ROW_2);
        if (csrfEnabled) {
            response = client.post(row_5_url, "application/octet-stream", Bytes.toBytes((String)VALUE_1));
            Assert.assertEquals((long)400L, (long)response.getCode());
        }
        client.post(row_5_url, "application/octet-stream", Bytes.toBytes((String)VALUE_1), extraHdr);
        client.post(row_6_url, "application/octet-stream", Bytes.toBytes((String)VALUE_2), extraHdr);
        response = client.get(path.toString(), "application/json");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"application/json", (Object)response.getHeader("content-type"));
        client.delete(row_5_url, extraHdr);
        client.delete(row_6_url, extraHdr);
    }

    private void checkMultiCellGetJSON(Response response) throws IOException {
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"application/json", (Object)response.getHeader("content-type"));
        ObjectMapper mapper = new JacksonJaxbJsonProvider().locateMapper(CellSetModel.class, MediaType.APPLICATION_JSON_TYPE);
        CellSetModel cellSet = (CellSetModel)mapper.readValue(response.getBody(), CellSetModel.class);
        RowModel rowModel = (RowModel)cellSet.getRows().get(0);
        Assert.assertEquals((Object)ROW_1, (Object)new String(rowModel.getKey()));
        Assert.assertEquals((long)1L, (long)rowModel.getCells().size());
        CellModel cell = (CellModel)rowModel.getCells().get(0);
        Assert.assertEquals((Object)COLUMN_1, (Object)new String(cell.getColumn()));
        Assert.assertEquals((Object)VALUE_1, (Object)new String(cell.getValue()));
        rowModel = (RowModel)cellSet.getRows().get(1);
        Assert.assertEquals((Object)ROW_2, (Object)new String(rowModel.getKey()));
        Assert.assertEquals((long)1L, (long)rowModel.getCells().size());
        cell = (CellModel)rowModel.getCells().get(0);
        Assert.assertEquals((Object)COLUMN_2, (Object)new String(cell.getColumn()));
        Assert.assertEquals((Object)VALUE_2, (Object)new String(cell.getValue()));
    }

    @Test
    public void testMultiCellGetJSONB64() throws IOException {
        String row_5_url = "/" + TABLE + "/" + ROW_1 + "/" + COLUMN_1;
        String row_6_url = "/" + TABLE + "/" + ROW_2 + "/" + COLUMN_2;
        if (csrfEnabled) {
            Response response = client.post(row_5_url, "application/octet-stream", Bytes.toBytes((String)VALUE_1));
            Assert.assertEquals((long)400L, (long)response.getCode());
        }
        client.post(row_5_url, "application/octet-stream", Bytes.toBytes((String)VALUE_1), extraHdr);
        client.post(row_6_url, "application/octet-stream", Bytes.toBytes((String)VALUE_2), extraHdr);
        StringBuilder path = new StringBuilder();
        Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
        path.append("/");
        path.append(TABLE);
        path.append("/multiget/?row=");
        path.append(encoder.encodeToString(ROW_1.getBytes("UTF-8")));
        path.append("&row=");
        path.append(encoder.encodeToString(ROW_2.getBytes("UTF-8")));
        path.append("&e=b64");
        Response response = client.get(path.toString(), "application/json");
        this.checkMultiCellGetJSON(response);
        path = new StringBuilder();
        path.append("/");
        path.append(TABLE);
        path.append("/multiget/?row=");
        path.append(encoder.encodeToString(ROW_1.getBytes("UTF-8")));
        path.append("&row=");
        path.append(encoder.encodeToString(ROW_2.getBytes("UTF-8")));
        Header[] headers = new Header[]{new BasicHeader("Accept", "application/json"), new BasicHeader("Encoding", "b64")};
        response = client.get(path.toString(), headers);
        this.checkMultiCellGetJSON(response);
        client.delete(row_5_url, extraHdr);
        client.delete(row_6_url, extraHdr);
    }

    @Test
    public void testMultiCellGetNoKeys() throws IOException {
        StringBuilder path = new StringBuilder();
        path.append("/");
        path.append(TABLE);
        path.append("/multiget");
        Response response = client.get(path.toString(), "text/xml");
        Assert.assertEquals((long)404L, (long)response.getCode());
    }

    @Test
    public void testMultiCellGetXML() throws IOException {
        String row_5_url = "/" + TABLE + "/" + ROW_1 + "/" + COLUMN_1;
        String row_6_url = "/" + TABLE + "/" + ROW_2 + "/" + COLUMN_2;
        StringBuilder path = new StringBuilder();
        path.append("/");
        path.append(TABLE);
        path.append("/multiget/?row=");
        path.append(ROW_1);
        path.append("&row=");
        path.append(ROW_2);
        client.post(row_5_url, "application/octet-stream", Bytes.toBytes((String)VALUE_1), extraHdr);
        client.post(row_6_url, "application/octet-stream", Bytes.toBytes((String)VALUE_2), extraHdr);
        Response response = client.get(path.toString(), "text/xml");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"text/xml", (Object)response.getHeader("content-type"));
        client.delete(row_5_url, extraHdr);
        client.delete(row_6_url, extraHdr);
    }

    @Test
    public void testMultiCellGetWithColsJSON() throws IOException {
        String row_5_url = "/" + TABLE + "/" + ROW_1 + "/" + COLUMN_1;
        String row_6_url = "/" + TABLE + "/" + ROW_2 + "/" + COLUMN_2;
        StringBuilder path = new StringBuilder();
        path.append("/");
        path.append(TABLE);
        path.append("/multiget");
        path.append("/a:1,b");
        path.append("?row=");
        path.append(ROW_1);
        path.append("&row=");
        path.append(ROW_2);
        client.post(row_5_url, "application/octet-stream", Bytes.toBytes((String)VALUE_1), extraHdr);
        client.post(row_6_url, "application/octet-stream", Bytes.toBytes((String)VALUE_2), extraHdr);
        Response response = client.get(path.toString(), "application/json");
        Assert.assertEquals((long)200L, (long)response.getCode());
        ObjectMapper mapper = new JacksonJaxbJsonProvider().locateMapper(CellSetModel.class, MediaType.APPLICATION_JSON_TYPE);
        CellSetModel cellSet = (CellSetModel)mapper.readValue(response.getBody(), CellSetModel.class);
        Assert.assertEquals((long)2L, (long)cellSet.getRows().size());
        Assert.assertEquals((Object)ROW_1, (Object)Bytes.toString((byte[])((RowModel)cellSet.getRows().get(0)).getKey()));
        Assert.assertEquals((Object)VALUE_1, (Object)Bytes.toString((byte[])((CellModel)((RowModel)cellSet.getRows().get(0)).getCells().get(0)).getValue()));
        Assert.assertEquals((Object)ROW_2, (Object)Bytes.toString((byte[])((RowModel)cellSet.getRows().get(1)).getKey()));
        Assert.assertEquals((Object)VALUE_2, (Object)Bytes.toString((byte[])((CellModel)((RowModel)cellSet.getRows().get(1)).getCells().get(0)).getValue()));
        client.delete(row_5_url, extraHdr);
        client.delete(row_6_url, extraHdr);
    }

    @Test
    public void testMultiCellGetJSONNotFound() throws IOException {
        String row_5_url = "/" + TABLE + "/" + ROW_1 + "/" + COLUMN_1;
        StringBuilder path = new StringBuilder();
        path.append("/");
        path.append(TABLE);
        path.append("/multiget/?row=");
        path.append(ROW_1);
        path.append("&row=");
        path.append(ROW_2);
        client.post(row_5_url, "application/octet-stream", Bytes.toBytes((String)VALUE_1), extraHdr);
        Response response = client.get(path.toString(), "application/json");
        Assert.assertEquals((long)200L, (long)response.getCode());
        ObjectMapper mapper = new JacksonJaxbJsonProvider().locateMapper(CellSetModel.class, MediaType.APPLICATION_JSON_TYPE);
        CellSetModel cellSet = (CellSetModel)mapper.readValue(response.getBody(), CellSetModel.class);
        Assert.assertEquals((long)1L, (long)cellSet.getRows().size());
        Assert.assertEquals((Object)ROW_1, (Object)Bytes.toString((byte[])((RowModel)cellSet.getRows().get(0)).getKey()));
        Assert.assertEquals((Object)VALUE_1, (Object)Bytes.toString((byte[])((CellModel)((RowModel)cellSet.getRows().get(0)).getCells().get(0)).getValue()));
        client.delete(row_5_url, extraHdr);
    }

    @Test
    public void testMultiCellGetWithColsInQueryPathJSON() throws IOException {
        String row_5_url = "/" + TABLE + "/" + ROW_1 + "/" + COLUMN_1;
        String row_6_url = "/" + TABLE + "/" + ROW_2 + "/" + COLUMN_2;
        StringBuilder path = new StringBuilder();
        path.append("/");
        path.append(TABLE);
        path.append("/multiget/?row=");
        path.append(ROW_1);
        path.append("/");
        path.append(COLUMN_1);
        path.append("&row=");
        path.append(ROW_2);
        path.append("/");
        path.append(COLUMN_1);
        client.post(row_5_url, "application/octet-stream", Bytes.toBytes((String)VALUE_1), extraHdr);
        client.post(row_6_url, "application/octet-stream", Bytes.toBytes((String)VALUE_2), extraHdr);
        Response response = client.get(path.toString(), "application/json");
        Assert.assertEquals((long)200L, (long)response.getCode());
        ObjectMapper mapper = new JacksonJaxbJsonProvider().locateMapper(CellSetModel.class, MediaType.APPLICATION_JSON_TYPE);
        CellSetModel cellSet = (CellSetModel)mapper.readValue(response.getBody(), CellSetModel.class);
        Assert.assertEquals((long)1L, (long)cellSet.getRows().size());
        Assert.assertEquals((Object)ROW_1, (Object)Bytes.toString((byte[])((RowModel)cellSet.getRows().get(0)).getKey()));
        Assert.assertEquals((Object)VALUE_1, (Object)Bytes.toString((byte[])((CellModel)((RowModel)cellSet.getRows().get(0)).getCells().get(0)).getValue()));
        client.delete(row_5_url, extraHdr);
        client.delete(row_6_url, extraHdr);
    }

    @Test
    public void testMultiCellGetFilterJSON() throws IOException {
        Response response;
        String row_5_url = "/" + TABLE + "/" + ROW_1 + "/" + COLUMN_1;
        String row_6_url = "/" + TABLE + "/" + ROW_2 + "/" + COLUMN_2;
        StringBuilder path = new StringBuilder();
        path.append("/");
        path.append(TABLE);
        path.append("/multiget/?row=");
        path.append(ROW_1);
        path.append("&row=");
        path.append(ROW_2);
        if (csrfEnabled) {
            response = client.post(row_5_url, "application/octet-stream", Bytes.toBytes((String)VALUE_1));
            Assert.assertEquals((long)400L, (long)response.getCode());
        }
        client.post(row_5_url, "application/octet-stream", Bytes.toBytes((String)VALUE_1), extraHdr);
        client.post(row_6_url, "application/octet-stream", Bytes.toBytes((String)VALUE_2), extraHdr);
        response = client.get(path.toString(), "application/json");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"application/json", (Object)response.getHeader("content-type"));
        String positivePath = path.toString() + "&filter_b64=" + base64UrlEncoder.encodeToString("PrefixFilter('testrow')".getBytes(StandardCharsets.UTF_8.toString()));
        response = client.get(positivePath, "application/json");
        this.checkMultiCellGetJSON(response);
        positivePath = path.toString() + "&filter=" + URLEncoder.encode("PrefixFilter('testrow')", StandardCharsets.UTF_8.name());
        response = client.get(positivePath, "application/json");
        this.checkMultiCellGetJSON(response);
        String negativePath = path.toString() + "&filter_b64=" + base64UrlEncoder.encodeToString("PrefixFilter('notfound')".getBytes(StandardCharsets.UTF_8.toString()));
        response = client.get(negativePath, "application/json");
        Assert.assertEquals((long)404L, (long)response.getCode());
        negativePath = path.toString() + "&filter=" + URLEncoder.encode("PrefixFilter('notfound')", StandardCharsets.UTF_8.name());
        response = client.get(negativePath, "application/json");
        Assert.assertEquals((long)404L, (long)response.getCode());
        positivePath = path.toString() + "&filter_b64=" + base64UrlEncoder.encodeToString(Bytes.toBytesBinary((String)"ColumnRangeFilter ('\\x00', true, '\\xff', true)"));
        response = client.get(positivePath, "application/json");
        this.checkMultiCellGetJSON(response);
        negativePath = path.toString() + "&filter_b64=" + base64UrlEncoder.encodeToString(Bytes.toBytesBinary((String)"ColumnRangeFilter ('\\x00', true, '1', false)"));
        response = client.get(negativePath, "application/json");
        Assert.assertEquals((long)404L, (long)response.getCode());
        client.delete(row_5_url, extraHdr);
        client.delete(row_6_url, extraHdr);
    }

    static {
        extraHdr = null;
        csrfEnabled = true;
    }
}

