/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.rest.filter.GZIPResponseStream;
import org.apache.hadoop.hbase.rest.filter.GZIPResponseWrapper;
import org.apache.hadoop.hbase.testclassification.RestTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={RestTests.class, SmallTests.class})
public class TestGZIPResponseWrapper {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestGZIPResponseWrapper.class);
    private final HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
    private final GZIPResponseWrapper wrapper = new GZIPResponseWrapper(this.response);

    @Test
    public void testHeader() throws IOException {
        this.wrapper.setStatus(200);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).setStatus(200);
        this.wrapper.addHeader("header", "header value");
        ((HttpServletResponse)Mockito.verify((Object)this.response)).addHeader("header", "header value");
        this.wrapper.addHeader("content-length", "header value2");
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).addHeader("content-length", "header value");
        this.wrapper.setIntHeader("header", 5);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).setIntHeader("header", 5);
        this.wrapper.setIntHeader("content-length", 4);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).setIntHeader("content-length", 4);
        this.wrapper.setHeader("set-header", "new value");
        ((HttpServletResponse)Mockito.verify((Object)this.response)).setHeader("set-header", "new value");
        this.wrapper.setHeader("content-length", "content length value");
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).setHeader("content-length", "content length value");
        this.wrapper.sendRedirect("location");
        ((HttpServletResponse)Mockito.verify((Object)this.response)).sendRedirect("location");
        this.wrapper.flushBuffer();
        ((HttpServletResponse)Mockito.verify((Object)this.response)).flushBuffer();
    }

    @Test
    public void testResetBuffer() throws IOException {
        Mockito.when((Object)this.response.isCommitted()).thenReturn((Object)false);
        ServletOutputStream out = (ServletOutputStream)Mockito.mock(ServletOutputStream.class);
        Mockito.when((Object)this.response.getOutputStream()).thenReturn((Object)out);
        ServletOutputStream servletOutput = this.wrapper.getOutputStream();
        Assert.assertEquals(GZIPResponseStream.class, servletOutput.getClass());
        this.wrapper.resetBuffer();
        ((HttpServletResponse)Mockito.verify((Object)this.response)).setHeader("Content-Encoding", null);
        Mockito.when((Object)this.response.isCommitted()).thenReturn((Object)true);
        servletOutput = this.wrapper.getOutputStream();
        Assert.assertEquals(out.getClass(), servletOutput.getClass());
        Assert.assertNotNull((Object)this.wrapper.getWriter());
    }

    @Test
    public void testReset() throws IOException {
        Mockito.when((Object)this.response.isCommitted()).thenReturn((Object)false);
        ServletOutputStream out = (ServletOutputStream)Mockito.mock(ServletOutputStream.class);
        Mockito.when((Object)this.response.getOutputStream()).thenReturn((Object)out);
        ServletOutputStream servletOutput = this.wrapper.getOutputStream();
        ((HttpServletResponse)Mockito.verify((Object)this.response)).addHeader("Content-Encoding", "gzip");
        Assert.assertEquals(GZIPResponseStream.class, servletOutput.getClass());
        this.wrapper.reset();
        ((HttpServletResponse)Mockito.verify((Object)this.response)).setHeader("Content-Encoding", null);
        Mockito.when((Object)this.response.isCommitted()).thenReturn((Object)true);
        servletOutput = this.wrapper.getOutputStream();
        Assert.assertEquals(out.getClass(), servletOutput.getClass());
    }

    @Test
    public void testSendError() throws IOException {
        this.wrapper.sendError(404);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).sendError(404);
        this.wrapper.sendError(404, "error message");
        ((HttpServletResponse)Mockito.verify((Object)this.response)).sendError(404, "error message");
    }
}

