/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import javax.xml.bind.JAXBException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.rest.RowResourceBase;
import org.apache.hadoop.hbase.rest.client.Response;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RestTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RestTests.class, MediumTests.class})
public class TestDeleteRow
extends RowResourceBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDeleteRow.class);

    @Test
    public void testDeleteNonExistentColumn() throws Exception {
        Response response = TestDeleteRow.putValueJson("TestRowResource", "testrow1", "a:1", "testvalue1");
        Assert.assertEquals((long)200L, (long)response.getCode());
        response = TestDeleteRow.checkAndDeleteJson("TestRowResource", "testrow1", "a:1", "testvalue2");
        Assert.assertEquals((long)304L, (long)response.getCode());
        Assert.assertEquals((long)200L, (long)TestDeleteRow.getValueJson("TestRowResource", "testrow1", "a:1").getCode());
        response = TestDeleteRow.checkAndDeleteJson("TestRowResource", "testrow2", "a:1", "testvalue2");
        Assert.assertEquals((long)304L, (long)response.getCode());
        Assert.assertEquals((long)200L, (long)TestDeleteRow.getValueJson("TestRowResource", "testrow1", "a:1").getCode());
        response = TestDeleteRow.checkAndDeleteJson("TestRowResource", "testrow1", "dummy", "testvalue1");
        Assert.assertEquals((long)400L, (long)response.getCode());
        Assert.assertEquals((long)200L, (long)TestDeleteRow.getValueJson("TestRowResource", "testrow1", "a:1").getCode());
        response = TestDeleteRow.checkAndDeleteJson("TestRowResource", "testrow1", "dummy:test", "testvalue1");
        Assert.assertEquals((long)404L, (long)response.getCode());
        Assert.assertEquals((long)200L, (long)TestDeleteRow.getValueJson("TestRowResource", "testrow1", "a:1").getCode());
        response = TestDeleteRow.checkAndDeleteJson("TestRowResource", "testrow1", "a:test", "testvalue1");
        Assert.assertEquals((long)304L, (long)response.getCode());
        Assert.assertEquals((long)200L, (long)TestDeleteRow.getValueJson("TestRowResource", "testrow1", "a:1").getCode());
    }

    @Test
    public void testDeleteXML() throws IOException, JAXBException {
        Response response = TestDeleteRow.putValueXML("TestRowResource", "testrow1", "a:1", "testvalue1");
        Assert.assertEquals((long)200L, (long)response.getCode());
        response = TestDeleteRow.putValueXML("TestRowResource", "testrow1", "b:2", "testvalue2");
        Assert.assertEquals((long)200L, (long)response.getCode());
        TestDeleteRow.checkValueXML("TestRowResource", "testrow1", "a:1", "testvalue1");
        TestDeleteRow.checkValueXML("TestRowResource", "testrow1", "b:2", "testvalue2");
        response = TestDeleteRow.deleteValue("TestRowResource", "testrow1", "a:1");
        Assert.assertEquals((long)200L, (long)response.getCode());
        response = TestDeleteRow.getValueXML("TestRowResource", "testrow1", "a:1");
        Assert.assertEquals((long)404L, (long)response.getCode());
        TestDeleteRow.checkValueXML("TestRowResource", "testrow1", "b:2", "testvalue2");
        response = TestDeleteRow.putValueXML("TestRowResource", "testrow1", "a:1", "testvalue1");
        Assert.assertEquals((long)200L, (long)response.getCode());
        response = TestDeleteRow.checkAndDeletePB("TestRowResource", "testrow1", "a:1", "testvalue1");
        Assert.assertEquals((long)200L, (long)response.getCode());
        response = TestDeleteRow.getValueXML("TestRowResource", "testrow1", "a:1");
        Assert.assertEquals((long)404L, (long)response.getCode());
        response = TestDeleteRow.deleteRow("TestRowResource", "testrow1");
        Assert.assertEquals((long)200L, (long)response.getCode());
        response = TestDeleteRow.getValueXML("TestRowResource", "testrow1", "a:1");
        Assert.assertEquals((long)404L, (long)response.getCode());
        response = TestDeleteRow.getValueXML("TestRowResource", "testrow1", "b:2");
        Assert.assertEquals((long)404L, (long)response.getCode());
        response = TestDeleteRow.deleteValue("dummy", "testrow1", "a:1");
        Assert.assertEquals((long)404L, (long)response.getCode());
        response = TestDeleteRow.deleteValue("TestRowResource", "testrow1", "dummy");
        Assert.assertEquals((long)404L, (long)response.getCode());
    }

    private void testDeleteB64XML(boolean useQueryString) throws IOException, JAXBException {
        Response response = TestDeleteRow.putValueXML("TestRowResource", "testrow1", "a:1", "testvalue1");
        Assert.assertEquals((long)200L, (long)response.getCode());
        response = TestDeleteRow.putValueXML("TestRowResource", "testrow1", "b:2", "testvalue2");
        Assert.assertEquals((long)200L, (long)response.getCode());
        TestDeleteRow.checkValueXML("TestRowResource", "testrow1", "a:1", "testvalue1");
        TestDeleteRow.checkValueXML("TestRowResource", "testrow1", "b:2", "testvalue2");
        response = TestDeleteRow.deleteValueB64("TestRowResource", "testrow1", "a:1", useQueryString);
        Assert.assertEquals((long)200L, (long)response.getCode());
        response = TestDeleteRow.getValueXML("TestRowResource", "testrow1", "a:1");
        Assert.assertEquals((long)404L, (long)response.getCode());
        TestDeleteRow.checkValueXML("TestRowResource", "testrow1", "b:2", "testvalue2");
        response = TestDeleteRow.putValueXML("TestRowResource", "testrow1", "a:1", "testvalue1");
        Assert.assertEquals((long)200L, (long)response.getCode());
        response = TestDeleteRow.checkAndDeletePB("TestRowResource", "testrow1", "a:1", "testvalue1");
        Assert.assertEquals((long)200L, (long)response.getCode());
        response = TestDeleteRow.getValueXML("TestRowResource", "testrow1", "a:1");
        Assert.assertEquals((long)404L, (long)response.getCode());
        response = TestDeleteRow.deleteRowB64("TestRowResource", "testrow1", useQueryString);
        Assert.assertEquals((long)200L, (long)response.getCode());
        response = TestDeleteRow.getValueXML("TestRowResource", "testrow1", "a:1");
        Assert.assertEquals((long)404L, (long)response.getCode());
        response = TestDeleteRow.getValueXML("TestRowResource", "testrow1", "b:2");
        Assert.assertEquals((long)404L, (long)response.getCode());
    }

    @Test
    public void testDeleteB64XML() throws IOException, JAXBException {
        this.testDeleteB64XML(false);
        this.testDeleteB64XML(true);
    }
}

