/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.rest.HBaseRESTTestingUtility;
import org.apache.hadoop.hbase.rest.client.Client;
import org.apache.hadoop.hbase.rest.client.Cluster;
import org.apache.hadoop.hbase.rest.client.RemoteHTable;
import org.apache.hadoop.hbase.rest.client.Response;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RestTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RestTests.class, MediumTests.class})
public class TestRemoteTable {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRemoteTable.class);
    private static final String INVALID_URL_CHARS_1 = "|\"\\^{}\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\u000b\f";
    private static final String INVALID_URL_CHARS_2 = "|^{}\u0242";
    private static final String VALID_TABLE_NAME_CHARS = "_-.";
    private static final TableName TABLE = TableName.valueOf((String)"TestRemoteTable_-.");
    private static final byte[] ROW_1 = Bytes.toBytes((String)"testrow1|\"\\^{}\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\u000b\f");
    private static final byte[] ROW_2 = Bytes.toBytes((String)"testrow2|\"\\^{}\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\u000b\f");
    private static final byte[] ROW_3 = Bytes.toBytes((String)"testrow3|\"\\^{}\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\u000b\f");
    private static final byte[] ROW_4 = Bytes.toBytes((String)"testrow4|\"\\^{}\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\u000b\f");
    private static final byte[] COLUMN_1 = Bytes.toBytes((String)"a|^{}\u0242");
    private static final byte[] COLUMN_2 = Bytes.toBytes((String)"b|^{}\u0242");
    private static final byte[] COLUMN_3 = Bytes.toBytes((String)"c|^{}\u0242");
    private static final byte[] QUALIFIER_1 = Bytes.toBytes((String)"1|\"\\^{}\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\u000b\f");
    private static final byte[] QUALIFIER_2 = Bytes.toBytes((String)"2|\"\\^{}\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\u000b\f");
    private static final byte[] VALUE_1 = Bytes.toBytes((String)"testvalue1");
    private static final byte[] VALUE_2 = Bytes.toBytes((String)"testvalue2");
    private static final long ONE_HOUR = 3600000L;
    private static final long TS_2 = EnvironmentEdgeManager.currentTime();
    private static final long TS_1 = TS_2 - 3600000L;
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final HBaseRESTTestingUtility REST_TEST_UTIL = new HBaseRESTTestingUtility();
    private RemoteHTable remoteTable;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
        REST_TEST_UTIL.startServletContainer(TEST_UTIL.getConfiguration());
    }

    @Before
    public void before() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        if (admin.tableExists(TABLE)) {
            if (admin.isTableEnabled(TABLE)) {
                admin.disableTable(TABLE);
            }
            admin.deleteTable(TABLE);
        }
        HTableDescriptor htd = new HTableDescriptor(TABLE);
        htd.addFamily(new HColumnDescriptor(COLUMN_1).setMaxVersions(3));
        htd.addFamily(new HColumnDescriptor(COLUMN_2).setMaxVersions(3));
        htd.addFamily(new HColumnDescriptor(COLUMN_3).setMaxVersions(3));
        admin.createTable((TableDescriptor)htd);
        try (Table table = TEST_UTIL.getConnection().getTable(TABLE);){
            Put put = new Put(ROW_1);
            put.addColumn(COLUMN_1, QUALIFIER_1, TS_2, VALUE_1);
            table.put(put);
            put = new Put(ROW_2);
            put.addColumn(COLUMN_1, QUALIFIER_1, TS_1, VALUE_1);
            put.addColumn(COLUMN_1, QUALIFIER_1, TS_2, VALUE_2);
            put.addColumn(COLUMN_2, QUALIFIER_2, TS_2, VALUE_2);
            table.put(put);
        }
        this.remoteTable = new RemoteHTable(new Client(new Cluster().add("localhost", REST_TEST_UTIL.getServletPort())), TEST_UTIL.getConfiguration(), TABLE.toBytes());
    }

    @After
    public void after() throws Exception {
        this.remoteTable.close();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        REST_TEST_UTIL.shutdownServletContainer();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testGetTableDescriptor() throws IOException {
        Table table = null;
        try {
            table = TEST_UTIL.getConnection().getTable(TABLE);
            HTableDescriptor local = table.getTableDescriptor();
            Assert.assertEquals((Object)this.remoteTable.getTableDescriptor(), (Object)local);
        }
        finally {
            if (null != table) {
                table.close();
            }
        }
    }

    @Test
    public void testGet() throws IOException {
        Get get = new Get(ROW_1);
        Result result = this.remoteTable.get(get);
        byte[] value1 = result.getValue(COLUMN_1, QUALIFIER_1);
        byte[] value2 = result.getValue(COLUMN_2, QUALIFIER_2);
        Assert.assertNotNull((Object)value1);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_1, (byte[])value1));
        Assert.assertNull((Object)value2);
        get = new Get(ROW_1);
        get.addFamily(COLUMN_3);
        result = this.remoteTable.get(get);
        value1 = result.getValue(COLUMN_1, QUALIFIER_1);
        value2 = result.getValue(COLUMN_2, QUALIFIER_2);
        Assert.assertNull((Object)value1);
        Assert.assertNull((Object)value2);
        get = new Get(ROW_1);
        get.addColumn(COLUMN_1, QUALIFIER_1);
        get.addColumn(COLUMN_2, QUALIFIER_2);
        result = this.remoteTable.get(get);
        value1 = result.getValue(COLUMN_1, QUALIFIER_1);
        value2 = result.getValue(COLUMN_2, QUALIFIER_2);
        Assert.assertNotNull((Object)value1);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_1, (byte[])value1));
        Assert.assertNull((Object)value2);
        get = new Get(ROW_2);
        result = this.remoteTable.get(get);
        value1 = result.getValue(COLUMN_1, QUALIFIER_1);
        value2 = result.getValue(COLUMN_2, QUALIFIER_2);
        Assert.assertNotNull((Object)value1);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_2, (byte[])value1));
        Assert.assertNotNull((Object)value2);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_2, (byte[])value2));
        get = new Get(ROW_2);
        get.addFamily(COLUMN_1);
        result = this.remoteTable.get(get);
        value1 = result.getValue(COLUMN_1, QUALIFIER_1);
        value2 = result.getValue(COLUMN_2, QUALIFIER_2);
        Assert.assertNotNull((Object)value1);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_2, (byte[])value1));
        Assert.assertNull((Object)value2);
        get = new Get(ROW_2);
        get.addColumn(COLUMN_1, QUALIFIER_1);
        get.addColumn(COLUMN_2, QUALIFIER_2);
        result = this.remoteTable.get(get);
        value1 = result.getValue(COLUMN_1, QUALIFIER_1);
        value2 = result.getValue(COLUMN_2, QUALIFIER_2);
        Assert.assertNotNull((Object)value1);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_2, (byte[])value1));
        Assert.assertNotNull((Object)value2);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_2, (byte[])value2));
        get = new Get(ROW_2);
        get.addFamily(COLUMN_1);
        get.addFamily(COLUMN_2);
        get.setTimestamp(TS_1);
        result = this.remoteTable.get(get);
        value1 = result.getValue(COLUMN_1, QUALIFIER_1);
        value2 = result.getValue(COLUMN_2, QUALIFIER_2);
        Assert.assertNotNull((Object)value1);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_1, (byte[])value1));
        Assert.assertNull((Object)value2);
        get = new Get(ROW_2);
        get.addFamily(COLUMN_1);
        get.addFamily(COLUMN_2);
        get.setTimeRange(0L, TS_1 + 1L);
        result = this.remoteTable.get(get);
        value1 = result.getValue(COLUMN_1, QUALIFIER_1);
        value2 = result.getValue(COLUMN_2, QUALIFIER_2);
        Assert.assertNotNull((Object)value1);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_1, (byte[])value1));
        Assert.assertNull((Object)value2);
        get = new Get(ROW_2);
        get.addFamily(COLUMN_1);
        get.setMaxVersions(2);
        result = this.remoteTable.get(get);
        int count = 0;
        for (Cell kv : result.listCells()) {
            if (CellUtil.matchingFamily((Cell)kv, (byte[])COLUMN_1) && TS_1 == kv.getTimestamp()) {
                Assert.assertTrue((boolean)CellUtil.matchingValue((Cell)kv, (byte[])VALUE_1));
                ++count;
            }
            if (!CellUtil.matchingFamily((Cell)kv, (byte[])COLUMN_1) || TS_2 != kv.getTimestamp()) continue;
            Assert.assertTrue((boolean)CellUtil.matchingValue((Cell)kv, (byte[])VALUE_2));
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testMultiGet() throws Exception {
        ArrayList<Object> gets = new ArrayList<Get>(2);
        gets.add(new Get(ROW_1));
        gets.add(new Get(ROW_2));
        Result[] results = this.remoteTable.get(gets);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)2L, (long)results.length);
        Assert.assertEquals((long)1L, (long)results[0].size());
        Assert.assertEquals((long)2L, (long)results[1].size());
        gets = new ArrayList(2);
        Get g = new Get(ROW_1);
        g.setMaxVersions(3);
        gets.add(g);
        gets.add(new Get(ROW_2));
        results = this.remoteTable.get(gets);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)2L, (long)results.length);
        Assert.assertEquals((long)1L, (long)results[0].size());
        Assert.assertEquals((long)3L, (long)results[1].size());
        gets = new ArrayList(1);
        gets.add(new Get(Bytes.toBytes((String)"RESALLYREALLYNOTTHERE")));
        results = this.remoteTable.get(gets);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)0L, (long)results.length);
        gets = new ArrayList(3);
        gets.add(new Get(Bytes.toBytes((String)"RESALLYREALLYNOTTHERE")));
        gets.add(new Get(ROW_1));
        gets.add(new Get(ROW_2));
        results = this.remoteTable.get(gets);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)2L, (long)results.length);
    }

    @Test
    public void testPut() throws IOException {
        Put put = new Put(ROW_3);
        put.addColumn(COLUMN_1, QUALIFIER_1, VALUE_1);
        this.remoteTable.put(put);
        Get get = new Get(ROW_3);
        get.addFamily(COLUMN_1);
        Result result = this.remoteTable.get(get);
        byte[] value = result.getValue(COLUMN_1, QUALIFIER_1);
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_1, (byte[])value));
        ArrayList<Put> puts = new ArrayList<Put>(3);
        put = new Put(ROW_3);
        put.addColumn(COLUMN_2, QUALIFIER_2, VALUE_2);
        puts.add(put);
        put = new Put(ROW_4);
        put.addColumn(COLUMN_1, QUALIFIER_1, VALUE_1);
        puts.add(put);
        put = new Put(ROW_4);
        put.addColumn(COLUMN_2, QUALIFIER_2, VALUE_2);
        puts.add(put);
        this.remoteTable.put(puts);
        get = new Get(ROW_3);
        get.addFamily(COLUMN_2);
        result = this.remoteTable.get(get);
        value = result.getValue(COLUMN_2, QUALIFIER_2);
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_2, (byte[])value));
        get = new Get(ROW_4);
        result = this.remoteTable.get(get);
        value = result.getValue(COLUMN_1, QUALIFIER_1);
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_1, (byte[])value));
        value = result.getValue(COLUMN_2, QUALIFIER_2);
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_2, (byte[])value));
        Assert.assertTrue((boolean)Bytes.equals((byte[])Bytes.toBytes((String)"TestRemoteTable_-."), (byte[])this.remoteTable.getTableName()));
    }

    @Test
    public void testDelete() throws IOException {
        Put put = new Put(ROW_3);
        put.addColumn(COLUMN_1, QUALIFIER_1, VALUE_1);
        put.addColumn(COLUMN_2, QUALIFIER_2, VALUE_2);
        put.addColumn(COLUMN_3, QUALIFIER_1, VALUE_1);
        put.addColumn(COLUMN_3, QUALIFIER_2, VALUE_2);
        this.remoteTable.put(put);
        Get get = new Get(ROW_3);
        get.addFamily(COLUMN_1);
        get.addFamily(COLUMN_2);
        get.addFamily(COLUMN_3);
        Result result = this.remoteTable.get(get);
        byte[] value1 = result.getValue(COLUMN_1, QUALIFIER_1);
        byte[] value2 = result.getValue(COLUMN_2, QUALIFIER_2);
        byte[] value3 = result.getValue(COLUMN_3, QUALIFIER_1);
        byte[] value4 = result.getValue(COLUMN_3, QUALIFIER_2);
        Assert.assertNotNull((Object)value1);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_1, (byte[])value1));
        Assert.assertNotNull((Object)value2);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_2, (byte[])value2));
        Assert.assertNotNull((Object)value3);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_1, (byte[])value3));
        Assert.assertNotNull((Object)value4);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_2, (byte[])value4));
        Delete delete = new Delete(ROW_3);
        delete.addColumn(COLUMN_2, QUALIFIER_2);
        this.remoteTable.delete(delete);
        get = new Get(ROW_3);
        get.addFamily(COLUMN_1);
        get.addFamily(COLUMN_2);
        result = this.remoteTable.get(get);
        value1 = result.getValue(COLUMN_1, QUALIFIER_1);
        value2 = result.getValue(COLUMN_2, QUALIFIER_2);
        Assert.assertNotNull((Object)value1);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_1, (byte[])value1));
        Assert.assertNull((Object)value2);
        delete = new Delete(ROW_3);
        delete.setTimestamp(1L);
        this.remoteTable.delete(delete);
        get = new Get(ROW_3);
        get.addFamily(COLUMN_1);
        get.addFamily(COLUMN_2);
        result = this.remoteTable.get(get);
        value1 = result.getValue(COLUMN_1, QUALIFIER_1);
        value2 = result.getValue(COLUMN_2, QUALIFIER_2);
        Assert.assertNotNull((Object)value1);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_1, (byte[])value1));
        Assert.assertNull((Object)value2);
        delete = new Delete(ROW_3);
        delete.addFamily(COLUMN_3);
        this.remoteTable.delete(delete);
        get = new Get(ROW_3);
        get.addFamily(COLUMN_3);
        result = this.remoteTable.get(get);
        value3 = result.getValue(COLUMN_3, QUALIFIER_1);
        value4 = result.getValue(COLUMN_3, QUALIFIER_2);
        Assert.assertNull((Object)value3);
        Assert.assertNull((Object)value4);
        delete = new Delete(ROW_3);
        this.remoteTable.delete(delete);
        get = new Get(ROW_3);
        get.addFamily(COLUMN_1);
        get.addFamily(COLUMN_2);
        result = this.remoteTable.get(get);
        value1 = result.getValue(COLUMN_1, QUALIFIER_1);
        value2 = result.getValue(COLUMN_2, QUALIFIER_2);
        Assert.assertNull((Object)value1);
        Assert.assertNull((Object)value2);
    }

    @Test
    public void testScanner() throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>(4);
        Put put = new Put(ROW_1);
        put.addColumn(COLUMN_1, QUALIFIER_1, VALUE_1);
        puts.add(put);
        put = new Put(ROW_2);
        put.addColumn(COLUMN_1, QUALIFIER_1, VALUE_1);
        puts.add(put);
        put = new Put(ROW_3);
        put.addColumn(COLUMN_1, QUALIFIER_1, VALUE_1);
        puts.add(put);
        put = new Put(ROW_4);
        put.addColumn(COLUMN_1, QUALIFIER_1, VALUE_1);
        puts.add(put);
        this.remoteTable.put(puts);
        ResultScanner scanner = this.remoteTable.getScanner(new Scan());
        Result[] results = scanner.next(1);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)1L, (long)results.length);
        Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_1, (byte[])results[0].getRow()));
        Result result = scanner.next();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_2, (byte[])result.getRow()));
        results = scanner.next(2);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)2L, (long)results.length);
        Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_3, (byte[])results[0].getRow()));
        Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_4, (byte[])results[1].getRow()));
        results = scanner.next(1);
        Assert.assertNull((Object)results);
        scanner.close();
        scanner = this.remoteTable.getScanner(COLUMN_1);
        results = scanner.next(4);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)4L, (long)results.length);
        Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_1, (byte[])results[0].getRow()));
        Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_2, (byte[])results[1].getRow()));
        Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_3, (byte[])results[2].getRow()));
        Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_4, (byte[])results[3].getRow()));
        scanner.close();
        scanner = this.remoteTable.getScanner(COLUMN_1, QUALIFIER_1);
        results = scanner.next(4);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)4L, (long)results.length);
        Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_1, (byte[])results[0].getRow()));
        Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_2, (byte[])results[1].getRow()));
        Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_3, (byte[])results[2].getRow()));
        Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_4, (byte[])results[3].getRow()));
        scanner.close();
        Assert.assertTrue((boolean)this.remoteTable.isAutoFlush());
    }

    @Test
    public void testCheckAndDelete() throws IOException {
        Get get = new Get(ROW_1);
        Result result = this.remoteTable.get(get);
        byte[] value1 = result.getValue(COLUMN_1, QUALIFIER_1);
        byte[] value2 = result.getValue(COLUMN_2, QUALIFIER_2);
        Assert.assertNotNull((Object)value1);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_1, (byte[])value1));
        Assert.assertNull((Object)value2);
        Assert.assertTrue((boolean)this.remoteTable.exists(get));
        Assert.assertEquals((long)1L, (long)this.remoteTable.existsAll(Collections.singletonList(get)).length);
        Delete delete = new Delete(ROW_1);
        this.remoteTable.checkAndMutate(ROW_1, COLUMN_1).qualifier(QUALIFIER_1).ifEquals(VALUE_1).thenDelete(delete);
        Assert.assertFalse((boolean)this.remoteTable.exists(get));
        Put put = new Put(ROW_1);
        put.addColumn(COLUMN_1, QUALIFIER_1, VALUE_1);
        this.remoteTable.put(put);
        Assert.assertTrue((boolean)this.remoteTable.checkAndMutate(ROW_1, COLUMN_1).qualifier(QUALIFIER_1).ifEquals(VALUE_1).thenPut(put));
        Assert.assertFalse((boolean)this.remoteTable.checkAndMutate(ROW_1, COLUMN_1).qualifier(QUALIFIER_1).ifEquals(VALUE_2).thenPut(put));
    }

    @Test
    public void testIteratorScaner() throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>(4);
        Put put = new Put(ROW_1);
        put.addColumn(COLUMN_1, QUALIFIER_1, VALUE_1);
        puts.add(put);
        put = new Put(ROW_2);
        put.addColumn(COLUMN_1, QUALIFIER_1, VALUE_1);
        puts.add(put);
        put = new Put(ROW_3);
        put.addColumn(COLUMN_1, QUALIFIER_1, VALUE_1);
        puts.add(put);
        put = new Put(ROW_4);
        put.addColumn(COLUMN_1, QUALIFIER_1, VALUE_1);
        puts.add(put);
        this.remoteTable.put(puts);
        ResultScanner scanner = this.remoteTable.getScanner(new Scan());
        Iterator iterator = scanner.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        int counter = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++counter;
        }
        Assert.assertEquals((long)4L, (long)counter);
    }

    @Test
    public void testResponse() {
        Response response = new Response(200);
        Assert.assertEquals((long)200L, (long)response.getCode());
        Header[] headers = new Header[]{new BasicHeader("header1", "value1"), new BasicHeader("header2", "value2")};
        response = new Response(200, headers);
        Assert.assertEquals((Object)"value1", (Object)response.getHeader("header1"));
        Assert.assertFalse((boolean)response.hasBody());
        response.setCode(404);
        Assert.assertEquals((long)404L, (long)response.getCode());
        headers = new Header[]{new BasicHeader("header1", "value1.1"), new BasicHeader("header2", "value2")};
        response.setHeaders(headers);
        Assert.assertEquals((Object)"value1.1", (Object)response.getHeader("header1"));
        response.setBody(Bytes.toBytes((String)"body"));
        Assert.assertTrue((boolean)response.hasBody());
    }

    @Test
    public void testLongLivedScan() throws Exception {
        int numTrials = 6;
        int trialPause = 1000;
        int cleanUpInterval = 100;
        REST_TEST_UTIL.shutdownServletContainer();
        TEST_UTIL.getConfiguration().setLong("hbase.rest.connection.max-idletime", (long)(numTrials / 2 * trialPause));
        TEST_UTIL.getConfiguration().setLong("hbase.rest.connection.cleanup-interval", (long)cleanUpInterval);
        REST_TEST_UTIL.startServletContainer(TEST_UTIL.getConfiguration());
        TEST_UTIL.getHBaseAdmin().disableTable(TABLE);
        TEST_UTIL.getHBaseAdmin().truncateTable(TABLE, false);
        this.remoteTable = new RemoteHTable(new Client(new Cluster().add("localhost", REST_TEST_UTIL.getServletPort())), TEST_UTIL.getConfiguration(), TABLE.toBytes());
        String row = "testrow";
        try (Table table = TEST_UTIL.getConnection().getTable(TABLE);){
            ArrayList<Put> puts = new ArrayList<Put>();
            Put put = null;
            for (int i = 1; i <= numTrials; ++i) {
                put = new Put(Bytes.toBytes((String)(row + i)));
                put.addColumn(COLUMN_1, QUALIFIER_1, TS_2, Bytes.toBytes((String)("testvalue" + i)));
                puts.add(put);
            }
            table.put(puts);
        }
        Scan scan = new Scan();
        scan.setCaching(1);
        scan.setBatch(1);
        ResultScanner scanner = this.remoteTable.getScanner(scan);
        Result result = null;
        for (int i = 1; i <= numTrials; ++i) {
            result = scanner.next();
            Assert.assertEquals((Object)(row + i), (Object)Bytes.toString((byte[])result.getRow()));
            Thread.sleep(trialPause);
        }
    }
}

