/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.rest.HBaseRESTTestingUtility;
import org.apache.hadoop.hbase.rest.client.Client;
import org.apache.hadoop.hbase.rest.client.Cluster;
import org.apache.hadoop.hbase.rest.client.Response;
import org.apache.hadoop.hbase.rest.model.CellModel;
import org.apache.hadoop.hbase.rest.model.CellSetModel;
import org.apache.hadoop.hbase.rest.model.RowModel;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import org.apache.hbase.thirdparty.javax.ws.rs.core.MediaType;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;

public class RowResourceBase {
    protected static final String TABLE = "TestRowResource";
    protected static final TableName TABLE_NAME = TableName.valueOf((String)"TestRowResource");
    protected static final String CFA = "a";
    protected static final String CFB = "b";
    protected static final String COLUMN_1 = "a:1";
    protected static final String COLUMN_2 = "b:2";
    protected static final String COLUMN_3 = "a:";
    protected static final String ROW_1 = "testrow1";
    protected static final String VALUE_1 = "testvalue1";
    protected static final String ROW_2 = "testrow2";
    protected static final String VALUE_2 = "testvalue2";
    protected static final String ROW_3 = "testrow3";
    protected static final String VALUE_3 = "testvalue3";
    protected static final String ROW_4 = "testrow4";
    protected static final String VALUE_4 = "testvalue4";
    protected static final String VALUE_5 = "5";
    protected static final String VALUE_6 = "6";
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    protected static final HBaseRESTTestingUtility REST_TEST_UTIL = new HBaseRESTTestingUtility();
    protected static Client client;
    protected static JAXBContext context;
    protected static Marshaller xmlMarshaller;
    protected static Unmarshaller xmlUnmarshaller;
    protected static Configuration conf;
    protected static ObjectMapper jsonMapper;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        TEST_UTIL.startMiniCluster(3);
        REST_TEST_UTIL.startServletContainer(conf);
        context = JAXBContext.newInstance((Class[])new Class[]{CellModel.class, CellSetModel.class, RowModel.class});
        xmlMarshaller = context.createMarshaller();
        xmlUnmarshaller = context.createUnmarshaller();
        jsonMapper = new JacksonJaxbJsonProvider().locateMapper(CellSetModel.class, MediaType.APPLICATION_JSON_TYPE);
        client = new Client(new Cluster().add("localhost", REST_TEST_UTIL.getServletPort()));
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        REST_TEST_UTIL.shutdownServletContainer();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void beforeMethod() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        if (admin.tableExists(TABLE_NAME)) {
            TEST_UTIL.deleteTable(TABLE_NAME);
        }
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)TABLE));
        htd.addFamily(new HColumnDescriptor(CFA));
        htd.addFamily(new HColumnDescriptor(CFB));
        admin.createTable((TableDescriptor)htd);
    }

    @After
    public void afterMethod() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        if (admin.tableExists(TABLE_NAME)) {
            TEST_UTIL.deleteTable(TABLE_NAME);
        }
    }

    static Response putValuePB(String table, String row, String column, String value) throws IOException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        path.append(table);
        path.append('/');
        path.append(row);
        path.append('/');
        path.append(column);
        return RowResourceBase.putValuePB(path.toString(), table, row, column, value);
    }

    static Response putValuePB(String url, String table, String row, String column, String value) throws IOException {
        RowModel rowModel = new RowModel(row);
        rowModel.addCell(new CellModel(Bytes.toBytes((String)column), Bytes.toBytes((String)value)));
        CellSetModel cellSetModel = new CellSetModel();
        cellSetModel.addRow(rowModel);
        Response response = client.put(url, "application/x-protobuf", cellSetModel.createProtobufOutput());
        Thread.yield();
        return response;
    }

    protected static void checkValueXML(String url, String table, String row, String column, String value) throws IOException, JAXBException {
        Response response = RowResourceBase.getValueXML(url);
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"text/xml", (Object)response.getHeader("content-type"));
        CellSetModel cellSet = (CellSetModel)xmlUnmarshaller.unmarshal((InputStream)new ByteArrayInputStream(response.getBody()));
        RowModel rowModel = (RowModel)cellSet.getRows().get(0);
        CellModel cell = (CellModel)rowModel.getCells().get(0);
        Assert.assertEquals((Object)Bytes.toString((byte[])cell.getColumn()), (Object)column);
        Assert.assertEquals((Object)Bytes.toString((byte[])cell.getValue()), (Object)value);
    }

    protected static void checkValueXML(String table, String row, String column, String value) throws IOException, JAXBException {
        Response response = RowResourceBase.getValueXML(table, row, column);
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"text/xml", (Object)response.getHeader("content-type"));
        CellSetModel cellSet = (CellSetModel)xmlUnmarshaller.unmarshal((InputStream)new ByteArrayInputStream(response.getBody()));
        RowModel rowModel = (RowModel)cellSet.getRows().get(0);
        CellModel cell = (CellModel)rowModel.getCells().get(0);
        Assert.assertEquals((Object)Bytes.toString((byte[])cell.getColumn()), (Object)column);
        Assert.assertEquals((Object)Bytes.toString((byte[])cell.getValue()), (Object)value);
    }

    protected static void checkIncrementValueXML(String table, String row, String column, long value) throws IOException, JAXBException {
        Response response1 = RowResourceBase.getValueXML(table, row, column);
        Assert.assertEquals((long)200L, (long)response1.getCode());
        Assert.assertEquals((Object)"text/xml", (Object)response1.getHeader("content-type"));
        CellSetModel cellSet = (CellSetModel)xmlUnmarshaller.unmarshal((InputStream)new ByteArrayInputStream(response1.getBody()));
        RowModel rowModel = (RowModel)cellSet.getRows().get(0);
        CellModel cell = (CellModel)rowModel.getCells().get(0);
        Assert.assertEquals((Object)Bytes.toString((byte[])cell.getColumn()), (Object)column);
        Assert.assertEquals((long)Bytes.toLong((byte[])cell.getValue()), (long)value);
    }

    protected static Response getValuePB(String url) throws IOException {
        Response response = client.get(url, "application/x-protobuf");
        return response;
    }

    protected static Response putValueXML(String table, String row, String column, String value) throws IOException, JAXBException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        path.append(table);
        path.append('/');
        path.append(row);
        path.append('/');
        path.append(column);
        return RowResourceBase.putValueXML(path.toString(), table, row, column, value);
    }

    protected static Response putValueXML(String url, String table, String row, String column, String value) throws IOException, JAXBException {
        RowModel rowModel = new RowModel(row);
        rowModel.addCell(new CellModel(Bytes.toBytes((String)column), Bytes.toBytes((String)value)));
        CellSetModel cellSetModel = new CellSetModel();
        cellSetModel.addRow(rowModel);
        StringWriter writer = new StringWriter();
        xmlMarshaller.marshal((Object)cellSetModel, (Writer)writer);
        Response response = client.put(url, "text/xml", Bytes.toBytes((String)writer.toString()));
        Thread.yield();
        return response;
    }

    protected static Response getValuePB(String table, String row, String column) throws IOException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        path.append(table);
        path.append('/');
        path.append(row);
        path.append('/');
        path.append(column);
        return RowResourceBase.getValuePB(path.toString());
    }

    protected static void checkValuePB(String table, String row, String column, String value) throws IOException {
        Response response = RowResourceBase.getValuePB(table, row, column);
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"application/x-protobuf", (Object)response.getHeader("content-type"));
        CellSetModel cellSet = new CellSetModel();
        cellSet.getObjectFromMessage(response.getBody());
        RowModel rowModel = (RowModel)cellSet.getRows().get(0);
        CellModel cell = (CellModel)rowModel.getCells().get(0);
        Assert.assertEquals((Object)Bytes.toString((byte[])cell.getColumn()), (Object)column);
        Assert.assertEquals((Object)Bytes.toString((byte[])cell.getValue()), (Object)value);
    }

    protected static void checkIncrementValuePB(String table, String row, String column, long value) throws IOException {
        Response response = RowResourceBase.getValuePB(table, row, column);
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"application/x-protobuf", (Object)response.getHeader("content-type"));
        CellSetModel cellSet = new CellSetModel();
        cellSet.getObjectFromMessage(response.getBody());
        RowModel rowModel = (RowModel)cellSet.getRows().get(0);
        CellModel cell = (CellModel)rowModel.getCells().get(0);
        Assert.assertEquals((Object)Bytes.toString((byte[])cell.getColumn()), (Object)column);
        Assert.assertEquals((long)Bytes.toLong((byte[])cell.getValue()), (long)value);
    }

    protected static Response checkAndPutValuePB(String url, String table, String row, String column, String valueToCheck, String valueToPut, HashMap<String, String> otherCells) throws IOException {
        RowModel rowModel = new RowModel(row);
        rowModel.addCell(new CellModel(Bytes.toBytes((String)column), Bytes.toBytes((String)valueToPut)));
        if (otherCells != null) {
            for (Map.Entry<String, String> entry : otherCells.entrySet()) {
                rowModel.addCell(new CellModel(Bytes.toBytes((String)entry.getKey()), Bytes.toBytes((String)entry.getValue())));
            }
        }
        rowModel.addCell(new CellModel(Bytes.toBytes((String)column), Bytes.toBytes((String)valueToCheck)));
        CellSetModel cellSetModel = new CellSetModel();
        cellSetModel.addRow(rowModel);
        Response response = client.put(url, "application/x-protobuf", cellSetModel.createProtobufOutput());
        Thread.yield();
        return response;
    }

    protected static Response checkAndPutValuePB(String table, String row, String column, String valueToCheck, String valueToPut) throws IOException {
        return RowResourceBase.checkAndPutValuePB(table, row, column, valueToCheck, valueToPut, null);
    }

    protected static Response checkAndPutValuePB(String table, String row, String column, String valueToCheck, String valueToPut, HashMap<String, String> otherCells) throws IOException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        path.append(table);
        path.append('/');
        path.append(row);
        path.append("?check=put");
        return RowResourceBase.checkAndPutValuePB(path.toString(), table, row, column, valueToCheck, valueToPut, otherCells);
    }

    protected static Response checkAndPutValueXML(String url, String table, String row, String column, String valueToCheck, String valueToPut, HashMap<String, String> otherCells) throws IOException, JAXBException {
        RowModel rowModel = new RowModel(row);
        rowModel.addCell(new CellModel(Bytes.toBytes((String)column), Bytes.toBytes((String)valueToPut)));
        if (otherCells != null) {
            for (Map.Entry<String, String> entry : otherCells.entrySet()) {
                rowModel.addCell(new CellModel(Bytes.toBytes((String)entry.getKey()), Bytes.toBytes((String)entry.getValue())));
            }
        }
        rowModel.addCell(new CellModel(Bytes.toBytes((String)column), Bytes.toBytes((String)valueToCheck)));
        CellSetModel cellSetModel = new CellSetModel();
        cellSetModel.addRow(rowModel);
        StringWriter writer = new StringWriter();
        xmlMarshaller.marshal((Object)cellSetModel, (Writer)writer);
        Response response = client.put(url, "text/xml", Bytes.toBytes((String)writer.toString()));
        Thread.yield();
        return response;
    }

    protected static Response checkAndPutValueXML(String table, String row, String column, String valueToCheck, String valueToPut) throws IOException, JAXBException {
        return RowResourceBase.checkAndPutValueXML(table, row, column, valueToCheck, valueToPut, null);
    }

    protected static Response checkAndPutValueXML(String table, String row, String column, String valueToCheck, String valueToPut, HashMap<String, String> otherCells) throws IOException, JAXBException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        path.append(table);
        path.append('/');
        path.append(row);
        path.append("?check=put");
        return RowResourceBase.checkAndPutValueXML(path.toString(), table, row, column, valueToCheck, valueToPut, otherCells);
    }

    protected static Response checkAndDeleteXML(String url, String table, String row, String column, String valueToCheck, HashMap<String, String> cellsToDelete) throws IOException, JAXBException {
        RowModel rowModel = new RowModel(row);
        if (cellsToDelete != null) {
            for (Map.Entry<String, String> entry : cellsToDelete.entrySet()) {
                rowModel.addCell(new CellModel(Bytes.toBytes((String)entry.getKey()), Bytes.toBytes((String)entry.getValue())));
            }
        }
        rowModel.addCell(new CellModel(Bytes.toBytes((String)column), Bytes.toBytes((String)valueToCheck)));
        CellSetModel cellSetModel = new CellSetModel();
        cellSetModel.addRow(rowModel);
        StringWriter writer = new StringWriter();
        xmlMarshaller.marshal((Object)cellSetModel, (Writer)writer);
        Response response = client.put(url, "text/xml", Bytes.toBytes((String)writer.toString()));
        Thread.yield();
        return response;
    }

    protected static Response checkAndDeleteXML(String table, String row, String column, String valueToCheck) throws IOException, JAXBException {
        return RowResourceBase.checkAndDeleteXML(table, row, column, valueToCheck, null);
    }

    protected static Response checkAndDeleteXML(String table, String row, String column, String valueToCheck, HashMap<String, String> cellsToDelete) throws IOException, JAXBException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        path.append(table);
        path.append('/');
        path.append(row);
        path.append("?check=delete");
        return RowResourceBase.checkAndDeleteXML(path.toString(), table, row, column, valueToCheck, cellsToDelete);
    }

    protected static Response checkAndDeleteJson(String table, String row, String column, String valueToCheck) throws IOException {
        return RowResourceBase.checkAndDeleteJson(table, row, column, valueToCheck, null);
    }

    protected static Response checkAndDeleteJson(String table, String row, String column, String valueToCheck, HashMap<String, String> cellsToDelete) throws IOException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        path.append(table);
        path.append('/');
        path.append(row);
        path.append("?check=delete");
        return RowResourceBase.checkAndDeleteJson(path.toString(), table, row, column, valueToCheck, cellsToDelete);
    }

    protected static Response checkAndDeleteJson(String url, String table, String row, String column, String valueToCheck, HashMap<String, String> cellsToDelete) throws IOException {
        RowModel rowModel = new RowModel(row);
        if (cellsToDelete != null) {
            for (Map.Entry<String, String> entry : cellsToDelete.entrySet()) {
                rowModel.addCell(new CellModel(Bytes.toBytes((String)entry.getKey()), Bytes.toBytes((String)entry.getValue())));
            }
        }
        rowModel.addCell(new CellModel(Bytes.toBytes((String)column), Bytes.toBytes((String)valueToCheck)));
        CellSetModel cellSetModel = new CellSetModel();
        cellSetModel.addRow(rowModel);
        String jsonString = jsonMapper.writeValueAsString((Object)cellSetModel);
        Response response = client.put(url, "application/json", Bytes.toBytes((String)jsonString));
        Thread.yield();
        return response;
    }

    protected static Response checkAndDeletePB(String table, String row, String column, String value) throws IOException {
        return RowResourceBase.checkAndDeletePB(table, row, column, value, null);
    }

    protected static Response checkAndDeletePB(String table, String row, String column, String value, HashMap<String, String> cellsToDelete) throws IOException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        path.append(table);
        path.append('/');
        path.append(row);
        path.append("?check=delete");
        return RowResourceBase.checkAndDeleteValuePB(path.toString(), table, row, column, value, cellsToDelete);
    }

    protected static Response checkAndDeleteValuePB(String url, String table, String row, String column, String valueToCheck, HashMap<String, String> cellsToDelete) throws IOException {
        RowModel rowModel = new RowModel(row);
        if (cellsToDelete != null) {
            for (Map.Entry<String, String> entry : cellsToDelete.entrySet()) {
                rowModel.addCell(new CellModel(Bytes.toBytes((String)entry.getKey()), Bytes.toBytes((String)entry.getValue())));
            }
        }
        rowModel.addCell(new CellModel(Bytes.toBytes((String)column), Bytes.toBytes((String)valueToCheck)));
        CellSetModel cellSetModel = new CellSetModel();
        cellSetModel.addRow(rowModel);
        Response response = client.put(url, "application/x-protobuf", cellSetModel.createProtobufOutput());
        Thread.yield();
        return response;
    }

    protected static Response getValueXML(String table, String startRow, String endRow, String column) throws IOException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        path.append(table);
        path.append('/');
        path.append(startRow);
        path.append(",");
        path.append(endRow);
        path.append('/');
        path.append(column);
        return RowResourceBase.getValueXML(path.toString());
    }

    protected static Response getValueXML(String url) throws IOException {
        Response response = client.get(url, "text/xml");
        return response;
    }

    protected static Response getValueXML(String url, Header[] headers) throws IOException {
        Header[] fullHeaders = new Header[headers.length + 1];
        for (int i = 0; i < headers.length; ++i) {
            fullHeaders[i] = headers[i];
        }
        fullHeaders[headers.length] = new BasicHeader("Accept", "text/xml");
        Response response = client.get(url, fullHeaders);
        return response;
    }

    protected static Response getValueJson(String url) throws IOException {
        Response response = client.get(url, "application/json");
        return response;
    }

    protected static Response deleteValue(String table, String row, String column) throws IOException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        path.append(table);
        path.append('/');
        path.append(row);
        path.append('/');
        path.append(column);
        Response response = client.delete(path.toString());
        Thread.yield();
        return response;
    }

    protected static Response deleteValueB64(String table, String row, String column, boolean useQueryString) throws IOException {
        Response response;
        StringBuilder path = new StringBuilder();
        Base64.Encoder encoder = Base64.getUrlEncoder();
        path.append('/');
        path.append(table);
        path.append('/');
        path.append(encoder.encodeToString(row.getBytes("UTF-8")));
        path.append('/');
        path.append(encoder.encodeToString(column.getBytes("UTF-8")));
        if (useQueryString) {
            path.append("?e=b64");
            response = client.delete(path.toString());
        } else {
            response = client.delete(path.toString(), (Header)new BasicHeader("Encoding", "b64"));
        }
        Thread.yield();
        return response;
    }

    protected static Response getValueXML(String table, String row, String column) throws IOException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        path.append(table);
        path.append('/');
        path.append(row);
        path.append('/');
        path.append(column);
        return RowResourceBase.getValueXML(path.toString());
    }

    protected static Response deleteRow(String table, String row) throws IOException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        path.append(table);
        path.append('/');
        path.append(row);
        Response response = client.delete(path.toString());
        Thread.yield();
        return response;
    }

    protected static Response deleteRowB64(String table, String row, boolean useQueryString) throws IOException {
        Response response;
        StringBuilder path = new StringBuilder();
        Base64.Encoder encoder = Base64.getUrlEncoder();
        path.append('/');
        path.append(table);
        path.append('/');
        path.append(encoder.encodeToString(row.getBytes("UTF-8")));
        if (useQueryString) {
            path.append("?e=b64");
            response = client.delete(path.toString());
        } else {
            response = client.delete(path.toString(), (Header)new BasicHeader("Encoding", "b64"));
        }
        Thread.yield();
        return response;
    }

    protected static Response getValueJson(String table, String row, String column) throws IOException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        path.append(table);
        path.append('/');
        path.append(row);
        path.append('/');
        path.append(column);
        return RowResourceBase.getValueJson(path.toString());
    }

    protected static void checkValueJSON(String table, String row, String column, String value) throws IOException {
        Response response = RowResourceBase.getValueJson(table, row, column);
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"application/json", (Object)response.getHeader("content-type"));
        ObjectMapper mapper = new JacksonJaxbJsonProvider().locateMapper(CellSetModel.class, MediaType.APPLICATION_JSON_TYPE);
        CellSetModel cellSet = (CellSetModel)mapper.readValue(response.getBody(), CellSetModel.class);
        RowModel rowModel = (RowModel)cellSet.getRows().get(0);
        CellModel cell = (CellModel)rowModel.getCells().get(0);
        Assert.assertEquals((Object)Bytes.toString((byte[])cell.getColumn()), (Object)column);
        Assert.assertEquals((Object)Bytes.toString((byte[])cell.getValue()), (Object)value);
    }

    protected static void checkIncrementValueJSON(String table, String row, String column, long value) throws IOException {
        Response response = RowResourceBase.getValueJson(table, row, column);
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"application/json", (Object)response.getHeader("content-type"));
        ObjectMapper mapper = new JacksonJaxbJsonProvider().locateMapper(CellSetModel.class, MediaType.APPLICATION_JSON_TYPE);
        CellSetModel cellSet = (CellSetModel)mapper.readValue(response.getBody(), CellSetModel.class);
        RowModel rowModel = (RowModel)cellSet.getRows().get(0);
        CellModel cell = (CellModel)rowModel.getCells().get(0);
        Assert.assertEquals((Object)Bytes.toString((byte[])cell.getColumn()), (Object)column);
        Assert.assertEquals((long)Bytes.toLong((byte[])cell.getValue()), (long)value);
    }

    protected static Response putValueJson(String table, String row, String column, String value) throws IOException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        path.append(table);
        path.append('/');
        path.append(row);
        path.append('/');
        path.append(column);
        return RowResourceBase.putValueJson(path.toString(), table, row, column, value);
    }

    protected static Response putValueJson(String url, String table, String row, String column, String value) throws IOException {
        RowModel rowModel = new RowModel(row);
        rowModel.addCell(new CellModel(Bytes.toBytes((String)column), Bytes.toBytes((String)value)));
        CellSetModel cellSetModel = new CellSetModel();
        cellSetModel.addRow(rowModel);
        String jsonString = jsonMapper.writeValueAsString((Object)cellSetModel);
        Response response = client.put(url, "application/json", Bytes.toBytes((String)jsonString));
        Thread.yield();
        return response;
    }

    protected static Response appendValueXML(String table, String row, String column, String value) throws IOException, JAXBException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        path.append(table);
        path.append('/');
        path.append(row);
        path.append("?check=append");
        return RowResourceBase.putValueXML(path.toString(), table, row, column, value);
    }

    protected static Response appendValuePB(String table, String row, String column, String value) throws IOException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        path.append(table);
        path.append('/');
        path.append(row);
        path.append("?check=append");
        return RowResourceBase.putValuePB(path.toString(), table, row, column, value);
    }

    protected static Response appendValueJson(String table, String row, String column, String value) throws IOException, JAXBException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        path.append(table);
        path.append('/');
        path.append(row);
        path.append("?check=append");
        return RowResourceBase.putValueJson(path.toString(), table, row, column, value);
    }

    protected static Response incrementValueXML(String table, String row, String column, String value) throws IOException, JAXBException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        path.append(table);
        path.append('/');
        path.append(row);
        path.append("?check=increment");
        return RowResourceBase.putValueXML(path.toString(), table, row, column, value);
    }

    protected static Response incrementValuePB(String table, String row, String column, String value) throws IOException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        path.append(table);
        path.append('/');
        path.append(row);
        path.append("?check=increment");
        return RowResourceBase.putValuePB(path.toString(), table, row, column, value);
    }

    protected static Response incrementValueJson(String table, String row, String column, String value) throws IOException, JAXBException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        path.append(table);
        path.append('/');
        path.append(row);
        path.append("?check=increment");
        return RowResourceBase.putValueJson(path.toString(), table, row, column, value);
    }
}

