/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.rest.model.CellModel;
import org.apache.hadoop.hbase.rest.model.RowModel;
import org.apache.hadoop.hbase.rest.model.TestModelBase;
import org.apache.hadoop.hbase.testclassification.RestTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RestTests.class, SmallTests.class})
public class TestRowModel
extends TestModelBase<RowModel> {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRowModel.class);
    private static final byte[] ROW1 = Bytes.toBytes((String)"testrow1");
    private static final byte[] COLUMN1 = Bytes.toBytes((String)"testcolumn1");
    private static final byte[] VALUE1 = Bytes.toBytes((String)"testvalue1");
    private static final long TIMESTAMP1 = 1245219839331L;

    public TestRowModel() throws Exception {
        super(RowModel.class);
        this.AS_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><Row key=\"dGVzdHJvdzE=\"><Cell column=\"dGVzdGNvbHVtbjE=\" timestamp=\"1245219839331\">dGVzdHZhbHVlMQ==</Cell></Row>";
        this.AS_JSON = "{\"key\":\"dGVzdHJvdzE=\",\"Cell\":[{\"column\":\"dGVzdGNvbHVtbjE=\",\"timestamp\":1245219839331,\"$\":\"dGVzdHZhbHVlMQ==\"}]}";
    }

    @Override
    protected RowModel buildTestModel() {
        RowModel model = new RowModel();
        model.setKey(ROW1);
        model.addCell(new CellModel(COLUMN1, 1245219839331L, VALUE1));
        return model;
    }

    @Override
    protected void checkModel(RowModel model) {
        Assert.assertTrue((boolean)Bytes.equals((byte[])ROW1, (byte[])model.getKey()));
        Iterator cells = model.getCells().iterator();
        CellModel cell = (CellModel)cells.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])COLUMN1, (byte[])cell.getColumn()));
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE1, (byte[])cell.getValue()));
        Assert.assertTrue((boolean)cell.hasUserTimestamp());
        Assert.assertEquals((long)1245219839331L, (long)cell.getTimestamp());
        Assert.assertFalse((boolean)cells.hasNext());
    }

    @Override
    public void testFromPB() throws Exception {
    }

    @Test
    public void testEquals() throws Exception {
        RowModel rowModel1 = this.buildTestModel();
        RowModel rowModel2 = this.buildTestModel();
        Assert.assertEquals((Object)rowModel1, (Object)rowModel2);
        RowModel rowModel3 = new RowModel();
        Assert.assertFalse((boolean)rowModel1.equals((Object)rowModel3));
    }

    @Test
    public void testToString() throws Exception {
        String expectedRowKey = ToStringBuilder.reflectionToString((Object)ROW1, (ToStringStyle)ToStringStyle.SIMPLE_STYLE);
        RowModel rowModel = this.buildTestModel();
        System.out.println(rowModel);
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)rowModel.toString(), (CharSequence)expectedRowKey));
    }
}

