/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.rest.model.NamespacesModel;
import org.apache.hadoop.hbase.rest.model.TestModelBase;
import org.apache.hadoop.hbase.testclassification.RestTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RestTests.class, SmallTests.class})
public class TestNamespacesModel
extends TestModelBase<NamespacesModel> {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestNamespacesModel.class);
    public static final String NAMESPACE_NAME_1 = "testNamespace1";
    public static final String NAMESPACE_NAME_2 = "testNamespace2";

    public TestNamespacesModel() throws Exception {
        super(NamespacesModel.class);
        this.AS_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><Namespaces><Namespace>testNamespace1</Namespace><Namespace>testNamespace2</Namespace></Namespaces>";
        this.AS_PB = "Cg50ZXN0TmFtZXNwYWNlMQoOdGVzdE5hbWVzcGFjZTI=";
        this.AS_JSON = "{\"Namespace\":[\"testNamespace1\",\"testNamespace2\"]}";
    }

    @Override
    protected NamespacesModel buildTestModel() {
        return this.buildTestModel(NAMESPACE_NAME_1, NAMESPACE_NAME_2);
    }

    public NamespacesModel buildTestModel(String ... namespaces) {
        NamespacesModel model = new NamespacesModel();
        model.setNamespaces(Arrays.asList(namespaces));
        return model;
    }

    @Override
    protected void checkModel(NamespacesModel model) {
        this.checkModel(model, NAMESPACE_NAME_1, NAMESPACE_NAME_2);
    }

    public void checkModel(NamespacesModel model, String ... namespaceName) {
        List namespaces = model.getNamespaces();
        Assert.assertEquals((long)namespaceName.length, (long)namespaces.size());
        for (int i = 0; i < namespaceName.length; ++i) {
            Assert.assertTrue((boolean)namespaces.contains(namespaceName[i]));
        }
    }

    @Override
    @Test
    public void testBuildModel() throws Exception {
        this.checkModel(this.buildTestModel());
    }

    @Override
    @Test
    public void testFromXML() throws Exception {
        this.checkModel((NamespacesModel)this.fromXML(this.AS_XML));
    }

    @Override
    @Test
    public void testFromPB() throws Exception {
        this.checkModel((NamespacesModel)this.fromPB(this.AS_PB));
    }
}

