/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.rest.HBaseRESTTestingUtility;
import org.apache.hadoop.hbase.rest.client.Client;
import org.apache.hadoop.hbase.rest.client.Cluster;
import org.apache.hadoop.hbase.rest.client.Response;
import org.apache.hadoop.hbase.rest.model.StorageClusterVersionModel;
import org.apache.hadoop.hbase.rest.model.VersionModel;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RestTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import org.apache.hbase.thirdparty.javax.ws.rs.core.MediaType;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RestTests.class, MediumTests.class})
public class TestVersionResource {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestVersionResource.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestVersionResource.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final HBaseRESTTestingUtility REST_TEST_UTIL = new HBaseRESTTestingUtility();
    private static Client client;
    private static JAXBContext context;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
        REST_TEST_UTIL.startServletContainer(TEST_UTIL.getConfiguration());
        client = new Client(new Cluster().add("localhost", REST_TEST_UTIL.getServletPort()));
        context = JAXBContext.newInstance((Class[])new Class[]{VersionModel.class, StorageClusterVersionModel.class});
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        REST_TEST_UTIL.shutdownServletContainer();
        TEST_UTIL.shutdownMiniCluster();
    }

    private static void validate(VersionModel model) {
        Assert.assertNotNull((Object)model);
        Assert.assertNotNull((Object)model.getRESTVersion());
        Assert.assertEquals((Object)"0.0.3", (Object)model.getRESTVersion());
        String osVersion = model.getOSVersion();
        Assert.assertNotNull((Object)osVersion);
        Assert.assertTrue((boolean)osVersion.contains(System.getProperty("os.name")));
        Assert.assertTrue((boolean)osVersion.contains(System.getProperty("os.version")));
        Assert.assertTrue((boolean)osVersion.contains(System.getProperty("os.arch")));
        String jvmVersion = model.getJVMVersion();
        Assert.assertNotNull((Object)jvmVersion);
        Assert.assertTrue((boolean)jvmVersion.contains(System.getProperty("java.vm.vendor")));
        Assert.assertTrue((boolean)jvmVersion.contains(System.getProperty("java.version")));
        Assert.assertTrue((boolean)jvmVersion.contains(System.getProperty("java.vm.version")));
        Assert.assertNotNull((Object)model.getServerVersion());
        String jerseyVersion = model.getJerseyVersion();
        Assert.assertNotNull((Object)jerseyVersion);
    }

    @Test
    public void testGetStargateVersionText() throws IOException {
        Response response = client.get("/version", "text/plain");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"text/plain", (Object)response.getHeader("content-type"));
        String body = Bytes.toString((byte[])response.getBody());
        Assert.assertTrue((body.length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)body.contains("0.0.3"));
        Assert.assertTrue((boolean)body.contains(System.getProperty("java.vm.vendor")));
        Assert.assertTrue((boolean)body.contains(System.getProperty("java.version")));
        Assert.assertTrue((boolean)body.contains(System.getProperty("java.vm.version")));
        Assert.assertTrue((boolean)body.contains(System.getProperty("os.name")));
        Assert.assertTrue((boolean)body.contains(System.getProperty("os.version")));
        Assert.assertTrue((boolean)body.contains(System.getProperty("os.arch")));
    }

    @Test
    public void testGetStargateVersionXML() throws IOException, JAXBException {
        Response response = client.get("/version", "text/xml");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"text/xml", (Object)response.getHeader("content-type"));
        VersionModel model = (VersionModel)context.createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(response.getBody()));
        TestVersionResource.validate(model);
        LOG.info("success retrieving Stargate version as XML");
    }

    @Test
    public void testGetStargateVersionJSON() throws IOException {
        Response response = client.get("/version", "application/json");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"application/json", (Object)response.getHeader("content-type"));
        ObjectMapper mapper = new JacksonJaxbJsonProvider().locateMapper(VersionModel.class, MediaType.APPLICATION_JSON_TYPE);
        VersionModel model = (VersionModel)mapper.readValue(response.getBody(), VersionModel.class);
        TestVersionResource.validate(model);
        LOG.info("success retrieving Stargate version as JSON");
    }

    @Test
    public void testGetStargateVersionPB() throws IOException {
        Response response = client.get("/version", "application/x-protobuf");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"application/x-protobuf", (Object)response.getHeader("content-type"));
        VersionModel model = new VersionModel();
        model.getObjectFromMessage(response.getBody());
        TestVersionResource.validate(model);
        response = client.get("/version", "application/protobuf");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"application/protobuf", (Object)response.getHeader("content-type"));
        model = new VersionModel();
        model.getObjectFromMessage(response.getBody());
        TestVersionResource.validate(model);
    }

    @Test
    public void testGetStorageClusterVersionText() throws IOException {
        Response response = client.get("/version/cluster", "text/plain");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"text/plain", (Object)response.getHeader("content-type"));
    }

    @Test
    public void testGetStorageClusterVersionXML() throws IOException, JAXBException {
        Response response = client.get("/version/cluster", "text/xml");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"text/xml", (Object)response.getHeader("content-type"));
        StorageClusterVersionModel clusterVersionModel = (StorageClusterVersionModel)context.createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(response.getBody()));
        Assert.assertNotNull((Object)clusterVersionModel);
        Assert.assertNotNull((Object)clusterVersionModel.getVersion());
        LOG.info("success retrieving storage cluster version as XML");
    }

    @Test
    public void testGetStorageClusterVersionJSON() throws IOException {
        Response response = client.get("/version/cluster", "application/json");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"application/json", (Object)response.getHeader("content-type"));
        ObjectMapper mapper = new JacksonJaxbJsonProvider().locateMapper(StorageClusterVersionModel.class, MediaType.APPLICATION_JSON_TYPE);
        StorageClusterVersionModel clusterVersionModel = (StorageClusterVersionModel)mapper.readValue(response.getBody(), StorageClusterVersionModel.class);
        Assert.assertNotNull((Object)clusterVersionModel);
        Assert.assertNotNull((Object)clusterVersionModel.getVersion());
        LOG.info("success retrieving storage cluster version as JSON");
    }
}

