/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.File;
import java.lang.reflect.Method;
import java.security.Key;
import java.security.KeyPair;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.http.ssl.KeyStoreTestUtil;
import org.apache.hadoop.hbase.rest.HBaseRESTTestingUtility;
import org.apache.hadoop.hbase.rest.client.Client;
import org.apache.hadoop.hbase.rest.client.Cluster;
import org.apache.hadoop.hbase.rest.client.Response;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RestTests;
import org.apache.http.client.ClientProtocolException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RestTests.class, MediumTests.class})
public class TestRESTServerSSL {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRESTServerSSL.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRESTServerSSL.class);
    private static final String KEY_STORE_PASSWORD = "myKSPassword";
    private static final String TRUST_STORE_PASSWORD = "myTSPassword";
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final HBaseRESTTestingUtility REST_TEST_UTIL = new HBaseRESTTestingUtility();
    private static Client sslClient;
    private static File keyDir;
    private Configuration conf;

    private static void initializeAlgorithmId() {
        try {
            Class<?> algoId = Class.forName("sun.security.x509.AlgorithmId");
            Method method = algoId.getMethod("get", String.class);
            method.setAccessible(true);
            method.invoke(null, "PBEWithSHA1AndDESede");
        }
        catch (Exception e) {
            LOG.warn("failed to initialize AlgorithmId", (Throwable)e);
        }
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        TestRESTServerSSL.initializeAlgorithmId();
        keyDir = TestRESTServerSSL.initKeystoreDir();
        KeyPair keyPair = KeyStoreTestUtil.generateKeyPair((String)"RSA");
        X509Certificate serverCertificate = KeyStoreTestUtil.generateCertificate((String)"CN=localhost, O=server", (KeyPair)keyPair, (int)30, (String)"SHA1withRSA");
        TestRESTServerSSL.generateTrustStore("jks", serverCertificate);
        TestRESTServerSSL.generateTrustStore("jceks", serverCertificate);
        TestRESTServerSSL.generateTrustStore("pkcs12", serverCertificate);
        TestRESTServerSSL.generateKeyStore("jks", keyPair, serverCertificate);
        TestRESTServerSSL.generateKeyStore("jceks", keyPair, serverCertificate);
        TestRESTServerSSL.generateKeyStore("pkcs12", keyPair, serverCertificate);
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void beforeEachTest() {
        this.conf = new Configuration(TEST_UTIL.getConfiguration());
        this.conf.set("hbase.rest.ssl.enabled", "true");
        this.conf.set("hbase.rest.ssl.keystore.keypassword", KEY_STORE_PASSWORD);
        this.conf.set("hbase.rest.ssl.keystore.password", KEY_STORE_PASSWORD);
        this.conf.set("hbase.rest.ssl.truststore.password", TRUST_STORE_PASSWORD);
    }

    @After
    public void tearDownAfterTest() {
        REST_TEST_UTIL.shutdownServletContainer();
    }

    @Test
    public void testSslConnection() throws Exception {
        this.startRESTServerWithDefaultKeystoreType();
        Response response = sslClient.get("/version", "text/plain");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"max-age=63072000;includeSubDomains;preload", (Object)response.getHeader("Strict-Transport-Security"));
        Assert.assertEquals((Object)"default-src https: data: 'unsafe-inline' 'unsafe-eval'", (Object)response.getHeader("Content-Security-Policy"));
    }

    @Test(expected=ClientProtocolException.class)
    public void testNonSslClientDenied() throws Exception {
        this.startRESTServerWithDefaultKeystoreType();
        Cluster localCluster = new Cluster().add("localhost", REST_TEST_UTIL.getServletPort());
        Client nonSslClient = new Client(localCluster, false);
        nonSslClient.get("/version");
    }

    @Test
    public void testSslConnectionUsingKeystoreFormatJKS() throws Exception {
        this.startRESTServer("jks");
        Response response = sslClient.get("/version", "text/plain");
        Assert.assertEquals((long)200L, (long)response.getCode());
    }

    @Test
    public void testSslConnectionUsingKeystoreFormatJCEKS() throws Exception {
        this.startRESTServer("jceks");
        Response response = sslClient.get("/version", "text/plain");
        Assert.assertEquals((long)200L, (long)response.getCode());
    }

    @Test
    public void testSslConnectionUsingKeystoreFormatPKCS12() throws Exception {
        this.startRESTServer("pkcs12");
        Response response = sslClient.get("/version", "text/plain");
        Assert.assertEquals((long)200L, (long)response.getCode());
    }

    private static File initKeystoreDir() {
        String dataTestDir = TEST_UTIL.getDataTestDir().toString();
        File keystoreDir = new File(dataTestDir, TestRESTServerSSL.class.getSimpleName() + "_keys");
        keystoreDir.mkdirs();
        return keystoreDir;
    }

    private static void generateKeyStore(String keyStoreType, KeyPair keyPair, X509Certificate serverCertificate) throws Exception {
        String keyStorePath = TestRESTServerSSL.getKeystoreFilePath(keyStoreType);
        KeyStoreTestUtil.createKeyStore((String)keyStorePath, (String)KEY_STORE_PASSWORD, (String)KEY_STORE_PASSWORD, (String)"serverKS", (Key)keyPair.getPrivate(), (Certificate)serverCertificate, (String)keyStoreType);
    }

    private static void generateTrustStore(String trustStoreType, X509Certificate serverCertificate) throws Exception {
        String trustStorePath = TestRESTServerSSL.getTruststoreFilePath(trustStoreType);
        KeyStoreTestUtil.createTrustStore((String)trustStorePath, (String)TRUST_STORE_PASSWORD, (String)"serverTS", (Certificate)serverCertificate, (String)trustStoreType);
    }

    private static String getKeystoreFilePath(String keyStoreType) {
        return String.format("%s/serverKS.%s", keyDir.getAbsolutePath(), keyStoreType);
    }

    private static String getTruststoreFilePath(String trustStoreType) {
        return String.format("%s/serverTS.%s", keyDir.getAbsolutePath(), trustStoreType);
    }

    private void startRESTServerWithDefaultKeystoreType() throws Exception {
        this.conf.set("hbase.rest.ssl.keystore.store", TestRESTServerSSL.getKeystoreFilePath("jks"));
        this.conf.set("hbase.rest.ssl.truststore.store", TestRESTServerSSL.getTruststoreFilePath("jks"));
        REST_TEST_UTIL.startServletContainer(this.conf);
        Cluster localCluster = new Cluster().add("localhost", REST_TEST_UTIL.getServletPort());
        sslClient = new Client(localCluster, TestRESTServerSSL.getTruststoreFilePath("jks"), Optional.of(TRUST_STORE_PASSWORD), Optional.empty());
    }

    private void startRESTServer(String storeType) throws Exception {
        this.conf.set("hbase.rest.ssl.keystore.type", storeType);
        this.conf.set("hbase.rest.ssl.keystore.store", TestRESTServerSSL.getKeystoreFilePath(storeType));
        this.conf.set("hbase.rest.ssl.truststore.store", TestRESTServerSSL.getTruststoreFilePath(storeType));
        this.conf.set("hbase.rest.ssl.truststore.type", storeType);
        REST_TEST_UTIL.startServletContainer(this.conf);
        Cluster localCluster = new Cluster().add("localhost", REST_TEST_UTIL.getServletPort());
        sslClient = new Client(localCluster, TestRESTServerSSL.getTruststoreFilePath(storeType), Optional.of(TRUST_STORE_PASSWORD), Optional.of(storeType));
    }
}

