/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.rest.HBaseRESTTestingUtility;
import org.apache.hadoop.hbase.rest.client.Client;
import org.apache.hadoop.hbase.rest.client.Cluster;
import org.apache.hadoop.hbase.rest.client.Response;
import org.apache.hadoop.hbase.rest.model.NamespacesModel;
import org.apache.hadoop.hbase.rest.model.TestNamespacesModel;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RestTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RestTests.class, MediumTests.class})
public class TestNamespacesResource {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestNamespacesResource.class);
    private static String NAMESPACE1 = "TestNamespacesInstanceResource1";
    private static String NAMESPACE2 = "TestNamespacesInstanceResource2";
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final HBaseRESTTestingUtility REST_TEST_UTIL = new HBaseRESTTestingUtility();
    private static Client client;
    private static JAXBContext context;
    private static Configuration conf;
    private static TestNamespacesModel testNamespacesModel;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        TEST_UTIL.startMiniCluster();
        REST_TEST_UTIL.startServletContainer(conf);
        client = new Client(new Cluster().add("localhost", REST_TEST_UTIL.getServletPort()));
        testNamespacesModel = new TestNamespacesModel();
        context = JAXBContext.newInstance((Class[])new Class[]{NamespacesModel.class});
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        REST_TEST_UTIL.shutdownServletContainer();
        TEST_UTIL.shutdownMiniCluster();
    }

    private static NamespacesModel fromXML(byte[] content) throws JAXBException {
        return (NamespacesModel)context.createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(content));
    }

    private boolean doesNamespaceExist(Admin admin, String namespaceName) throws IOException {
        NamespaceDescriptor[] nd;
        for (NamespaceDescriptor namespaceDescriptor : nd = admin.listNamespaceDescriptors()) {
            if (!namespaceDescriptor.getName().equals(namespaceName)) continue;
            return true;
        }
        return false;
    }

    private void createNamespaceViaAdmin(Admin admin, String name) throws IOException {
        NamespaceDescriptor.Builder builder = NamespaceDescriptor.create((String)name);
        NamespaceDescriptor nsd = builder.build();
        admin.createNamespace(nsd);
    }

    @Test
    public void testNamespaceListXMLandJSON() throws IOException, JAXBException {
        String namespacePath = "/namespaces/";
        Admin admin = TEST_UTIL.getAdmin();
        Assert.assertFalse((boolean)this.doesNamespaceExist(admin, NAMESPACE1));
        NamespacesModel model = testNamespacesModel.buildTestModel(new String[0]);
        testNamespacesModel.checkModel(model, new String[0]);
        Response response = client.get(namespacePath, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getCode());
        model = TestNamespacesResource.fromXML(response.getBody());
        testNamespacesModel.checkModel(model, "hbase", "default");
        response = client.get(namespacePath, "application/json");
        Assert.assertEquals((long)200L, (long)response.getCode());
        model = (NamespacesModel)testNamespacesModel.fromJSON(Bytes.toString((byte[])response.getBody()));
        testNamespacesModel.checkModel(model, "hbase", "default");
        this.createNamespaceViaAdmin(admin, NAMESPACE1);
        response = client.get(namespacePath, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getCode());
        model = TestNamespacesResource.fromXML(response.getBody());
        testNamespacesModel.checkModel(model, NAMESPACE1, "hbase", "default");
        response = client.get(namespacePath, "application/json");
        Assert.assertEquals((long)200L, (long)response.getCode());
        model = (NamespacesModel)testNamespacesModel.fromJSON(Bytes.toString((byte[])response.getBody()));
        testNamespacesModel.checkModel(model, NAMESPACE1, "hbase", "default");
        this.createNamespaceViaAdmin(admin, NAMESPACE2);
        response = client.get(namespacePath, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getCode());
        model = TestNamespacesResource.fromXML(response.getBody());
        testNamespacesModel.checkModel(model, NAMESPACE1, NAMESPACE2, "hbase", "default");
        response = client.get(namespacePath, "application/json");
        Assert.assertEquals((long)200L, (long)response.getCode());
        model = (NamespacesModel)testNamespacesModel.fromJSON(Bytes.toString((byte[])response.getBody()));
        testNamespacesModel.checkModel(model, NAMESPACE1, NAMESPACE2, "hbase", "default");
        admin.deleteNamespace(NAMESPACE1);
        response = client.get(namespacePath, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getCode());
        model = TestNamespacesResource.fromXML(response.getBody());
        testNamespacesModel.checkModel(model, NAMESPACE2, "hbase", "default");
        response = client.get(namespacePath, "application/json");
        Assert.assertEquals((long)200L, (long)response.getCode());
        model = (NamespacesModel)testNamespacesModel.fromJSON(Bytes.toString((byte[])response.getBody()));
        testNamespacesModel.checkModel(model, NAMESPACE2, "hbase", "default");
        admin.deleteNamespace(NAMESPACE2);
    }

    @Test
    public void testNamespaceListPBandDefault() throws IOException {
        String schemaPath = "/namespaces/";
        Admin admin = TEST_UTIL.getAdmin();
        Assert.assertFalse((boolean)this.doesNamespaceExist(admin, NAMESPACE1));
        NamespacesModel model = testNamespacesModel.buildTestModel(new String[0]);
        testNamespacesModel.checkModel(model, new String[0]);
        Response response = client.get(schemaPath, "application/x-protobuf");
        Assert.assertEquals((long)200L, (long)response.getCode());
        model.getObjectFromMessage(response.getBody());
        testNamespacesModel.checkModel(model, "hbase", "default");
        response = client.get(schemaPath);
        Assert.assertEquals((long)200L, (long)response.getCode());
        this.createNamespaceViaAdmin(admin, NAMESPACE1);
        response = client.get(schemaPath, "application/x-protobuf");
        Assert.assertEquals((long)200L, (long)response.getCode());
        model.getObjectFromMessage(response.getBody());
        testNamespacesModel.checkModel(model, NAMESPACE1, "hbase", "default");
        response = client.get(schemaPath);
        Assert.assertEquals((long)200L, (long)response.getCode());
        this.createNamespaceViaAdmin(admin, NAMESPACE2);
        response = client.get(schemaPath, "application/x-protobuf");
        Assert.assertEquals((long)200L, (long)response.getCode());
        model.getObjectFromMessage(response.getBody());
        testNamespacesModel.checkModel(model, NAMESPACE1, NAMESPACE2, "hbase", "default");
        response = client.get(schemaPath);
        Assert.assertEquals((long)200L, (long)response.getCode());
        admin.deleteNamespace(NAMESPACE1);
        response = client.get(schemaPath, "application/x-protobuf");
        Assert.assertEquals((long)200L, (long)response.getCode());
        model.getObjectFromMessage(response.getBody());
        testNamespacesModel.checkModel(model, NAMESPACE2, "hbase", "default");
        response = client.get(schemaPath);
        Assert.assertEquals((long)200L, (long)response.getCode());
        admin.deleteNamespace(NAMESPACE2);
    }
}

