/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.rest.model.TestModelBase;
import org.apache.hadoop.hbase.rest.model.VersionModel;
import org.apache.hadoop.hbase.testclassification.RestTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;

@Category(value={RestTests.class, SmallTests.class})
public class TestVersionModel
extends TestModelBase<VersionModel> {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestVersionModel.class);
    private static final String REST_VERSION = "0.0.1";
    private static final String OS_VERSION = "Linux 2.6.18-128.1.6.el5.centos.plusxen amd64";
    private static final String JVM_VERSION = "Sun Microsystems Inc. 1.6.0_13-11.3-b02";
    private static final String JETTY_VERSION = "6.1.14";
    private static final String JERSEY_VERSION = "1.1.0-ea";
    private static final String VERSION = "4.0.0-alpha-1-SNAPSHOT";
    private static final String REVISION = "5085d27ab17d857118a96ae3f37c00b60c925471";

    public TestVersionModel() throws Exception {
        super(VersionModel.class);
        this.AS_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><Version JVM=\"Sun Microsystems Inc. 1.6.0_13-11.3-b02\" Jersey=\"1.1.0-ea\" OS=\"Linux 2.6.18-128.1.6.el5.centos.plusxen amd64\" REST=\"0.0.1\" Server=\"6.1.14\" Version=\"4.0.0-alpha-1-SNAPSHOT\" Revision=\"5085d27ab17d857118a96ae3f37c00b60c925471\"/>";
        this.AS_PB = "CgUwLjAuMRInU3VuIE1pY3Jvc3lzdGVtcyBJbmMuIDEuNi4wXzEzLTExLjMtYjAyGi1MaW51eCAyLjYuMTgtMTI4LjEuNi5lbDUuY2VudG9zLnBsdXN4ZW4gYW1kNjQiBjYuMS4xNCoIMS4xLjAtZWEyFjQuMC4wLWFscGhhLTEtU05BUFNIT1Q6KDUwODVkMjdhYjE3ZDg1NzExOGE5NmFlM2YzN2MwMGI2MGM5MjU0NzE=";
        this.AS_JSON = "{\"JVM\":\"Sun Microsystems Inc. 1.6.0_13-11.3-b02\",\"Jersey\":\"1.1.0-ea\",\"OS\":\"Linux 2.6.18-128.1.6.el5.centos.plusxen amd64\",\"REST\":\"0.0.1\",\"Server\":\"6.1.14\", \"Version\":\"4.0.0-alpha-1-SNAPSHOT\",\"Revision\":\"5085d27ab17d857118a96ae3f37c00b60c925471\"}";
    }

    @Override
    protected VersionModel buildTestModel() {
        VersionModel model = new VersionModel();
        model.setRESTVersion(REST_VERSION);
        model.setOSVersion(OS_VERSION);
        model.setJVMVersion(JVM_VERSION);
        model.setServerVersion(JETTY_VERSION);
        model.setJerseyVersion(JERSEY_VERSION);
        model.setVersion(VERSION);
        model.setRevision(REVISION);
        return model;
    }

    @Override
    protected void checkModel(VersionModel model) {
        Assert.assertEquals((Object)REST_VERSION, (Object)model.getRESTVersion());
        Assert.assertEquals((Object)OS_VERSION, (Object)model.getOSVersion());
        Assert.assertEquals((Object)JVM_VERSION, (Object)model.getJVMVersion());
        Assert.assertEquals((Object)JETTY_VERSION, (Object)model.getServerVersion());
        Assert.assertEquals((Object)JERSEY_VERSION, (Object)model.getJerseyVersion());
        Assert.assertEquals((Object)VERSION, (Object)model.getVersion());
        Assert.assertEquals((Object)REVISION, (Object)model.getRevision());
    }
}

