/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import java.util.Iterator;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.rest.model.TableListModel;
import org.apache.hadoop.hbase.rest.model.TableModel;
import org.apache.hadoop.hbase.rest.model.TestModelBase;
import org.apache.hadoop.hbase.testclassification.RestTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;

@Category(value={RestTests.class, SmallTests.class})
public class TestTableListModel
extends TestModelBase<TableListModel> {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTableListModel.class);
    private static final String TABLE1 = "table1";
    private static final String TABLE2 = "table2";
    private static final String TABLE3 = "table3";

    public TestTableListModel() throws Exception {
        super(TableListModel.class);
        this.AS_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><TableList><table name=\"table1\"/><table name=\"table2\"/><table name=\"table3\"/></TableList>";
        this.AS_PB = "CgZ0YWJsZTEKBnRhYmxlMgoGdGFibGUz";
        this.AS_JSON = "{\"table\":[{\"name\":\"table1\"},{\"name\":\"table2\"},{\"name\":\"table3\"}]}";
    }

    @Override
    protected TableListModel buildTestModel() {
        TableListModel model = new TableListModel();
        model.add(new TableModel(TABLE1));
        model.add(new TableModel(TABLE2));
        model.add(new TableModel(TABLE3));
        return model;
    }

    @Override
    protected void checkModel(TableListModel model) {
        Iterator tables = model.getTables().iterator();
        TableModel table = (TableModel)tables.next();
        Assert.assertEquals((Object)TABLE1, (Object)table.getName());
        table = (TableModel)tables.next();
        Assert.assertEquals((Object)TABLE2, (Object)table.getName());
        table = (TableModel)tables.next();
        Assert.assertEquals((Object)TABLE3, (Object)table.getName());
        Assert.assertFalse((boolean)tables.hasNext());
    }
}

