/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.client;

import java.io.IOException;
import javax.xml.bind.UnmarshalException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.rest.client.Client;
import org.apache.hadoop.hbase.rest.client.RemoteAdmin;
import org.apache.hadoop.hbase.rest.client.Response;
import org.apache.hadoop.hbase.rest.model.StorageClusterVersionModel;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SmallTests.class})
public class TestXmlParsing {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestXmlParsing.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestXmlParsing.class);

    @Test
    public void testParsingClusterVersion() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><ClusterVersion Version=\"2.0.0\"/>";
        Client client = (Client)Mockito.mock(Client.class);
        RemoteAdmin admin = new RemoteAdmin(client, HBaseConfiguration.create(), null);
        Response resp = new Response(200, null, Bytes.toBytes((String)"<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><ClusterVersion Version=\"2.0.0\"/>"));
        Mockito.when((Object)client.get("/version/cluster", "text/xml")).thenReturn((Object)resp);
        StorageClusterVersionModel cv = admin.getClusterVersion();
        Assert.assertEquals((Object)"2.0.0", (Object)cv.getVersion());
    }

    @Test
    public void testFailOnExternalEntities() throws Exception {
        String externalEntitiesXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <!DOCTYPE foo [ <!ENTITY xxe SYSTEM \"/tmp/foo\"> ] > <ClusterVersion>&xee;</ClusterVersion>";
        Client client = (Client)Mockito.mock(Client.class);
        RemoteAdmin admin = new RemoteAdmin(client, HBaseConfiguration.create(), null);
        Response resp = new Response(200, null, Bytes.toBytes((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?> <!DOCTYPE foo [ <!ENTITY xxe SYSTEM \"/tmp/foo\"> ] > <ClusterVersion>&xee;</ClusterVersion>"));
        Mockito.when((Object)client.get("/version/cluster", "text/xml")).thenReturn((Object)resp);
        try {
            admin.getClusterVersion();
            Assert.fail((String)"Expected getClusterVersion() to throw an exception");
        }
        catch (IOException e) {
            Assert.assertEquals((String)"Cause of exception ought to be a failure to parse the stream due to our invalid external entity. Make sure this isn't just a false positive due to implementation. see HBASE-19020.", UnmarshalException.class, e.getCause().getClass());
            String exceptionText = StringUtils.stringifyException((Throwable)e);
            String expectedText = "\"xee\"";
            LOG.debug("exception text: '" + exceptionText + "'", (Throwable)e);
            Assert.assertTrue((String)"Exception does not contain expected text", (boolean)exceptionText.contains("\"xee\""));
        }
    }
}

