/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import org.apache.hadoop.hbase.rest.model.ScannerModel;
import org.apache.hadoop.hbase.rest.model.TestModelBase;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestScannerModel
extends TestModelBase<ScannerModel> {
    private static final String PRIVATE = "private";
    private static final String PUBLIC = "public";
    private static final byte[] START_ROW = Bytes.toBytes((String)"abracadabra");
    private static final byte[] END_ROW = Bytes.toBytes((String)"zzyzx");
    private static final byte[] COLUMN1 = Bytes.toBytes((String)"column1");
    private static final byte[] COLUMN2 = Bytes.toBytes((String)"column2:foo");
    private static final long START_TIME = 1245219839331L;
    private static final long END_TIME = 1245393318192L;
    private static final int CACHING = 1000;
    private static final int BATCH = 100;
    private static final boolean CACHE_BLOCKS = false;

    public TestScannerModel() throws Exception {
        super(ScannerModel.class);
        this.AS_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><Scanner batch=\"100\" cacheBlocks=\"false\" caching=\"1000\" endRow=\"enp5eng=\" endTime=\"1245393318192\" maxVersions=\"2147483647\" startRow=\"YWJyYWNhZGFicmE=\" startTime=\"1245219839331\"><column>Y29sdW1uMQ==</column><column>Y29sdW1uMjpmb28=</column><labels>private</labels><labels>public</labels></Scanner>";
        this.AS_JSON = "{\"batch\":100,\"caching\":1000,\"cacheBlocks\":false,\"endRow\":\"enp5eng=\",\"endTime\":1245393318192,\"maxVersions\":2147483647,\"startRow\":\"YWJyYWNhZGFicmE=\",\"startTime\":1245219839331,\"column\":[\"Y29sdW1uMQ==\",\"Y29sdW1uMjpmb28=\"],\"labels\":[\"private\",\"public\"]}";
        this.AS_PB = "CgthYnJhY2FkYWJyYRIFenp5engaB2NvbHVtbjEaC2NvbHVtbjI6Zm9vIGQo47qL554kMLDi57mfJDj/////B0joB1IHcHJpdmF0ZVIGcHVibGljWAA=";
    }

    @Override
    protected ScannerModel buildTestModel() {
        ScannerModel model = new ScannerModel();
        model.setStartRow(START_ROW);
        model.setEndRow(END_ROW);
        model.addColumn(COLUMN1);
        model.addColumn(COLUMN2);
        model.setStartTime(1245219839331L);
        model.setEndTime(1245393318192L);
        model.setBatch(100);
        model.setCaching(1000);
        model.addLabel(PRIVATE);
        model.addLabel(PUBLIC);
        model.setCacheBlocks(false);
        return model;
    }

    @Override
    protected void checkModel(ScannerModel model) {
        TestScannerModel.assertTrue((boolean)Bytes.equals((byte[])model.getStartRow(), (byte[])START_ROW));
        TestScannerModel.assertTrue((boolean)Bytes.equals((byte[])model.getEndRow(), (byte[])END_ROW));
        boolean foundCol1 = false;
        boolean foundCol2 = false;
        for (byte[] column : model.getColumns()) {
            if (Bytes.equals((byte[])column, (byte[])COLUMN1)) {
                foundCol1 = true;
                continue;
            }
            if (!Bytes.equals((byte[])column, (byte[])COLUMN2)) continue;
            foundCol2 = true;
        }
        TestScannerModel.assertTrue((boolean)foundCol1);
        TestScannerModel.assertTrue((boolean)foundCol2);
        TestScannerModel.assertEquals((long)model.getStartTime(), (long)1245219839331L);
        TestScannerModel.assertEquals((long)model.getEndTime(), (long)1245393318192L);
        TestScannerModel.assertEquals((int)model.getBatch(), (int)100);
        TestScannerModel.assertEquals((int)model.getCaching(), (int)1000);
        TestScannerModel.assertEquals((boolean)model.getCacheBlocks(), (boolean)false);
        boolean foundLabel1 = false;
        boolean foundLabel2 = false;
        if (model.getLabels() != null && model.getLabels().size() > 0) {
            for (String label : model.getLabels()) {
                if (label.equals(PRIVATE)) {
                    foundLabel1 = true;
                    continue;
                }
                if (!label.equals(PUBLIC)) continue;
                foundLabel2 = true;
            }
            TestScannerModel.assertTrue((boolean)foundLabel1);
            TestScannerModel.assertTrue((boolean)foundLabel2);
        }
    }
}

