/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.rest.ProtobufMessageHandler;
import org.apache.hadoop.hbase.rest.provider.JAXBContextResolver;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Base64;
import org.codehaus.jackson.jaxrs.JacksonJaxbJsonProvider;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public abstract class TestModelBase<T>
extends TestCase {
    protected String AS_XML;
    protected String AS_PB;
    protected String AS_JSON;
    protected JAXBContext context;
    protected Class<?> clazz;
    protected ObjectMapper mapper;

    protected TestModelBase(Class<?> clazz) throws Exception {
        this.clazz = clazz;
        this.context = new JAXBContextResolver().getContext(clazz);
        this.mapper = new JacksonJaxbJsonProvider().locateMapper(clazz, MediaType.APPLICATION_JSON_TYPE);
    }

    protected abstract T buildTestModel();

    protected String toXML(T model) throws JAXBException {
        StringWriter writer = new StringWriter();
        this.context.createMarshaller().marshal(model, (Writer)writer);
        return writer.toString();
    }

    protected String toJSON(T model) throws JAXBException, IOException {
        StringWriter writer = new StringWriter();
        this.mapper.writeValue((Writer)writer, model);
        return writer.toString();
    }

    public T fromJSON(String json) throws JAXBException, IOException {
        return (T)this.mapper.readValue(json, this.clazz);
    }

    public T fromXML(String xml) throws JAXBException {
        return (T)this.context.createUnmarshaller().unmarshal((Reader)new StringReader(xml));
    }

    protected byte[] toPB(ProtobufMessageHandler model) {
        return model.createProtobufOutput();
    }

    protected T fromPB(String pb) throws Exception {
        return (T)this.clazz.getMethod("getObjectFromMessage", byte[].class).invoke(this.clazz.newInstance(), new Object[]{Base64.decode((String)this.AS_PB)});
    }

    protected abstract void checkModel(T var1);

    public void testBuildModel() throws Exception {
        this.checkModel(this.buildTestModel());
    }

    public void testFromPB() throws Exception {
        this.checkModel(this.fromPB(this.AS_PB));
    }

    public void testFromXML() throws Exception {
        this.checkModel(this.fromXML(this.AS_XML));
    }

    public void testToXML() throws Exception {
        TestModelBase.assertEquals((String)this.AS_XML, (String)this.toXML(this.buildTestModel()));
    }

    public void testToJSON() throws Exception {
        try {
            ObjectNode expObj = (ObjectNode)this.mapper.readValue(this.AS_JSON, ObjectNode.class);
            ObjectNode actObj = (ObjectNode)this.mapper.readValue(this.toJSON(this.buildTestModel()), ObjectNode.class);
            TestModelBase.assertEquals((Object)expObj, (Object)actObj);
        }
        catch (Exception e) {
            TestModelBase.assertEquals((String)this.AS_JSON, (String)this.toJSON(this.buildTestModel()));
        }
    }

    public void testFromJSON() throws Exception {
        this.checkModel(this.fromJSON(this.AS_JSON));
    }
}

